/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.astro;

import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.grelf.Angle;
import net.grelf.Length;
import net.grelf.Maths;
import net.grelf.MeasuredValue;
import net.grelf.Util;
import net.grelf.XmlUtil;
import net.grelf.astro.Dec;
import net.grelf.astro.Epoch;
import net.grelf.astro.JulianDate;
import net.grelf.astro.Magnitude;
import net.grelf.astro.ProperMotion;
import net.grelf.astro.RA;
import net.grelf.astro.SkyPoint;
import net.grelf.astro.SkyVector;
import net.grelf.astro.Variability;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.BlobMeasList;
import net.grelf.grip.ImFrame;
import net.grelf.image.Calibration;
import net.grelf.image.Image;

public class Star
implements Cloneable,
Serializable {
    public static final long serialVersionUID = 1L;
    private String commonId = "";
    private String hipparcosId = "";
    private String tychoId = "";
    private String otherId = "";
    private String typeOfStellarObject = "";
    private SkyPoint position = null;
    private List<Magnitude> magnitudes = new ArrayList<Magnitude>();
    private Variability variability = null;
    private ProperMotion properMotion = new ProperMotion(0.0, 0.0);
    protected transient double xdd;
    protected transient double zdd;
    private Point plotPoint;

    public String getId() {
        if (null != this.commonId && 0 < this.commonId.length()) {
            return this.commonId;
        }
        if (null != this.hipparcosId && 0 < this.hipparcosId.length()) {
            return this.hipparcosId;
        }
        if (null != this.tychoId && 0 < this.tychoId.length()) {
            return this.tychoId;
        }
        if (null != this.otherId && 0 < this.otherId.length()) {
            return this.otherId;
        }
        return "";
    }

    public String getCommonId() {
        return this.commonId;
    }

    public void setCommonId(String string) {
        this.commonId = string;
    }

    public String getHipparcosId() {
        return this.hipparcosId;
    }

    public void setHipparcosId(String string) {
        this.hipparcosId = string;
    }

    public String getTychoId() {
        return this.tychoId;
    }

    public void setTychoId(String string) {
        this.tychoId = string;
    }

    public String getOtherId() {
        return this.otherId;
    }

    public void setOtherId(String string) {
        this.otherId = string;
    }

    public String getTypeOfStellarObject() {
        return this.typeOfStellarObject;
    }

    public void setTypeOfStellarObject(String string) {
        this.typeOfStellarObject = string;
    }

    public SkyPoint getPosition() {
        return this.position;
    }

    public void setPosition(SkyPoint skyPoint) {
        this.position = skyPoint;
    }

    public List<Magnitude> getMagnitudes() {
        return this.magnitudes;
    }

    public void addMagnitude(Magnitude magnitude) {
        this.magnitudes.add(magnitude);
    }

    public void setMagnitude(Magnitude magnitude) {
        this.magnitudes = new ArrayList<Magnitude>();
        this.magnitudes.add(magnitude);
    }

    public Magnitude getMagnitude() {
        if (this.magnitudes.size() == 0) {
            return null;
        }
        for (Magnitude magnitude : this.magnitudes) {
            if (!magnitude.getBandId().toUpperCase().equals("V")) continue;
            return magnitude;
        }
        return this.magnitudes.get(0);
    }

    public Magnitude getMagnitude(String string) {
        for (Magnitude magnitude : this.magnitudes) {
            if (!magnitude.getBandId().equals(string)) continue;
            return magnitude;
        }
        return null;
    }

    public Variability getVariability() {
        return this.variability;
    }

    public void setVariability(Variability variability) {
        this.variability = variability;
    }

    public ProperMotion getProperMotion() {
        return this.properMotion;
    }

    public void setProperMotion(ProperMotion properMotion) {
        this.properMotion = properMotion;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        Star star = (Star)object;
        if (!star.commonId.equals(this.commonId)) {
            return false;
        }
        if (!star.hipparcosId.equals(this.hipparcosId)) {
            return false;
        }
        if (!star.tychoId.equals(this.tychoId)) {
            return false;
        }
        if (!star.otherId.equals(this.otherId)) {
            return false;
        }
        if (null == star.position && null != this.position) {
            return false;
        }
        if (null != star.position && null == this.position) {
            return false;
        }
        if (null != star.position && null != this.position && !star.position.equals(this.position)) {
            return false;
        }
        if (null == star.magnitudes && null != this.magnitudes) {
            return false;
        }
        if (null != star.magnitudes && null == this.magnitudes) {
            return false;
        }
        if (null != star.magnitudes && null != this.magnitudes && !((Object)star.magnitudes).equals(this.magnitudes)) {
            return false;
        }
        if (null == star.variability && null != this.variability) {
            return false;
        }
        if (null != star.variability && null == this.variability) {
            return false;
        }
        if (null != star.variability && null != this.variability && !star.variability.equals((Object)this.variability)) {
            return false;
        }
        if (null == star.properMotion && null != this.properMotion) {
            return false;
        }
        if (null != star.properMotion && null == this.properMotion) {
            return false;
        }
        return null == star.properMotion || null == this.properMotion || star.properMotion.equals(this.properMotion);
    }

    public int hashCode() {
        return this.commonId.hashCode() * 7 + this.hipparcosId.hashCode() * 11 + this.tychoId.hashCode() * 13 + this.otherId.hashCode() * 17 + this.position.hashCode() * 19 + ((Object)this.magnitudes).hashCode() * 23 + this.variability.hashCode() * 29 + this.properMotion.hashCode() * 97;
    }

    public Star clone() {
        Star star = new Star();
        star.commonId = this.commonId;
        star.hipparcosId = this.hipparcosId;
        star.tychoId = this.tychoId;
        star.otherId = this.otherId;
        star.position = null == this.position ? null : this.position.clone();
        ArrayList<Magnitude> arrayList = new ArrayList<Magnitude>();
        for (Magnitude magnitude : this.magnitudes) {
            arrayList.add(magnitude);
        }
        star.magnitudes = arrayList;
        star.variability = this.variability;
        star.properMotion = this.properMotion.clone();
        star.xdd = this.xdd;
        star.zdd = this.zdd;
        return star;
    }

    public Star(String string, String string2, String string3, RA rA, Dec dec, Epoch epoch, Magnitude magnitude, Variability variability) {
        if (null != string) {
            this.commonId = string;
        }
        if (null != string2) {
            this.hipparcosId = string2;
        }
        if (null != string3) {
            this.tychoId = string3;
        }
        this.position = new SkyPoint(rA, dec, epoch);
        if (null != magnitude) {
            this.magnitudes.add(magnitude);
        }
        if (null != variability) {
            this.variability = variability;
        }
        this.properMotion = new ProperMotion(0.0, 0.0);
    }

    public Star(String string, String string2, String string3, RA rA, Dec dec, Epoch epoch, Magnitude magnitude, Variability variability, double d, double d2) {
        this(string, string2, string3, rA, dec, epoch, magnitude, variability);
        this.xdd = d;
        this.zdd = d2;
    }

    public Star(String string, String string2, String string3, RA rA, Dec dec, Epoch epoch, Magnitude magnitude, Variability variability, ProperMotion properMotion) {
        this(string, string2, string3, rA, dec, epoch, magnitude, variability);
        this.properMotion = properMotion;
    }

    public Star(String string, String string2, String string3, RA rA, Dec dec, Epoch epoch, Magnitude magnitude, Variability variability, ProperMotion properMotion, double d, double d2) {
        this(string, string2, string3, rA, dec, epoch, magnitude, variability, properMotion);
        this.xdd = d;
        this.zdd = d2;
    }

    public Star() {
        this.properMotion = new ProperMotion(0.0, 0.0);
    }

    public void changeEpoch(Epoch epoch, JulianDate julianDate) {
        Epoch epoch2 = this.position.getEquinox();
        double d = epoch2.getJulianDate().toDouble();
        double d2 = julianDate.toDouble();
        double d3 = (d2 - d) / 365.25;
        double d4 = d3 / 3600.0;
        double d5 = this.position.getRA().toDegrees();
        double d6 = this.position.getDec().toDegrees();
        this.position = new SkyPoint(new RA(d5 += this.properMotion.getPmRA_arcsecPerYr() * d4), new Dec(d6 += this.properMotion.getPmDec_arcsecPerYr() * d4), epoch2);
        this.position.changeEquinox(epoch);
    }

    public SkyPoint measurePosition(ImFrame imFrame, BlobMeasList blobMeasList) {
        if (this.position != null) {
            Util.warning(imFrame, "Sorry", (Object)"This star's position is already known");
        } else {
            ArrayList<BlobMeas> arrayList = new ArrayList<BlobMeas>();
            ArrayList<BlobMeas> arrayList2 = new ArrayList<BlobMeas>();
            Epoch epoch = null;
            boolean bl = false;
            Image image = imFrame.getImPane().getImage();
            for (Cloneable cloneable : blobMeasList) {
                Star star = cloneable.getStar();
                if (null == star) continue;
                SkyPoint cloneable2 = star.getPosition();
                if (null != cloneable2) {
                    arrayList.add((BlobMeas)cloneable);
                    if (null == epoch) {
                        epoch = cloneable2.getEquinox();
                        continue;
                    }
                    if (cloneable2.getEquinox().equals(epoch)) continue;
                    bl = true;
                    continue;
                }
                arrayList2.add((BlobMeas)cloneable);
            }
            int n = arrayList.size();
            if (n < 2) {
                Util.warning(imFrame, "Sorry", (Object)"You need to have set at least 2 reference stars\nbefore you can measure position");
            } else if (bl) {
                Util.warning(imFrame, "Sorry", (Object)"The reference stars are not all for the same epoch");
            } else {
                Cloneable cloneable;
                cloneable = this.calibrateImage(arrayList);
                for (BlobMeas blobMeas : arrayList2) {
                    SkyPoint skyPoint = this.measureTargetBlob(arrayList, blobMeas, epoch, image, (MeasuredValue)cloneable);
                    blobMeas.getStar().setPosition(skyPoint);
                }
            }
        }
        return this.position;
    }

    protected SkyPoint measureTargetBlob(List<BlobMeas> list, BlobMeas blobMeas, Epoch epoch, Image image, MeasuredValue measuredValue) {
        int n = image.getWidth() / 2;
        int n2 = image.getHeight() / 2;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = measuredValue.getValue() * measuredValue.getValue();
        System.out.println("degrees/pixel=" + measuredValue.toString());
        for (int i = 0; i < list.size() - 1; ++i) {
            BlobMeas blobMeas2 = list.get(i);
            SkyPoint skyPoint = blobMeas2.getStar().getPosition();
            Dec dec = skyPoint.getDec();
            double d7 = skyPoint.getRA().toDegrees() * dec.cos();
            double d8 = dec.toDegrees();
            double d9 = d7 * d7;
            double d10 = d8 * d8;
            double d11 = blobMeas2.centre.x - blobMeas.centre.x;
            double d12 = blobMeas2.centre.y - blobMeas.centre.y;
            double d13 = d6 * (d11 * d11 + d12 * d12);
            for (int j = i + 1; j < list.size(); ++j) {
                BlobMeas blobMeas3 = list.get(j);
                SkyPoint skyPoint2 = blobMeas3.getStar().getPosition();
                Dec dec2 = skyPoint2.getDec();
                double d14 = skyPoint2.getRA().toDegrees() * dec2.cos();
                double d15 = dec2.toDegrees();
                double d16 = d14 * d14;
                double d17 = d15 * d15;
                double d18 = blobMeas3.centre.x - blobMeas.centre.x;
                double d19 = blobMeas3.centre.y - blobMeas.centre.y;
                double d20 = d6 * (d18 * d18 + d19 * d19);
                double d21 = d11 * d19 - d18 * d12;
                double d22 = 1.0 / (d15 - d8);
                double d23 = (d7 - d14) * d22;
                double d24 = 0.5 * (d13 - d20 - d10 + d17 - d9 + d16) * d22;
                double d25 = -2.0 * (d7 + d23 * (d8 - d24));
                double d26 = d25 * d25;
                double d27 = 1.0 + d23 * d23;
                double d28 = d9 - 2.0 * d8 * d24 + d10 - d13 + d24 * d24;
                double d29 = 4.0 * d27 * d28;
                if (d26 >= d29) {
                    double d30 = StrictMath.sqrt(d26 - d29);
                    double d31 = 0.5 / d27;
                    double d32 = (-d25 + d30) * d31;
                    double d33 = d23 * d32 + d24;
                    double d34 = (-d25 - d30) * d31;
                    double d35 = d23 * d34 + d24;
                    double d36 = (d7 - d32) * (d15 - d33) - (d14 - d32) * (d8 - d33);
                    if (d21 * d36 > 0.0) {
                        d += (d32 /= Maths.cosDegs(d33));
                        d2 += d32 * d32;
                        d3 += d33;
                        d4 += d33 * d33;
                    } else {
                        d += (d34 /= Maths.cosDegs(d35));
                        d2 += d34 * d34;
                        d3 += d35;
                        d4 += d35 * d35;
                    }
                    d5 += 1.0;
                    continue;
                }
                Util.logWarning("No real solution for star position");
            }
        }
        double d37 = d3 / d5;
        double d38 = StrictMath.sqrt(d4 / d5 - d37 * d37);
        Dec dec = new Dec(d37, d38);
        double d39 = d / d5;
        double d40 = StrictMath.sqrt(d2 / d5 - d39 * d39);
        RA rA = new RA(d39, d40);
        SkyPoint skyPoint = new SkyPoint(rA, dec, epoch);
        System.out.println("Result1:" + skyPoint.toString());
        return skyPoint;
    }

    protected SkyPoint measureTargetBlob2(List<BlobMeas> list, BlobMeas blobMeas, Epoch epoch, Image image, MeasuredValue measuredValue) {
        int n = image.getWidth() / 2;
        int n2 = image.getHeight() / 2;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < list.size() - 1; ++i) {
            BlobMeas blobMeas2 = list.get(i);
            SkyPoint skyPoint = blobMeas2.getStar().getPosition();
            Dec dec = skyPoint.getDec();
            double d6 = dec.toDegrees();
            double d7 = skyPoint.getRA().toDegrees();
            double d8 = blobMeas2.centre.x - blobMeas.centre.x;
            double d9 = blobMeas2.centre.y - blobMeas.centre.y;
            double d10 = measuredValue.getValue() * StrictMath.sqrt(d8 * d8 + d9 * d9);
            for (int j = i + 1; j < list.size(); ++j) {
                BlobMeas blobMeas3 = list.get(j);
                SkyPoint skyPoint2 = blobMeas3.getStar().getPosition();
                Dec dec2 = skyPoint2.getDec();
                double d11 = dec2.toDegrees();
                double d12 = skyPoint2.getRA().toDegrees();
                double d13 = blobMeas3.centre.x - blobMeas2.centre.x;
                double d14 = blobMeas3.centre.y - blobMeas2.centre.y;
                double d15 = measuredValue.getValue() * StrictMath.sqrt(d13 * d13 + d14 * d14);
                double d16 = blobMeas3.centre.x - blobMeas.centre.x;
                double d17 = blobMeas3.centre.y - blobMeas.centre.y;
                double d18 = measuredValue.getValue() * StrictMath.sqrt(d16 * d16 + d17 * d17);
                System.out.println("[1]" + blobMeas2.getStar().getId() + " [2]" + blobMeas3.getStar().getId() + " [3]" + blobMeas.getStar().getId());
                System.out.println("d1=" + d10 + " d2=" + d18 + " d12=" + d15);
                Angle angle = Angle.atan2(d6 - d11, d12 - d7);
                double d19 = 0.5 * (d10 + d18 + d15);
                double d20 = 2.0 * StrictMath.sqrt(d19 * (d19 - d10) * (d19 - d18) * (d19 - d15));
                Angle angle2 = Angle.asin(d20 / (d10 * d15));
                Angle angle3 = Angle.asin(d20 / (d18 * d15));
                Angle angle4 = angle3.subtract(angle);
                double d21 = d11 - d18 * angle4.sin();
                double d22 = d12 - d18 * angle4.cos();
                System.out.println("raDegs=" + d22 + " decDegs=" + d21 + " RA=" + new RA(d22).toString() + " Dec=" + new Dec(d21).toString());
                d += d22;
                d2 += d22 * d22;
                d3 += d21;
                d4 += d21 * d21;
                d5 += 1.0;
                Angle angle5 = angle2.add(angle);
                d21 = d6 - d10 * angle5.sin();
                d22 = d7 + d10 * angle5.cos();
                System.out.println("raDegs=" + d22 + " decDegs=" + d21 + " RA=" + new RA(d22).toString() + " Dec=" + new Dec(d21).toString());
                d += d22;
                d2 += d22 * d22;
                d3 += d21;
                d4 += d21 * d21;
                d5 += 1.0;
            }
        }
        double d23 = d3 / d5;
        double d24 = StrictMath.sqrt(d4 / d5 - d23 * d23);
        Dec dec = new Dec(d23, d24);
        double d25 = d / d5;
        double d26 = StrictMath.sqrt(d2 / d5 - d25 * d25);
        RA rA = new RA(d25, d26);
        SkyPoint skyPoint = new SkyPoint(rA, dec, epoch);
        System.out.println("Result2:" + skyPoint.toString());
        return skyPoint;
    }

    protected MeasuredValue calibrateImage(List<BlobMeas> list) {
        double d;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        for (int i = 0; i < list.size() - 1; ++i) {
            BlobMeas blobMeas = list.get(i);
            d = blobMeas.centre.x;
            double d4 = blobMeas.centre.y;
            SkyPoint skyPoint = blobMeas.getStar().getPosition();
            for (int j = i + 1; j < list.size(); ++j) {
                BlobMeas blobMeas2 = list.get(j);
                double d5 = blobMeas2.centre.x;
                double d6 = blobMeas2.centre.y;
                SkyPoint skyPoint2 = blobMeas2.getStar().getPosition();
                SkyVector skyVector = skyPoint.calculateSeparation(skyPoint2);
                double d7 = d5 - d;
                double d8 = d6 - d4;
                double d9 = StrictMath.sqrt(d7 * d7 + d8 * d8);
                double d10 = skyVector.getSeparation().getDegrees() / d9;
                d2 += d10;
                d3 += d10 * d10;
                ++n;
            }
        }
        double d11 = d2 / (double)n;
        d = StrictMath.sqrt(d3 / (double)n - d11 * d11);
        Calibration.Units units = new Calibration.Units(Length.Units.PIXEL, Angle.Units.DEGREES);
        return new MeasuredValue(d11, d, units);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Magnitude magnitude : this.magnitudes) {
            stringBuffer.append(magnitude.toString());
            stringBuffer.append(" ");
        }
        return this.getId() + " at " + this.position.toString() + ", magnitude " + stringBuffer.toString() + ", variability " + this.variability.toString().toLowerCase();
    }

    public String toFoldedString() {
        return this.toFoldedString("\n");
    }

    public String toFoldedString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != this.commonId && this.commonId.length() > 0) {
            stringBuffer.append(this.commonId);
            stringBuffer.append(string);
        }
        if (null != this.hipparcosId && this.hipparcosId.length() > 0) {
            stringBuffer.append("Hipparcos ");
            stringBuffer.append(this.hipparcosId);
            stringBuffer.append(string);
        }
        if (null != this.tychoId && this.tychoId.length() > 0) {
            stringBuffer.append("Tycho ");
            stringBuffer.append(this.tychoId);
            stringBuffer.append(string);
        }
        if (null != this.otherId && this.otherId.length() > 0) {
            stringBuffer.append("Entered ref ");
            stringBuffer.append(this.otherId);
            stringBuffer.append(string);
        }
        if (null != this.position) {
            stringBuffer.append("at ");
            stringBuffer.append(this.position.toFoldedString(string));
        }
        stringBuffer.append("magnitude ");
        if (0 == this.magnitudes.size()) {
            stringBuffer.append("unknown");
            stringBuffer.append(string);
        } else {
            StringBuffer stringBuffer2 = new StringBuffer();
            for (Magnitude magnitude : this.magnitudes) {
                stringBuffer.append(magnitude.toString());
                stringBuffer.append(string);
            }
        }
        if (this.properMotion.isKnown()) {
            stringBuffer.append("Proper motion ");
            stringBuffer.append(string);
            stringBuffer.append(this.properMotion.toFoldedString(string));
        }
        stringBuffer.append("Hipparcos variability ");
        if (null == this.variability) {
            stringBuffer.append("unknown");
            stringBuffer.append(string);
        } else {
            stringBuffer.append(this.variability.toString().toLowerCase());
            stringBuffer.append(string);
        }
        if (null != this.typeOfStellarObject && this.typeOfStellarObject.length() > 0) {
            stringBuffer.append("Type of object: ");
            stringBuffer.append(this.typeOfStellarObject);
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public StringBuffer toXML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("<Star>\n");
        if (null != this.commonId && this.commonId.length() > 0) {
            stringBuffer.append(string);
            stringBuffer.append("\t<CommonId>");
            stringBuffer.append(this.commonId);
            stringBuffer.append("</CommonId>\n");
        }
        if (null != this.hipparcosId && this.hipparcosId.length() > 0) {
            stringBuffer.append(string);
            stringBuffer.append("\t<HipparcosId>");
            stringBuffer.append(this.hipparcosId);
            stringBuffer.append("</HipparcosId>\n");
        }
        if (null != this.tychoId && this.tychoId.length() > 0) {
            stringBuffer.append(string);
            stringBuffer.append("\t<TychoId>");
            stringBuffer.append(this.tychoId);
            stringBuffer.append("</TychoId>\n");
        }
        if (null != this.otherId && this.otherId.length() > 0) {
            stringBuffer.append(string);
            stringBuffer.append("\t<OtherId>");
            stringBuffer.append(this.otherId);
            stringBuffer.append("</OtherId>\n");
        }
        if (null != this.position) {
            stringBuffer.append(string);
            stringBuffer.append("\t<SkyPt>");
            stringBuffer.append(this.position.toXML());
            stringBuffer.append("</SkyPt>\n");
        }
        if (0 != this.magnitudes.size()) {
            for (Magnitude magnitude : this.magnitudes) {
                stringBuffer.append(string);
                stringBuffer.append("\t");
                stringBuffer.append(magnitude.toXML());
                stringBuffer.append("\n");
            }
        }
        if (this.properMotion.isKnown()) {
            stringBuffer.append(string);
            stringBuffer.append("\t");
            stringBuffer.append(this.properMotion.toXML());
            stringBuffer.append("\n");
        }
        if (null != this.variability) {
            stringBuffer.append(string);
            stringBuffer.append("\t<Var>");
            stringBuffer.append(this.variability.toString());
            stringBuffer.append("</Var>\n");
        }
        if (this.typeOfStellarObject.length() > 0) {
            stringBuffer.append(string);
            stringBuffer.append("\t<Type>");
            stringBuffer.append(XmlUtil.escape(new StringBuffer(this.typeOfStellarObject)));
            stringBuffer.append("</Type>\n");
        }
        stringBuffer.append(string);
        stringBuffer.append("</Star>\n");
        return stringBuffer;
    }

    public void setPlotPoint(Point point) {
        this.plotPoint = point;
    }

    public Point getPlotPoint() {
        return this.plotPoint;
    }
}

