/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.astro;

import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import net.grelf.AbstractDialogue;
import net.grelf.Angle;
import net.grelf.FileIO;
import net.grelf.FileIOChartFilter;
import net.grelf.Gaussian;
import net.grelf.Length;
import net.grelf.Maths;
import net.grelf.Timer;
import net.grelf.Util;
import net.grelf.astro.AstroGridGateway;
import net.grelf.astro.Dec;
import net.grelf.astro.Epoch;
import net.grelf.astro.Hipparcos;
import net.grelf.astro.JulianDate;
import net.grelf.astro.Magnitude;
import net.grelf.astro.ProperMotion;
import net.grelf.astro.RA;
import net.grelf.astro.SimbadGateway;
import net.grelf.astro.SkyPoint;
import net.grelf.astro.Star;
import net.grelf.astro.StarChartLoader;
import net.grelf.astro.StarChartSource;
import net.grelf.astro.Tycho;
import net.grelf.astro.Variability;
import net.grelf.grip.DefaultMeasurementHandler;
import net.grelf.grip.DrawingMode;
import net.grelf.grip.GRIP;
import net.grelf.grip.GlassPane;
import net.grelf.grip.HelpMenu;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImPane;
import net.grelf.grip.StarChartFrame;
import net.grelf.image.Calibration;
import net.grelf.image.Image;
import net.grelf.image.Image8or16Base;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class StarChart
extends StarChartLoader {
    private static int chartWidth = 700;
    private static int chartHeight = 700;
    private static int starRadius = 3;
    private float minMagnitude = 0.0f;
    private float maxMagnitude = 18.0f;
    public static final int STAR_SIZE = 10;
    private SkyPoint plotCentre;
    private double fieldRadius = 1.0;
    private double xScale;
    private double yScale;
    private List<Star> stars;
    private static Star selectedStar = null;
    private static StarChart sourceOfSelectedStar = null;
    private static final Pattern CELL_PATTERN = Pattern.compile(">([^><]+)(<SUP>.*</SUP>)?</");

    public List<Star> getStars() {
        return this.stars;
    }

    public static Star getSelectedStar() {
        return selectedStar;
    }

    public static StarChart getSourceOfSelectedStar() {
        return sourceOfSelectedStar;
    }

    public static void createChart() {
        new StarChart();
    }

    public static void createChart(Frame frame) {
        new StarChart(frame);
    }

    private StarChart() {
        new StarChartDialogue();
    }

    private StarChart(Frame frame) {
        new StarChartDialogue(frame);
    }

    public StarChart(String string, RA rA, Dec dec, Epoch epoch, JulianDate julianDate, double d, StarChartSource starChartSource) {
        this(string, rA, dec, epoch, julianDate, d, true, true, starChartSource);
    }

    public StarChart(String string, RA rA, Dec dec, Epoch epoch, JulianDate julianDate, double d, boolean bl, boolean bl2, StarChartSource starChartSource) {
        Object object;
        Serializable serializable;
        Object object2;
        this.plotCentre = new SkyPoint(rA, dec, epoch);
        this.fieldRadius = d * 0.5;
        this.epoch = julianDate;
        if (starChartSource == StarChartSource.SIMBAD) {
            this.stars = SimbadGateway.getInstance().searchCone(this.plotCentre, this.fieldRadius, null, null);
        } else if (starChartSource == StarChartSource.ASTROGRID) {
            this.stars = AstroGridGateway.getInstance().searchCone(this.plotCentre, this.fieldRadius * StrictMath.sqrt(2.0));
        }
        if (null == this.stars) {
            this.stars = new ArrayList<Star>();
            object2 = new Timer("Loading star data", null);
            serializable = new HashMap(10000);
            new Hipparcos().load(this.stars, (Map<String, Star>)((Object)serializable), this.plotCentre, this.epoch, this.fieldRadius);
            new Tycho().load(this.stars, (Map<String, Star>)((Object)serializable), this.plotCentre, this.epoch, this.fieldRadius);
            for (int i = this.stars.size() - 1; i >= 0; --i) {
                Star star = this.stars.get(i);
                object = star.getPosition();
                if (!(StrictMath.abs(((SkyPoint)object).getRA().toDegrees()) < 1.0E-4) || !(StrictMath.abs(((SkyPoint)object).getDec().toDegrees()) < 1.0E-4)) continue;
                this.stars.remove(i);
                Util.logInfo("Removed star {0} from list", star.getId());
            }
            ((Timer)object2).stop();
        }
        if (0 == this.stars.size()) {
            Util.warning("Sorry", "No stars found");
        } else {
            try {
                object2 = new Properties();
                serializable = ClassLoader.getSystemResource("hip_names.properties");
                ((Properties)object2).load(serializable.openStream());
                for (Star star : this.stars) {
                    object = ((Properties)object2).getProperty(star.getHipparcosId().trim());
                    if (null == object) continue;
                    star.setCommonId((String)object);
                }
            }
            catch (IOException iOException) {
                Util.logInfo("Could not load hip_names.properties");
            }
            double d2 = 2.0 * StrictMath.sin(StrictMath.toRadians(this.fieldRadius));
            this.xScale = (double)chartWidth / d2;
            this.yScale = (double)chartHeight / d2;
            this.createFrame(string, this.plotCentre, this.fieldRadius, true, bl, bl2);
        }
    }

    private StarChart(String string, RA rA, Dec dec, Epoch epoch, JulianDate julianDate, double d, boolean bl, boolean bl2, List<Star> list) {
        this.fieldRadius = d * 0.5;
        this.plotCentre = new SkyPoint(rA, dec, epoch);
        this.equinox = epoch;
        this.epoch = julianDate;
        this.initialiseChartCoordinates(this.plotCentre, this.fieldRadius);
        this.stars = list;
        for (Star star : this.stars) {
            this.calculateChartCoordinates(star);
        }
        double d2 = 2.0 * StrictMath.sin(StrictMath.toRadians(this.fieldRadius));
        this.xScale = (double)chartWidth / d2;
        this.yScale = (double)chartHeight / d2;
        this.createFrame(string, this.plotCentre, this.fieldRadius, true, bl, bl2);
    }

    private StarChartFrame createFrame(String string, SkyPoint skyPoint, double d, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        if (null == string) {
            string = d + " degrees around " + skyPoint.getRA().toString() + ", " + skyPoint.getDec().toString() + " (" + skyPoint.getEquinox().toString() + ").";
        }
        StarChartFrame starChartFrame = new StarChartFrame(string, chartWidth, chartHeight, this);
        starChartFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
        Image image = starChartFrame.getImPane().getImage();
        if (!(image instanceof Image8or16Base)) {
            Util.warning(starChartFrame, "Error", (Object)"Star chart is not an 8- or 16-bit image");
            return null;
        }
        if (d >= 2.0) {
            object = new Calibration.Units(Length.Units.PIXEL, Angle.Units.DEGREES);
            image.setCalibration(new Calibration((Calibration.Units)object, 2.0 * d / (double)chartWidth));
        } else {
            object = new Calibration.Units(Length.Units.PIXEL, Angle.Units.ARCMINUTES);
            image.setCalibration(new Calibration((Calibration.Units)object, 2.0 * d * 60.0 / (double)chartWidth));
        }
        object = new Timer("Plotting " + this.stars.size() + " stars", null);
        this.drawStars(image, bl, bl2, bl3);
        ((Timer)object).stop();
        starChartFrame.redisplay();
        starChartFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        return starChartFrame;
    }

    private ImPane createPane(SkyPoint skyPoint, double d, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        GlassPane glassPane = new GlassPane(DrawingMode.STAR_CHART, null, new DefaultMeasurementHandler());
        ImPane imPane = new ImPane(null, chartWidth, chartHeight, glassPane);
        Image image = imPane.getImage();
        if (!(image instanceof Image8or16Base)) {
            Util.warning(imPane, "Error", (Object)"Star chart is not an 8- or 16-bit image");
            return null;
        }
        if (d >= 2.0) {
            object = new Calibration.Units(Length.Units.PIXEL, Angle.Units.DEGREES);
            image.setCalibration(new Calibration((Calibration.Units)object, 2.0 * d / (double)chartWidth));
        } else {
            object = new Calibration.Units(Length.Units.PIXEL, Angle.Units.ARCMINUTES);
            image.setCalibration(new Calibration((Calibration.Units)object, 2.0 * d * 60.0 / (double)chartWidth));
        }
        object = new Timer("Plotting " + this.stars.size() + " stars", null);
        this.drawStars(image, bl, bl2, bl3);
        ((Timer)object).stop();
        return imPane;
    }

    /*
     * WARNING - void declaration
     */
    private void drawStars(Image image, boolean bl, boolean bl2, boolean bl3) {
        int n;
        Object object;
        int n2;
        int n3;
        BufferedImage bufferedImage = ((Image8or16Base)image).getBufferedImage();
        int n4 = bufferedImage.getWidth();
        int n5 = n4 / 2;
        int n6 = bufferedImage.getHeight();
        int n7 = n6 / 2;
        int n8 = Image8or16Base.getNBands(bufferedImage);
        int n9 = Image8or16Base.getMaxLevel(bufferedImage);
        int[] nArray = new int[n8];
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n10 = n5;
        int n11 = n7;
        float f = this.findMagnitudeRange();
        float[] fArray = this.getMagnitudeFactors();
        for (Star iterator : this.stars) {
            double d = iterator.xdd * this.xScale;
            double d2 = iterator.zdd * this.yScale;
            n3 = (int)StrictMath.round((double)n10 + d);
            n2 = (int)StrictMath.round((double)n11 - d2);
            iterator.setPlotPoint(new Point(n3, n2));
            float f2 = iterator.getMagnitude().getValue() - this.minMagnitude;
            float f3 = fArray[(int)f2];
            starRadius = 10 - (int)(8.0f * f2 / f);
            float[][] fArray2 = this.calculateStarProfile(n9, starRadius);
            int n12 = 0;
            int n13 = n2 - starRadius;
            int n14 = 0;
            while (n13 <= n2 + starRadius) {
                if (n13 >= 0 && n13 < n6) {
                    int n15 = n3 - starRadius;
                    int n16 = 0;
                    while (n15 <= n3 + starRadius) {
                        if (n15 >= 0 && n15 < n4) {
                            writableRaster.getPixel(n15, n13, nArray);
                            n12 = (int)(fArray2[n16][n14] * f3);
                            int n17 = 0;
                            while (n17 < n8) {
                                int n18 = n17++;
                                nArray[n18] = nArray[n18] + n12;
                            }
                            writableRaster.setPixel(n15, n13, nArray);
                        }
                        ++n15;
                        ++n16;
                    }
                }
                ++n13;
                ++n14;
            }
        }
        int n19 = n9;
        if (bl) {
            nArray[0] = n19;
            boolean i = true;
            while (i < n8) {
                nArray[i] = 0;
                ++i;
            }
            for (Star star : this.stars) {
                int n20;
                object = star.getOtherId();
                if (null == object || 0 >= object.length()) continue;
                Point point = star.getPlotPoint();
                n = point.x;
                n3 = point.y;
                for (n2 = n - starRadius; n2 <= n + starRadius; ++n2) {
                    if (n2 < 0 || n2 >= n4) continue;
                    n20 = n3 - starRadius;
                    if (n20 >= 0 && n20 < n6) {
                        writableRaster.setPixel(n2, n20, nArray);
                    }
                    if ((n20 = n3 + starRadius) < 0 || n20 >= n6) continue;
                    writableRaster.setPixel(n2, n20, nArray);
                }
                for (n2 = n3 - starRadius; n2 <= n3 + starRadius; ++n2) {
                    if (n2 < 0 || n2 >= n6) continue;
                    n20 = n - starRadius;
                    if (n20 >= 0 && n20 < n4) {
                        writableRaster.setPixel(n20, n2, nArray);
                    }
                    if ((n20 = n + starRadius) < 0 || n20 >= n4) continue;
                    writableRaster.setPixel(n20, n2, nArray);
                }
            }
        }
        if (bl2) {
            void var19_26;
            nArray[0] = n19;
            boolean bl4 = true;
            while (var19_26 < n8) {
                nArray[var19_26] = 0;
                ++var19_26;
            }
            for (Star star : this.stars) {
                int n21;
                object = star.getVariability();
                if (null == object || Variability.NONE == object) continue;
                Point point = star.getPlotPoint();
                n = point.x;
                n3 = point.y;
                for (n2 = n - starRadius; n2 <= n + starRadius; ++n2) {
                    if (n2 < 0 || n2 >= n4) continue;
                    n21 = n3 - starRadius;
                    if (n21 >= 0 && n21 < n6) {
                        writableRaster.setPixel(n2, n21, nArray);
                    }
                    if ((n21 = n3 + starRadius) < 0 || n21 >= n6) continue;
                    writableRaster.setPixel(n2, n21, nArray);
                }
                for (n2 = n3 - starRadius; n2 <= n3 + starRadius; ++n2) {
                    if (n2 < 0 || n2 >= n6) continue;
                    n21 = n - starRadius;
                    if (n21 >= 0 && n21 < n4) {
                        writableRaster.setPixel(n21, n2, nArray);
                    }
                    if ((n21 = n + starRadius) < 0 || n21 >= n4) continue;
                    writableRaster.setPixel(n21, n2, nArray);
                }
            }
        }
        if (bl3) {
            int n22;
            int n23 = n7;
            for (n22 = 0; n22 < 4; ++n22) {
                writableRaster.getPixel(n22, n23, nArray);
                nArray[0] = nArray[0] + n19;
                writableRaster.setPixel(n22, n23, nArray);
            }
            n23 = n7;
            for (n22 = n5 - 4; n22 <= n5 + 4; ++n22) {
                writableRaster.getPixel(n22, n23, nArray);
                nArray[0] = nArray[0] + n19;
                writableRaster.setPixel(n22, n23, nArray);
            }
            n23 = n7;
            for (n22 = n4 - 4; n22 < n4; ++n22) {
                writableRaster.getPixel(n22, n23, nArray);
                nArray[0] = nArray[0] + n19;
                writableRaster.setPixel(n22, n23, nArray);
            }
            n22 = n5;
            for (n23 = 0; n23 < 4; ++n23) {
                writableRaster.getPixel(n22, n23, nArray);
                nArray[0] = nArray[0] + n19;
                writableRaster.setPixel(n22, n23, nArray);
            }
            n22 = n5;
            for (n23 = n7 - 4; n23 <= n7 + 4; ++n23) {
                writableRaster.getPixel(n22, n23, nArray);
                nArray[0] = nArray[0] + n19;
                writableRaster.setPixel(n22, n23, nArray);
            }
            n22 = n5;
            for (n23 = n6 - 4; n23 < n6; ++n23) {
                writableRaster.getPixel(n22, n23, nArray);
                nArray[0] = nArray[0] + n19;
                writableRaster.setPixel(n22, n23, nArray);
            }
        }
        image.autoStretch(true);
    }

    private float[][] calculateStarProfile(int n, int n2) {
        int n3 = 2 * n2 + 1;
        float[][] fArray = new float[n3][n3];
        float f = (float)n2 / 2.0f;
        Gaussian gaussian = new Gaussian(0.0f, f);
        int n4 = 0;
        int n5 = -n2;
        while (n4 < n3) {
            int n6 = 0;
            int n7 = -n2;
            while (n6 < n3) {
                fArray[n6][n4] = (float)n * gaussian.calc(n7) * gaussian.calc(n5);
                ++n6;
                ++n7;
            }
            ++n4;
            ++n5;
        }
        return fArray;
    }

    private float findMagnitudeRange() {
        boolean bl = true;
        for (Star star : this.stars) {
            if (bl) {
                this.minMagnitude = this.maxMagnitude = star.getMagnitude().getValue();
                bl = false;
                continue;
            }
            float f = star.getMagnitude().getValue();
            if (f < this.minMagnitude) {
                this.minMagnitude = f;
                continue;
            }
            if (!(f > this.maxMagnitude)) continue;
            this.maxMagnitude = f;
        }
        return this.maxMagnitude - this.minMagnitude;
    }

    private float[] getMagnitudeFactors() {
        int n = (int)(this.maxMagnitude - this.minMagnitude + 0.5f);
        float[] fArray = new float[n + 1];
        for (int i = 0; i < n; ++i) {
            fArray[i] = 1.0f - 0.4f * ((float)i / (float)n);
        }
        return fArray;
    }

    public void showNearestStarData(int n, int n2) {
        selectedStar = this.findNearestStar(n, n2);
        sourceOfSelectedStar = this;
        JTextArea jTextArea = new JTextArea(selectedStar.toFoldedString() + "\n\nThe selected star is now available so that if on a photo" + "\nyou (1) segment stars (on the Levels menu) and (2) click on" + "\na blob to magnify it, you can then (3) on the blob menu" + "\npaste the star data, identifying the blob as this star and" + "\nattaching to it all of the details shown above.");
        Util.message("Star", jTextArea);
    }

    public Star findNearestStar(int n, int n2) {
        double d = chartWidth;
        Star star = null;
        for (Star star2 : this.stars) {
            Point point = star2.getPlotPoint();
            int n3 = point.x - n;
            int n4 = point.y - n2;
            double d2 = StrictMath.sqrt(n3 * n3 + n4 * n4);
            if (!(d2 < d)) continue;
            d = d2;
            star = star2;
        }
        return star;
    }

    public static void mergeCharts(List<StarChartFrame> list) {
        FileFilter[] fileFilterArray = new FileFilter[]{new FileIOChartFilter(1)};
        File[] fileArray = FileIO.selectInputFiles("Select .chart files", null, fileFilterArray);
        if (null != fileArray && fileArray.length > 0) {
            Object object;
            Comparable<File> comparable2;
            ArrayList<Star> arrayList = new ArrayList<Star>();
            Epoch epoch = null;
            JulianDate julianDate = null;
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            ArrayList<Double> arrayList3 = new ArrayList<Double>();
            for (Comparable<File> comparable2 : fileArray) {
                object = StarChart.loadFromXML(comparable2.getPath());
                if (null == object) continue;
                Epoch d = ((StarChartLoader)object).getEquinox();
                if (null == epoch) {
                    epoch = d;
                }
                JulianDate julianDate2 = ((StarChartLoader)object).getEpoch();
                if (null == julianDate) {
                    julianDate = julianDate2;
                }
                for (Star star : ((StarChart)object).stars) {
                    boolean bl = false;
                    for (Star star2 : arrayList) {
                        String string = star.getCommonId();
                        String string2 = star.getHipparcosId();
                        String string3 = star.getTychoId();
                        String string4 = star.getOtherId();
                        if (!(string.length() > 0 && star2.getCommonId().equals(string) || string2.length() > 0 && star2.getHipparcosId().equals(string2) || string3.length() > 0 && star2.getTychoId().equals(string3)) && (string4.length() <= 0 || !star2.getOtherId().equals(string4))) continue;
                        bl = true;
                        if (string.length() > 0 && star2.getCommonId().length() == 0) {
                            star2.setCommonId(string);
                        }
                        if (string2.length() > 0 && star2.getHipparcosId().length() == 0) {
                            star2.setHipparcosId(string2);
                        }
                        if (string3.length() > 0 && star2.getTychoId().length() == 0) {
                            star2.setTychoId(string3);
                        }
                        if (string4.length() > 0 && star2.getOtherId().length() == 0) {
                            star2.setOtherId(string4);
                        }
                        List<Magnitude> list2 = star.getMagnitudes();
                        for (Magnitude magnitude : list2) {
                            if (null != star2.getMagnitude(magnitude.getBandId())) continue;
                            star2.addMagnitude(magnitude);
                        }
                    }
                    if (bl) continue;
                    SkyPoint skyPoint = star.getPosition();
                    if (!skyPoint.getEquinox().equals(epoch)) {
                        skyPoint.changeEquinox(epoch);
                    }
                    star.setPosition(skyPoint);
                    arrayList2.add(skyPoint.getRA().toDegrees());
                    arrayList3.add(skyPoint.getDec().toDegrees());
                    arrayList.add(star);
                }
            }
            String string = "Merged chart";
            Maths.Statistics statistics = Maths.angleStatistics(arrayList2);
            Maths.Statistics statistics2 = Maths.angleStatistics(arrayList3);
            comparable2 = new RA(Maths.in360((statistics.min + statistics.max) * 0.5));
            object = new Dec(Maths.in360((statistics2.min + statistics2.max) * 0.5));
            double d = StrictMath.max(Maths.in360(statistics.max - statistics.min), Maths.in360(statistics2.max - statistics2.min));
            StarChart starChart = new StarChart(string, (RA)comparable2, (Dec)object, epoch, julianDate, d, true, true, arrayList);
            String string5 = FileIO.selectOutputFile("Save merged chart", null, fileFilterArray, "merged.chart");
            if (null != string5) {
                starChart.saveAsXML(string5, string);
            }
            if (null != list && list.size() > 0 && Util.confirm("Confirm", "Close the charts again?")) {
                for (StarChartFrame starChartFrame : list) {
                    ((ImFrame)starChartFrame).dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StarChart loadFromHTML(String string) {
        block48: {
            BufferedReader bufferedReader = null;
            try {
                Object object;
                File file = new File(string);
                bufferedReader = new BufferedReader(new FileReader(file));
                char[] cArray = new char[(int)file.length()];
                int n = bufferedReader.read(cArray);
                bufferedReader.close();
                String string2 = new String(cArray).toUpperCase();
                if (-1 == string2.indexOf("AAVSO")) {
                    Util.warning("Error", "Could not find text \"AAVSO\" in file\n{0}", string);
                    StarChart starChart = null;
                    return starChart;
                }
                int n2 = string2.indexOf("<TABLE");
                if (-1 == n2) {
                    Util.warning("Error", "Could not find TABLE element in file\n{0}", string);
                    StarChart starChart = null;
                    return starChart;
                }
                int n3 = string2.indexOf("</TABLE>", n2);
                if (-1 == n3) {
                    Util.warning("Error", "Could not find end of TABLE element in file\n{0}", string);
                    StarChart starChart = null;
                    return starChart;
                }
                String string3 = string2.substring(n2, n3 + "</TABLE>".length());
                String[] stringArray = string3.split("<TR>");
                int n4 = 0;
                int n5 = -1;
                int n6 = -1;
                int n7 = -1;
                int n8 = -1;
                int n9 = -1;
                int n10 = -1;
                int n11 = -1;
                int n12 = -1;
                Epoch epoch = new Epoch(2000.0f);
                JulianDate julianDate = new JulianDate(2451545.0);
                ArrayList<Star> arrayList = new ArrayList<Star>();
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                ArrayList<Double> arrayList3 = new ArrayList<Double>();
                for (String string4 : stringArray) {
                    double d;
                    object = string4.split("<TD");
                    int n13 = ((String[])object).length;
                    if (n13 <= 3) continue;
                    if (1 == ++n4) {
                        for (int i = 0; i < n13; ++i) {
                            String starChart = StarChart.getCellContent(object[i]);
                            if (starChart.equals("AUID")) {
                                n5 = i;
                                continue;
                            }
                            if (starChart.startsWith("RA")) {
                                n6 = i;
                                continue;
                            }
                            if (starChart.startsWith("DEC")) {
                                n7 = i;
                                continue;
                            }
                            if (starChart.equals("U")) {
                                n8 = i;
                                continue;
                            }
                            if (starChart.equals("B")) {
                                n9 = i;
                                continue;
                            }
                            if (starChart.equals("V")) {
                                n10 = i;
                                continue;
                            }
                            if (starChart.equals("RC")) {
                                n11 = i;
                                continue;
                            }
                            if (!starChart.equals("IC")) continue;
                            n12 = i;
                        }
                        continue;
                    }
                    Star star = new Star();
                    if (n5 != -1) {
                        star.setOtherId(StarChart.getCellContent(object[n5]));
                    }
                    if (n6 != -1 && n7 != -1) {
                        d = StarChart.getDegrees(StarChart.getCellContent(object[n6]));
                        arrayList2.add(d);
                        double d2 = StarChart.getDegrees(StarChart.getCellContent(object[n7]));
                        arrayList3.add(d2);
                        SkyPoint skyPoint = new SkyPoint(new RA(d), new Dec(d2), epoch);
                        star.setPosition(skyPoint);
                    }
                    if (n8 != -1 && (d = StarChart.getValue(StarChart.getCellContent(object[n8]))) != 0.0) {
                        star.addMagnitude(new Magnitude((float)d, "U"));
                    }
                    if (n9 != -1 && (d = StarChart.getValue(StarChart.getCellContent(object[n9]))) != 0.0) {
                        star.addMagnitude(new Magnitude((float)d, "B"));
                    }
                    if (n10 != -1 && (d = StarChart.getValue(StarChart.getCellContent(object[n10]))) != 0.0) {
                        star.addMagnitude(new Magnitude((float)d, "V"));
                    }
                    if (n11 != -1 && (d = StarChart.getValue(StarChart.getCellContent(object[n11]))) != 0.0) {
                        star.addMagnitude(new Magnitude((float)d, "Rc"));
                    }
                    if (n12 != -1 && (d = StarChart.getValue(StarChart.getCellContent(object[n12]))) != 0.0) {
                        star.addMagnitude(new Magnitude((float)d, "Ic"));
                    }
                    arrayList.add(star);
                }
                if (arrayList2.size() == 0) {
                    Util.warning("Sorry", "No star data found in file");
                    break block48;
                }
                String string5 = "AAVSO chart";
                Maths.Statistics statistics = Maths.angleStatistics(arrayList2);
                Maths.Statistics statistics2 = Maths.angleStatistics(arrayList3);
                RA rA = new RA(Maths.in360((statistics.min + statistics.max) * 0.5));
                object = new Dec(Maths.in360((statistics2.min + statistics2.max) * 0.5));
                double d = StrictMath.max(Maths.in360(statistics.max - statistics.min), Maths.in360(statistics2.max - statistics2.min));
                StarChart starChart = new StarChart(string5, rA, (Dec)object, epoch, julianDate, d, true, true, arrayList);
                return starChart;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Util.logWarning(fileNotFoundException.toString());
            }
            catch (IOException iOException) {
                Util.logWarning(iOException.toString());
            }
            finally {
                try {
                    if (null != bufferedReader) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    Util.logWarning(iOException.toString());
                }
            }
        }
        return null;
    }

    private static String getCellContent(String string) {
        try {
            Matcher matcher = CELL_PATTERN.matcher(string);
            if (matcher.find()) {
                return matcher.group(1);
            }
        }
        catch (IllegalStateException illegalStateException) {
            Util.logWarning("No match");
        }
        return "";
    }

    private static double getDegrees(String string) {
        int n = string.indexOf("[");
        int n2 = string.indexOf("D]");
        if (-1 == n || -1 == n2) {
            return 0.0;
        }
        return StarChart.getValue(string.substring(n + 1, n2));
    }

    private static double getValue(String string) {
        int n = string.indexOf("(");
        if (-1 != n) {
            string = string.substring(0, n);
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public static StarChart loadFromXML(String string) {
        try {
            Timer timer = new Timer("Loading star chart data from " + string, null);
            InputSource inputSource = new InputSource(new FileReader(string));
            ChartSaxHandler chartSaxHandler = new ChartSaxHandler();
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", false);
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            xMLReader.setContentHandler(chartSaxHandler);
            xMLReader.parse(inputSource);
            timer.stop();
            return chartSaxHandler.getStarChart();
        }
        catch (SAXParseException sAXParseException) {
            Util.logWarning("{0}[line {1}, col {2}]", sAXParseException.toString(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
        }
        catch (SAXException sAXException) {
            Util.logWarning(sAXException.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            Util.logWarning(fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            Util.logWarning(iOException.toString());
        }
        Util.warning("Error", "Failed to load star chart data");
        return null;
    }

    public void saveAsXML(String string, String string2) {
        Timer timer = new Timer("Saving star chart data in " + string, null);
        try {
            PrintWriter printWriter = new PrintWriter(string);
            printWriter.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            printWriter.println("<!-- Written by GRIP v12.6.24 from www.grelf.net -->");
            printWriter.println(this.toXML(string2).toString());
            printWriter.close();
            timer.stop();
        }
        catch (IOException iOException) {
            Util.logWarning(iOException.toString());
            Util.warning("Error", "Failed to save star chart data");
        }
    }

    public StringBuffer toXML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<StarChart>\n");
        stringBuffer.append("\t<Chart>");
        stringBuffer.append(string);
        stringBuffer.append("</Chart>\n");
        stringBuffer.append("\t<Centre>");
        stringBuffer.append(this.plotCentre.toXML());
        stringBuffer.append("</Centre>\n");
        stringBuffer.append("\t<Radius>");
        stringBuffer.append(this.fieldRadius);
        stringBuffer.append("</Radius>\n");
        for (Star star : this.stars) {
            stringBuffer.append(star.toXML("\t"));
        }
        stringBuffer.append("</StarChart>");
        return stringBuffer;
    }

    public static class StarChartDialogue
    extends AbstractDialogue
    implements ActionListener {
        private JLabel nameLabel = new JLabel("Name of object");
        private JTextField name = new JTextField(8);
        private JButton nameButton = new JButton("Get coordinates");
        private JLabel raLabel = new JLabel("RA (0h0m0s..23h59m59.99s)");
        private JTextField raH = new JTextField(8);
        private JLabel raHLabel = new JLabel(" h ");
        private JTextField raM = new JTextField(8);
        private JLabel raMLabel = new JLabel(" m ");
        private JTextField raS = new JTextField(8);
        private JLabel raSLabel = new JLabel(" s ");
        private JLabel decLabel = new JLabel("Dec (-90d0m0s..+90d0m0s)");
        private JTextField decD = new JTextField(8);
        private JLabel decDLabel = new JLabel(" d ");
        private JTextField decM = new JTextField(8);
        private JLabel decMLabel = new JLabel(" m ");
        private JTextField decS = new JTextField(8);
        private JLabel decSLabel = new JLabel(" s ");
        private JLabel equinoxLabel = new JLabel("Equinox (for coordinates)");
        private JComboBox equinoxBox = new JComboBox<String>(new String[]{"B1950.0", "J2000.0", "J2010.0", "J2020.0", "J2030.0", "J2040.0", "J2050.0"});
        private JLabel epochLabel = new JLabel("Epoch (for proper motion)");
        private JTextField epochField = new JTextField("", 8);
        private JLabel fieldLabel = new JLabel("Field width (not negative)");
        private JTextField fieldD = new JTextField("1", 8);
        private JLabel fieldDLabel = new JLabel(" d ");
        private JTextField fieldM = new JTextField(8);
        private JLabel fieldMLabel = new JLabel(" m ");
        private JTextField fieldS = new JTextField(8);
        private JLabel fieldSLabel = new JLabel(" s ");
        private JLabel spacer1Label = new JLabel(" ");
        private JLabel spacer2Label = new JLabel(" ");
        private JLabel spacer3Label = new JLabel(" ");
        private JLabel spacer4Label = new JLabel(" ");
        private JLabel spacer5Label = new JLabel(" ");
        private JLabel spacer6Label = new JLabel(" ");
        private JLabel spacer7Label = new JLabel(" ");
        private JLabel spacer8Label = new JLabel(" ");
        private JLabel spacer9Label = new JLabel(" ");
        private JLabel note1Label = new JLabel("You can put decimals in any of the fields above.");
        private JLabel note2Label = new JLabel("Empty fields are considered to be 0.");
        private JLabel radiusLabel = new JLabel("Star radius (pixels) = Gaussian half width");
        private JTextField radius = new JTextField("" + StarChart.access$200(), 8);
        private JCheckBox variabilityCheck = new JCheckBox("Mark Hipparcos variables on chart", false);
        private JCheckBox centreMarkCheck = new JCheckBox("Mark centre of chart", true);
        private JLabel chartSizeLabel = new JLabel("Chart size (pixels)");
        private JTextField chartWidthField = new JTextField("" + StarChart.access$300(), 8);
        private JLabel chartXLabel = new JLabel(" x ");
        private JTextField chartHeightField = new JTextField("" + StarChart.access$400(), 8);
        private JLabel serviceLabel = new JLabel("Data source ");
        private JList serviceList = null;
        private JButton createButton = new JButton("Create chart");
        private JButton cancelButton = new JButton("Cancel");
        private JButton helpButton = new JButton("Help");
        private static final String sSIMBAD = "Simbad";
        private static final String sASTROGRID = "AstroGrid ";
        private static final String sLOCAL = "Use local files";

        public StarChartDialogue() {
            this((Frame)null);
        }

        public StarChartDialogue(Frame frame) {
            super(frame, "Star chart", false);
            String[] stringArray;
            Container container = this.getContentPane();
            container.setLayout(new GridBagLayout());
            this.placeControl(container, this.nameLabel, 0, 0, 1, 1);
            this.placeControl(container, this.name, 2, 0, 1, 1);
            this.placeControl(container, this.nameButton, 4, 0, 1, 1);
            this.nameButton.setActionCommand("name");
            this.nameButton.addActionListener(this);
            this.placeControl(container, this.raLabel, 0, 1, 6, 1);
            this.placeControl(container, this.raH, 0, 2, 1, 1);
            this.placeControl(container, this.raHLabel, 1, 2, 1, 1);
            this.placeControl(container, this.raM, 2, 2, 1, 1);
            this.placeControl(container, this.raMLabel, 3, 2, 1, 1);
            this.placeControl(container, this.raS, 4, 2, 1, 1);
            this.placeControl(container, this.raSLabel, 5, 2, 1, 1);
            this.placeControl(container, this.spacer1Label, 0, 3, 6, 1);
            this.placeControl(container, this.decLabel, 0, 4, 6, 1);
            this.placeControl(container, this.decD, 0, 5, 1, 1);
            this.placeControl(container, this.decDLabel, 1, 5, 1, 1);
            this.placeControl(container, this.decM, 2, 5, 1, 1);
            this.placeControl(container, this.decMLabel, 3, 5, 1, 1);
            this.placeControl(container, this.decS, 4, 5, 1, 1);
            this.placeControl(container, this.decSLabel, 5, 5, 1, 1);
            this.placeControl(container, this.spacer2Label, 0, 6, 6, 1);
            this.placeControl(container, this.equinoxLabel, 0, 7, 2, 1);
            this.placeControl(container, this.equinoxBox, 2, 7, 1, 1);
            this.equinoxBox.setSelectedIndex(1);
            this.placeControl(container, this.epochLabel, 0, 8, 2, 1);
            this.placeControl(container, this.epochField, 2, 8, 3, 1);
            this.epochField.setText("2012.0");
            this.placeControl(container, this.spacer3Label, 0, 9, 6, 1);
            this.placeControl(container, this.fieldLabel, 0, 10, 6, 1);
            this.placeControl(container, this.fieldD, 0, 11, 1, 1);
            this.placeControl(container, this.fieldDLabel, 1, 11, 1, 1);
            this.placeControl(container, this.fieldM, 2, 11, 1, 1);
            this.placeControl(container, this.fieldMLabel, 3, 11, 1, 1);
            this.placeControl(container, this.fieldS, 4, 11, 1, 1);
            this.placeControl(container, this.fieldSLabel, 5, 11, 1, 1);
            this.placeControl(container, this.spacer4Label, 0, 12, 6, 1);
            this.placeControl(container, this.note1Label, 0, 13, 6, 1);
            this.placeControl(container, this.note2Label, 0, 14, 6, 1);
            this.placeControl(container, this.spacer5Label, 0, 15, 6, 1);
            this.placeControl(container, this.radiusLabel, 0, 16, 6, 1);
            this.placeControl(container, this.radius, 2, 17, 1, 1);
            this.placeControl(container, this.spacer6Label, 0, 18, 6, 1);
            this.placeControl(container, this.variabilityCheck, 2, 19, 4, 1);
            this.placeControl(container, this.centreMarkCheck, 2, 20, 4, 1);
            this.placeControl(container, this.spacer7Label, 0, 21, 6, 1);
            this.placeControl(container, this.chartSizeLabel, 0, 22, 6, 1);
            this.placeControl(container, this.chartWidthField, 2, 23, 1, 1);
            this.placeControl(container, this.chartXLabel, 3, 23, 1, 1);
            this.placeControl(container, this.chartHeightField, 4, 23, 1, 1);
            this.chartWidthField.setActionCommand("width");
            this.chartWidthField.addActionListener(this);
            this.chartHeightField.setActionCommand("height");
            this.chartHeightField.addActionListener(this);
            this.placeControl(container, this.spacer8Label, 0, 24, 6, 1);
            this.placeControl(container, this.serviceLabel, 1, 25, 1, 1);
            String[] stringArray2 = null;
            try {
                stringArray = AstroGridGateway.getInstance();
                stringArray2 = stringArray.getAcceptableConeServiceURIs();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                stringArray2 = new String[]{"[AstroGrid not available]"};
            }
            stringArray = new String[stringArray2.length + 2];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray[i + 2] = sASTROGRID + stringArray2[i];
            }
            stringArray[0] = sLOCAL;
            stringArray[1] = sSIMBAD;
            this.serviceList = new JList<String>(stringArray);
            this.serviceList.setSelectionMode(0);
            this.serviceList.setSelectedIndex(0);
            this.placeControl(container, this.serviceList, 2, 25, 4, 1);
            this.placeControl(container, this.spacer9Label, 0, 26, 6, 1);
            this.createButton.setActionCommand("create");
            this.createButton.addActionListener(this);
            this.placeControl(container, this.createButton, 0, 27, 2, 1);
            this.cancelButton.setActionCommand("cancel");
            this.cancelButton.addActionListener(this);
            this.placeControl(container, this.cancelButton, 2, 27, 2, 1);
            this.helpButton.setActionCommand("help");
            this.helpButton.addActionListener(this);
            this.placeControl(container, this.helpButton, 4, 27, 2, 1);
            this.pack();
            this.raH.requestFocusInWindow();
            this.setResizable(false);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block59: {
                String string = actionEvent.getActionCommand();
                if (string.equals("cancel")) {
                    this.setVisible(false);
                    this.dispose();
                } else if (string.equals("create")) {
                    int n = 0;
                    try {
                        double d = this.getNumericField(this.raH);
                        ++n;
                        double d2 = this.getNumericField(this.raM);
                        ++n;
                        double d3 = this.getNumericField(this.raS);
                        ++n;
                        boolean bl = this.decD.getText().startsWith("-");
                        double d4 = this.getNumericField(this.decD);
                        ++n;
                        double d5 = this.getNumericField(this.decM);
                        ++n;
                        double d6 = this.getNumericField(this.decS);
                        ++n;
                        Epoch epoch = null;
                        switch (this.equinoxBox.getSelectedIndex()) {
                            case 0: {
                                epoch = new Epoch('B', 1950.0f);
                                break;
                            }
                            case 1: {
                                epoch = new Epoch('J', 2000.0f);
                                break;
                            }
                            case 2: {
                                epoch = new Epoch('J', 2010.0f);
                                break;
                            }
                            case 3: {
                                epoch = new Epoch('J', 2020.0f);
                                break;
                            }
                            case 4: {
                                epoch = new Epoch('J', 2030.0f);
                                break;
                            }
                            case 5: {
                                epoch = new Epoch('J', 2040.0f);
                                break;
                            }
                            case 6: {
                                epoch = new Epoch('J', 2050.0f);
                                break;
                            }
                            default: {
                                epoch = new Epoch('J', 2000.0f);
                            }
                        }
                        double d7 = this.getNumericField(this.epochField);
                        long l = (long)((d7 - 1970.0) * 365.2425) * 86400L * 1000L;
                        JulianDate julianDate = new JulianDate(l);
                        ++n;
                        double d8 = this.getNumericField(this.fieldD);
                        ++n;
                        double d9 = this.getNumericField(this.fieldM);
                        ++n;
                        double d10 = this.getNumericField(this.fieldS);
                        ++n;
                        starRadius = Integer.parseInt(this.radius.getText());
                        ++n;
                        if (starRadius < 1) {
                            throw new NumberFormatException();
                        }
                        RA rA = new RA(d, d2, d3);
                        if (bl) {
                            if (d4 > 0.0) {
                                d4 = -d4;
                            }
                            if (d5 > 0.0) {
                                d5 = -d5;
                            }
                            if (d6 > 0.0) {
                                d6 = -d6;
                            }
                        }
                        Dec dec = new Dec(d4, d5, d6);
                        ++n;
                        double d11 = dec.toDegrees();
                        if (d11 < -90.0 || d11 > 90.0) {
                            throw new NumberFormatException();
                        }
                        ++n;
                        double d12 = new Dec(d8, d9, d10).toDegrees();
                        if (d12 < 0.0) {
                            throw new NumberFormatException();
                        }
                        ++n;
                        chartWidth = Integer.parseInt(this.chartWidthField.getText());
                        if (chartWidth < 1) {
                            throw new NumberFormatException();
                        }
                        ++n;
                        chartHeight = Integer.parseInt(this.chartHeightField.getText());
                        if (chartWidth < 1) {
                            throw new NumberFormatException();
                        }
                        String string2 = (String)this.serviceList.getSelectedValue();
                        StarChartSource starChartSource = null;
                        if (string2.equals(sLOCAL)) {
                            starChartSource = StarChartSource.LOCAL_FILES;
                        } else if (string2.equals(sSIMBAD)) {
                            starChartSource = StarChartSource.SIMBAD;
                        } else {
                            starChartSource = StarChartSource.ASTROGRID;
                            String string3 = (String)this.serviceList.getSelectedValue();
                            String string4 = string3.substring(sASTROGRID.length());
                            AstroGridGateway.getInstance().assignConeServiceURI(string4);
                        }
                        if (chartWidth != chartHeight) {
                            if (Util.confirm(this, "Warning", "Chart width and height differ so\nchart will be stretched in the larger direction")) {
                                this.setVisible(false);
                                this.dispose();
                                new StarChart(null, rA, dec, epoch, julianDate, d12, this.variabilityCheck.isSelected(), this.centreMarkCheck.isSelected(), starChartSource);
                            }
                            break block59;
                        }
                        this.setVisible(false);
                        this.dispose();
                        new StarChart(null, rA, dec, epoch, julianDate, d12, this.variabilityCheck.isSelected(), this.centreMarkCheck.isSelected(), starChartSource);
                    }
                    catch (NumberFormatException numberFormatException) {
                        StringBuffer stringBuffer = new StringBuffer("Invalid number in field for ");
                        switch (n) {
                            case 0: {
                                stringBuffer.append("RA hours");
                                break;
                            }
                            case 1: {
                                stringBuffer.append("RA minutes");
                                break;
                            }
                            case 2: {
                                stringBuffer.append("RA seconds");
                                break;
                            }
                            case 3: {
                                stringBuffer.append("Dec degrees");
                                break;
                            }
                            case 4: {
                                stringBuffer.append("Dec minutes");
                                break;
                            }
                            case 5: {
                                stringBuffer.append("Dec seconds");
                                break;
                            }
                            case 6: {
                                stringBuffer.append("epoch");
                                break;
                            }
                            case 7: {
                                stringBuffer.append("field width degrees");
                                break;
                            }
                            case 8: {
                                stringBuffer.append("field width minutes");
                                break;
                            }
                            case 9: {
                                stringBuffer.append("field width seconds");
                                break;
                            }
                            case 10: {
                                stringBuffer.append("star radius (must be a whole number)");
                                break;
                            }
                            case 11: {
                                stringBuffer.append("star radius (must be at least 1)");
                                break;
                            }
                            case 12: {
                                stringBuffer.append("Dec (out of range -90..+90)");
                                break;
                            }
                            case 13: {
                                stringBuffer.append("field width (must be positive)");
                                break;
                            }
                            case 14: {
                                stringBuffer.append("chart width (must be positive)");
                                break;
                            }
                            case 15: {
                                stringBuffer.append("chart height (must be positive)");
                            }
                        }
                        Util.warning(this, "Error", (Object)stringBuffer.toString());
                    }
                } else if (string.equals("help")) {
                    HelpMenu.help("pages/star_chart.html");
                } else if (string.equals("height")) {
                    this.chartWidthField.setText(this.chartHeightField.getText());
                } else if (string.equals("name")) {
                    this.setCursor(GRIP.GRIP_WAIT_CURSOR);
                    try {
                        Star star = SimbadGateway.getInstance().getStarFromId(this.name.getText(), "", null);
                        if (null == star || null == star.getPosition()) {
                            Util.message(this, "Sorry", "Object name not found");
                            this.raH.setText("");
                            this.raM.setText("");
                            this.raS.setText("");
                            this.decD.setText("");
                            this.decM.setText("");
                            this.decS.setText("");
                        } else {
                            SkyPoint skyPoint = star.getPosition();
                            RA rA = skyPoint.getRA();
                            this.raH.setText("" + rA.getHour());
                            this.raM.setText("" + rA.getMinute());
                            this.raS.setText("" + rA.getSecond());
                            Dec dec = skyPoint.getDec();
                            String string5 = dec.toDegrees() > 0.0 ? "+" : "-";
                            this.decD.setText(string5 + StrictMath.abs(dec.getDegree()));
                            this.decM.setText("" + StrictMath.abs(dec.getMinute()));
                            this.decS.setText("" + StrictMath.abs(dec.getSecond()));
                        }
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        Util.logWarning("AstroGrid JAR files not on classpath");
                        Util.message(this, "Sorry", "Service not available.\nPut AstroGrid RMI JAR files on the classpath");
                    }
                    this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
                } else if (string.equals("width")) {
                    this.chartHeightField.setText(this.chartWidthField.getText());
                }
            }
        }

        private double getNumericField(JTextField jTextField) throws NumberFormatException {
            String string = jTextField.getText();
            if (null == string || 0 == string.length()) {
                return 0.0;
            }
            return Double.parseDouble(string);
        }
    }

    private static class ChartSaxHandler
    extends DefaultHandler {
        private StarChart chart = null;
        private String chartTitle = null;
        private Magnitude mag = null;
        private String bandId = "";
        private SkyPoint centre = null;
        private List<Star> stars;
        private double radius = 0.0;
        private boolean inChart = false;
        private boolean inRadius = false;
        private boolean inCommonId = false;
        private boolean inHipparcosId = false;
        private boolean inTychoId = false;
        private boolean inOtherId = false;
        private boolean inRA = false;
        private boolean inDec = false;
        private boolean inEpoch = false;
        private boolean inMag = false;
        private boolean inBand = false;
        private boolean inValue = false;
        private boolean inVar = false;
        private boolean inType = false;
        private boolean inPM = false;
        private boolean inUnits = false;
        private Star star = null;
        private RA ra = null;
        private Dec dec = null;
        private Epoch epoch = null;
        private double pmRA = 0.0;
        private double pmDec = 0.0;

        private ChartSaxHandler() {
        }

        public StarChart getStarChart() {
            return this.chart;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (string3.equals("StarChart")) {
                this.stars = new ArrayList<Star>();
            } else if (string3.equals("Chart")) {
                this.inChart = true;
            } else if (!string3.equals("Centre")) {
                if (string3.equals("Radius")) {
                    this.inRadius = true;
                } else if (string3.equals("Star")) {
                    this.star = new Star();
                } else if (string3.equals("CommonId")) {
                    this.inCommonId = true;
                } else if (string3.equals("HipparcosId")) {
                    this.inHipparcosId = true;
                } else if (string3.equals("TychoId")) {
                    this.inTychoId = true;
                } else if (string3.equals("OtherId")) {
                    this.inOtherId = true;
                } else if (!string3.equals("SkyPt")) {
                    if (string3.equals("RA")) {
                        this.inRA = true;
                    } else if (string3.equals("Dec")) {
                        this.inDec = true;
                    } else if (string3.equals("Epoch")) {
                        this.inEpoch = true;
                    } else if (string3.equals("Mag")) {
                        this.inMag = true;
                    } else if (string3.equals("Band")) {
                        this.inBand = true;
                        this.inMag = false;
                    } else if (string3.equals("Value")) {
                        this.inValue = true;
                        this.inMag = false;
                    } else if (string3.equals("Var")) {
                        this.inVar = true;
                    } else if (string3.equals("Type")) {
                        this.inType = true;
                    } else if (string3.equals("PM")) {
                        this.inPM = true;
                    } else if (string3.equals("Units")) {
                        this.inUnits = true;
                    } else {
                        Util.logWarning("Unhandled element <{0}>", string3);
                    }
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if (string3.equals("StarChart")) {
                this.chart = new StarChart(this.chartTitle, this.centre.getRA(), this.centre.getDec(), this.centre.getEquinox(), this.centre.getEquinox().getJulianDate(), 2.0 * this.radius, false, true, this.stars);
            } else if (string3.equals("Chart")) {
                this.inChart = false;
            } else if (string3.equals("Centre")) {
                this.centre = new SkyPoint(this.ra, this.dec, this.epoch);
            } else if (string3.equals("Radius")) {
                this.inRadius = false;
            } else if (string3.equals("Star")) {
                this.stars.add(this.star);
                this.star = null;
            } else if (string3.equals("CommonId")) {
                this.inCommonId = false;
            } else if (string3.equals("HipparcosId")) {
                this.inHipparcosId = false;
            } else if (string3.equals("TychoId")) {
                this.inTychoId = false;
            } else if (string3.equals("OtherId")) {
                this.inOtherId = false;
            } else if (string3.equals("SkyPt")) {
                this.star.setPosition(new SkyPoint(this.ra, this.dec, this.epoch));
            } else if (string3.equals("RA")) {
                this.inRA = false;
            } else if (string3.equals("Dec")) {
                this.inDec = false;
            } else if (string3.equals("Epoch")) {
                this.inEpoch = false;
            } else if (string3.equals("Mag")) {
                this.inMag = false;
                this.star.addMagnitude(this.mag);
            } else if (string3.equals("Band")) {
                this.inBand = false;
            } else if (string3.equals("Value")) {
                this.inValue = false;
            } else if (string3.equals("Var")) {
                this.inVar = false;
            } else if (string3.equals("Type")) {
                this.inType = false;
            } else if (string3.equals("PM")) {
                this.inPM = false;
            } else if (string3.equals("Units")) {
                this.inUnits = false;
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            String string = new String(cArray, n, n2);
            String string2 = "";
            try {
                if (this.inChart) {
                    this.chartTitle = string;
                } else if (this.inRadius) {
                    string2 = "Radius";
                    this.radius = Double.parseDouble(string);
                } else if (this.inCommonId) {
                    this.star.setCommonId(string);
                } else if (this.inHipparcosId) {
                    this.star.setHipparcosId(string);
                } else if (this.inTychoId) {
                    this.star.setTychoId(string);
                } else if (this.inOtherId) {
                    this.star.setOtherId(string);
                } else if (this.inRA) {
                    if (this.inPM) {
                        string2 = "PMRA";
                        this.pmRA = Double.parseDouble(string);
                    } else {
                        string2 = "RA";
                        int n3 = Integer.parseInt(string.substring(0, 2));
                        int n4 = Integer.parseInt(string.substring(3, 5));
                        String string3 = string.substring(6);
                        if (string3.endsWith("s")) {
                            string3 = string3.substring(0, string3.length() - 1);
                        }
                        double d = Double.parseDouble(string3);
                        this.ra = new RA((double)n3, (double)n4, d);
                    }
                } else if (this.inDec) {
                    if (this.inPM) {
                        string2 = "PMDec";
                        this.pmDec = Double.parseDouble(string);
                    } else {
                        string2 = "Dec";
                        int n5 = 1;
                        if (string.charAt(0) == '+') {
                            string = string.substring(1);
                        } else if (string.charAt(0) == '-') {
                            n5 = -1;
                            string = string.substring(1);
                        }
                        int n6 = Integer.parseInt(string.substring(0, 2));
                        int n7 = Integer.parseInt(string.substring(3, 5));
                        String string4 = string.substring(6);
                        if (string4.endsWith("s")) {
                            string4 = string4.substring(0, string4.length() - 1);
                        }
                        double d = Double.parseDouble(string4);
                        this.dec = new Dec((double)(n5 * n6), (double)(n5 * n7), (double)n5 * d);
                    }
                } else if (this.inEpoch) {
                    string2 = "Epoch";
                    char c = string.charAt(0);
                    if (c == 'B' || c == 'J') {
                        string = string.substring(1);
                    }
                    this.epoch = new Epoch(Float.parseFloat(string));
                } else if (this.inMag) {
                    string2 = "Mag";
                    this.mag = new Magnitude(Float.parseFloat(string));
                } else if (this.inBand) {
                    string2 = "Band";
                    this.bandId = string;
                } else if (this.inValue) {
                    string2 = "Value";
                    this.mag = new Magnitude(Float.parseFloat(string), this.bandId);
                    this.bandId = "";
                } else if (this.inType) {
                    string2 = "Type";
                    this.star.setTypeOfStellarObject(string);
                } else if (this.inUnits) {
                    if (this.inPM) {
                        if (string.equals("arcsec/yr")) {
                            this.star.setProperMotion(new ProperMotion(this.pmRA, this.pmDec));
                        } else {
                            Util.logWarning("Invalid units for PM: {0}", string);
                        }
                    }
                } else if (this.inVar) {
                    string2 = "Var";
                    if (string.equals("none")) {
                        this.star.setVariability(Variability.NONE);
                    } else if (string.startsWith("small")) {
                        this.star.setVariability(Variability.SMALL);
                    } else if (string.startsWith("medium")) {
                        this.star.setVariability(Variability.MEDIUM);
                    } else if (string.startsWith("large")) {
                        this.star.setVariability(Variability.LARGE);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                Util.logWarning("Invalid value for <{0}> :{1}", string2, string);
            }
        }
    }
}

