/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import net.grelf.FileIO;
import net.grelf.FileIOImageFilter;
import net.grelf.FileIO_XMLFilter;
import net.grelf.Util;
import net.grelf.astro.StarChart;
import net.grelf.grip.AstroProcessDialogue;
import net.grelf.grip.AstroProcessKind;
import net.grelf.grip.BatchDialogue;
import net.grelf.grip.BatchProcessor;
import net.grelf.grip.GRIP;
import net.grelf.grip.HelpMenu;
import net.grelf.grip.ImageSizeAction;
import net.grelf.grip.ImageSizeDialogue;
import net.grelf.grip.SlideShow;
import net.grelf.grip.StarChartFrame;
import net.grelf.grip.StarMeasProcessor;

public class BatchMenu
extends JMenu
implements ActionListener,
MenuListener,
ImageSizeAction {
    private JMenuItem itemAccum;
    private JMenuItem itemCombine;
    private JMenuItem itemWarp;
    private JMenuItem itemMerge;
    private JMenuItem itemComet;
    private JMenuItem itemMeas;
    private JMenuItem itemTrail;

    public BatchMenu() {
        super("Batch");
        this.setMnemonic('B');
        this.add(Util.menuItem(this, "Image information (as XML file)", "infoxml", 88, 0));
        this.add(Util.menuItem(this, "Slide show", "slides", 87, 0));
        this.addSeparator();
        JMenu jMenu = new JMenu("Astro");
        this.itemCombine = Util.menuItem(this, "Astro combine into 1 image", "astrocombine", 49, 0);
        jMenu.add(this.itemCombine);
        this.itemCombine.setToolTipText("Warp or shift to same positions and accumulate (formerly Astro-process)");
        this.itemComet = Util.menuItem(this, "Astro combine for comets", "comet", 65, 0);
        jMenu.add(this.itemComet);
        this.itemComet.setToolTipText("Semi-interactive: point to object in every image to keep it still");
        this.itemWarp = Util.menuItem(this, "Astro warp/shift onto common basis", "astrowarp", 79, 0);
        jMenu.add(this.itemWarp);
        this.itemWarp.setToolTipText("Blobs will be in same positions on every _warp or _shav image");
        this.itemTrail = Util.menuItem(this, "Accumulate star trails", "astrotrail", 0, 0);
        jMenu.add(this.itemTrail);
        this.itemTrail.setToolTipText("Star brightnesses are boosted");
        this.itemMeas = Util.menuItem(this, "Measure star(s) (select on first image)", "astromeas", 69, 0);
        jMenu.add(this.itemMeas);
        this.itemMeas.setToolTipText("You need to have warped/shifted onto common basis first");
        this.itemMerge = Util.menuItem(this, "Merge star charts", "charts", 71, 0);
        jMenu.add(this.itemMerge);
        this.add(jMenu);
        JMenu jMenu2 = new JMenu("Geometry");
        jMenu2.add(Util.menuItem(this, "Fit images in m x n", "fit", 70, 0));
        jMenu2.add(Util.menuItem(this, "Crop (set on first image)", "crop", 80, 0));
        jMenu2.add(Util.menuItem(this, "Flip horizontally", "fliph", 90, 0));
        jMenu2.add(Util.menuItem(this, "Flip vertically", "flipv", 89, 0));
        jMenu2.add(Util.menuItem(this, "Scale (interpolated)", "scale", 76, 0));
        jMenu2.add(Util.menuItem(this, "Magnify (replicated)", "magnify", 76, 0));
        jMenu2.add(Util.menuItem(this, "Rotate", "rotate", 82, 0));
        jMenu2.add(Util.menuItem(this, "Inverse gnomonic projection", "invgnomonic", 74, 0));
        jMenu2.add(Util.menuItem(this, "Gnomonic projection", "gnomonic", 78, 0));
        jMenu2.add(Util.menuItem(this, "Apply warping grid", "warpgrid", 87, 0));
        this.add(jMenu2);
        JMenu jMenu3 = new JMenu("Levels");
        jMenu3.add(Util.menuItem(this, "Invert contrast", "invert", 73, 0));
        jMenu3.add(Util.menuItem(this, "Contrast auto-stretch", "autostretch", 84, 0));
        jMenu3.add(Util.menuItem(this, "Convert to monochrome", "mono", 67, 0));
        jMenu3.add(Util.menuItem(this, "Convert to 8 bits per channel", "8bit", 56, 0));
        jMenu3.add(Util.menuItem(this, "Convert to 16 bits per channel", "16bit", 54, 0));
        jMenu3.add(Util.menuItem(this, "Convert to 32 bits per channel", "32bit", 51, 0));
        jMenu3.add(Util.menuItem(this, "Convert to 64 bits per channel", "64bit", 52, 0));
        jMenu3.add(Util.menuItem(this, "Correct background", "background", 66, 0));
        jMenu3.add(Util.menuItem(this, "Saturate", "saturate", 83, 0));
        jMenu3.add(Util.menuItem(this, "Square (multiply by self)", "square", 81, 0));
        this.add(jMenu3);
        JMenu jMenu4 = new JMenu("Combine with an image");
        jMenu4.add(Util.menuItem(this, "Subtract an image", "subtract", 85, 0));
        jMenu4.add(Util.menuItem(this, "Multiply by an image", "multiply", 77, 0));
        jMenu4.add(Util.menuItem(this, "Divide by a flat-field image", "divide", 68, 0));
        this.add(jMenu4);
        this.addSeparator();
        this.add(Util.menuItem(this, "Average images into 1", "average", 86, 0));
        this.itemAccum = Util.menuItem(this, "Accumulate images into 1", "accumulate", 0, 0);
        this.add(this.itemAccum);
        this.itemAccum.setToolTipText("Like averaging but can apply curves on accumulator read-out");
        this.add(Util.menuItem(this, "Interpret RAW & save as TIFF", "raw", 38, 0));
        this.addSeparator();
        this.add(Util.menuItem(this, "Make your own process", "diy", 75, 0));
        this.addSeparator();
        this.add(Util.menuItem(this, "Help about this menu", "help", 72, 0));
    }

    @Override
    public void process(ImageSizeDialogue imageSizeDialogue) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int n = imageSizeDialogue.getWidth();
        int n2 = imageSizeDialogue.getHeight();
        imageSizeDialogue.dispose();
        hashMap.put("width", n);
        hashMap.put("height", n2);
        if (0 < n && 0 < n2) {
            new BatchProcessor().batch("fit", "_" + n + "x" + n2, hashMap);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (string.equals("8bit")) {
            new BatchProcessor().batch("8bit", "_8bit", hashMap);
        } else if (string.equals("16bit")) {
            new BatchProcessor().batch("16bit", "_16bit", hashMap);
        } else if (string.equals("32bit")) {
            new BatchProcessor().batch("32bit", "_32bit", hashMap);
        } else if (string.equals("64bit")) {
            new BatchProcessor().batch("64bit", "_64bit", hashMap);
        } else if (string.equals("accumulate")) {
            new BatchProcessor().batch("accum", "_acc", hashMap);
        } else if (string.equals("astrocombine")) {
            new AstroProcessDialogue((Frame)GRIP.getInstance(), AstroProcessKind.COMBINE);
        } else if (string.equals("astromeas")) {
            if (Util.confirm("Prerequisite", "Have you aligned the images\n(option Warp/shift onto common basis)?")) {
                new StarMeasProcessor().run();
            } else {
                new AstroProcessDialogue((Frame)GRIP.getInstance(), AstroProcessKind.ALIGN);
            }
        } else if (string.equals("astrotrail")) {
            new BatchProcessor().batch("trail", "_trail", hashMap);
        } else if (string.equals("astrowarp")) {
            new AstroProcessDialogue((Frame)GRIP.getInstance(), AstroProcessKind.ALIGN);
        } else if (string.equals("autostretch")) {
            boolean bl = Util.confirm(null, "Contrast stretch", "All channels stretched the same?");
            hashMap.put("allSame", bl);
            new BatchProcessor().batch("autostretch", "_stretch", hashMap);
        } else if (string.equals("average")) {
            new BatchProcessor().batch("average", "_ave", hashMap);
        } else if (string.equals("background")) {
            new BatchProcessor().batch("background", "_bkgr", hashMap);
        } else if (string.equals("charts")) {
            List<StarChartFrame> list = GRIP.getInstance().getAllStarChartFrames();
            StarChart.mergeCharts(list);
        } else if (string.equals("comet")) {
            new AstroProcessDialogue((Frame)GRIP.getInstance(), AstroProcessKind.COMBINE, true);
        } else if (string.equals("crop")) {
            new BatchProcessor().batch("crop", "_crop", hashMap);
        } else if (string.equals("divide")) {
            String string2 = FileIO.selectInputFile("Flat field", null, new FileFilter[]{new FileIOImageFilter()});
            if (null != string2) {
                hashMap.put("divPath", string2);
                new BatchProcessor().batch("divide", "_div", hashMap);
            }
        } else if (string.equals("diy")) {
            new BatchDialogue();
        } else if (string.equals("fit")) {
            int n = 1024;
            int n2 = 768;
            new ImageSizeDialogue(n, n2, "Scale to fit", this);
        } else if (string.equals("fliph")) {
            new BatchProcessor().batch("fliph", "_flh", hashMap);
        } else if (string.equals("flipv")) {
            new BatchProcessor().batch("flipv", "_flv", hashMap);
        } else if (string.equals("gnomonic")) {
            new BatchProcessor().batch("gnomonic", "_gnm", hashMap);
        } else if (string.equals("help")) {
            HelpMenu.help("pages/batch_menu.html");
        } else if (string.equals("infoxml")) {
            String string3 = FileIO.selectOutputFile("Save as XML file", null, new FileIO_XMLFilter[]{new FileIO_XMLFilter(1)}, "x.xml");
            if (null != string3) {
                hashMap.put("outputPath", string3);
                new BatchProcessor().batch("infoxml", null, hashMap);
            }
        } else if (string.equals("invert")) {
            new BatchProcessor().batch("invert", "_inv", hashMap);
        } else if (string.equals("invgnomonic")) {
            new BatchProcessor().batch("invgnomonic", "_ignm", hashMap);
        } else if (string.equals("magnify")) {
            int n = Util.askInteger("Factor to magnify by [2..8]?", 2, 2, 8);
            if (2 <= n && n <= 8) {
                hashMap.put("factor", n);
                new BatchProcessor().batch("magnify", "_mgn", hashMap);
            }
        } else if (string.equals("mono")) {
            new BatchProcessor().batch("mono", "_mono", hashMap);
        } else if (string.equals("multiply")) {
            String string4 = FileIO.selectInputFile("Image to multiply by", null, new FileFilter[]{new FileIOImageFilter()});
            if (null != string4) {
                hashMap.put("mulPath", string4);
                new BatchProcessor().batch("multiply", "_mpy", hashMap);
            }
        } else if (string.equals("raw")) {
            new BatchProcessor().batch("raw", "_", hashMap);
        } else if (string.equals("rotate")) {
            double d = Util.askDouble("Angle to rotate anti-clockwise (degrees) [-360..360]?", 0.0, -360.0, 360.0);
            if (-360.0 <= d && d <= 360.0) {
                hashMap.put("angle", d);
                new BatchProcessor().batch("rotate", "_rot", hashMap);
            }
        } else if (string.equals("saturate")) {
            new BatchProcessor().batch("saturate", "_sat", hashMap);
        } else if (string.equals("scale")) {
            double d = Util.askDouble("Factor to scale by [0.1..10]?", 1.0, 0.1, 10.0);
            if (0.1 <= d && d <= 10.0) {
                hashMap.put("factor", d);
                new BatchProcessor().batch("scale", "_scl", hashMap);
            }
        } else if (string.equals("slides")) {
            File[] fileArray;
            int n = Util.askInteger("Interval between slides, s [1..1000]?", 5, 1, 1000);
            if (n != Integer.MIN_VALUE && null != (fileArray = FileIO.selectInputFiles("Images to show"))) {
                new SlideShow(fileArray, n * 1000);
            }
        } else if (string.equals("square")) {
            new BatchProcessor().batch("square", "_squ", hashMap);
        } else if (string.equals("subtract")) {
            String string5 = FileIO.selectInputFile("Image to subtract", null, new FileFilter[]{new FileIOImageFilter()});
            if (null != string5) {
                hashMap.put("subPath", string5);
                new BatchProcessor().batch("subtract", "_sub", hashMap);
            }
        } else if (string.equals("warpgrid")) {
            new BatchProcessor().batch("warpgrid", "_grid", hashMap);
        } else if (string.equals("experiment")) {
            new AstroProcessDialogue((Frame)GRIP.getInstance(), AstroProcessKind.COMBINE, true);
        }
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }
}

