/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ProgressMonitor;
import net.grelf.Angle;
import net.grelf.FileIO;
import net.grelf.PointFloat;
import net.grelf.Statistics;
import net.grelf.Timer;
import net.grelf.Util;
import net.grelf.astro.Dec;
import net.grelf.astro.Epoch;
import net.grelf.astro.RA;
import net.grelf.astro.SkyPoint;
import net.grelf.astro.SkyVector;
import net.grelf.grip.Accumulator;
import net.grelf.grip.Accumulator32;
import net.grelf.grip.Accumulator64;
import net.grelf.grip.Analyser;
import net.grelf.grip.AstroProcessKind;
import net.grelf.grip.AstroProcessMethod;
import net.grelf.grip.BatchMetadata;
import net.grelf.grip.Blob;
import net.grelf.grip.BlobMask;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.BlobMeasList;
import net.grelf.grip.Blob_;
import net.grelf.grip.Config;
import net.grelf.grip.ConnectionList;
import net.grelf.grip.DefaultMeasurementHandler;
import net.grelf.grip.DrawingMode;
import net.grelf.grip.GRIP;
import net.grelf.grip.Histogram;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImSaturateDialogue;
import net.grelf.grip.ImageSummaryDialogue;
import net.grelf.grip.MatchList;
import net.grelf.grip.MatchPair;
import net.grelf.grip.Raw;
import net.grelf.grip.StarSegmenter;
import net.grelf.grip.Warp;
import net.grelf.grip.WarpingGrid;
import net.grelf.image.Exif;
import net.grelf.image.HistogramAll;
import net.grelf.image.Image8or16Base;
import net.grelf.image.ImageLoader;
import net.grelf.image.IncompatibleImageException;
import net.grelf.image.Metadata;
import net.grelf.image.Threshold;

public class BatchProcessor {
    private static final int MAX_STAR_BOUNDARY_SIZE = 250;
    private Timer timer;
    private GRIP app;
    private int nFiles;
    private int wd;
    private int ht;
    private int progress;
    private boolean doFullAuto = false;
    private boolean showBlobsOnEachImage = false;
    private AstroProcessKind processKind = null;
    private BlobMeas[][] lookupBlobMeases = null;
    private List<List<ConnectionList>> connectionsInAllImages = null;
    private List<String> pathsToTempFiles = null;
    private List<PointFloat> centres = null;
    private int nBrightest;
    private List<MatchPair> matches = null;
    private AstroProcessMethod astroProcessMethod = AstroProcessMethod.WARP;
    private int starSegmenterDifference;
    private int starSegmenterRadius;
    private Accumulator accum;
    private int srcBitDepth;
    private WarpingGrid warpingGrid = null;
    private BatchMetadata batchMetadata = new BatchMetadata();
    private double experimentDx = 0.0;
    private double experimentDy = 0.0;
    private static File[] cropFiles = null;
    private ProgressMonitor monitor = null;

    public void batch(String string, String string2, Map<String, Object> map) {
        this.batch(string, string2, map, 1);
    }

    public void batch(String string, String string2, Map<String, Object> map, int n) {
        File[] fileArray = FileIO.selectInputFiles("Images to process");
        if (null != fileArray) {
            this.doOpInBackground(fileArray, string, string2, map, fileArray.length);
        }
    }

    public void batch(File[] fileArray, String string, String string2, Map<String, Object> map) {
        Object object;
        List<MatchList> list;
        int n;
        Object object2;
        double d;
        double d2;
        Object object3;
        Object object4;
        this.timer = new Timer("BatchProcessor.batch", null);
        this.app = GRIP.getInstance();
        this.nFiles = fileArray.length;
        this.ht = 0;
        this.wd = 0;
        this.progress = 0;
        net.grelf.image.Image image = null;
        net.grelf.image.Image image2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (null != map.get("experiment")) {
            object4 = new SkyPoint(new RA(1.0, 22.0, 46.18), new Dec(16.0, 38.0, 51.1), Epoch.J2000);
            SkyPoint skyPoint = new SkyPoint(new RA(1.0, 22.0, 44.31), new Dec(16.0, 38.0, 46.0), Epoch.J2000);
            object3 = ((SkyPoint)object4).calculateSeparation(skyPoint);
            d2 = ((SkyVector)object3).getSeparation().getDegrees();
            d = 3267.4 * d2 * 2.0;
            System.out.println("Comet moved " + d + " px");
            Angle angle = new Angle(38.0, Angle.Units.DEGREES);
            this.experimentDx = angle.cos() * d / 47.0;
            this.experimentDy = angle.sin() * d / 47.0;
            System.out.println("Setting experiment dx, dy = " + this.experimentDx + ", " + this.experimentDy);
        }
        if (null != (object4 = map.get("nBrightest")) && object4 instanceof Integer) {
            this.nBrightest = (Integer)object4;
        } else {
            try {
                this.nBrightest = Integer.parseInt(Config.getValue("NBrightest.value"));
            }
            catch (NumberFormatException numberFormatException) {
                this.nBrightest = 24;
            }
        }
        try {
            this.starSegmenterDifference = Integer.parseInt(Config.getValue("StarSegmentDifference.value"));
            this.starSegmenterRadius = Integer.parseInt(Config.getValue("StarSegmentRadius.value"));
        }
        catch (NumberFormatException numberFormatException) {
            object3 = "Config values missing for StarSegmenter parameters.\nTry deleting file grip.properties and re-running GRIP.";
            Util.warning(null, "Error", object3);
        }
        double d3 = Double.parseDouble(Config.getValue("Detector.width.mm.value"));
        d2 = Double.parseDouble(Config.getValue("Detector.height.mm.value"));
        d = 1.0;
        try {
            d = Math.abs(Double.parseDouble(Config.getValue("BackgroundFactor.value")));
        }
        catch (NumberFormatException numberFormatException) {
            d = 1.0;
        }
        int n2 = 256;
        try {
            n2 = Integer.parseInt(Config.getValue("BackgroundCellFactor.value"));
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 256;
        }
        this.accum = null;
        this.srcBitDepth = 16;
        ImFrame imFrame = null;
        PrintWriter printWriter = null;
        net.grelf.image.Image image3 = null;
        int n3 = 0;
        net.grelf.image.Image image4 = null;
        if (string.equals("astro")) {
            String string3;
            this.processKind = (AstroProcessKind)((Object)map.get("processKind"));
            this.astroProcessMethod = (AstroProcessMethod)((Object)map.get("method"));
            this.pathsToTempFiles = new ArrayList<String>();
            this.centres = new ArrayList<PointFloat>();
            this.connectionsInAllImages = new ArrayList<List<ConnectionList>>();
            this.lookupBlobMeases = new BlobMeas[this.nFiles][this.nBrightest];
            String string4 = (String)map.get("darkPath");
            if (null != string4 && string4.length() > 0) {
                image = this.loadAuxiliaryImage(string4);
            }
            if (null != (object2 = (String)map.get("flatPath")) && ((String)object2).length() > 0) {
                image2 = this.loadAuxiliaryImage((String)object2);
            }
            bl = null != (string3 = (String)map.get("doNeutralise")) && string3.equals("true");
            string3 = (String)map.get("doBackground");
            bl2 = null != string3 && string3.equals("true");
            string3 = (String)map.get("doGnomonic");
            bl3 = null != string3 && string3.equals("true");
            string3 = (String)map.get("doFullAuto");
            this.doFullAuto = null != string3 && string3.equals("true");
            string3 = (String)map.get("showBlobsOnEachImage");
            this.showBlobsOnEachImage = null != string3 && string3.equals("true");
        } else if (string.equals("divide")) {
            image2 = this.loadAuxiliaryImage((String)map.get("divPath"));
        } else if (string.equals("infoxml")) {
            try {
                printWriter = new PrintWriter(new File((String)map.get("outputPath")));
                printWriter.println("<?xml version=\"1.0\"?>");
                printWriter.println("<Images>");
            }
            catch (IOException iOException) {
                Util.warning("Sorry", "Could not create XML output file");
                string = "abort";
            }
        } else if (string.equals("multiply")) {
            image3 = this.loadAuxiliaryImage((String)map.get("mulPath"));
        } else if (string.equals("subtract")) {
            image4 = this.loadAuxiliaryImage((String)map.get("subPath"));
        }
        boolean bl4 = false;
        object2 = null;
        for (n = 0; n < this.nFiles; ++n) {
            list = fileArray[n];
            if (((File)((Object)list)).exists()) {
                if (null != this.monitor) {
                    this.monitor.setProgress(this.progress++);
                    object = string.equals("astro") ? "Pass 1: " : "";
                    this.monitor.setNote((String)object + ((File)((Object)list)).getName() + " [" + (n + 1) + " of " + this.nFiles + "]");
                    if (this.monitor.isCanceled()) {
                        this.monitor.close();
                        this.monitor = null;
                        return;
                    }
                }
                object = null;
                if (0 == n && (string.equals("crop") || string.equals("saturate"))) {
                    imFrame = new ImFrame(((File)((Object)list)).getPath(), new DefaultMeasurementHandler());
                    object = imFrame.getImPane().getImage();
                } else {
                    object = ImageLoader.load((File)((Object)list));
                }
                if (null == object) {
                    Util.logWarning("Image " + n + " null");
                } else {
                    try {
                        if (n == 0 && object.isRaw()) {
                            if (string.equals("accum") || string.equals("trail")) {
                                bl4 = Util.confirm("Accumulating raw images", "Accumulate the raw images, without first interpreting?");
                            } else if (string.equals("average")) {
                                bl4 = Util.confirm("Averaging raw images", "Average the raw images, without first interpreting?");
                            }
                        }
                        if ((null != image || null != image2 || bl || bl2 || bl3) && !Util.isRoomForTemporaryTiffImages(list, this.nFiles, object.getWidth(), object.getHeight(), object.getNBands(), object.getBitsPerChannel())) {
                            string = "abort";
                        }
                        if (!string.equals("abort")) {
                            List<Blob> list2;
                            block175: {
                                boolean bl5 = false;
                                if (object.isRaw() && !bl4) {
                                    Raw.interpret((net.grelf.image.Image)object);
                                    Raw.removeMargin((net.grelf.image.Image)object);
                                    bl5 = true;
                                }
                                this.wd = object.getWidth();
                                this.ht = object.getHeight();
                                if (string.equals("8bit")) {
                                    if (null == (object = object.convertToImage8())) {
                                        string = "abort";
                                    }
                                } else if (string.equals("16bit")) {
                                    if (null == (object = object.convertToImage16())) {
                                        string = "abort";
                                    }
                                } else if (string.equals("32bit")) {
                                    if (null == (object = object.convertToImage32())) {
                                        string = "abort";
                                    }
                                } else if (string.equals("64bit")) {
                                    if (null == (object = object.convertToImage64())) {
                                        string = "abort";
                                    }
                                } else if (string.equals("astro")) {
                                    Object object5;
                                    Metadata metadata = this.batchMetadata.add((File)((Object)list), (net.grelf.image.Image)object);
                                    if (null != image) {
                                        try {
                                            object.subtractToZero(image);
                                            bl5 = true;
                                        }
                                        catch (IncompatibleImageException incompatibleImageException) {
                                            Util.warning("Error", "Incompatible dark frame");
                                            string = "abort";
                                        }
                                    }
                                    if (null != image2) {
                                        object.divideByFlatField(image2);
                                        bl5 = true;
                                    }
                                    if (bl) {
                                        object.neutraliseBackground();
                                        bl5 = true;
                                    }
                                    if (bl2) {
                                        object.correctBackground(d, n2);
                                        bl5 = true;
                                    }
                                    if (bl3) {
                                        int n4 = Integer.MIN_VALUE;
                                        if (null != metadata) {
                                            n4 = metadata.getFocalLength();
                                        }
                                        if (n4 == Integer.MIN_VALUE) {
                                            try {
                                                object5 = (String)map.get("focalLength");
                                                if (null == object5 || ((String)object5).length() < 1) {
                                                    n4 = -1;
                                                } else {
                                                    n4 = Integer.parseInt((String)object5);
                                                    metadata.setFocalLength(n4);
                                                }
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                n4 = -1;
                                            }
                                        }
                                        if (-1 != n4) {
                                            object = object.inverseGnomonicProjection(n4, d3, d2);
                                            bl5 = true;
                                        }
                                    }
                                    if (bl5) {
                                        if (object instanceof Image8or16Base) {
                                            this.pathsToTempFiles.add(this.saveTemporaryImage((File)((Object)list), string2, ((Image8or16Base)object).getBufferedImage()));
                                        } else {
                                            Util.warning("Error", "Cannot save temporary image of more than 16 bit depth");
                                        }
                                    }
                                    BlobMeasList blobMeasList = null;
                                    object5 = null;
                                    object5 = object2 != null ? (BlobMask)object.threshold((Threshold)object2) : StarSegmenter.segment((net.grelf.image.Image)object, this.starSegmenterDifference, this.starSegmenterRadius);
                                    if (null == object5) {
                                        Util.logInfo("null segmented mask");
                                    } else {
                                        list2 = ((BlobMask)object5).detectBlobs(false);
                                        if (null == list2) {
                                            Util.logInfo("null blobs list");
                                        } else {
                                            Serializable serializable;
                                            Util.logInfo("NBLOBS = {0}", list2.size());
                                            object5 = null;
                                            if (0 == list2.size() && null == object2 && 0 == n) {
                                                Util.warning("Error", "No objects were detected.\nTry thresholding this\nfirst image manually");
                                                serializable = new ImFrame("First image", object.getWidth(), object.getHeight());
                                                serializable.getImPane().setImage((net.grelf.image.Image)object);
                                                object2 = serializable.threshold();
                                                blobMeasList = serializable.detectBlobs(false);
                                                serializable.setVisible(false);
                                                serializable.dispose();
                                            } else {
                                                blobMeasList = new BlobMeasList(null);
                                                for (Blob blob : list2) {
                                                    List<Point> list3 = blob.getBoundary();
                                                    if (null != list3 && list3.size() < 250) {
                                                        BlobMeas blobMeas = blob.measure((net.grelf.image.Image)object);
                                                        if (null != blobMeasList) {
                                                            blobMeasList.insert(blobMeas);
                                                        }
                                                        ((Blob_)blob).nullRows();
                                                        continue;
                                                    }
                                                    Object var34_64 = null;
                                                }
                                                this.batchMetadata.addToNStars(list2.size());
                                                if (null != blobMeasList) {
                                                    double d4 = 0.0;
                                                    int n4 = 5;
                                                    for (int i = 0; i < n4 && i < blobMeasList.size(); ++i) {
                                                        BlobMeas blobMeas = (BlobMeas)blobMeasList.get(i);
                                                        d4 += blobMeas.calculateCircularity();
                                                    }
                                                    this.batchMetadata.addToMeanCircularities((float)(d4 / (double)n4));
                                                }
                                                list2 = null;
                                            }
                                            if (this.astroProcessMethod == AstroProcessMethod.SHIFT_BRIGHTEST) {
                                                if (blobMeasList.size() > 0) {
                                                    serializable = (BlobMeas)blobMeasList.get(0);
                                                    ((BlobMeas)serializable).blob = null;
                                                    this.centres.add(new PointFloat(((BlobMeas)serializable).centre.x, ((BlobMeas)serializable).centre.y));
                                                }
                                                blobMeasList = null;
                                            } else {
                                                this.connectionsInAllImages.add(Analyser.getSortedConnections(blobMeasList, this.nBrightest));
                                                int n6 = 0;
                                                Iterator iterator = blobMeasList.iterator();
                                                while (iterator.hasNext()) {
                                                    BlobMeas blobMeas;
                                                    this.lookupBlobMeases[n][n6] = blobMeas = (BlobMeas)iterator.next();
                                                    if (++n6 < this.nBrightest) continue;
                                                    break;
                                                }
                                                if (this.showBlobsOnEachImage) {
                                                    this.displayBlobsInImage(((File)((Object)list)).getName(), blobMeasList);
                                                }
                                            }
                                            blobMeasList = null;
                                        }
                                    }
                                    System.gc();
                                } else if (string.equals("autostretch")) {
                                    object.autoStretch((Boolean)map.get("allSame"));
                                } else if (string.equals("accum") || string.equals("average") || string.equals("trail")) {
                                    try {
                                        if (0 == n) {
                                            this.accum = string.equals("trail") && this.nFiles > 180 ? new Accumulator64(((Image8or16Base)object).getBufferedImage()) : new Accumulator32(((Image8or16Base)object).getBufferedImage());
                                            this.srcBitDepth = object.getBitsPerChannel();
                                            break block175;
                                        }
                                        if (string.equals("trail")) {
                                            this.accum.addWithStarBoost((Image8or16Base)object, this.nFiles);
                                            break block175;
                                        }
                                        this.accum.add((net.grelf.image.Image)object);
                                    }
                                    catch (IncompatibleImageException incompatibleImageException) {
                                        Util.warning(this.app, "Error", "{0} - {1}", null != list ? ((File)((Object)list)).getPath() : "", incompatibleImageException.toString());
                                    }
                                } else if (string.equals("background")) {
                                    object.correctBackground(d, n2);
                                } else {
                                    if (string.equals("crop") && 0 == n) {
                                        cropFiles = fileArray;
                                        imFrame.getGP().setDrawingMode(DrawingMode.CROP);
                                        imFrame.setTitle("Click to set rectangle corners");
                                        break;
                                    }
                                    if (string.equals("divide")) {
                                        object.divideByFlatField(image2);
                                    } else if (string.equals("fit")) {
                                        int n7 = (Integer)map.get("width");
                                        int n8 = (Integer)map.get("height");
                                        object.fit(n7, n8);
                                        string2 = "_" + this.accum.getWidth() + "x" + this.accum.getHeight();
                                    } else if (string.equals("fliph")) {
                                        object.flipHorizontal();
                                    } else if (string.equals("flipv")) {
                                        object.flipVertical();
                                    } else if (string.equals("gnomonic")) {
                                        object = object.gnomonicProjection(object.getMetadata().getFocalLength(), d3, d2);
                                    } else if (string.equals("infoxml")) {
                                        this.infoXML((File)((Object)list), this.wd, this.ht, (net.grelf.image.Image)object, printWriter);
                                    } else if (string.equals("invert")) {
                                        object.invert();
                                    } else if (string.equals("invgnomonic")) {
                                        object = object.inverseGnomonicProjection(object.getMetadata().getFocalLength(), d3, d2);
                                    } else if (string.equals("magnify")) {
                                        int n9 = (Integer)map.get("factor");
                                        object.scale(n9, false);
                                    } else if (string.equals("mono")) {
                                        object.convertToMonochrome();
                                    } else if (string.equals("multiply")) {
                                        object.multiply(image3);
                                    } else if (string.equals("rotate")) {
                                        double d5 = (Double)map.get("angle");
                                        object.rotate(d5);
                                    } else if (string.equals("saturate")) {
                                        if (0 == n) {
                                            n3 = ImSaturateDialogue.askSaturate(imFrame);
                                            if (0 == n3) {
                                                n = this.nFiles + 1;
                                            }
                                        } else {
                                            ImSaturateDialogue.saturate((net.grelf.image.Image)object, n3);
                                        }
                                    } else if (string.equals("scale")) {
                                        double d6 = (Double)map.get("factor");
                                        object.scale(d6, true);
                                    } else if (string.equals("square")) {
                                        object.multiply((net.grelf.image.Image)object);
                                    } else if (string.equals("subtract")) {
                                        try {
                                            object.subtract(image4);
                                        }
                                        catch (IncompatibleImageException incompatibleImageException) {
                                            Util.warning("Error", "Incompatible image to subtract");
                                            string = "abort";
                                        }
                                    } else if (string.equals("warpgrid")) {
                                        if (null == this.warpingGrid) {
                                            this.warpingGrid = new WarpingGrid().load();
                                        }
                                        if (null == this.warpingGrid) {
                                            Util.warning("Sorry", "No warping grid is loaded");
                                            string = "abort";
                                        } else {
                                            this.warpingGrid.use((net.grelf.image.Image)object);
                                        }
                                    }
                                }
                            }
                            if (!(null == string2 || string.equals("abort") || string.equals("accum") || string.equals("astro") || string.equals("average") || string.equals("crop") || string.equals("saturate") && n3 == 0 || string.equals("trail"))) {
                                int n10;
                                String string5 = ((File)((Object)list)).getPath();
                                String string6 = FileIO.getExtension(string5);
                                if (object.isRaw() || string.equals("raw")) {
                                    string6 = ".tif";
                                }
                                if ((n10 = object.getBitsPerChannel()) == 8) {
                                    string6 = ".jpg";
                                } else if (n10 > 16) {
                                    string6 = ".fits";
                                }
                                list2 = FileIO.removeExtension(string5) + string2 + string6;
                                object.save((String)((Object)list2));
                            }
                            if (0 == n && string.equals("saturate")) {
                                imFrame.setVisible(false);
                                imFrame.dispose();
                            }
                        }
                        object.dispose();
                        object = null;
                    }
                    catch (NullPointerException nullPointerException) {
                        Util.logWarning("Image " + n + " failed:" + nullPointerException.toString());
                    }
                }
            }
            System.gc();
        }
        if (string.equals("astro")) {
            if (this.astroProcessMethod == AstroProcessMethod.SHIFT_BRIGHTEST) {
                if (null != this.monitor) {
                    this.monitor.close();
                    this.monitor = null;
                }
                if (0 == this.pathsToTempFiles.size()) {
                    for (n = 0; n < this.nFiles; ++n) {
                        this.pathsToTempFiles.add(fileArray[n].getPath());
                    }
                }
                this.astroPass2();
            } else {
                if (null != this.monitor) {
                    this.monitor.setNote("Analysing matches");
                }
                this.matches = Analyser.matchBrightest(this.connectionsInAllImages);
                if (null != this.monitor) {
                    this.monitor.close();
                    this.monitor = null;
                }
                if (this.matches.isEmpty()) {
                    if (Util.confirm("Sorry", "No matches found between images.\nDo you want to see which\nobjects were detected?")) {
                        this.displayAllBlobs(this.wd, this.ht, this.lookupBlobMeases);
                        this.deleteTemporaryFiles(this.pathsToTempFiles);
                    }
                } else {
                    n = this.nFiles / 2;
                    list = MatchList.makeListOfLists(this.matches, this.nBrightest, n);
                    if (list.size() == 0) {
                        Util.message("Abort", "No matching objects found across images");
                        this.deleteTemporaryFiles(this.pathsToTempFiles);
                    } else {
                        if (0 == this.pathsToTempFiles.size()) {
                            for (int i = 0; i < this.nFiles; ++i) {
                                this.pathsToTempFiles.add(fileArray[i].getPath());
                            }
                        }
                        if (null != this.monitor) {
                            this.monitor.close();
                            this.monitor = null;
                        }
                        if (!this.doFullAuto) {
                            MatchPair.drawMatches(list, this.matches, this.wd, this.ht, this.lookupBlobMeases, this);
                        } else {
                            MatchPair.setListOfLists(list);
                            this.astroPass2();
                        }
                    }
                }
            }
        } else if (null != string2) {
            if (string.equals("average")) {
                ImFrame imFrame2 = new ImFrame(fileArray[0].getPath(), new DefaultMeasurementHandler());
                imFrame2.setCursor(GRIP.GRIP_WAIT_CURSOR);
                list = imFrame2.getImPane().getImage();
                if (null != this.monitor) {
                    this.monitor.setNote("Dividing and drawing result");
                }
                this.accum.divide(this.nFiles);
                if (this.srcBitDepth == 32) {
                    imFrame2.getImPane().setImage(this.accum);
                } else {
                    imFrame2.getImPane().setImage(this.accum.convertToImage16());
                }
                object = fileArray[0].getPath();
                String string7 = FileIO.removeExtension((String)object) + string2 + FileIO.getExtension((String)object);
                imFrame2.setCaption(new File(string7).getName());
                imFrame2.redisplay();
                imFrame2.getImPane().getImage().save(string7);
                imFrame2.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
                GRIP.getTable().refresh();
            } else if (string.equals("accum") || string.equals("trail")) {
                String string8 = fileArray[0].getPath();
                list = fileArray[this.nFiles - 1].getName();
                object = FileIO.removeExtension(string8) + "-" + FileIO.removeExtension(list) + "_ave.fits";
                this.accum.save((String)object);
                new ImFrame((String)object, this.accum);
            }
        } else if (string.equals("infoxml")) {
            printWriter.println("</Images>");
            printWriter.close();
        }
        if (null != this.monitor) {
            this.monitor.close();
            this.monitor = null;
        }
        this.timer.stop();
    }

    private net.grelf.image.Image loadAuxiliaryImage(String string) {
        net.grelf.image.Image image = ImageLoader.load(new File(string));
        if (image.isRaw()) {
            Raw.interpret(image);
            Raw.removeMargin(image);
        }
        return image;
    }

    private void deleteTemporaryFiles(List<String> list) {
        for (String string : list) {
            if (!string.endsWith("_temp.tif")) continue;
            if (new File(string).delete()) {
                Util.logInfo("Deleted {0}", string);
                continue;
            }
            Util.logWarning("FAILED to delete {0}", string);
        }
    }

    private String saveTemporaryImage(File file, String string, BufferedImage bufferedImage) {
        String string2 = null;
        try {
            string2 = FileIO.removeExtension(file.getPath()) + string + ".tif";
            ImageIO.write((RenderedImage)bufferedImage, "tiff", new File(string2));
            Util.logInfo("Saved {0}", string2);
            return string2;
        }
        catch (IOException iOException) {
            Util.warning("Error", "Could not save {0}", null != string2 ? string2 : " temporary file");
            return "ERROR";
        }
    }

    protected void astroPass2() {
        if (null != this.matches && this.matches.size() == 0) {
            this.deleteTemporaryFiles(this.pathsToTempFiles);
        } else {
            block54: {
                int n;
                Object object;
                boolean bl = false;
                for (ImFrame imFrame : GRIP.getTable().getList()) {
                    if (-1 == imFrame.getCaption().indexOf("objects detected")) continue;
                    imFrame.dispose();
                    bl = true;
                }
                if (bl) {
                    GRIP.getTable().refresh();
                }
                bl = false;
                int n2 = this.pathsToTempFiles.size();
                if (this.doFullAuto) {
                    object = new boolean[n2];
                    for (n = 0; n < n2; ++n) {
                        object[n] = true;
                    }
                } else {
                    ImageSummaryDialogue imageSummaryDialogue = new ImageSummaryDialogue(this.batchMetadata, this.matches, this.lookupBlobMeases, this.nBrightest, true);
                    object = imageSummaryDialogue.getSelected();
                    imageSummaryDialogue.dispose();
                    if (null == object) {
                        bl = true;
                    }
                }
                if (!bl) {
                    this.progress = 0;
                    try {
                        int n3;
                        n = 0;
                        int n4 = 0;
                        int n5 = 0;
                        for (n3 = 0; n3 < ((Object)object).length; ++n3) {
                            if (object[n3] == false) continue;
                            ++n5;
                        }
                        if (0 < n2 && 0 < n5) {
                            Object object2;
                            Object object3;
                            Object object4;
                            String string;
                            this.timer = new Timer("BatchProcessor.astroPass2", null);
                            if (null != this.monitor) {
                                this.monitor.setMaximum(n2);
                            }
                            n3 = n2 / 2;
                            for (int i = 0; i < n2; ++i) {
                                if (object[i] == false) continue;
                                try {
                                    string = this.pathsToTempFiles.get(i);
                                    object4 = new File(string);
                                    if (null != this.monitor) {
                                        this.monitor.setProgress(this.progress++);
                                        this.monitor.setNote("Pass 2: " + ((File)object4).getName() + " [" + (i + 1) + " of " + n2 + "]");
                                        if (this.monitor.isCanceled()) {
                                            this.monitor.close();
                                            this.monitor = null;
                                            return;
                                        }
                                    }
                                    if (null == (object3 = this.loadAuxiliaryImage(((File)object4).getPath()))) {
                                        Util.warning("Error", "Could not reload image {0} from\n{1}", i, ((File)object4).getPath());
                                    } else {
                                        object2 = ((Image8or16Base)object3).getBufferedImage();
                                        if (null == object2) {
                                            Util.warning("Error", "Could not get BufferedImage from loaded image");
                                        }
                                        if (null == this.accum && this.processKind == AstroProcessKind.COMBINE) {
                                            this.accum = new Accumulator32(object3.getWidth(), object3.getHeight(), object3.getNBands());
                                            n = 0;
                                        }
                                        if (i == n3 && this.processKind == AstroProcessKind.COMBINE) {
                                            if (0.0 != this.experimentDx || 0.0 != this.experimentDy) {
                                                double d = this.experimentDx * (double)(n2 - i);
                                                double d2 = this.experimentDy * (double)(n2 - i);
                                                System.out.println("Translate by " + d + ", " + d2);
                                                object3.translate(d, d2);
                                            }
                                            this.accum.add((net.grelf.image.Image)object3);
                                            ++n;
                                        } else {
                                            switch (this.astroProcessMethod) {
                                                case SHIFT_AVERAGE: {
                                                    Object object5;
                                                    if (this.processKind == AstroProcessKind.COMBINE) {
                                                        if (0.0 != this.experimentDx || 0.0 != this.experimentDy) {
                                                            double d = this.experimentDx * (double)(n2 - i);
                                                            double d3 = this.experimentDy * (double)(n2 - i);
                                                            System.out.println("Translate by " + d + ", " + d3);
                                                            object3.translate(d, d3);
                                                        }
                                                        this.accum.averageShiftAccumulate((Image8or16Base)object3, i, n3, this.matches, this.lookupBlobMeases, this.nBrightest);
                                                        ++n;
                                                        break;
                                                    }
                                                    Object object6 = null;
                                                    if (i == n3) {
                                                        object6 = object3;
                                                    } else {
                                                        object5 = MatchList.getAverageShift(i, n3, this.matches, this.lookupBlobMeases, this.nBrightest);
                                                        if (null == object5 || 2 > ((Object)object5).length) {
                                                            Util.warning("Error", "Could not find average shift for image " + i);
                                                        } else {
                                                            object3.translate((double)object5[0], (double)object5[1]);
                                                            object6 = object3;
                                                        }
                                                    }
                                                    if (null == object6) {
                                                        Util.logWarning("Failed to shift image {0}", ((File)object4).getName());
                                                        ++n4;
                                                        break;
                                                    }
                                                    object5 = ((File)object4).getPath();
                                                    String string2 = FileIO.getExtension((String)object5);
                                                    if (null == object5 || null == string2) {
                                                        Util.warning("Error", "Null inputPath or extension");
                                                    }
                                                    if (object3.isRaw()) {
                                                        string2 = ".tif";
                                                    }
                                                    if (object3.getBitsPerChannel() == 8) {
                                                        string2 = ".jpg";
                                                    }
                                                    String string3 = FileIO.removeExtension((String)object5) + "_shav" + string2;
                                                    object3.save(string3);
                                                    object6.dispose();
                                                    object6 = null;
                                                    break;
                                                }
                                                case SHIFT_BRIGHTEST: {
                                                    if (this.processKind != AstroProcessKind.COMBINE || !this.accum.brightestShiftAccumulate((Image8or16Base)object3, i, n3, this.centres)) break;
                                                    ++n;
                                                    break;
                                                }
                                                default: {
                                                    if (this.processKind == AstroProcessKind.COMBINE) {
                                                        if (!this.accum.warpAccumulate((Image8or16Base)object3, i, n3, this.matches, this.lookupBlobMeases, this.nBrightest)) break;
                                                        ++n;
                                                        break;
                                                    }
                                                    Object object7 = null;
                                                    object7 = i == n3 ? object2 : Warp.warp((BufferedImage)object2, i, n3, this.matches, this.lookupBlobMeases, this.nBrightest);
                                                    if (null == object7) {
                                                        Util.logWarning("Failed to warp image {0}", ((File)object4).getName());
                                                        ++n4;
                                                        break;
                                                    }
                                                    Object object5 = ((File)object4).getPath();
                                                    String string4 = FileIO.getExtension((String)object5);
                                                    if (object3.isRaw()) {
                                                        string4 = ".tif";
                                                    }
                                                    if (object3.getBitsPerChannel() == 8) {
                                                        string4 = ".jpg";
                                                    }
                                                    String string3 = FileIO.removeExtension((String)object5) + "_warp" + string4;
                                                    ((Image8or16Base)object3).setBufferedImage((BufferedImage)object7);
                                                    object3.save(string3);
                                                    ((Image)object7).flush();
                                                    object7 = null;
                                                }
                                            }
                                        }
                                        ((Image)object2).flush();
                                        object2 = null;
                                        object3.dispose();
                                    }
                                    object3 = null;
                                    System.gc();
                                    continue;
                                }
                                catch (NullPointerException nullPointerException) {
                                    Util.logWarning("Image " + i + " failed in pass 2: " + nullPointerException.toString());
                                }
                            }
                            this.deleteTemporaryFiles(this.pathsToTempFiles);
                            if (this.processKind == AstroProcessKind.COMBINE) {
                                if (null != this.monitor) {
                                    this.monitor.close();
                                    this.monitor = null;
                                }
                                Metadata metadata = this.batchMetadata.setImageMetadata(this.accum, n);
                                string = Util.removeSubString(this.pathsToTempFiles.get(0), "_temp");
                                object4 = Util.removeSubString(new File(this.pathsToTempFiles.get(n2 - 1)).getName(), "_temp");
                                object3 = "";
                                switch (this.astroProcessMethod) {
                                    case SHIFT_AVERAGE: {
                                        object3 = "_shav";
                                        metadata.addValue("StackingMethod", "Average shift");
                                        break;
                                    }
                                    case SHIFT_BRIGHTEST: {
                                        object3 = "_shbr";
                                        metadata.addValue("StackingMethod", "Brightest shift");
                                        break;
                                    }
                                    case WARP: {
                                        object3 = "_warp";
                                        metadata.addValue("StackingMethod", "Warp");
                                    }
                                }
                                object2 = FileIO.removeExtension(string) + "-" + FileIO.removeExtension((String)object4) + (String)object3 + ".fits";
                                ImFrame imFrame = new ImFrame((String)object2, this.accum);
                                imFrame.getImPane().getImage().save((String)object2);
                            }
                            new ImageSummaryDialogue(this.batchMetadata, this.matches, this.lookupBlobMeases, this.nBrightest, false);
                            if (n4 > 0) {
                                Util.warning("Sorry", n4 + " images could not be combined");
                            }
                            this.timer.stop();
                            Util.message("Done", n5 + " images processed in pass 2");
                            break block54;
                        }
                        Util.warning("Sorry", "No files processed in pass 2");
                    }
                    catch (IncompatibleImageException incompatibleImageException) {
                        Util.warning(this.app, "Error", (Object)incompatibleImageException.toString());
                    }
                } else {
                    Util.warning("Sorry", "No files processed in pass 2");
                }
            }
            MatchPair.resetStaticObjects();
            if (null != this.monitor) {
                this.monitor.close();
                this.monitor = null;
            }
            this.pathsToTempFiles = null;
            this.batchMetadata.dispose();
            this.centres = null;
        }
    }

    public static boolean isBatchCropping() {
        return null != cropFiles;
    }

    protected void cropOthers(Point point, Point point2) {
        GRIP gRIP = GRIP.getInstance();
        gRIP.setCursor(GRIP.GRIP_WAIT_CURSOR);
        gRIP.pack();
        try {
            this.progress = 0;
            int n = cropFiles.length;
            for (int i = 1; i < n; ++i) {
                net.grelf.image.Image image;
                File file = cropFiles[i];
                if (!file.exists()) continue;
                if (null != this.monitor) {
                    this.monitor.setProgress(i);
                    this.monitor.setNote(file.getName() + " [" + (i + 1) + " of " + n + "]");
                    if (this.monitor.isCanceled()) {
                        this.monitor.close();
                        this.monitor = null;
                        return;
                    }
                }
                if (null == (image = this.loadAuxiliaryImage(file.getPath()))) continue;
                image.crop(point, point2);
                String string = file.getPath();
                String string2 = FileIO.removeExtension(string) + "_crop" + FileIO.getExtension(string);
                image.save(string2);
            }
            if (null != this.monitor) {
                this.monitor.close();
                this.monitor = null;
            }
        }
        catch (Exception exception) {
            Util.warning(gRIP, "Error", (Object)exception.toString());
        }
        cropFiles = null;
        gRIP.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    private void infoXML(File file, int n, int n2, net.grelf.image.Image image, PrintWriter printWriter) {
        Map<String, String> map;
        printWriter.println("\t<Image>");
        printWriter.println("\t\t<Name>" + file.getName() + "</Name>");
        printWriter.println("\t\t<Path>" + file.getPath() + "</Path>");
        printWriter.println("\t\t<Width>" + n + "</Width>");
        printWriter.println("\t\t<Height>" + n2 + "</Height>");
        printWriter.println("\t\t<Channels>" + image.getNBands() + "</Channels>");
        printWriter.println("\t\t<BitsPerChannel>" + image.getBitsPerChannel() + "</BitsPerChannel>");
        Metadata metadata = image.getMetadata();
        if (null != metadata) {
            map = metadata.getMap();
            if (map.containsKey("Artist")) {
                printWriter.println("\t\t<Photographer>" + (String)map.get("Artist") + "</Photographer>");
            }
            if (map.containsKey("Make")) {
                printWriter.println("\t\t<CameraMake>" + (String)map.get("Make") + "</CameraMake>");
            }
            if (map.containsKey("Model")) {
                printWriter.println("\t\t<CameraModel>" + (String)map.get("Model") + "</CameraModel>");
            }
            if (map.containsKey("DateTimeOriginal")) {
                printWriter.println("\t\t<DateTimeOriginal>" + (String)map.get("DateTimeOriginal") + "</DateTimeOriginal>");
            }
            if (map.containsKey("DateTime")) {
                printWriter.println("\t\t<DateTime>" + (String)map.get("DateTime") + "</DateTime>");
            }
            if (map.containsKey("FocalLength")) {
                printWriter.print("\t\t<FocalLength>");
                try {
                    printWriter.print(Float.parseFloat(Util.rational((String)map.get("FocalLength"))));
                }
                catch (NumberFormatException numberFormatException) {
                    printWriter.print(Util.rational((String)map.get("FocalLength")));
                }
                printWriter.println("</FocalLength>");
            }
            if (map.containsKey("FNumber")) {
                printWriter.print("\t\t<FNumber>");
                try {
                    printWriter.print(Float.parseFloat(Util.rational((String)map.get("FNumber"))));
                }
                catch (NumberFormatException numberFormatException) {
                    printWriter.print(Util.rational((String)map.get("FNumber")));
                }
                printWriter.println("</FNumber>");
            }
            if (map.containsKey("ExposureTime")) {
                printWriter.print("\t\t<ExposureTime>");
                try {
                    printWriter.print(Float.parseFloat(Util.rational((String)map.get("ExposureTime"))));
                }
                catch (NumberFormatException numberFormatException) {
                    printWriter.print(Util.rational((String)map.get("ExposureTime")));
                }
                printWriter.println("</ExposureTime>");
            }
            if (map.containsKey("ISOSpeedRatings")) {
                printWriter.println("\t\t<ISOSpeedRatings>" + (String)map.get("ISOSpeedRatings") + "</ISOSpeedRatings>");
            }
        }
        if (3 == image.getNBands()) {
            printWriter.println("\t\t<Histogram>");
            map = new Histogram(image);
            Statistics[] statisticsArray = ((HistogramAll)((Object)map)).getStatistics();
            printWriter.println("\t\t\t<Red>");
            printWriter.println("\t\t\t\t<Min>" + statisticsArray[0].min + "</Min>");
            printWriter.println("\t\t\t\t<Mode>" + statisticsArray[0].mode + "</Mode>");
            printWriter.println("\t\t\t\t<Max>" + statisticsArray[0].max + "</Max>");
            printWriter.println("\t\t\t\t<Mean>" + statisticsArray[0].mean + "</Mean>");
            printWriter.println("\t\t\t\t<StdDev>" + statisticsArray[0].stdDev + "</StdDev>");
            printWriter.println("\t\t\t</Red>");
            printWriter.println("\t\t\t<Green>");
            printWriter.println("\t\t\t\t<Min>" + statisticsArray[1].min + "</Min>");
            printWriter.println("\t\t\t\t<Mode>" + statisticsArray[1].mode + "</Mode>");
            printWriter.println("\t\t\t\t<Max>" + statisticsArray[1].max + "</Max>");
            printWriter.println("\t\t\t\t<Mean>" + statisticsArray[1].mean + "</Mean>");
            printWriter.println("\t\t\t\t<StdDev>" + statisticsArray[1].stdDev + "</StdDev>");
            printWriter.println("\t\t\t</Green>");
            printWriter.println("\t\t\t<Blue>");
            printWriter.println("\t\t\t\t<Min>" + statisticsArray[2].min + "</Min>");
            printWriter.println("\t\t\t\t<Mode>" + statisticsArray[2].mode + "</Mode>");
            printWriter.println("\t\t\t\t<Max>" + statisticsArray[2].max + "</Max>");
            printWriter.println("\t\t\t\t<Mean>" + statisticsArray[2].mean + "</Mean>");
            printWriter.println("\t\t\t\t<StdDev>" + statisticsArray[2].stdDev + "</StdDev>");
            printWriter.println("\t\t\t</Blue>");
            printWriter.println("\t\t</Histogram>");
        }
        Exif.processFile(file.getPath(), printWriter);
        printWriter.println("\t</Image>");
    }

    public void doOpInBackground(File[] fileArray, String string, String string2, Map<String, Object> map, int n) {
        this.monitor = new ProgressMonitor(null, "Batch [" + string + "]", "Running", 0, n);
        this.monitor.setMillisToDecideToPopup(100);
        OpThread opThread = new OpThread(fileArray, string, string2, map);
        opThread.start();
    }

    private void displayAllBlobs(int n, int n2, BlobMeas[][] blobMeasArray) {
        ImFrame imFrame = new ImFrame("Objects detected in all images", DrawingMode.UNDEFINED, null, -1, n, n2, new DefaultMeasurementHandler());
        net.grelf.image.Image image = imFrame.getImPane().getImage();
        BufferedImage bufferedImage = ((Image8or16Base)image).getBufferedImage();
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        int n3 = blobMeasArray.length;
        for (int i = 0; i < n3; ++i) {
            int n4 = blobMeasArray[i].length;
            int n5 = (int)((double)i * 192.0 / (double)n3);
            int[] nArray = new int[]{n5, n5, n5};
            for (int j = 0; j < n4; ++j) {
                Blob blob = blobMeasArray[i][j].blob;
                blob.drawRegion(bufferedImage, nArray);
            }
        }
        imFrame.redisplay();
    }

    private void displayBlobsInImage(String string, BlobMeasList blobMeasList) {
        ImFrame imFrame = new ImFrame(blobMeasList.size() + " objects detected in " + string, DrawingMode.UNDEFINED, null, -1, this.wd, this.ht, new DefaultMeasurementHandler());
        BlobMeas.drawBoundaries(imFrame, blobMeasList);
    }

    private class OpThread
    extends Thread {
        private File[] files;
        private String action;
        private String fileNameModifier;
        private Map<String, Object> params;

        public OpThread(File[] fileArray, String string, String string2, Map<String, Object> map) {
            this.files = fileArray;
            this.action = string;
            this.fileNameModifier = string2;
            this.params = map;
        }

        @Override
        public void run() {
            BatchProcessor.this.batch(this.files, this.action, this.fileNameModifier, this.params);
        }
    }
}

