/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.BlobMeasList;
import net.grelf.grip.GRIP;

public class BlobGraph
extends JComponent
implements Printable {
    private List<Point> points;
    private JFrame jf;
    private static final Dimension SIZE = new Dimension(500, 500);
    private GraphKind kind;
    private double minYDatum = 0.0;
    private double maxYDatum = 0.0;
    private double minXDatum = 0.0;
    private double maxXDatum = 0.0;
    private static final DecimalFormat DF3 = new DecimalFormat("0.###");
    private static final int CROSS_ARM = 3;

    public BlobGraph(BlobMeasList blobMeasList, GraphKind graphKind) {
        this.kind = graphKind;
        this.setPoints(blobMeasList);
        this.setSize(SIZE);
        this.setPreferredSize(SIZE);
        this.jf = new JFrame("Blob/star radii");
        this.jf.getContentPane().add(this);
        this.jf.setDefaultCloseOperation(2);
        this.jf.setSize(this.getWidth() + 6, this.getHeight() + 40);
        this.jf.pack();
        this.jf.setLocation(0, 0);
        ImageIcon imageIcon = GRIP.getIcon();
        if (null != imageIcon) {
            this.jf.setIconImage(imageIcon.getImage());
        }
        this.jf.setVisible(true);
    }

    private void setPoints(BlobMeasList blobMeasList) {
        double d;
        boolean bl = true;
        for (BlobMeas blobMeas : blobMeasList) {
            d = 0.0;
            if (this.kind == GraphKind.RADIUS) {
                d = Math.log10(blobMeas.brightness);
            }
            double d2 = StrictMath.sqrt((double)blobMeas.area / Math.PI);
            if (bl) {
                this.minYDatum = this.maxYDatum = d;
                this.minXDatum = this.maxXDatum = d2;
                bl = false;
                continue;
            }
            if (d < this.minYDatum) {
                this.minYDatum = d;
            } else if (d > this.maxYDatum) {
                this.maxYDatum = d;
            }
            if (d2 < this.minXDatum) {
                this.minXDatum = d2;
                continue;
            }
            if (!(d2 > this.maxXDatum)) continue;
            this.maxXDatum = d2;
        }
        double d3 = ((double)BlobGraph.SIZE.height - 100.0) / (this.maxYDatum - this.minYDatum);
        d = ((double)BlobGraph.SIZE.width - 100.0) / (this.maxXDatum - this.minXDatum);
        this.points = new ArrayList<Point>();
        for (BlobMeas blobMeas : blobMeasList) {
            double d4 = 0.0;
            if (this.kind == GraphKind.RADIUS) {
                d4 = Math.log10(blobMeas.brightness);
            }
            double d5 = StrictMath.sqrt((double)blobMeas.area / Math.PI);
            this.points.add(new Point((int)Math.round((d5 - this.minXDatum) * d), (int)Math.round((d4 - this.minYDatum) * d3)));
        }
    }

    protected void draw(Graphics2D graphics2D, int n, int n2) {
        int n3 = n + 70;
        int n4 = n2 + BlobGraph.SIZE.height - 50;
        int n5 = BlobGraph.SIZE.width - 100;
        int n6 = BlobGraph.SIZE.height - 100;
        graphics2D.setPaint(new Color(212, 208, 200));
        graphics2D.fillRect(n, n2, this.getWidth(), this.getHeight());
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n3, n4 - n6, n3, n4);
        graphics2D.drawString(DF3.format(this.minYDatum), n3 - 40, n4);
        graphics2D.drawString(DF3.format(this.maxYDatum), n3 - 40, n4 - n6);
        int n7 = n3 - 68;
        int n8 = n4 - n6 + 40;
        graphics2D.drawString("log10", n7 + 15, n8);
        graphics2D.drawString("brightness", n7 + 10, n8 + 20);
        graphics2D.drawLine(n3, n4, n3 + n5, n4);
        graphics2D.drawString(DF3.format(this.minXDatum), n3, n4 + 14);
        graphics2D.drawString(DF3.format(this.maxXDatum), n3 + n5 - 30, n4 + 14);
        int n9 = n3 + n5 - 100;
        int n10 = n4 + 20;
        graphics2D.drawString("radius", n9 + 15, n10);
        graphics2D.drawString(this.points.size() + " objects plotted", n3 + n5 / 2 - 100, n4 - n6 - 20);
        for (Point point : this.points) {
            this.drawCross(graphics2D, n3 + point.x, n4 - point.y);
        }
    }

    private void drawCross(Graphics2D graphics2D, int n, int n2) {
        graphics2D.drawLine(n - 3, n2, n + 3, n2);
        graphics2D.drawLine(n, n2 - 3, n, n2 + 3);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.draw((Graphics2D)graphics, 0, 0);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.draw(graphics2D, 0, 0);
        return 0;
    }

    public static enum GraphKind {
        RADIUS;

    }
}

