/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.grelf.FileIO;
import net.grelf.Util;
import net.grelf.grip.DrawingMode;
import net.grelf.grip.GlassPane;
import net.grelf.grip.HelpMenu;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImPane;
import net.grelf.grip.OpThread;
import net.grelf.image.Image;
import net.grelf.image.ImageBase;
import net.grelf.image.Kernel;

public class ConvolutionMenu
extends JMenu
implements ActionListener,
MenuListener {
    private ImFrame imframe;
    private static int nPasses = 1;
    private static double deconvolutionWeight = 0.5;
    private static Kernel kernel;
    private static int initialHalfWidth;

    public ConvolutionMenu(ImFrame imFrame) {
        super("Convolution");
        this.imframe = imFrame;
        this.setMnemonic('C');
        this.add(Util.menuItem(this, "Median filter", "median", 70, 0));
        this.add(Util.menuItem(this, "Mean filter", "mean", 69, 0));
        this.add(Util.menuItem(this, "Variance filter", "variance", 82, 0));
        this.add(Util.menuItem(this, "Nearest extreme filter", "extreme", 88, 0));
        this.add(Util.menuItem(this, "Rank filter", "rank", 75, 0));
        this.add(Util.menuItem(this, "Gaussian blur", "blur", 66, 0));
        this.addSeparator();
        this.add(Util.menuItem(this, "Load kernel from file", "kernelload", 76, 0));
        this.add(Util.menuItem(this, "Sample kernel manually", "kernelmanual", 77, 0));
        this.add(Util.menuItem(this, "Sample kernel automatically (star)", "kernelauto", 65, 0));
        this.add(Util.menuItem(this, "Set Gaussian kernel", "kernelgauss", 71, 0));
        this.add(Util.menuItem(this, "View kernel", "viewkernel", 86, 0));
        this.add(Util.menuItem(this, "Convolve", "convolve", 67, 0));
        this.addSeparator();
        this.add(Util.menuItem(this, "Deconvolve (van Cittert)", "deconvolve", 68, 0));
        this.addSeparator();
        this.add(Util.menuItem(this, "Help about this menu", "help", 72, 0));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("blur")) {
            Image image = this.imframe.getImPane().getImage();
            int n = Math.min(image.getWidth(), image.getHeight()) / 16;
            int n2 = Util.askInteger("Blur radius? [1.." + n + "]", 1, 1, n);
            if (Integer.MIN_VALUE != n2) {
                int n3 = 1 + 2 * n2;
                this.imframe.doOpInBackground(OpThread.Ops.BLUR_GAUSSIAN, n3);
                this.imframe.addHistory("Gaussian blur (" + n2 + " x " + n2 + ")");
            }
        } else if (string.equals("convolve")) {
            this.imframe.doOpInBackground(OpThread.Ops.CONVOLVE, 0);
            this.imframe.addHistory("Convolution");
        } else if (string.equals("deconvolve")) {
            nPasses = Util.askInteger(this, "No of passes?", 1, 1, 10);
            deconvolutionWeight = Util.askDouble(this, "Deconvolution weight", 0.5, 0.1, 0.9);
            this.imframe.doOpInBackground(OpThread.Ops.DECONVOLVE, 0);
            this.imframe.addHistory("Deconvolution");
        } else if (string.equals("extreme")) {
            this.imframe.doOpInBackground(OpThread.Ops.NEAREST_EXTREME);
        } else if (string.equals("help")) {
            HelpMenu.help("pages/conv_menu.html");
        } else if (string.equals("kernelgauss")) {
            this.imframe.addHistory("Gaussian kernel");
            Kernel kernel = new Kernel(0, null);
            if (kernel.askHalfWidth()) {
                ConvolutionMenu.setKernel(Kernel.createGaussianKernel(this.imframe.getImPane().getImage(), kernel.getHalfWidth()));
            }
        } else if (string.equals("kernelload")) {
            String string2 = FileIO.selectInputFile("Load kernel CSV file");
            if (null != string2) {
                this.imframe.addHistory("Load kernel from " + string2);
                ConvolutionMenu.setKernel(Kernel.load(string2, this.imframe.getImPane().getImage().getNBands()));
            }
        } else if (string.equals("kernelmanual")) {
            this.imframe.addHistory("Set kernel manually");
            Kernel kernel = new Kernel(0, null);
            if (kernel.askHalfWidth()) {
                ConvolutionMenu.setKernel(kernel);
                ConvolutionMenu.setInitialHalfWidth(kernel.getHalfWidth());
                this.imframe.pushCaption();
                GlassPane glassPane = this.imframe.getImPane().getGlassPane();
                glassPane.setDrawingMode(DrawingMode.KERNEL);
                this.imframe.setTitle("Click to set kernel centre");
            }
        } else if (string.equals("kernelauto")) {
            this.imframe.addHistory("Set kernel automatically");
            Kernel kernel = new Kernel(0, null);
            ConvolutionMenu.setKernel(kernel);
            ConvolutionMenu.setInitialHalfWidth(-50);
            this.imframe.pushCaption();
            GlassPane glassPane = this.imframe.getImPane().getGlassPane();
            glassPane.setDrawingMode(DrawingMode.KERNEL);
            this.imframe.setTitle("Click to set kernel centre");
        } else if (string.equals("mean")) {
            this.imframe.doOpInBackground(OpThread.Ops.MEAN);
        } else if (string.equals("median")) {
            this.imframe.doOpInBackground(OpThread.Ops.MEDIAN);
        } else if (string.equals("rank")) {
            this.imframe.doOpInBackground(OpThread.Ops.RANK);
        } else if (string.equals("variance")) {
            this.imframe.doOpInBackground(OpThread.Ops.VARIANCE);
        } else if (string.equals("viewkernel")) {
            Kernel kernel = ConvolutionMenu.getKernel();
            if (null == kernel) {
                Util.warning("Error", "Kernel is not yet set.");
            } else {
                this.viewKernel(this.imframe.getImPane().getImage());
            }
        }
    }

    protected static int getNPasses() {
        return nPasses;
    }

    protected static double getDeconvolutionWeight() {
        return deconvolutionWeight;
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    public static Kernel getKernel() {
        return kernel;
    }

    public static void setKernel(Kernel kernel) {
        ConvolutionMenu.kernel = kernel;
    }

    public static int getInitialHalfWidth() {
        return initialHalfWidth;
    }

    public static void setInitialHalfWidth(int n) {
        initialHalfWidth = n;
    }

    public void viewKernel(Image image) {
        int n = 2 * kernel.getHalfWidth() + 1;
        int n2 = n * 8;
        int n3 = n * 8;
        Util.message("Note", "Using menu options in the following\ndisplay of the kernel as an image\nwill not affect the current kernel.");
        ImFrame imFrame = new ImFrame(n + " x " + n + " kernel", n2, n3, true);
        ImPane imPane = imFrame.getImPane();
        int n4 = image.getNBands();
        Image image2 = ImageBase.createImage(n2, n3, n4, image.getBitsPerChannel());
        imPane.setImage(image2);
        double d = image2.getRangeDouble().high / image.getRangeDouble().high;
        double[] dArray = new double[n4];
        float[][] fArray = kernel.getData();
        int n5 = 0;
        for (int i = 0; i < n3; i += 8) {
            int n6 = 0;
            while (n6 < n2) {
                int n7;
                for (n7 = 0; n7 < n4; ++n7) {
                    dArray[n7] = (double)fArray[n7][n5] * d;
                }
                for (n7 = 0; n7 < 8; ++n7) {
                    for (int j = 0; j < 8; ++j) {
                        image2.setPixelDouble(n6 + j, i + n7, dArray);
                    }
                }
                n6 += 8;
                ++n5;
            }
        }
        imFrame.redisplay();
    }

    static {
        initialHalfWidth = 1;
    }
}

