/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.grelf.AbstractDialogue;
import net.grelf.Util;
import net.grelf.grip.GRIP;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImPreview;
import net.grelf.grip.ImPreviewActor;
import net.grelf.image.Image;
import net.grelf.image.Timer;

public class ImMultiplyProportionDialogue
extends AbstractDialogue
implements ChangeListener,
ActionListener,
ImPreviewActor {
    private Image im1;
    private static Image im2;
    private JSlider slider;
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private JPanel buttonPanel = new JPanel();
    private ImPreview imPreview;
    private int proportion = 50;
    private boolean accepted = false;

    public int getProportion() {
        return this.proportion;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public ImMultiplyProportionDialogue(ImFrame imFrame, ImFrame imFrame2) {
        super((Frame)imFrame, "Adjust proportion to multiply the images");
        this.im1 = imFrame.getImPane().getImage();
        im2 = imFrame2.getImPane().getImage();
        this.proportion = 50;
        this.slider = new JSlider(0, 0, 100, this.proportion);
        this.slider.addChangeListener(this);
        this.slider.setMajorTickSpacing(20);
        this.slider.setMinorTickSpacing(5);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.setValue(this.proportion);
        this.getContentPane().add((Component)this.slider, "Center");
        this.imPreview = new ImPreview(this.im1, this);
        this.getContentPane().add((Component)this.imPreview, "North");
        this.okButton.addActionListener(this);
        this.buttonPanel.add((Component)this.okButton, "West");
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add((Component)this.cancelButton, "East");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setModal(true);
        this.setVisible(true);
    }

    public static void multiply(Image image, Image image2, int n) {
        int n2 = image.getWidth();
        int n3 = image.getHeight();
        Point point = new Point(n2 / 2, n3 / 2);
        ImMultiplyProportionDialogue.multiply(image, image, point, n2, n3, n);
    }

    @Override
    public void previewAction(Image image, Image image2, Point point, int n, int n2) {
        ImMultiplyProportionDialogue.multiply(image, image2, point, n, n2, this.proportion);
    }

    public static void multiply(Image image, Image image2, Point point, int n, int n2, int n3) {
        double d = (double)(100 - n3) / 100.0;
        double d2 = (double)n3 / 100.0;
        int n4 = image.getNBands();
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        int[] nArray3 = new int[n4];
        double d3 = image.getRangeDouble().high;
        Image image3 = im2;
        double d4 = image3.getRangeDouble().high;
        double d5 = image2.getRangeDouble().high;
        double d6 = d5 / Math.sqrt(d3 * (d * d3 + d2 * d4));
        int n5 = point.y - n2 / 2;
        for (int i = 0; i < n2; ++i) {
            int n6 = point.x - n / 2;
            for (int j = 0; j < n; ++j) {
                nArray = image.getPixel(n6, n5);
                nArray2 = image3.getPixel(n6, n5);
                for (int k = 0; k < n4; ++k) {
                    nArray3[k] = (int)(d6 * Math.sqrt((double)nArray[k] * ((double)nArray[k] * d + (double)nArray2[k] * d2)));
                }
                image2.setPixel(j, i, nArray3);
                ++n6;
            }
            ++n5;
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof JSlider) {
            this.proportion = ((JSlider)object).getValue();
            this.imPreview.refresh();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.okButton)) {
            this.accepted = true;
            this.setVisible(false);
        } else if (actionEvent.getSource().equals(this.cancelButton)) {
            this.accepted = false;
            this.setVisible(false);
        }
    }

    public static int askProportion(ImFrame imFrame, ImFrame imFrame2) {
        if (imFrame.getImPane().getImage().getBitsPerChannel() != imFrame2.getImPane().getImage().getBitsPerChannel()) {
            Util.warning("Sorry", "Cannot combine images with difering\nnumber of bits per channel");
            return 0;
        }
        int n = 50;
        ImMultiplyProportionDialogue imMultiplyProportionDialogue = new ImMultiplyProportionDialogue(imFrame, imFrame2);
        boolean bl = imMultiplyProportionDialogue.isAccepted();
        if (bl) {
            imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
            n = imMultiplyProportionDialogue.getProportion();
            String string = "Multiply proportion [" + (100 - n) + ":" + n + "]";
            imFrame.addHistory(string);
            Timer timer = new Timer(string, imMultiplyProportionDialogue.im1);
            imMultiplyProportionDialogue.applyProportion(imMultiplyProportionDialogue.im1, im2);
            timer.stop();
            imFrame.redisplay();
            imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        }
        imMultiplyProportionDialogue.setVisible(false);
        imMultiplyProportionDialogue.dispose();
        if (bl) {
            return n;
        }
        return -1;
    }

    private void applyProportion(Image image, Image image2) {
        double d = (double)(100 - this.proportion) / 100.0;
        double d2 = (double)this.proportion / 100.0;
        image.multiply(image2, d, d2);
    }
}

