/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import net.grelf.grip.GRIP;
import net.grelf.grip.ImPreviewActor;
import net.grelf.image.Image;
import net.grelf.image.Image8;

public class ImPreview
extends JComponent
implements MouseListener,
MouseMotionListener {
    public static final int PREVIEW_WIDTH = 300;
    public static final int PREVIEW_HEIGHT = 300;
    private Image image = null;
    private Image8 previewIm;
    private int imWd;
    private int imHt;
    private Point centre;
    private Point oldCentre;
    private Point mouseStart;
    private boolean mouseOver = false;
    private ImPreviewActor caller;
    private int width;
    private int height;
    private int widthOn2;
    private int heightOn2;

    public Image8 getPreviewIm() {
        return this.previewIm;
    }

    public ImPreview(Image image, ImPreviewActor imPreviewActor) {
        this(image, imPreviewActor, 300, 300);
    }

    public ImPreview(Image image, ImPreviewActor imPreviewActor, int n, int n2) {
        this.image = image;
        this.imWd = image.getWidth();
        this.imHt = image.getHeight();
        this.width = Math.min(n, this.imWd);
        this.widthOn2 = this.width / 2;
        this.height = Math.min(n2, this.imHt);
        this.heightOn2 = this.height / 2;
        int n3 = image.getNBands();
        this.previewIm = new Image8(this.width, this.height, n3, false, false);
        this.centre = new Point(this.imWd / 2, this.imHt / 2);
        this.caller = imPreviewActor;
        this.caller.previewAction(this.image, this.previewIm, this.centre, this.width, this.height);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setPreferredSize(new Dimension(n, n2));
    }

    public void refresh() {
        this.caller.previewAction(this.image, this.previewIm, this.centre, this.width, this.height);
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.mouseOver) {
            this.centre = new Point(this.oldCentre.x - mouseEvent.getX() + this.mouseStart.x, this.oldCentre.y - mouseEvent.getY() + this.mouseStart.y);
            if (this.centre.x - this.widthOn2 < 0) {
                this.centre.x = this.widthOn2;
            } else if (this.centre.x >= this.imWd - this.widthOn2) {
                this.centre.x = this.imWd - this.widthOn2 - 1;
            }
            if (this.centre.y - this.heightOn2 < 0) {
                this.centre.y = this.heightOn2;
            } else if (this.centre.y >= this.imHt - this.heightOn2) {
                this.centre.y = this.imHt - this.heightOn2 - 1;
            }
            this.caller.previewAction(this.image, this.previewIm, this.centre, this.width, this.height);
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseOver = false;
        this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseOver = true;
        this.setCursor(GRIP.GRIP_HAND_CURSOR);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.mouseOver) {
            this.oldCentre = new Point(this.centre.x, this.centre.y);
            this.mouseStart = mouseEvent.getPoint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.drawImage(this.previewIm.getBufferedImage(), 0, 0, this);
    }
}

