/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.grelf.AbstractDialogue;
import net.grelf.Timer;
import net.grelf.Util;
import net.grelf.grip.GRIP;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImPreview;
import net.grelf.grip.ImPreviewActor;
import net.grelf.image.Image;

public class ImSaturateDialogue
extends AbstractDialogue
implements ChangeListener,
ActionListener,
ImPreviewActor {
    private Image image;
    private int srcMaxLevel;
    private int dstMaxLevel;
    private JSlider slider;
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private JPanel buttonPanel = new JPanel();
    private ImPreview imPreview;
    private int satValue = 0;
    private boolean accepted = false;

    public int getSaturationValue() {
        return this.satValue;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public ImSaturateDialogue(ImFrame imFrame) {
        super((Frame)imFrame, "Adjust saturation");
        this.image = imFrame.getImPane().getImage();
        this.dstMaxLevel = this.image.getRange().high;
        this.srcMaxLevel = this.image.getRange().high;
        this.imPreview = new ImPreview(this.image, this);
        this.satValue = 0;
        this.slider = new JSlider(0, -100, 100, this.satValue);
        this.slider.addChangeListener(this);
        this.slider.setMajorTickSpacing(50);
        this.slider.setMinorTickSpacing(10);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.getContentPane().add((Component)this.slider, "Center");
        this.getContentPane().add((Component)this.imPreview, "North");
        this.okButton.addActionListener(this);
        this.buttonPanel.add((Component)this.okButton, "West");
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add((Component)this.cancelButton, "East");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setModal(true);
        this.setVisible(true);
    }

    public void applySaturation(Image image) {
        int n = this.imPreview.getPreviewIm().getWidth();
        int n2 = this.imPreview.getPreviewIm().getHeight();
        Point point = new Point(n / 2, n2 / 2);
        ImSaturateDialogue.saturate(image, this.satValue);
    }

    public static void saturate(Image image, int n) {
        block11: {
            double d;
            int[] nArray;
            int n2;
            Point point;
            int n3;
            int n4;
            block10: {
                n4 = image.getWidth();
                n3 = image.getHeight();
                point = new Point(n4 / 2, n3 / 2);
                n2 = image.getNBands();
                nArray = new int[n2];
                d = (double)n / 100.0;
                if (!(d < 0.0)) break block10;
                int n5 = point.y - n3 / 2;
                for (int i = 0; i < n3; ++i) {
                    int n6 = point.x - n4 / 2;
                    for (int j = 0; j < n4; ++j) {
                        int n7;
                        nArray = image.getPixel(n6, n5);
                        int n8 = nArray[0];
                        for (n7 = 1; n7 < n2; ++n7) {
                            n8 += nArray[n7];
                        }
                        n7 = n8 / n2;
                        for (int k = 0; k < n2; ++k) {
                            nArray[k] = (int)((double)nArray[k] - d * (double)(n7 - nArray[k]));
                        }
                        image.setPixel(j, i, nArray);
                        ++n6;
                    }
                    ++n5;
                }
                break block11;
            }
            if (!(d > 0.0)) break block11;
            d *= 4.0;
            int n9 = point.y - n3 / 2;
            for (int i = 0; i < n3; ++i) {
                int n10 = point.x - n4 / 2;
                for (int j = 0; j < n4; ++j) {
                    int n11;
                    nArray = image.getPixel(n10, n9);
                    int n12 = n11 = nArray[0];
                    for (int k = 1; k < n2; ++k) {
                        if (nArray[k] < n11) {
                            n11 = nArray[k];
                            continue;
                        }
                        if (nArray[k] <= n12) continue;
                        n12 = nArray[k];
                    }
                    double d2 = 1.0;
                    if (n12 > n11) {
                        d2 = (double)n12 / ((double)n12 + d * (double)(n12 - n11));
                    }
                    for (int k = 0; k < n2; ++k) {
                        nArray[k] = (int)(d2 * ((double)nArray[k] + d * (double)(nArray[k] - n11)));
                    }
                    image.setPixel(j, i, nArray);
                    ++n10;
                }
                ++n9;
            }
        }
    }

    @Override
    public void previewAction(Image image, Image image2, Point point, int n, int n2) {
        int n3 = image.getNBands();
        int[] nArray = new int[n3];
        double d = (double)this.satValue / 100.0;
        double d2 = image2.getRangeDouble().high / (double)image.getRange().high;
        if (d < 0.0) {
            int n4 = point.y - n2 / 2;
            for (int i = 0; i < n2; ++i) {
                int n5 = point.x - n / 2;
                for (int j = 0; j < n; ++j) {
                    int n6;
                    nArray = image.getPixel(n5, n4);
                    int n7 = nArray[0];
                    for (n6 = 1; n6 < n3; ++n6) {
                        n7 += nArray[n6];
                    }
                    n6 = n7 / n3;
                    for (int k = 0; k < n3; ++k) {
                        nArray[k] = (int)(d2 * ((double)nArray[k] - d * (double)(n6 - nArray[k])));
                    }
                    image2.setPixel(j, i, nArray);
                    ++n5;
                }
                ++n4;
            }
        } else if (d > 0.0) {
            d *= 4.0;
            int n8 = point.y - n2 / 2;
            for (int i = 0; i < n2; ++i) {
                int n9 = point.x - n / 2;
                for (int j = 0; j < n; ++j) {
                    int n10;
                    nArray = image.getPixel(n9, n8);
                    int n11 = n10 = nArray[0];
                    for (int k = 1; k < n3; ++k) {
                        nArray[k] = nArray[k];
                        if (nArray[k] < n10) {
                            n10 = nArray[k];
                            continue;
                        }
                        if (nArray[k] <= n11) continue;
                        n11 = nArray[k];
                    }
                    double d3 = 1.0;
                    if (n11 > n10) {
                        d3 = (double)n11 / ((double)n11 + d * (double)(n11 - n10));
                    }
                    for (int k = 0; k < n3; ++k) {
                        nArray[k] = (int)(d2 * (d3 * ((double)nArray[k] + d * (double)(nArray[k] - n10))));
                    }
                    image2.setPixel(j, i, nArray);
                    ++n9;
                }
                ++n8;
            }
        } else {
            int n12 = point.y - n2 / 2;
            for (int i = 0; i < n2; ++i) {
                int n13 = point.x - n / 2;
                for (int j = 0; j < n; ++j) {
                    nArray = image.getPixel(n13, n12);
                    int n14 = 0;
                    while (n14 < n3) {
                        int n15 = n14++;
                        nArray[n15] = (int)((double)nArray[n15] * d2);
                    }
                    image2.setPixel(j, i, nArray);
                    ++n13;
                }
                ++n12;
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof JSlider) {
            this.satValue = ((JSlider)object).getValue();
            this.imPreview.refresh();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.okButton)) {
            this.accepted = true;
            this.setVisible(false);
        } else if (actionEvent.getSource().equals(this.cancelButton)) {
            this.accepted = false;
            this.setVisible(false);
        }
    }

    public static int askSaturate(ImFrame imFrame) {
        Image image = imFrame.getImPane().getImage();
        int n = 0;
        if (image.getNBands() == 1) {
            Util.message("Information", "Colour saturation is not relevant for monochrome (1-channel) images");
        } else {
            ImSaturateDialogue imSaturateDialogue = new ImSaturateDialogue(imFrame);
            if (imSaturateDialogue.isAccepted()) {
                imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
                imFrame.addHistory("Saturation");
                n = imSaturateDialogue.getSaturationValue();
                Timer timer = new Timer("Saturation", null);
                imSaturateDialogue.applySaturation(image);
                timer.stop();
                imFrame.redisplay();
                imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
            }
            imSaturateDialogue.setVisible(false);
            imSaturateDialogue.dispose();
        }
        return n;
    }
}

