/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Dimension;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import net.grelf.FileIO;
import net.grelf.FileIO_CSVFilter;
import net.grelf.FileIO_XMLFilter;
import net.grelf.Util;
import net.grelf.grip.DefaultMeasurementHandler;
import net.grelf.grip.DrawingMode;
import net.grelf.grip.GRIP;
import net.grelf.grip.ImAddProportionDialogue;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImMultiplyProportionDialogue;
import net.grelf.grip.ImTableMenu;
import net.grelf.grip.ImTableModel;
import net.grelf.image.Image;
import net.grelf.image.ImageBase;
import net.grelf.image.IncompatibleImageException;
import net.grelf.image.Metadata;

public class ImTable {
    private JTable table;
    private ImTableModel tableModel;
    private ImTableMenu menu;
    private JFrame frame;
    private List<ImFrame> imFramesList = GRIP.getImFramesList();

    protected JTable getJTable() {
        return this.table;
    }

    protected ImTableModel getTableModel() {
        return this.tableModel;
    }

    public List<ImFrame> getList() {
        return this.imFramesList;
    }

    public ImTable(GRIP gRIP, String string) {
        this(gRIP, string, false);
    }

    public ImTable(GRIP gRIP, String string, boolean bl) {
        int n = this.imFramesList.size();
        if (n < 3) {
            n = 3;
        }
        this.frame = new JFrame(string);
        ImageIcon imageIcon = GRIP.getIcon();
        if (null != imageIcon) {
            this.frame.setIconImage(imageIcon.getImage());
        }
        this.tableModel = new ImTableModel(this.buildData());
        this.table = new JTable(this.tableModel);
        this.frame.getContentPane().add(new JScrollPane(this.table));
        this.frame.setDefaultCloseOperation(2);
        this.frame.setPreferredSize(new Dimension(800, 30 * n + 91));
        this.frame.setResizable(true);
        this.frame.setLocation(gRIP.getWidth(), 0);
        this.menu = new ImTableMenu(this.frame, this);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void refresh() {
        this.tableModel.setTable(this.buildData());
        this.menu.enableItems();
        this.frame.getContentPane().removeAll();
        this.frame.getContentPane().add(new JScrollPane(this.table));
        this.frame.setVisible(true);
    }

    public void setVisible(boolean bl) {
        this.frame.setVisible(bl);
    }

    private String[][] buildData() {
        int n = this.imFramesList.size();
        String[][] stringArray = new String[n][11];
        for (int i = 0; i < n; ++i) {
            Map<String, String> map;
            ImFrame imFrame = this.imFramesList.get(i);
            Image image = imFrame.getImPane().getImage();
            stringArray[i][0] = imFrame.getCaption();
            stringArray[i][1] = imFrame.getFilePath();
            stringArray[i][2] = "" + image.getWidth() + " px";
            stringArray[i][3] = "" + image.getHeight() + " px";
            stringArray[i][4] = "" + image.getNBands();
            stringArray[i][5] = "" + image.getBitsPerChannel();
            Metadata metadata = image.getMetadata();
            if (null == metadata || null == (map = metadata.getMap())) continue;
            stringArray[i][6] = "" + this.makeSafe(map.get("DateTimeOriginal"));
            stringArray[i][7] = "" + Util.rational(this.makeSafe(map.get("ExposureTime"))) + " s";
            stringArray[i][8] = "f/" + Util.rational(this.makeSafe(map.get("FNumber")));
            stringArray[i][9] = "" + this.makeSafe(map.get("ISOSpeedRatings"));
            stringArray[i][10] = "" + Util.rational(this.makeSafe(map.get("FocalLength"))) + " mm";
        }
        return stringArray;
    }

    private String makeSafe(String string) {
        if (null == string) {
            return "-";
        }
        return string;
    }

    protected int getNSelected() {
        int n = 0;
        if (null != this.table) {
            int n2 = this.tableModel.getRowCount();
            for (int i = 0; i < n2; ++i) {
                if (!this.table.getSelectionModel().isSelectedIndex(i)) continue;
                ++n;
            }
        }
        return n;
    }

    protected List<ImFrame> getSelected() {
        ArrayList<ImFrame> arrayList = new ArrayList<ImFrame>();
        if (null != this.table) {
            int n = this.tableModel.getRowCount();
            for (int i = 0; i < n; ++i) {
                if (!this.table.getSelectionModel().isSelectedIndex(i)) continue;
                arrayList.add(this.imFramesList.get(i));
            }
            return arrayList;
        }
        return arrayList;
    }

    public void saveAsCSV() {
        int n = this.getTableModel().getColumnCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getTableModel().getColumnName(i);
        }
        String string = FileIO.selectOutputFile("Save as CSV file", null, new FileIO_CSVFilter[]{new FileIO_CSVFilter(1)}, "x.csv");
        if (null != string) {
            Util.saveJTableAsCSV(stringArray, this.getJTable(), string);
        }
    }

    public void saveAsXML() {
        String string = FileIO.selectOutputFile("Save as XML file", null, new FileIO_XMLFilter[]{new FileIO_XMLFilter(1)}, "x.xml");
        if (null != string) {
            try {
                PrintWriter printWriter = new PrintWriter(string);
                printWriter.println("<?xml version=\"1.0\"?>");
                printWriter.println("<Images>");
                ImTableModel imTableModel = this.getTableModel();
                for (int i = 0; i < imTableModel.getRowCount(); ++i) {
                    printWriter.println("\t<Image>");
                    for (int j = 0; j < 11; ++j) {
                        String string2 = imTableModel.getColumnElementName(j);
                        printWriter.println("\t\t<" + string2 + ">" + (String)imTableModel.getValueAt(i, j) + "</" + string2 + ">");
                    }
                    printWriter.println("\t</Image>");
                }
                printWriter.println("</Images>");
                printWriter.close();
            }
            catch (IOException iOException) {
                Util.message(this.frame, "Sorry", "Could not open " + string);
            }
        }
    }

    protected void combine(String string) {
        String string2 = "";
        if (string.equals("add")) {
            string2 = "Added";
        } else if (string.equals("ave")) {
            string2 = "Averaged";
        } else if (string.equals("div")) {
            string2 = "Divided (by flat field)";
        } else if (string.equals("mpy")) {
            string2 = "Multiplied";
        } else if (string.equals("revsub") || string.equals("sub")) {
            string2 = "Subtracted";
        } else if (string.equals("stereo")) {
            string2 = "Red - green stero";
        } else if (string.equals("warp")) {
            string2 = "Warped";
        }
        try {
            List<ImFrame> list = this.getSelected();
            ImFrame imFrame = list.get(0);
            Image image = imFrame.getImPane().getImage();
            Image image2 = null;
            if (string.equals("add") || string.equals("ave")) {
                image2 = image.getBitsPerChannel() > 16 ? image : image.convertToImage32();
            }
            for (int i = 1; i < list.size(); ++i) {
                ImFrame imFrame2 = list.get(i);
                Image image3 = imFrame2.getImPane().getImage();
                if (string.equals("add") || string.equals("ave")) {
                    image2.add(image3);
                    continue;
                }
                if (string.equals("addP")) {
                    ImAddProportionDialogue.askProportion(imFrame, imFrame2);
                    continue;
                }
                if (string.equals("div")) {
                    imFrame.divideByFlatField(imFrame2);
                    continue;
                }
                if (string.equals("mpy")) {
                    imFrame.multiply(imFrame2);
                    continue;
                }
                if (string.equals("mpyP")) {
                    ImMultiplyProportionDialogue.askProportion(imFrame, imFrame2);
                    continue;
                }
                if (string.equals("revsub")) {
                    imFrame2.sub(imFrame);
                    imFrame2.setCaption(string2);
                    imFrame2.addHistory(string2);
                    continue;
                }
                if (string.equals("stereo")) {
                    imFrame.stereo(imFrame2);
                    continue;
                }
                if (string.equals("sub")) {
                    imFrame.sub(imFrame2);
                    continue;
                }
                if (!string.equals("subzero")) continue;
                imFrame.subToZero(imFrame2);
            }
            if (string.equals("ave")) {
                image2.divide(list.size());
            }
            if (string.equals("add") || string.equals("ave")) {
                imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
                imFrame.getImPane().setImage(image2);
                imFrame.redisplay();
                imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
            }
            if (!string.equals("revsub")) {
                imFrame.setCaption(string2);
                imFrame.addHistory(string2);
            }
        }
        catch (IncompatibleImageException incompatibleImageException) {
            Util.warning(this.frame, "Error", (Object)incompatibleImageException.toString());
        }
    }

    public void reapplyColour() {
        int n;
        int n2;
        List<ImFrame> list = this.getSelected();
        if (2 != list.size()) {
            return;
        }
        Image image = list.get(0).getImPane().getImage();
        Image image2 = list.get(1).getImPane().getImage();
        int n3 = image.getNBands();
        int n4 = image2.getNBands();
        Image image3 = null;
        Image image4 = null;
        if (n3 == 1 && n4 > 1) {
            image3 = image;
            image4 = image2;
        } else if (n4 == 1 && n3 > 1) {
            image3 = image2;
            image4 = image;
        }
        if (null == image3 || null == image4) {
            return;
        }
        if (!image3.getClass().equals(image4.getClass())) {
            Util.warning("Sorry", "Intensity and colour images are of different bit depths");
            return;
        }
        int n5 = image3.getWidth();
        Image image5 = ImageBase.createImage(n5, n2 = image3.getHeight(), n = image4.getNBands(), image4.getBitsPerChannel());
        if (null == image5) {
            Util.warning("Error", "Could not construct image for result");
            return;
        }
        ImFrame imFrame = new ImFrame("Reapplied colour", DrawingMode.UNDEFINED, null, -1, n5, n2, new DefaultMeasurementHandler(), true);
        imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
        imFrame.getImPane().setImage(image5);
        image5.reapplyColour(image3, image4);
        imFrame.redisplay();
        imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public void recombine() {
        List<ImFrame> list = this.getSelected();
        ImFrame imFrame = list.get(0);
        ImFrame imFrame2 = list.get(1);
        ImFrame imFrame3 = list.get(2);
        Image image = imFrame.getImPane().getImage();
        Image image2 = imFrame2.getImPane().getImage();
        Image image3 = imFrame3.getImPane().getImage();
        int n = image.getBitsPerChannel();
        int n2 = image2.getBitsPerChannel();
        int n3 = image3.getBitsPerChannel();
        if (n != n2 || n != n3) {
            Util.message("Sorry", "All 3 selected images must have the same number of bits per channel");
            return;
        }
        int n4 = image.getWidth();
        int n5 = image.getHeight();
        int n6 = image.getNBands();
        if (n6 != 3) {
            Util.warning("Sorry", "This operation is for three 3-channel (RGB) images only");
            return;
        }
        if (n4 != image2.getWidth() || n5 != image2.getHeight() || n6 != image2.getNBands() || n4 != image3.getWidth() || n5 != image3.getHeight() || n6 != image3.getNBands()) {
            Util.warning("Sorry", "The 3 images must be the same size for swapping channels");
            return;
        }
        imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
        imFrame2.setCursor(GRIP.GRIP_WAIT_CURSOR);
        imFrame3.setCursor(GRIP.GRIP_WAIT_CURSOR);
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n6];
        int[] nArray3 = new int[n6];
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                nArray = image.getPixel(j, i);
                nArray2 = image2.getPixel(j, i);
                nArray3 = image3.getPixel(j, i);
                int n7 = nArray[1];
                nArray[1] = nArray2[1];
                nArray2[1] = nArray3[1];
                nArray3[1] = n7;
                n7 = nArray3[2];
                nArray3[2] = nArray2[2];
                nArray2[2] = nArray[2];
                nArray[2] = n7;
                image.setPixel(j, i, nArray);
                image2.setPixel(j, i, nArray2);
                image3.setPixel(j, i, nArray3);
            }
            imFrame.redisplay();
            imFrame2.redisplay();
            imFrame3.redisplay();
            imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
            imFrame2.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
            imFrame3.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
            imFrame.setCaption("Recombined R1G2B3");
            imFrame.addHistory("Recombined R1G2B3");
            imFrame2.setCaption("Recombined R2G3B1");
            imFrame2.addHistory("Recombined R2G3B1");
            imFrame3.setCaption("Recombined R3G1B2");
            imFrame3.addHistory("Recombined R3G1B2");
        }
    }

    protected void swap() {
        if (null != this.table) {
            ArrayList<ImFrame> arrayList = new ArrayList<ImFrame>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            int n = this.tableModel.getRowCount();
            for (int i = 0; i < n; ++i) {
                if (!this.table.getSelectionModel().isSelectedIndex(i)) continue;
                arrayList.add(this.imFramesList.get(i));
                arrayList2.add(i);
            }
            ImFrame imFrame = (ImFrame)arrayList.get(0);
            ImFrame imFrame2 = (ImFrame)arrayList.get(1);
            this.imFramesList.set((Integer)arrayList2.get(0), imFrame2);
            this.imFramesList.set((Integer)arrayList2.get(1), imFrame);
        }
    }
}

