/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.grelf.FileIO;
import net.grelf.FileIO_CSVFilter;
import net.grelf.FileIO_XMLFilter;
import net.grelf.Util;
import net.grelf.grip.ComparisonPrint;
import net.grelf.grip.DefaultMeasurementHandler;
import net.grelf.grip.GRIP;
import net.grelf.grip.HelpMenu;
import net.grelf.grip.MeasurementCurve;
import net.grelf.grip.MeasurementGraph;
import net.grelf.grip.MeasurementTable;
import net.grelf.grip.MeasurementTableModel;

public class MeasurementTableMenu
implements ActionListener,
MenuListener {
    private JFrame frame;
    private String[][] data;
    private MeasurementTable table;
    private JMenuBar menubar;

    public JMenuBar getMenuBar() {
        return this.menubar;
    }

    public MeasurementTableMenu(JFrame jFrame, String[][] stringArray, MeasurementTable measurementTable) {
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        jMenu.add(Util.menuItem(this, "Save table as CSV", "savecsv", 83, 0));
        jMenu.add(Util.menuItem(this, "Save table as XML", "savexml", 88, 83));
        jMenu.add(Util.menuItem(this, "Print", "print", 80, 80));
        jMenu.add(Util.menuItem(this, "Close window", "close", 87, 87));
        JMenu jMenu2 = new JMenu("Graph");
        jMenu2.setMnemonic('G');
        jMenu2.add(Util.menuItem(this, "Graph selected rows", "graph", 71, 0));
        this.menubar = new JMenuBar();
        this.menubar.add(jMenu);
        this.menubar.add(jMenu2);
        this.menubar.add(new HelpMenu());
        this.frame = jFrame;
        this.data = stringArray;
        this.table = measurementTable;
        jFrame.setJMenuBar(this.menubar);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        String string2 = actionEvent.getActionCommand();
        if (string2.equals("close")) {
            this.frame.setVisible(false);
            this.frame.dispose();
        } else if (string2.equals("graph")) {
            MeasurementTableModel measurementTableModel = this.table.getTableModel();
            if (null != measurementTableModel) {
                int n;
                int n2 = measurementTableModel.getRowCount();
                int n3 = measurementTableModel.getColumnCount();
                ArrayList<MeasurementCurve> arrayList = new ArrayList<MeasurementCurve>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (n = 3; n < n3; ++n) {
                    arrayList2.add((String)measurementTableModel.getValueAt(2, n));
                }
                for (n = 3; n < n2; ++n) {
                    if (!this.table.getJTable().getSelectionModel().isSelectedIndex(n)) continue;
                    String string3 = (String)measurementTableModel.getValueAt(n, 1);
                    String string4 = (String)measurementTableModel.getValueAt(n, 2);
                    if (string4.length() > 0) {
                        string3 = string3 + ", " + string4;
                    }
                    double[] dArray = new double[n3 - 3];
                    boolean bl = true;
                    for (int i = 0; i < dArray.length; ++i) {
                        try {
                            dArray[i] = Double.parseDouble((String)measurementTableModel.getValueAt(n, i + 3));
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            dArray[i] = Double.NaN;
                            bl = false;
                        }
                    }
                    if (bl) {
                        arrayList.add(new MeasurementCurve(dArray, string3));
                        continue;
                    }
                    Util.warning("Warning", string3 + "<br>has some non-floating-point values<br>so will not be graphed");
                }
                if (arrayList.size() > 0) {
                    MeasurementGraph measurementGraph = new MeasurementGraph(arrayList, arrayList2);
                    JOptionPane.showMessageDialog(this.frame, measurementGraph, "Measured", -1, GRIP.getIcon());
                }
            }
        } else if (string2.equals("print")) {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPrintable(new ComparisonPrint(this.data));
            if (printerJob.printDialog(DefaultMeasurementHandler.getAtts())) {
                try {
                    printerJob.print();
                }
                catch (PrinterException printerException) {
                    Util.warning("Error", printerException.toString());
                }
            }
        } else if (string2.equals("savecsv")) {
            String string5 = FileIO.selectOutputFile("Save as CSV file", null, new FileIO_CSVFilter[]{new FileIO_CSVFilter(1)}, "x.csv");
            if (null != string5) {
                try {
                    PrintWriter printWriter = new PrintWriter(new FileWriter(new File(string5)));
                    for (int i = 0; i < this.data.length; ++i) {
                        for (int j = 0; j < this.data[0].length; ++j) {
                            int n;
                            StringBuffer stringBuffer = new StringBuffer(this.data[i][j]);
                            do {
                                if ((n = stringBuffer.indexOf("<")) == -1) continue;
                                int n4 = stringBuffer.indexOf(">", n);
                                if (n4 != -1) {
                                    // empty if block
                                }
                                stringBuffer.delete(n, n4 + 1);
                            } while (n != -1);
                            if (-1 != stringBuffer.indexOf(",")) {
                                printWriter.print("\"" + stringBuffer.toString() + "\",");
                                continue;
                            }
                            printWriter.print(stringBuffer.toString() + ",");
                        }
                        printWriter.println();
                    }
                    printWriter.close();
                }
                catch (IOException iOException) {
                    Util.message(this.frame, "Sorry", "Could not open " + string5);
                }
            }
        } else if (string2.equals("savexml") && null != (string = FileIO.selectOutputFile("Save as XML file", null, new FileIO_XMLFilter[]{new FileIO_XMLFilter(1)}, "x.xml"))) {
            MeasurementTableModel measurementTableModel = this.table.getTableModel();
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(new File(string)));
                printWriter.println("<?xml version=\"1.0\"?>");
                printWriter.println("<Rows>");
                for (int i = 0; i < this.data.length; ++i) {
                    printWriter.println("\t<Row>");
                    for (int j = 0; j < this.data[0].length; ++j) {
                        String string6 = this.data[i][j].trim();
                        if (0 >= string6.length()) continue;
                        String string7 = measurementTableModel.getColumnName(j);
                        printWriter.println("\t\t<" + string7 + ">" + this.data[i][j] + "</" + string7 + ">");
                    }
                    printWriter.println("\t</Row>");
                }
                printWriter.println("</Rows>");
                printWriter.close();
            }
            catch (IOException iOException) {
                Util.message(this.frame, "Sorry", "Could not open " + string);
            }
        }
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }
}

