/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import net.grelf.grip.ConvolutionMenu;
import net.grelf.grip.ImFrame;

public class OpThread
extends Thread {
    private Ops op;
    private ImFrame frame;
    private int width;

    public OpThread(Ops ops, ImFrame imFrame, int n) {
        this.op = ops;
        this.frame = imFrame;
        this.width = n;
    }

    @Override
    public void run() {
        switch (this.op) {
            case BLUR_GAUSSIAN: {
                this.frame.blurGaussian(this.width, this.width);
                break;
            }
            case CONVOLVE: {
                this.frame.convolve(ConvolutionMenu.getKernel());
                break;
            }
            case DECONVOLVE: {
                this.frame.deconvolve(ConvolutionMenu.getKernel(), ConvolutionMenu.getNPasses(), ConvolutionMenu.getDeconvolutionWeight());
                break;
            }
            case MEAN: {
                this.frame.meanFilter();
                break;
            }
            case MEDIAN: {
                this.frame.medianFilter();
                break;
            }
            case NEAREST_EXTREME: {
                this.frame.nearestExtremeFilter();
                break;
            }
            case RANK: {
                this.frame.rankFilter();
                break;
            }
            case VARIANCE: {
                this.frame.varianceFilter();
            }
        }
    }

    public static enum Ops {
        BLUR_GAUSSIAN,
        CONVOLVE,
        DECONVOLVE,
        MEAN,
        MEDIAN,
        NEAREST_EXTREME,
        RANK,
        VARIANCE;

    }
}

