/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.grelf.FileIO;
import net.grelf.PointFloat;
import net.grelf.Statistics;
import net.grelf.Util;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.BlobMeasList;
import net.grelf.grip.GRIP;
import net.grelf.grip.Histogram;
import net.grelf.grip.ImFrame;
import net.grelf.grip.Warp;
import net.grelf.grip.WarpingPair;
import net.grelf.image.Image;
import net.grelf.image.ImageBase;
import net.grelf.image.Threshold;

public class WarpingGrid {
    private static final int MIN_BLOBS = 20;
    private List<WarpingPair> points = new ArrayList<WarpingPair>();

    public List<WarpingPair> getPoints() {
        return this.points;
    }

    public boolean make(BlobMeasList blobMeasList) {
        double d;
        double d2;
        double d3;
        double d4;
        BlobMeasList blobMeasList2 = new BlobMeasList(blobMeasList.getImFrame());
        for (BlobMeas blobMeas : blobMeasList) {
            float f = blobMeas.maxX - blobMeas.minX + 1;
            float f2 = blobMeas.maxY - blobMeas.minY + 1;
            float f3 = f / f2;
            if (!((double)f3 > 0.5) || !((double)f3 < 2.0)) continue;
            blobMeasList2.insert(blobMeas);
        }
        double d5 = 0.0;
        int n = blobMeasList2.size();
        System.out.println("meases.size()=" + n);
        if (n < 20) {
            Util.warning("Error", "Not enough unelongated dots detected.\nFound " + n + " but need at least " + 20);
            return false;
        }
        for (BlobMeas blobMeas : blobMeasList2) {
            BlobMeas blobMeas2 = blobMeasList2.getNearestBlob(blobMeas.blob);
            double d6 = blobMeas.centre.x - blobMeas2.centre.x;
            d4 = blobMeas.centre.y - blobMeas2.centre.y;
            d5 += StrictMath.sqrt(d6 * d6 + d4 * d4);
        }
        double d7 = d5 / (double)n;
        System.out.println("Mean distance (pass 1) = " + d7 + " px");
        d5 = 0.0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        d4 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        for (BlobMeas blobMeas : blobMeasList2) {
            BlobMeas blobMeas3;
            d3 = blobMeas.centre.x;
            double d11 = blobMeas.centre.y;
            d9 += d3;
            d10 += d11;
            if (d3 > d7) {
                ++n2;
                blobMeas3 = blobMeasList2.getNearestBlob((int)(d3 - d7), (int)d11);
                d2 = Math.abs(d3 - (double)blobMeas3.centre.x);
                d = Math.abs(d11 - (double)blobMeas3.centre.y);
                d5 += StrictMath.sqrt(d2 * d2 + d * d);
                if (d2 > d) {
                    ++n3;
                    d4 += StrictMath.atan2(d, d2);
                } else {
                    ++n4;
                    d8 += StrictMath.atan2(d, d2);
                }
            }
            if (!(d11 > d7)) continue;
            ++n2;
            blobMeas3 = blobMeasList2.getNearestBlob((int)d3, (int)(d11 - d7));
            d2 = Math.abs(d3 - (double)blobMeas3.centre.x);
            d = Math.abs(d11 - (double)blobMeas3.centre.y);
            d5 += StrictMath.sqrt(d2 * d2 + d * d);
            if (d2 > d) {
                ++n3;
                d4 += StrictMath.atan2(d, d2);
                continue;
            }
            ++n4;
            d8 += StrictMath.atan2(d, d2);
        }
        d7 = d5 / (double)n2;
        double d12 = d4 / (double)n3;
        d3 = d8 / (double)n4;
        System.out.println("Mean distance (pass 2) = " + d7 + " px");
        System.out.println("Angle horz = " + StrictMath.toDegrees(d12) + " degrees");
        System.out.println("Angle vert = " + StrictMath.toDegrees(d3) + " degrees");
        BlobMeas blobMeas = blobMeasList2.getNearestBlob((int)(d9 / (double)n), (int)(d10 / (double)n));
        float f = blobMeas.centre.x;
        float f4 = blobMeas.centre.y;
        System.out.println("Central blob at (" + f + ", " + f4 + ")");
        d2 = f;
        d = f4;
        int n5 = 0;
        int n6 = 0;
        while (d2 >= d7) {
            d2 -= d7;
            ++n5;
        }
        while (d >= d7) {
            d -= d7;
            ++n6;
        }
        n5 = 2 * n5 + 1;
        n6 = 2 * n6 + 1;
        double d13 = d7 * StrictMath.cos(d12);
        double d14 = d7 * StrictMath.sin(d12);
        System.out.println("(x0, y0) = (" + d2 + ", " + d + ")");
        System.out.println("(dxGrid, dyGrid) = (" + d13 + ", " + d14 + ")");
        System.out.println("nx x ny = " + n5 + " x " + n6);
        for (int i = 0; i < n6; ++i) {
            for (int j = 0; j < n5; ++j) {
                double d15 = d2 + (double)j * d13 + (double)i * d14;
                double d16 = d - (double)j * d14 + (double)i * d13;
                BlobMeas blobMeas4 = blobMeasList2.getNearestBlob((int)d15, (int)d16);
                PointFloat pointFloat = blobMeas4.centre;
                PointFloat pointFloat2 = new PointFloat((float)d15, (float)d16);
                this.points.add(new WarpingPair(pointFloat, pointFloat2));
            }
        }
        return true;
    }

    public WarpingGrid load() {
        String string = FileIO.selectInputFile("Load .warp file");
        if (string == null) {
            return null;
        }
        return this.load(string);
    }

    public WarpingGrid load(String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            this.points = new ArrayList<WarpingPair>();
            while (null != (string2 = bufferedReader.readLine())) {
                String[] stringArray = string2.split(",");
                if (stringArray.length >= 4) {
                    this.points.add(new WarpingPair(new PointFloat(Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1])), new PointFloat(Float.parseFloat(stringArray[2]), Float.parseFloat(stringArray[3]))));
                    continue;
                }
                throw new IOException("Less than 4 commas in a row of file\n" + string);
            }
            bufferedReader.close();
            return this;
        }
        catch (IOException iOException) {
            Util.warning("Error: ", iOException.toString());
        }
        catch (NumberFormatException numberFormatException) {
            Util.warning("Error", "Invalid float values in file\n{0}", string);
        }
        return null;
    }

    public void save() {
        String string = FileIO.selectOutputFile("Create .warp file", null, null, "grid.warp");
        if (string != null) {
            this.save(string);
        }
    }

    public void save(String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            for (WarpingPair warpingPair : this.getPoints()) {
                printWriter.println(warpingPair.fromPoint.x + "," + warpingPair.fromPoint.y + "," + warpingPair.toPoint.x + "," + warpingPair.toPoint.y + ",");
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            Util.warning("Error", iOException.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (WarpingPair warpingPair : this.points) {
            stringBuffer.append("(");
            stringBuffer.append(warpingPair.fromPoint.x);
            stringBuffer.append(", ");
            stringBuffer.append(warpingPair.fromPoint.y);
            stringBuffer.append(") -> (");
            stringBuffer.append(warpingPair.toPoint.x);
            stringBuffer.append(", ");
            stringBuffer.append(warpingPair.toPoint.y);
            stringBuffer.append(")\n");
        }
        return stringBuffer.toString();
    }

    public void use(Image image) {
        int n;
        int n2;
        int n3;
        int n4 = this.points.size();
        PointFloat[] pointFloatArray = new PointFloat[n4];
        PointFloat[] pointFloatArray2 = new PointFloat[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            WarpingPair warpingPair = this.points.get(n3);
            pointFloatArray[n3] = warpingPair.fromPoint;
            pointFloatArray2[n3] = warpingPair.toPoint;
        }
        n3 = image.getWidth();
        Image image2 = ImageBase.createImage(n3, n2 = image.getHeight(), n = image.getNBands(), image.getBitsPerChannel());
        if (null != image2) {
            Warp.warp(image, pointFloatArray, image2, pointFloatArray2);
        }
    }

    public static WarpingGrid make(ImFrame imFrame) {
        WarpingGrid warpingGrid = null;
        Image image = imFrame.getImPane().getImage();
        int n = image.getNBands();
        int n2 = image.getRange().high;
        int n3 = n2 / 2;
        byte[][] byArray = null;
        try {
            Histogram histogram = new Histogram(image);
            if (null != histogram) {
                Statistics[] statisticsArray = histogram.getStatistics(0, n2);
                double d = 0.0;
                for (int i = 0; i < n; ++i) {
                    d += statisticsArray[i].mean;
                }
                if (d > (double)(n * n3)) {
                    imFrame.invert();
                }
                if (Util.confirm("Confirm", "Is this an image of a square array of\nbright dots on a uniform dark background?")) {
                    Threshold threshold = new Threshold(n);
                    for (int i = 0; i < n; ++i) {
                        threshold.th[i].low = n3;
                        threshold.th[i].high = n2;
                    }
                    Util.logInfo("Auto-threshold levels: {0}", threshold.toString());
                    imFrame.threshold(threshold);
                    if (!Util.confirm("Confirm", "Dots detected correctly (in green)?")) {
                        threshold = imFrame.threshold();
                    }
                    if (null != threshold) {
                        BlobMeasList blobMeasList = imFrame.detectBlobs();
                        if (null == blobMeasList || 0 == blobMeasList.size()) {
                            Util.warning("Sorry", "No dots detected.\nTry again with different threshold setting.");
                        } else {
                            warpingGrid = new WarpingGrid();
                            if (warpingGrid.make(blobMeasList)) {
                                warpingGrid.save();
                            }
                        }
                    }
                }
            }
        }
        catch (ArithmeticException arithmeticException) {
            Util.warning("Sorry", "You cannot do automatic thresholding on this kind of image");
        }
        return warpingGrid;
    }

    public static WarpingGrid use(ImFrame imFrame) {
        WarpingGrid warpingGrid = new WarpingGrid().load();
        if (null != warpingGrid) {
            imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
            warpingGrid.use(imFrame.getImPane().getImage());
            imFrame.redisplay();
            imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        }
        return warpingGrid;
    }
}

