/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.image;

import java.awt.Color;
import java.awt.Point;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.ProgressMonitor;
import net.grelf.Gaussian;
import net.grelf.Interpolator;
import net.grelf.Statistics;
import net.grelf.Util;
import net.grelf.astro.JulianDate;
import net.grelf.image.ByteMask;
import net.grelf.image.Calibration;
import net.grelf.image.FITS;
import net.grelf.image.FITS_KeywordRecord;
import net.grelf.image.HistogramAll;
import net.grelf.image.Image;
import net.grelf.image.Image16;
import net.grelf.image.Image64;
import net.grelf.image.Image8;
import net.grelf.image.Image8or16Base;
import net.grelf.image.ImageBase;
import net.grelf.image.IncompatibleImageException;
import net.grelf.image.Kernel;
import net.grelf.image.Metadata;
import net.grelf.image.RangeDouble;
import net.grelf.image.RangeInt;
import net.grelf.image.Threshold;
import net.grelf.image.Timer;

public class Image32
extends ImageBase
implements Image,
Cloneable {
    protected int[][] data;
    private int width;
    private int height;
    private int widthTimesHeight;
    private int[] zeroPxInt;
    private double[] zeroPxDouble;
    private RangeInt extremes = new RangeInt(0, 255);
    private static final String GRIP_V = "GRIP v";
    private static final String WIDTH_PX_EQ = "width(px)=";
    private static final String HEIGHT_PX_EQ = "height(px)=";
    private static final String CHANNELS_EQ = "channels=";
    private static final String BPCH_EQ = "bitsPerChannel=";
    private static final String MIN_EQ = "minValue=";
    private static final String MAX_EQ = "maxValue=";
    private static final short TIFF_ASCII = 2;
    private static final short TIFF_SHORT = 3;
    private static final short TIFF_LONG = 4;
    private static final short TIFF_RATIONAL = 5;
    private static final short TIFF_UNDEFINED = 7;

    @Override
    public int getWidth() {
        if (null == this.data) {
            return 0;
        }
        return this.width;
    }

    @Override
    public int getHeight() {
        if (null == this.data) {
            return 0;
        }
        return this.height;
    }

    @Override
    public String getImageTypeAsString() {
        return "32 bits (integer) per channel";
    }

    @Override
    public int getNBands() {
        if (null == this.data) {
            return 0;
        }
        return this.data.length;
    }

    @Override
    public int getBitsPerChannel() {
        return 32;
    }

    @Override
    public RangeInt getRange() {
        return this.extremes;
    }

    protected void setRange(RangeInt rangeInt) {
        this.extremes = rangeInt;
    }

    @Override
    public RangeDouble getRangeDouble() {
        return new RangeDouble(this.extremes.low, this.extremes.high);
    }

    @Override
    public RangeInt getRangeByRescanning() {
        int n;
        int n2;
        if (null == this.data) {
            return null;
        }
        Timer timer = new Timer("Image32.getRangeByRescanning", this);
        int n3 = n2 = (n = this.data[0][0]);
        for (int i = 0; i < this.getNBands(); ++i) {
            for (int j = 0; j < this.widthTimesHeight; ++j) {
                n = this.data[i][j];
                if (n < n2) {
                    n2 = n;
                    continue;
                }
                if (n <= n3) continue;
                n3 = n;
            }
        }
        if (n2 == n3) {
            ++n3;
        }
        this.extremes = new RangeInt(n2, n3);
        timer.stop();
        return this.extremes;
    }

    @Override
    public RangeDouble getRangeByRescanningDouble() {
        this.getRangeByRescanning();
        return this.getRangeDouble();
    }

    @Override
    public RangeInt[] getChannelRanges() {
        int n;
        Timer timer = new Timer("Image32.getChannelRanges ()", this);
        int n2 = this.getNBands();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = nArray2[i] = this.data[i][0];
            for (n = 0; n < this.widthTimesHeight; ++n) {
                int n3 = this.data[i][n];
                if (n3 < nArray[i]) {
                    nArray[i] = n3;
                    continue;
                }
                if (n3 <= nArray2[i]) continue;
                nArray2[i] = n3;
            }
        }
        RangeInt[] rangeIntArray = new RangeInt[n2];
        for (n = 0; n < n2; ++n) {
            rangeIntArray[n] = new RangeInt(nArray[n], nArray2[n]);
        }
        timer.stop();
        return rangeIntArray;
    }

    @Override
    public RangeDouble[] getChannelRangesDouble() {
        RangeInt[] rangeIntArray = this.getChannelRanges();
        int n = this.getNBands();
        RangeDouble[] rangeDoubleArray = new RangeDouble[n];
        for (int i = 0; i < n; ++i) {
            rangeDoubleArray[i] = new RangeDouble(rangeIntArray[i].low, rangeIntArray[i].high);
        }
        return rangeDoubleArray;
    }

    private int[][] createDataArray(int n, int n2, int n3) {
        if (n <= 0 || n2 <= 0 || n3 <= 0) {
            Util.warning("Error", "Cannot create an image " + n + "x" + n2 + "x" + n3 + "x32");
            return null;
        }
        long l = ((long)n * (long)n2 * 4L + 12L) * (long)n3 + 12L;
        long l2 = Runtime.getRuntime().freeMemory();
        if (l + 50000L < l2) {
            try {
                int n4 = n * n2;
                int[][] nArray = new int[n3][n4];
                if (null != nArray) {
                    this.width = n;
                    this.height = n2;
                    this.widthTimesHeight = n4;
                    this.zeroPxInt = new int[n3];
                    this.zeroPxDouble = new double[n3];
                    for (int i = 0; i < n3; ++i) {
                        this.zeroPxInt[i] = 0;
                        this.zeroPxDouble[i] = 0.0;
                    }
                }
                return nArray;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Cannot create image data array because it\nwould require ");
        stringBuffer.append(100L * (l + 50000L) / l2);
        stringBuffer.append("% of available memory.\n");
        stringBuffer.append("You might do one of the following:\n");
        stringBuffer.append(" - Geometry/Crop\n");
        stringBuffer.append(" - Geometry/Scale (down)\n");
        stringBuffer.append(" - Levels/Convert to 16 bits per channel\n");
        stringBuffer.append(" - Levels/Convert to monochrome\n");
        stringBuffer.append("and then try again.");
        Util.message("Not enough memory", stringBuffer.toString());
        return null;
    }

    public Image32(int n, int n2, int n3) {
        this(n, n2, n3, false);
    }

    public Image32(int n, int n2, int n3, boolean bl) {
        this.data = this.createDataArray(n, n2, n3);
        if (null != this.data) {
            this.setCalibration(new Calibration());
            this.setFilePath("New image");
            this.setMetadata(new Metadata());
            if (bl) {
                for (int i = 0; i < n3; ++i) {
                    int n4 = 0;
                    for (int j = 0; j < n2; ++j) {
                        int n5 = 0;
                        while (n5 < n) {
                            this.data[i][n4] = 0;
                            ++n5;
                            ++n4;
                        }
                    }
                }
                this.extremes = new RangeInt(0, 1);
            } else {
                this.extremes = new RangeInt(0, 255);
            }
        }
    }

    public Image32(BufferedImage bufferedImage) throws IncompatibleImageException {
        this.data = this.createDataArray(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getSampleModel().getNumBands());
        if (null != this.data) {
            this.set(bufferedImage);
        }
    }

    private Image32() {
    }

    public Image32(String string) {
        this();
        this.load(string);
    }

    protected void checkCompatibility(String string, BufferedImage bufferedImage) throws IncompatibleImageException {
        int n = bufferedImage.getSampleModel().getNumBands();
        if (this.getNBands() < n) {
            throw new IncompatibleImageException("Image has wrong number of bands (" + n + ") for " + string + " to Image32 (" + this.getNBands() + " bands)");
        }
    }

    @Override
    public void add(BufferedImage bufferedImage) throws IncompatibleImageException {
        int n;
        int n2;
        this.checkCompatibility("add", bufferedImage);
        Timer timer = new Timer("Image32.add ()", this);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n3 = this.getNBands();
        int[] nArray = new int[n3];
        int n4 = StrictMath.min(this.getWidth(), bufferedImage.getWidth());
        int n5 = StrictMath.min(this.getHeight(), bufferedImage.getHeight());
        writableRaster.getPixel(0, 0, nArray);
        int n6 = n2 = (n = this.data[0][0] + nArray[0]);
        int n7 = 0;
        for (int i = 0; i < n5; ++i) {
            int n8 = 0;
            while (n8 < n4) {
                writableRaster.getPixel(n8, i, nArray);
                for (int j = 0; j < n3; ++j) {
                    this.data[j][n7] = n = this.data[j][n7] + nArray[j];
                    if (n < n2) {
                        n2 = n;
                        continue;
                    }
                    if (n <= n6) continue;
                    n6 = n;
                }
                ++n8;
                ++n7;
            }
        }
        if (n2 == n6) {
            ++n6;
        }
        this.extremes = new RangeInt(n2, n6);
        timer.stop();
    }

    @Override
    public void add(Image image) throws IncompatibleImageException {
        if (image instanceof Image32) {
            this.add((Image32)image);
        } else if (image.getBitsPerChannel() < 32) {
            this.add(((Image8or16Base)image).getBufferedImage());
        } else {
            throw new IncompatibleImageException("Cannot add double-valued image into integer-valued one");
        }
    }

    @Override
    public void addProportion(Image image, double d, double d2) throws IncompatibleImageException {
        int n;
        int n2;
        Timer timer;
        if (image instanceof Image32) {
            int n3;
            timer = new Timer("Image32.add (f1, f2)", this);
            int n4 = this.getNBands();
            int[] nArray = new int[n4];
            int n5 = StrictMath.min(this.getWidth(), image.getWidth());
            int n6 = StrictMath.min(this.getHeight(), image.getHeight());
            nArray = image.getPixel(0, 0);
            n = n2 = (n3 = this.data[0][0] + nArray[0]);
            int n7 = 0;
            for (int i = 0; i < n6; ++i) {
                int n8 = 0;
                while (n8 < n5) {
                    nArray = image.getPixel(n8, i);
                    for (int j = 0; j < n4; ++j) {
                        this.data[j][n7] = (int)((double)this.data[j][n7] * d + (double)nArray[j] * d2);
                        n3 = this.data[j][n7];
                        if (n3 < n2) {
                            n2 = n3;
                            continue;
                        }
                        if (n3 <= n) continue;
                        n = n3;
                    }
                    ++n8;
                    ++n7;
                }
            }
            if (n2 == n) {
                ++n;
            }
        } else {
            throw new IncompatibleImageException("Cannot add proportions of images with different bit depths");
        }
        this.extremes = new RangeInt(n2, n);
        timer.stop();
    }

    public void add(Image32 image32) throws IncompatibleImageException {
        int n;
        int n2;
        Timer timer = new Timer("Image32.add ()", this);
        int n3 = this.getNBands();
        int[] nArray = new int[n3];
        int n4 = StrictMath.min(this.getWidth(), image32.getWidth());
        int n5 = StrictMath.min(this.getHeight(), image32.getHeight());
        nArray = image32.getPixel(0, 0);
        int n6 = n2 = (n = this.data[0][0] + nArray[0]);
        int n7 = 0;
        for (int i = 0; i < n5; ++i) {
            int n8 = 0;
            while (n8 < n4) {
                nArray = image32.getPixel(n8, i);
                for (int j = 0; j < n3; ++j) {
                    int[] nArray2 = this.data[j];
                    int n9 = n7;
                    nArray2[n9] = nArray2[n9] + nArray[j];
                    n = this.data[j][n7];
                    if (n < n2) {
                        n2 = n;
                        continue;
                    }
                    if (n <= n6) continue;
                    n6 = n;
                }
                ++n8;
                ++n7;
            }
        }
        if (n2 == n6) {
            ++n6;
        }
        this.extremes = new RangeInt(n2, n6);
        timer.stop();
    }

    public void add(Image32 image32, double d, double d2) throws IncompatibleImageException {
        int n;
        int n2;
        Timer timer = new Timer("Image32.add ()", this);
        int n3 = this.getNBands();
        int[] nArray = new int[n3];
        int n4 = StrictMath.min(this.getWidth(), image32.getWidth());
        int n5 = StrictMath.min(this.getHeight(), image32.getHeight());
        nArray = image32.getPixel(0, 0);
        int n6 = n2 = (n = (int)(d * (double)this.data[0][0] + d2 * (double)nArray[0]));
        int n7 = 0;
        for (int i = 0; i < n5; ++i) {
            int n8 = 0;
            while (n8 < n4) {
                nArray = image32.getPixel(n8, i);
                for (int j = 0; j < n3; ++j) {
                    this.data[j][n7] = n = (int)(d * (double)this.data[j][n7] + d2 * (double)nArray[j]);
                    if (n < n2) {
                        n2 = n;
                        continue;
                    }
                    if (n <= n6) continue;
                    n6 = n;
                }
                ++n8;
                ++n7;
            }
        }
        if (n2 == n6) {
            ++n6;
        }
        this.extremes = new RangeInt(n2, n6);
        timer.stop();
    }

    @Override
    public void addTranslated(BufferedImage bufferedImage, int n, int n2) throws IncompatibleImageException {
        int n3;
        int n4;
        this.checkCompatibility("add", bufferedImage);
        Timer timer = new Timer("Image32.add ()", this);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n5 = this.getNBands();
        int[] nArray = new int[n5];
        int n6 = bufferedImage.getWidth();
        int n7 = bufferedImage.getHeight();
        int n8 = this.width;
        int n9 = this.height;
        int n10 = n2 < 0 ? -n2 : 0;
        int n11 = n < 0 ? -n : 0;
        writableRaster.getPixel(n11, n10, nArray);
        int n12 = n4 = (n3 = this.data[0][0] + nArray[0]);
        int n13 = 0;
        for (int i = n10 + n2; n10 < n7 && i < n9; ++n10, ++i) {
            n11 = n < 0 ? -n : 0;
            for (int j = n11 + n; n11 < n6 && j < n8; ++n11, ++j) {
                writableRaster.getPixel(n11, n10, nArray);
                for (int k = 0; k < n5; ++k) {
                    n13 = i * this.width + j;
                    int[] nArray2 = this.data[k];
                    int n14 = n13;
                    nArray2[n14] = nArray2[n14] + nArray[k];
                    n3 = this.data[k][n13];
                    if (n3 < n4) {
                        n4 = n3;
                        continue;
                    }
                    if (n3 <= n12) continue;
                    n12 = n3;
                }
            }
        }
        if (n4 == n12) {
            ++n12;
        }
        this.extremes = new RangeInt(n4, n12);
        timer.stop();
    }

    @Override
    public void addTranslated(BufferedImage bufferedImage, double d, double d2) throws IncompatibleImageException {
        int n;
        int n2;
        int n3;
        this.checkCompatibility("add", bufferedImage);
        Timer timer = new Timer("Image32.add ()", this);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n4 = this.getNBands();
        int[] nArray = new int[n4];
        double d3 = bufferedImage.getWidth();
        double d4 = bufferedImage.getHeight();
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        double d5 = d2 < 0.0 ? -d2 : 0.0;
        double d6 = d < 0.0 ? -d : 0.0;
        nArray = Interpolator.getPixel(writableRaster, d6, d5);
        int n7 = n3 = (n2 = this.data[0][0] + nArray[0]);
        int n8 = 0;
        for (int i = n = (int)StrictMath.round(d5 + d2); d5 < d4 && i < n6; d5 += 1.0, ++i) {
            int n9;
            d6 = d < 0.0 ? -d : 0.0;
            for (int j = n9 = (int)StrictMath.round(d6 + d); d6 < d3 && j < n5; d6 += 1.0, ++j) {
                nArray = Interpolator.getPixel(writableRaster, d6, d5);
                for (int k = 0; k < n4; ++k) {
                    n8 = j + this.width * i;
                    int[] nArray2 = this.data[k];
                    int n10 = n8;
                    nArray2[n10] = nArray2[n10] + nArray[k];
                    n2 = this.data[k][n8];
                    if (n2 < n3) {
                        n3 = n2;
                        continue;
                    }
                    if (n2 <= n7) continue;
                    n7 = n2;
                }
            }
        }
        if (n3 == n7) {
            ++n7;
        }
        this.extremes = new RangeInt(n3, n7);
        timer.stop();
    }

    @Override
    public void applyCurve(RangeInt rangeInt, List<Point> list, BufferedImage bufferedImage) throws IncompatibleImageException {
        if (1 < list.size()) {
            int n;
            int n2;
            int n3;
            Timer timer = new Timer("Image32.applyCurve ()", this);
            int n4 = this.getNBands();
            WritableRaster writableRaster = null;
            int n5 = this.getRange().high;
            if (null != bufferedImage) {
                if (Image8or16Base.getNBands(bufferedImage) != n4) {
                    throw new IncompatibleImageException("Target image does not have same number of channels as Image32");
                }
                writableRaster = bufferedImage.getRaster();
                n3 = Image8or16Base.getMaxLevel(bufferedImage);
            } else {
                n3 = this.getRange().high;
            }
            int[] nArray = new int[n5 + 1];
            double d = (double)n5 / 255.0;
            double d2 = (double)n3 / 255.0;
            Point point = list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                Point point2 = list.get(i);
                double d3 = (double)point.y * d2;
                double d4 = d * (double)(point2.x - point.x);
                if (d4 > 0.0) {
                    double d5 = d2 * (double)(point2.y - point.y) / d4;
                    int n6 = (int)((double)point.x * d);
                    while (n6 <= (int)((double)point2.x * d) && n6 < nArray.length) {
                        nArray[n6] = (int)d3;
                        ++n6;
                        d3 += d5;
                    }
                }
                point = point2;
            }
            int[] nArray2 = new int[n4];
            int n7 = n2 = (n = nArray[this.data[0][0]]);
            int n8 = 0;
            for (int i = 0; i < this.getHeight(); ++i) {
                int n9 = 0;
                while (n9 < this.getWidth()) {
                    int n10;
                    if (null != bufferedImage) {
                        for (n10 = 0; n10 < n4; ++n10) {
                            nArray2[n10] = nArray[this.data[n10][n8]];
                        }
                        writableRaster.setPixel(n9, i, nArray2);
                    } else {
                        for (n10 = 0; n10 < n4; ++n10) {
                            this.data[n10][n8] = n = nArray[this.data[n10][n8]];
                            if (n < n2) {
                                n2 = n;
                                continue;
                            }
                            if (n <= n7) continue;
                            n7 = n;
                        }
                    }
                    ++n9;
                    ++n8;
                }
            }
            if (null == bufferedImage) {
                if (n2 == n7) {
                    ++n7;
                }
                this.extremes = new RangeInt(n2, n7);
            }
            timer.stop();
        }
    }

    @Override
    public void autoCrop() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Timer timer = new Timer("Image32.autoCrop", this);
        int n6 = this.getWidth();
        int n7 = this.getHeight();
        int n8 = this.getNBands();
        Point point = new Point(0, 0);
        Point point2 = new Point(n6 - 1, n7 - 1);
        boolean bl = false;
        for (n5 = 0; n5 < n7 && !bl; ++n5) {
            n4 = this.width * n5;
            block1: for (n3 = 0; n3 < n6 && !bl; ++n3) {
                n2 = n3 + n4;
                for (n = 0; n < n8; ++n) {
                    if (0 == this.data[n][n2]) continue;
                    bl = true;
                    point.y = n5;
                    continue block1;
                }
            }
        }
        bl = false;
        for (n5 = n7 - 1; n5 >= 0 && !bl; --n5) {
            n4 = this.width * n5;
            block4: for (n3 = 0; n3 < n6 && !bl; ++n3) {
                n2 = n3 + n4;
                for (n = 0; n < n8; ++n) {
                    if (0 == this.data[n][n2]) continue;
                    bl = true;
                    point2.y = n5;
                    continue block4;
                }
            }
        }
        bl = false;
        for (n5 = 0; n5 < n6 && !bl; ++n5) {
            block7: for (n3 = 0; n3 < n7 && !bl; ++n3) {
                n2 = n5 + this.width * n3;
                for (n = 0; n < n8; ++n) {
                    if (0 == this.data[n][n2]) continue;
                    bl = true;
                    point.x = n5;
                    continue block7;
                }
            }
        }
        bl = false;
        for (n5 = n6 - 1; n5 >= 0 && !bl; --n5) {
            block10: for (n3 = 0; n3 < n7 && !bl; ++n3) {
                n2 = n5 + this.width * n3;
                for (n = 0; n < n8; ++n) {
                    if (0 == this.data[n][n2]) continue;
                    bl = true;
                    point2.x = n5;
                    continue block10;
                }
            }
        }
        this.crop(point, point2);
        timer.stop();
    }

    @Override
    public void autoStretch(boolean bl) {
        this.autoStretch(bl, new Point(0, 0), new Point(this.getWidth() - 1, this.getHeight() - 1));
    }

    @Override
    public void autoStretch(boolean bl, Point point, Point point2) {
        Timer timer = new Timer("Image32.autoStretch", this);
        int n = this.getNBands();
        int[] nArray = new int[n];
        int n2 = this.getRange().high;
        if (bl) {
            int n3 = this.getRange().low;
            int n4 = this.getRange().high;
            float f = (float)n2 / (float)(n4 - n3);
            for (int i = point.y; i <= point2.y; ++i) {
                for (int j = point.x; j <= point2.x; ++j) {
                    nArray = this.getPixel(j, i);
                    for (int k = 0; k < n; ++k) {
                        nArray[k] = (int)((float)(nArray[k] - n3) * f);
                    }
                    this.setPixel(j, i, nArray);
                }
            }
        } else {
            int n5;
            int n6;
            int n7;
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n];
            for (n7 = 0; n7 < n; ++n7) {
                nArray2[n7] = n2;
                nArray3[n7] = 0;
            }
            for (n7 = point.y; n7 <= point2.y; ++n7) {
                for (n6 = point.x; n6 <= point2.x; ++n6) {
                    nArray = this.getPixel(n6, n7);
                    for (n5 = 0; n5 < n; ++n5) {
                        if (nArray[n5] > nArray3[n5]) {
                            nArray3[n5] = nArray[n5];
                            continue;
                        }
                        if (nArray[n5] >= nArray2[n5]) continue;
                        nArray2[n5] = nArray[n5];
                    }
                }
            }
            float[] fArray = new float[n];
            for (n6 = 0; n6 < n; ++n6) {
                fArray[n6] = (float)n2 / (float)(nArray3[n6] - nArray2[n6]);
            }
            for (n6 = point.y; n6 <= point2.y; ++n6) {
                for (n5 = point.x; n5 <= point2.x; ++n5) {
                    nArray = this.getPixel(n5, n6);
                    for (int i = 0; i < n; ++i) {
                        nArray[i] = (int)((float)(nArray[i] - nArray2[i]) * fArray[i]);
                    }
                    this.setPixel(n5, n6, nArray);
                }
            }
        }
        timer.stop();
    }

    @Override
    public ByteMask autoThreshold() {
        Timer timer = new Timer("Image32.autoThreshold", this);
        int n = this.getNBands();
        int n2 = this.extremes.high;
        int n3 = n2 / 2;
        ByteMask byteMask = null;
        try {
            Statistics[] statisticsArray = new HistogramAll(this).getStatistics(0, n2);
            Threshold threshold = new Threshold(n);
            for (int i = 0; i < n; ++i) {
                if (statisticsArray[i].mean < (double)n3) {
                    threshold.th[i].low = n3;
                    threshold.th[i].high = n2;
                    continue;
                }
                threshold.th[i].low = 0;
                threshold.th[i].high = n3;
            }
            Util.logInfo("Auto-threshold levels: {0}", threshold.toString());
            byteMask = this.threshold(threshold);
        }
        catch (ArithmeticException arithmeticException) {
            Util.warning("Sorry", "You cannot do automatic thresholding on this kind of image");
        }
        timer.stop();
        return byteMask;
    }

    @Override
    public void averageVertically() {
        this.averageVertically(0, this.height - 1);
    }

    @Override
    public void averageVertically(int n, int n2) {
        Timer timer = new Timer("Image32.averageVertically", this);
        int n3 = this.width;
        int n4 = n2 - n + 1;
        int n5 = this.getNBands();
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n5];
        for (int i = 0; i < n3; ++i) {
            int n6;
            for (n6 = 0; n6 < n5; ++n6) {
                nArray2[n6] = 0;
            }
            for (n6 = n; n6 <= n2; ++n6) {
                nArray = this.getPixel(i, n6);
                for (int j = 0; j < n5; ++j) {
                    int n7 = j;
                    nArray2[n7] = nArray2[n7] + nArray[j];
                }
            }
            n6 = 0;
            while (n6 < n5) {
                int n8 = n6++;
                nArray2[n8] = nArray2[n8] / n4;
            }
            for (n6 = n; n6 <= n2; ++n6) {
                this.setPixel(i, n6, nArray2);
            }
        }
        timer.stop();
    }

    @Override
    public void blurGaussian(int n, int n2, ProgressMonitor progressMonitor) {
        double d = this.getRange().high;
        double[] dArray = Gaussian.getProfileAsArray(n, d);
        double[] dArray2 = Gaussian.getProfileAsArray(n2, d);
        this.convolve(dArray, dArray2, progressMonitor);
    }

    @Override
    public Image clone() {
        int n;
        int n2;
        int n3 = this.getWidth();
        Image32 image32 = new Image32(n3, n2 = this.getHeight(), n = this.getNBands());
        if (null != image32 && null != image32.data) {
            for (int i = 0; i < n; ++i) {
                int n4 = 0;
                for (int j = 0; j < n2; ++j) {
                    int n5 = 0;
                    while (n5 < n3) {
                        image32.data[i][n4] = this.data[i][n4];
                        ++n5;
                        ++n4;
                    }
                }
            }
            image32.extremes = new RangeInt(this.extremes.low, this.extremes.high);
            return image32;
        }
        return null;
    }

    @Override
    public Image8 convertToImage8() {
        return this.convertToImage16().convertToImage8();
    }

    @Override
    public Image16 convertToImage16() {
        Timer timer = new Timer("Image32.convertToImage16", this);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getNBands();
        Image16 image16 = new Image16(n, n2, n3);
        int[] nArray = new int[n3];
        double d = 65535.0 / (double)this.getRange().high;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = 0;
            while (n5 < n) {
                for (int j = 0; j < n3; ++j) {
                    nArray[j] = (int)((double)this.data[j][n4] * d);
                }
                image16.setPixel(n5, i, nArray);
                ++n5;
                ++n4;
            }
        }
        image16.setCalibration(this.getCalibration());
        image16.setFilePath(this.getFilePath());
        image16.setMetadata(this.getMetadata());
        timer.stop();
        return image16;
    }

    @Override
    public Image32 convertToImage32() {
        return this;
    }

    @Override
    public Image64 convertToImage64() {
        int n;
        int n2;
        int n3 = this.getWidth();
        Image64 image64 = new Image64(n3, n2 = this.getHeight(), n = this.getNBands());
        if (null != image64) {
            Timer timer = new Timer("Image32.convertToImage64", this);
            double[] dArray = new double[n];
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                int n5 = 0;
                while (n5 < n3) {
                    for (int j = 0; j < n; ++j) {
                        dArray[j] = this.data[j][n4];
                    }
                    image64.setPixelDouble(n5, i, dArray);
                    ++n5;
                    ++n4;
                }
            }
            image64.setRangeDouble(new RangeDouble(this.extremes.low, this.extremes.high));
            image64.setMetadata(this.metadata);
            image64.setCalibration(this.getCalibration());
            image64.setFilePath(this.getFilePath());
            image64.setMetadata(this.getMetadata());
            timer.stop();
        }
        return image64;
    }

    @Override
    public void convertToMonochrome() {
        this.convertToMonochrome(0.325, 0.5, 0.175);
    }

    @Override
    public void convertToMonochrome(double ... dArray) {
        int n = this.getNBands();
        if (n < dArray.length) {
            Util.warning("Error", "Number of factors does not equal number of image bands.");
        } else {
            int n2;
            int n3 = this.getWidth();
            int[][] nArray = this.createDataArray(n3, n2 = this.getHeight(), 1);
            if (null != nArray) {
                int n4;
                int n5;
                Timer timer = new Timer("Image32.convertToMonochrome", this);
                double d = 0.0;
                double d2 = 0.0;
                for (int i = 0; i < n; ++i) {
                    d += dArray[i];
                    d2 += dArray[i] * (double)this.data[i][0];
                }
                double d3 = 1.0 / d;
                int n6 = n5 = (n4 = (int)(d2 * d3));
                int n7 = 0;
                for (int i = 0; i < n2; ++i) {
                    int n8 = 0;
                    while (n8 < n3) {
                        d2 = 0.0;
                        for (int j = 0; j < n; ++j) {
                            d2 += dArray[j] * (double)this.data[j][n7];
                        }
                        nArray[0][n7] = n4 = (int)(d2 * d3);
                        if (n4 < n5) {
                            n5 = n4;
                        } else if (n4 > n6) {
                            n6 = n4;
                        }
                        ++n8;
                        ++n7;
                    }
                }
                this.data = nArray;
                if (n5 == n6) {
                    ++n6;
                }
                this.extremes = new RangeInt(n5, n6);
                timer.stop();
            }
        }
    }

    @Override
    public void convolve(Kernel kernel, ProgressMonitor progressMonitor) {
        int n;
        int n2;
        int n3 = this.getWidth();
        int[][] nArray = this.createDataArray(n3, n2 = this.getHeight(), n = this.getNBands());
        if (null != nArray) {
            int n4;
            int n5;
            Timer timer = new Timer("Image32.convolve", this);
            int n6 = 2 * kernel.getHalfWidth() + 1;
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = 0.0;
            }
            float[][] fArray = kernel.getData();
            float[][] fArray2 = new float[n][fArray[0].length];
            if (fArray2.length == 1) {
                for (n5 = 0; n5 < n; ++n5) {
                    for (n4 = 0; n4 < fArray2[0].length; ++n4) {
                        fArray2[n5][n4] = fArray[0][n4];
                    }
                }
            } else {
                fArray2 = fArray;
            }
            if (null != progressMonitor) {
                progressMonitor.setMaximum(n * n2);
            }
            n4 = n5 = this.data[0][0];
            int n7 = n5;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < fArray2[i].length; ++j) {
                    int n8 = i;
                    dArray[n8] = dArray[n8] + (double)fArray2[i][j];
                }
                dArray2[i] = dArray[i] != 0.0 ? 1.0 / dArray[i] : 1.0;
                int n9 = 0;
                int n10 = kernel.getHalfWidth();
                while (n9 < n2 - n6) {
                    if (null != progressMonitor) {
                        progressMonitor.setProgress(i * n2 + n9);
                        if (progressMonitor.isCanceled()) {
                            progressMonitor.close();
                            return;
                        }
                    }
                    int n11 = 0;
                    int n12 = kernel.getHalfWidth();
                    int n13 = n10 * n3 + n12;
                    while (n11 < n3 - n6) {
                        double d = 0.0;
                        int n14 = 0;
                        for (int j = n9; j < n9 + n6; ++j) {
                            int n15 = n11;
                            int n16 = j * n3 + n11;
                            while (n15 < n11 + n6) {
                                d += (double)this.data[i][n16] * (double)fArray2[i][n14];
                                ++n15;
                                ++n14;
                                ++n16;
                            }
                        }
                        nArray[i][n13] = n5 = (int)(d * dArray2[i]);
                        if (n5 < n4) {
                            n4 = n5;
                        } else if (n5 > n7) {
                            n7 = n5;
                        }
                        ++n11;
                        ++n12;
                        ++n13;
                    }
                    ++n9;
                    ++n10;
                }
            }
            if (n4 == n7) {
                ++n7;
            }
            this.extremes = new RangeInt(n4, n7);
            if (null != progressMonitor) {
                progressMonitor.close();
            }
            this.data = nArray;
            timer.stop();
        }
    }

    @Override
    public void convolve(double[] dArray, double[] dArray2, ProgressMonitor progressMonitor) {
        int n;
        int n2;
        double d;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int[] nArray;
        int[] nArray2;
        double d2;
        int n8;
        int n9;
        Timer timer = new Timer("Image32.convolve", this);
        int n10 = this.getRange().high;
        int n11 = this.getNBands();
        int n12 = this.getWidth();
        int n13 = n12 - 1;
        int n14 = this.getHeight();
        int n15 = (n14 - 1) * n12;
        int n16 = 0;
        if (null != progressMonitor) {
            int n17 = 0;
            if (null != dArray) {
                n17 += n14;
            }
            if (null != dArray2) {
                n17 += n12;
            }
            progressMonitor.setMaximum(n17);
        }
        if (null != dArray) {
            int[][] nArray3 = this.createDataArray(n12, n14, n11);
            if (null == nArray3) {
                return;
            }
            n9 = dArray.length;
            n8 = n9 / 2;
            d2 = 0.0;
            for (int i = 0; i < n9; ++i) {
                d2 += dArray[i];
            }
            double d3 = 1.0 / d2;
            nArray2 = new int[n11];
            nArray = new int[n11];
            for (n7 = 0; n7 < n14; ++n7) {
                if (null != progressMonitor) {
                    progressMonitor.setProgress(++n16);
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.close();
                        return;
                    }
                }
                for (n6 = 0; n6 < n11; ++n6) {
                    n5 = n7 * n12;
                    nArray2[n6] = this.data[n6][n5];
                    nArray[n6] = this.data[n6][n5 + n13];
                }
                n6 = 0;
                n5 = n7 * n12;
                n4 = n5 - n8;
                while (n6 < n12) {
                    for (n3 = 0; n3 < n11; ++n3) {
                        d = 0.0;
                        n2 = n6 - n8;
                        for (n = 0; n < n9; ++n) {
                            d = n2 < 0 ? (d += (double)nArray2[n3] * dArray[n]) : (n2 >= n12 ? (d += (double)nArray[n3] * dArray[n]) : (d += (double)this.data[n3][n4 + n] * dArray[n]));
                            ++n2;
                        }
                        nArray3[n3][n5] = (d *= d3) > (double)n10 ? n10 : (d < 0.0 ? 0 : (int)d);
                    }
                    ++n6;
                    ++n4;
                    ++n5;
                }
            }
            this.data = nArray3;
        }
        if (null != dArray2) {
            int[][] nArray4 = this.createDataArray(n12, n14, n11);
            if (null == nArray4) {
                return;
            }
            n9 = dArray2.length;
            n8 = n9 / 2;
            d2 = 0.0;
            for (int i = 0; i < n9; ++i) {
                d2 += dArray2[i];
            }
            double d4 = 1.0 / d2;
            nArray2 = new int[n11];
            nArray = new int[n11];
            for (n7 = 0; n7 < n12; ++n7) {
                if (null != progressMonitor) {
                    progressMonitor.setProgress(++n16);
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.close();
                        return;
                    }
                }
                for (n6 = 0; n6 < n11; ++n6) {
                    n5 = n7;
                    nArray2[n6] = this.data[n6][n5];
                    nArray[n6] = this.data[n6][n5 + n15];
                }
                n6 = 0;
                n5 = n7;
                n4 = n5 - n8 * n12;
                while (n6 < n14) {
                    for (n3 = 0; n3 < n11; ++n3) {
                        d = 0.0;
                        n2 = n6 - n8;
                        n = 0;
                        int n18 = 0;
                        while (n < n9) {
                            d = n2 < 0 ? (d += (double)nArray2[n3] * dArray2[n]) : (n2 >= n14 ? (d += (double)nArray[n3] * dArray2[n]) : (d += (double)this.data[n3][n4 + n18] * dArray2[n]));
                            ++n2;
                            ++n;
                            n18 += n12;
                        }
                        nArray4[n3][n5] = (d *= d4) > (double)n10 ? n10 : (d < 0.0 ? 0 : (int)d);
                    }
                    ++n6;
                    n4 += n12;
                    n5 += n12;
                }
            }
            this.data = nArray4;
        }
        if (null != progressMonitor) {
            progressMonitor.close();
        }
        timer.stop();
        this.getRangeByRescanning();
    }

    @Override
    public void correctBackground(double d, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Timer timer = new Timer("Image32.correctBackground", this);
        int n9 = this.getWidth();
        int n10 = this.getHeight();
        int n11 = this.getNBands();
        int n12 = n9 / n;
        int n13 = n10 / n;
        int n14 = this.getRange().high + 1;
        int n15 = n12 / 2;
        int n16 = n13 / 2;
        int n17 = n9 / n12;
        int n18 = n10 / n13;
        int[] nArray = new int[n11];
        int[][][] nArray2 = new int[n17][n18][n11];
        int[][] nArray3 = new int[n14][n11];
        for (n8 = 0; n8 < n18; ++n8) {
            for (n7 = 0; n7 < n17; ++n7) {
                int n19;
                for (n6 = 0; n6 < n11; ++n6) {
                    for (n19 = 0; n19 < n14; ++n19) {
                        nArray3[n19][n6] = 0;
                    }
                }
                for (n6 = n8 * n13; n6 < (n8 + 1) * n13; ++n6) {
                    for (n19 = n7 * n12; n19 < (n7 + 1) * n12; ++n19) {
                        nArray = this.getPixel(n19, n6);
                        for (n5 = 0; n5 < n11; ++n5) {
                            n4 = nArray[n5];
                            if (0 > n4 || n4 >= n14) continue;
                            int[] nArray4 = nArray3[n4];
                            int n20 = n5;
                            nArray4[n20] = nArray4[n20] + 1;
                        }
                    }
                }
                for (n6 = 0; n6 < n11; ++n6) {
                    nArray2[n7][n8][n6] = 0;
                    n19 = nArray3[0][n6];
                    n5 = nArray3[0][n6];
                    n4 = 0;
                    n3 = 0;
                    for (n2 = 1; n2 < n14 - 1; ++n2) {
                        if (nArray3[n2][n6] <= n19) continue;
                        n19 = nArray3[n2][n6];
                        n4 = n2;
                    }
                    for (n2 = n14 - 2; n2 >= 0; --n2) {
                        if (nArray3[n2][n6] <= n5) continue;
                        n5 = nArray3[n2][n6];
                        n3 = n2;
                    }
                    nArray2[n7][n8][n6] = (n4 + n3) / 2;
                }
            }
        }
        for (n8 = 0; n8 < n18; ++n8) {
            for (n7 = 0; n7 < n17; ++n7) {
                for (n6 = 0; n6 < n11; ++n6) {
                    nArray2[n7][n8][n6] = (int)(d * (double)nArray2[n7][n8][n6]);
                }
            }
        }
        for (n3 = 0; n3 < n18; ++n3) {
            for (n2 = 0; n2 < n17; ++n2) {
                int n21 = n3 * n13;
                int n22 = 0;
                while (n21 < (n3 + 1) * n13) {
                    float f;
                    if (n22 < n16) {
                        f = (float)(n16 + n22) / (float)n13;
                        n4 = n3 - 1;
                    } else {
                        f = (float)(n22 - n16) / (float)n13;
                        n4 = n3;
                    }
                    float f2 = 1.0f - f;
                    int n23 = n2 * n12;
                    int n24 = 0;
                    while (n23 < (n2 + 1) * n12) {
                        float f3;
                        nArray = this.getPixel(n23, n21);
                        if (n24 < n15) {
                            f3 = (float)(n15 + n24) / (float)n12;
                            n5 = n2 - 1;
                        } else {
                            f3 = (float)(n24 - n15) / (float)n12;
                            n5 = n2;
                        }
                        float f4 = 1.0f - f3;
                        for (int i = 0; i < n11; ++i) {
                            if (n4 < 0 || n4 + 1 >= n18 || n5 < 0 || n5 + 1 >= n17) {
                                if (n4 < 0 || n4 + 1 >= n18) {
                                    if (n5 < 0 || n5 + 1 >= n17) {
                                        int n25 = i;
                                        nArray[n25] = nArray[n25] - nArray2[n2][n3][i];
                                    } else {
                                        int n26 = i;
                                        nArray[n26] = nArray[n26] - (int)(0.5f + f3 * (float)nArray2[n5 + 1][n3][i] + f4 * (float)nArray2[n5][n3][i]);
                                    }
                                } else if (n5 < 0 || n5 + 1 >= n17) {
                                    if (n4 < 0 || n4 + 1 >= n18) {
                                        int n27 = i;
                                        nArray[n27] = nArray[n27] - nArray2[n2][n3][i];
                                    } else {
                                        int n28 = i;
                                        nArray[n28] = nArray[n28] - (int)(0.5f + f * (float)nArray2[n2][n4 + 1][i] + f2 * (float)nArray2[n2][n4][i]);
                                    }
                                }
                            } else {
                                int n29 = i;
                                nArray[n29] = nArray[n29] - (int)(0.5f + f * (f3 * (float)nArray2[n5 + 1][n4 + 1][i] + f4 * (float)nArray2[n5][n4 + 1][i]) + f2 * (f3 * (float)nArray2[n5 + 1][n4][i] + f4 * (float)nArray2[n5][n4][i]));
                            }
                            if (nArray[i] >= 0) continue;
                            nArray[i] = 0;
                        }
                        this.setPixel(n23, n21, nArray);
                        ++n23;
                        ++n24;
                    }
                    ++n21;
                    ++n22;
                }
            }
        }
        timer.stop();
    }

    @Override
    public void crop(Point point, Point point2) {
        Point point3 = new Point(Math.min(point.x, point2.x), Math.min(point.y, point2.y));
        Point point4 = new Point(Math.max(point.x, point2.x), Math.max(point.y, point2.y));
        int n = point4.x - point3.x + 1;
        int n2 = point4.y - point3.y + 1;
        int n3 = n;
        int n4 = n2;
        int n5 = this.getNBands();
        int n6 = this.width;
        int[][] nArray = this.createDataArray(n3, n4, n5);
        if (null != nArray) {
            int n7;
            int n8;
            Timer timer = new Timer("Image32.crop", this);
            int n9 = n8 = (n7 = this.data[0][point3.x + n6 * point3.y]);
            int n10 = point3.y;
            for (int i = 0; i < n4; ++i) {
                int n11 = n6 * n10;
                int n12 = this.width * i;
                int n13 = point3.x;
                for (int j = 0; j < n3; ++j) {
                    int n14 = n13 + n11;
                    int n15 = j + n12;
                    for (int k = 0; k < n5; ++k) {
                        nArray[k][n15] = n7 = this.data[k][n14];
                        if (n7 < n8) {
                            n8 = n7;
                            continue;
                        }
                        if (n7 <= n9) continue;
                        n9 = n7;
                    }
                    ++n13;
                }
                ++n10;
            }
            this.data = nArray;
            if (n8 == n9) {
                ++n9;
            }
            this.extremes = new RangeInt(n8, n9);
            timer.stop();
        }
    }

    @Override
    public void deconvolve(Kernel kernel, int n, double d, ProgressMonitor progressMonitor) {
        int n2;
        int n3;
        int n4;
        Timer timer = new Timer("Image32.deconvolve", this);
        int n5 = this.getNBands();
        int n6 = this.getWidth();
        int n7 = this.getHeight();
        int[][] nArray = this.data;
        int[][] nArray2 = this.createDataArray(n6, n7, n5);
        if (null == nArray2) {
            return;
        }
        int[][] nArray3 = this.createDataArray(n6, n7, n5);
        if (null == nArray3) {
            return;
        }
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < this.widthTimesHeight; ++n3) {
                nArray2[n4][n3] = nArray[n4][n3];
            }
        }
        n4 = this.getRange().high;
        n3 = kernel.getHalfWidth();
        int n8 = 2 * n3 + 1;
        int n9 = n8 * n8;
        float[] fArray = new float[n5];
        for (int i = 0; i < n5; ++i) {
            fArray[i] = 0.0f;
        }
        float[][] fArray2 = kernel.getData();
        int n10 = 0;
        if (fArray2.length == n5) {
            n10 = 1;
        }
        int n11 = 0;
        int n12 = 0;
        while (n11 < n5) {
            for (n2 = 0; n2 < fArray2[n12].length; ++n2) {
                int n13 = n11;
                fArray[n13] = fArray[n13] + fArray2[n12][n2];
            }
            ++n11;
            n12 += n10;
        }
        float[] fArray3 = new float[n5];
        for (n12 = 0; n12 < n5; ++n12) {
            fArray3[n12] = fArray[n12] != 0.0f ? 1.0f / fArray[n12] : 1.0f;
        }
        n2 = 0;
        if (null != progressMonitor) {
            progressMonitor.setMaximum(n * n5 * n7);
        }
        for (int i = 0; i < n; ++i) {
            int n14 = 0;
            int n15 = 0;
            while (n14 < n5) {
                float[] fArray4 = fArray2[n15];
                int n16 = 0;
                int n17 = n3;
                while (n16 < n7 - n8) {
                    if (null != progressMonitor) {
                        progressMonitor.setProgress(++n2);
                        if (progressMonitor.isCanceled()) {
                            progressMonitor.close();
                            return;
                        }
                    }
                    int n18 = 0;
                    int n19 = n3;
                    int n20 = n17 * n6 + n19;
                    while (n18 < n6 - n8) {
                        int n21;
                        float f = 0.0f;
                        int n22 = 0;
                        for (n21 = n16; n21 < n16 + n8; ++n21) {
                            int n23 = n18;
                            int n24 = n21 * n6;
                            while (n23 < n18 + n8) {
                                f = (float)((double)f + (double)this.data[n14][n24] * (double)fArray2[n14][n22]);
                                ++n23;
                                ++n22;
                                ++n24;
                            }
                        }
                        n21 = nArray[n14][n20];
                        n22 = nArray2[n14][n20];
                        if ((n22 = (int)((double)n22 + d * (double)((float)n21 - (f *= fArray3[n14])))) > n4) {
                            n22 = n4;
                        } else if (n22 < 0) {
                            n22 = 0;
                        }
                        nArray3[n14][n20] = n22;
                        ++n18;
                        ++n19;
                        ++n20;
                    }
                    ++n16;
                    ++n17;
                }
                ++n14;
                n15 += n10;
            }
            int[][] nArray4 = nArray2;
            nArray2 = nArray3;
            nArray3 = nArray4;
        }
        if (null != progressMonitor) {
            progressMonitor.close();
        }
        this.data = nArray2;
        this.getRangeByRescanning();
        timer.stop();
    }

    @Override
    public void dispose() {
        this.data = null;
        this.zeroPxInt = null;
        this.zeroPxDouble = null;
    }

    @Override
    public void divide(int n) {
        Timer timer = new Timer("Image32.divide ()", this);
        for (int i = 0; i < this.getNBands(); ++i) {
            int n2 = 0;
            for (int j = 0; j < this.height; ++j) {
                for (int k = 0; k < this.width; ++k) {
                    int[] nArray = this.data[i];
                    int n3 = n2++;
                    nArray[n3] = nArray[n3] / n;
                }
            }
        }
        this.extremes.low /= n;
        this.extremes.high /= n;
        if (this.extremes.low == this.extremes.high) {
            ++this.extremes.high;
        }
        timer.stop();
    }

    @Override
    public void divideByFlatField(Image image) {
        int n;
        Timer timer = new Timer("Image32.divideByFlatField", this);
        int n2 = this.getNBands();
        int n3 = this.extremes.high;
        RangeDouble[] rangeDoubleArray = image.getChannelRangesDouble();
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = rangeDoubleArray[i].high;
        }
        int[] nArray = new int[n2];
        double[] dArray2 = new double[n2];
        int n4 = n = this.getPixel(0, 0)[0];
        int n5 = n;
        for (int i = 0; i < Math.min(this.getHeight(), image.getHeight()); ++i) {
            for (int j = 0; j < Math.min(this.getWidth(), image.getWidth()); ++j) {
                nArray = this.getPixel(j, i);
                dArray2 = image.getPixelDouble(j, i);
                for (int k = 0; k < n2; ++k) {
                    n = Math.min(n3, (int)((double)nArray[k] * dArray[k] / dArray2[k]));
                    if (n > 0) {
                        nArray[k] = n;
                    } else {
                        n = nArray[k];
                    }
                    if (n < n4) {
                        n4 = n;
                        continue;
                    }
                    if (n <= n5) continue;
                    n5 = n;
                }
                this.setPixel(j, i, nArray);
            }
        }
        if (n4 == n5) {
            ++n5;
        }
        this.extremes = new RangeInt(n4, n5);
        timer.stop();
    }

    @Override
    public void drawRim(int n, Color color) {
        int n2 = Math.min(3, this.getNBands());
        double d = (double)this.getRange().high / 255.0;
        int[] nArray = new int[n2];
        nArray[0] = (int)((double)color.getRed() * d);
        if (n2 > 1) {
            nArray[1] = (int)((double)color.getGreen() * d);
        }
        if (n2 > 2) {
            nArray[2] = (int)((double)color.getBlue() * d);
        }
        int n3 = this.width;
        int n4 = n3 - 1;
        int n5 = this.height;
        int n6 = n5 - 1;
        int n7 = n3 * n6;
        for (int i = 0; i < n2; ++i) {
            int n8;
            for (n8 = 0; n8 < n3; ++n8) {
                this.data[i][n8] = nArray[i];
                this.data[i][n8 + n7] = nArray[i];
            }
            n8 = 0;
            int n9 = 0;
            while (n8 < n5) {
                this.data[i][n9] = nArray[i];
                this.data[i][n4 + n9] = nArray[i];
                ++n8;
                n9 += n3;
            }
        }
    }

    @Override
    public void fit(int n, int n2) {
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        double d = Math.min((double)n / (double)n3, (double)n2 / (double)n4);
        int n5 = (int)((double)n3 * d);
        int n6 = (int)((double)n4 * d);
        int n7 = this.getNBands();
        int[][] nArray = this.createDataArray(n5, n6, n7);
        this.widthTimesHeight = n3 * n4;
        this.width = n3;
        this.height = n4;
        if (null != nArray) {
            int n8;
            int n9;
            Timer timer = new Timer("Image32.fit", this);
            double d2 = 1.0 / d;
            int[] nArray2 = new int[n7];
            int n10 = n9 = (n8 = this.data[0][0]);
            int n11 = 0;
            for (int i = 0; i < n6; ++i) {
                int n12 = 0;
                while (n12 < n5) {
                    nArray2 = this.getPixelInterpolated((double)n12 * d2, (double)i * d2);
                    for (int j = 0; j < n7; ++j) {
                        nArray[j][n11] = n8 = nArray2[j];
                        if (n8 < n9) {
                            n9 = n8;
                            continue;
                        }
                        if (n8 <= n10) continue;
                        n10 = n8;
                    }
                    ++n12;
                    ++n11;
                }
            }
            if (n9 == n10) {
                ++n10;
            }
            this.extremes = new RangeInt(n9, n10);
            this.data = nArray;
            this.widthTimesHeight = n5 * n6;
            this.width = n5;
            this.height = n6;
            timer.stop();
        }
    }

    @Override
    public void flipHorizontal() {
        Timer timer = new Timer("Image32.flipHorizontal", this);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getNBands();
        int n4 = 0;
        for (int i = n - 1; n4 < i; ++n4, --i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    int n5;
                    int n6 = this.width * j;
                    int n7 = n4 + n6;
                    int n8 = i + n6;
                    int n9 = this.data[k][n7];
                    this.data[k][n7] = n5 = this.data[k][n8];
                    this.data[k][n8] = n9;
                }
            }
        }
        timer.stop();
    }

    @Override
    public void flipVertical() {
        Timer timer = new Timer("Image32.flipVertical", this);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getNBands();
        int n4 = 0;
        for (int i = n2 - 1; n4 < i; ++n4, --i) {
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n3; ++k) {
                    int n5 = j + this.width * n4;
                    int n6 = j + this.width * i;
                    int n7 = this.data[k][n5];
                    int n8 = this.data[k][n6];
                    this.data[k][n6] = n7;
                    this.data[k][n5] = n8;
                }
            }
        }
        timer.stop();
    }

    @Override
    public int[] getPixel(int n, int n2) {
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return this.zeroPxInt;
        }
        int n3 = n + this.width * n2;
        if (n3 >= this.widthTimesHeight) {
            return this.zeroPxInt;
        }
        int n4 = this.getNBands();
        int[] nArray = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray[i] = this.data[i][n3];
        }
        return nArray;
    }

    @Override
    public double[] getPixelDouble(int n, int n2) {
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return this.zeroPxDouble;
        }
        int n3 = n + this.width * n2;
        if (n3 >= this.widthTimesHeight) {
            return this.zeroPxDouble;
        }
        int n4 = this.getNBands();
        double[] dArray = new double[n4];
        for (int i = 0; i < n4; ++i) {
            dArray[i] = this.data[i][n3];
        }
        return dArray;
    }

    @Override
    public int[] getPixelInterpolated(double d, double d2) {
        int n = this.width - 1;
        int n2 = this.height - 1;
        if (d < 0.0 || d > (double)n || d2 < 0.0 || d2 > (double)n2) {
            return this.zeroPxInt;
        }
        if (d == (double)n || d2 == (double)n2) {
            return this.getPixel((int)d, (int)d2);
        }
        int n3 = this.getNBands();
        int[] nArray = new int[n3];
        int n4 = (int)d;
        int n5 = (int)d2;
        double d3 = d - (double)n4;
        double d4 = 1.0 - d3;
        double d5 = d2 - (double)n5;
        double d6 = 1.0 - d5;
        int[] nArray2 = this.getPixel(n4, n5);
        int[] nArray3 = this.getPixel(n4 + 1, n5);
        int[] nArray4 = this.getPixel(n4, n5 + 1);
        int[] nArray5 = this.getPixel(n4 + 1, n5 + 1);
        for (int i = 0; i < n3; ++i) {
            nArray[i] = (int)(d3 * (d5 * (double)nArray5[i] + d6 * (double)nArray3[i]) + d4 * (d5 * (double)nArray4[i] + d6 * (double)nArray2[i]));
        }
        return nArray;
    }

    @Override
    public double[] getPixelDoubleInterpolated(double d, double d2) {
        if (d < 0.0 || d >= (double)this.width || d2 < 0.0 || d2 >= (double)this.height) {
            return this.zeroPxDouble;
        }
        int n = (int)d;
        int n2 = (int)d2;
        double d3 = d - (double)n;
        double d4 = 1.0 - d3;
        double d5 = d2 - (double)n2;
        double d6 = 1.0 - d5;
        double[] dArray = this.getPixelDouble(n, n2);
        double[] dArray2 = this.getPixelDouble(n + 1, n2);
        double[] dArray3 = this.getPixelDouble(n, n2 + 1);
        double[] dArray4 = this.getPixelDouble(n + 1, n2 + 1);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = d3 * (d5 * dArray4[i] + d6 * dArray2[i]) + d4 * (d5 * dArray3[i] + d6 * dArray[i]);
        }
        return dArray;
    }

    public int[] getHorizontalSamples(int n, int n2, int n3, int n4) {
        int[] nArray = new int[n4];
        int n5 = 0;
        int n6 = n + this.width * n2;
        while (n5 < n4) {
            nArray[n5] = this.data[n3][n6];
            ++n5;
            ++n6;
        }
        return nArray;
    }

    public int[] getVerticalSamples(int n, int n2, int n3, int n4) {
        int[] nArray = new int[n4];
        int n5 = 0;
        int n6 = n + this.width * n2;
        while (n5 < n4) {
            nArray[n5] = this.data[n3][n6];
            ++n5;
            n6 += this.width;
        }
        return nArray;
    }

    @Override
    public Image gnomonicProjection(int n, double d, double d2) {
        if (0 < n) {
            int n2;
            int n3;
            int n4 = this.getWidth();
            int n5 = this.getHeight();
            double d3 = 2.0 * (double)n;
            double d4 = Math.atan2(d, d3);
            double d5 = d / d3;
            double d6 = (double)n4 * 0.5 / d4;
            double d7 = d6 * d5;
            double d8 = 1.0 / d6;
            double d9 = Math.sqrt(n4 * n4 + n5 * n5) * 0.5;
            double d10 = Math.atan2(n5, n4);
            double d11 = d6 * Math.tan(d8 * d9);
            int n6 = (int)Math.floor(d11 * Math.cos(d10));
            Image32 image32 = new Image32(2 * n6, 2 * (n3 = (int)Math.floor(d11 * Math.sin(d10))), n2 = this.getNBands());
            if (null != image32) {
                Timer timer = new Timer("Image32.gnomonicProjection", this);
                int[] nArray = new int[n2];
                int n7 = n4 / 2;
                int n8 = n5 / 2;
                int n9 = 0;
                int n10 = -n3;
                while (n9 < image32.getHeight()) {
                    double d12 = n10 * n10;
                    int n11 = 0;
                    int n12 = -n6;
                    while (n11 < image32.getWidth()) {
                        double d13 = Math.sqrt((double)(n12 * n12) + d12);
                        double d14 = d6 * Math.atan2(d13 * d5, d7);
                        double d15 = d14 / d13;
                        double d16 = (double)n12 * d15 + (double)n7;
                        double d17 = (double)n10 * d15 + (double)n8;
                        nArray = this.getPixelInterpolated(d16, d17);
                        image32.setPixel(n11, n9, nArray);
                        ++n11;
                        ++n12;
                    }
                    ++n9;
                    ++n10;
                }
                image32.extremes = new RangeInt(this.extremes.low, this.extremes.high);
                timer.stop();
            }
            return image32;
        }
        return this;
    }

    @Override
    public Image inverseGnomonicProjection(int n, double d, double d2) {
        if (0 < n) {
            int n2;
            int n3;
            int n4 = this.getWidth();
            int n5 = this.getHeight();
            double d3 = (double)n4 * 0.5;
            double d4 = (double)n5 * 0.5;
            double d5 = 2.0 * (double)n;
            double d6 = Math.atan2(d, d5);
            double d7 = Math.atan2(d2, d5);
            double d8 = d / d5;
            double d9 = d2 / d5;
            double d10 = d3 / d8;
            double d11 = d4 / d9;
            double d12 = d8 / d3;
            int n6 = (int)Math.floor(d6 * d10);
            Image32 image32 = new Image32(2 * n6, 2 * (n3 = (int)Math.floor(d7 * d11)), n2 = this.getNBands());
            if (null != image32) {
                Timer timer = new Timer("Image32.inverseGnomonicProjection", this);
                int[] nArray = new int[n2];
                int n7 = n4 / 2;
                int n8 = n5 / 2;
                int n9 = 0;
                int n10 = -n3;
                while (n9 < image32.getHeight()) {
                    double d13 = n10 * n10;
                    int n11 = 0;
                    int n12 = -n6;
                    while (n11 < image32.getWidth()) {
                        double d14 = Math.sqrt((double)(n12 * n12) + d13);
                        double d15 = d10 * Math.tan(d12 * d14);
                        double d16 = d15 / d14;
                        double d17 = (double)n12 * d16 + (double)n7;
                        double d18 = (double)n10 * d16 + (double)n8;
                        nArray = this.getPixelInterpolated(d17, d18);
                        image32.setPixel(n11, n9, nArray);
                        ++n11;
                        ++n12;
                    }
                    ++n9;
                    ++n10;
                }
                timer.stop();
                image32.extremes = new RangeInt(this.extremes.low, this.extremes.high);
            }
            return image32;
        }
        return this;
    }

    @Override
    public void invert() {
        int n;
        Timer timer = new Timer("Image32.invert", this);
        int n2 = this.getNBands();
        int n3 = this.extremes.high;
        int n4 = 0;
        for (n = 0; n < this.getHeight(); ++n) {
            int n5 = 0;
            while (n5 < this.getWidth()) {
                for (int i = 0; i < n2; ++i) {
                    this.data[i][n4] = n3 - this.data[i][n4];
                }
                ++n5;
                ++n4;
            }
        }
        n = n3 - this.extremes.high;
        n4 = n3 - this.extremes.low;
        if (n == n4) {
            ++n4;
        }
        this.extremes = new RangeInt(n, n4);
        timer.stop();
    }

    public static boolean isAccumFile(String string) {
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
            dataInputStream.readShort();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < GRIP_V.length(); ++i) {
                stringBuilder.append(dataInputStream.readChar());
            }
            dataInputStream.close();
            return stringBuilder.toString().equals(GRIP_V);
        }
        catch (IOException iOException) {
            Util.logWarning(iOException.toString());
            return false;
        }
    }

    @Override
    public boolean isRaw() {
        return false;
    }

    private RangeInt load(String string) {
        Timer timer = new Timer("Image32.load ()", this);
        RangeInt rangeInt = null;
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
            String string2 = this.readString(dataInputStream);
            if (!string2.startsWith(GRIP_V)) {
                this.data = null;
                throw new IncompatibleImageException("The file was not saved by GRIP");
            }
            int n = this.readValue(dataInputStream, WIDTH_PX_EQ);
            int n2 = this.readValue(dataInputStream, HEIGHT_PX_EQ);
            int n3 = this.readValue(dataInputStream, CHANNELS_EQ);
            int n4 = this.readValue(dataInputStream, BPCH_EQ);
            int n5 = this.readValue(dataInputStream, MIN_EQ);
            int n6 = this.readValue(dataInputStream, MAX_EQ);
            rangeInt = new RangeInt(n5, n6);
            if (n4 != 32) {
                this.data = null;
                throw new IncompatibleImageException("Must be 32 bits per channel, not " + n4);
            }
            this.data = this.createDataArray(n, n2, n3);
            if (null != this.data) {
                int n7 = 0;
                for (int i = 0; i < n; ++i) {
                    int n8 = 0;
                    while (n8 < n2) {
                        for (int j = 0; j < n3; ++j) {
                            this.data[j][i + n7] = dataInputStream.readInt();
                        }
                        ++n8;
                        n7 += n;
                    }
                    n7 = 0;
                }
                dataInputStream.close();
                this.extremes = rangeInt;
            }
        }
        catch (IncompatibleImageException incompatibleImageException) {
            Util.message("Error", "Failed to load image from " + string);
            Util.logWarning("Failed to load image from {0}\n{1}", string, incompatibleImageException.toString());
        }
        catch (NumberFormatException numberFormatException) {
            Util.message("Error", "Failed to load image from " + string);
            Util.logWarning("Failed to load image from {0}\n{1}", string, numberFormatException.toString());
        }
        catch (IOException iOException) {
            Util.message("Error", "Failed to load image from " + string);
            Util.logWarning("Failed to load image from {0}\n{1}", string, iOException.toString());
        }
        timer.stop();
        return rangeInt;
    }

    @Override
    public void meanFilter(int n, ProgressMonitor progressMonitor) {
        int n2;
        int n3 = this.getNBands();
        int n4 = this.getWidth();
        int[][] nArray = this.createDataArray(n4, n2 = this.getHeight(), n3);
        if (null != nArray) {
            int n5;
            int n6;
            Timer timer = new Timer("Image32.meanFilter", this);
            int n7 = 2 * n + 1;
            int n8 = n7 * n7;
            int[] nArray2 = new int[n3];
            int n9 = n6 = (n5 = this.data[0][0]);
            if (null != progressMonitor) {
                progressMonitor.setMaximum(n2 - n);
            }
            for (int i = n; i < n2 - n; ++i) {
                if (null != progressMonitor) {
                    progressMonitor.setProgress(i);
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.close();
                        return;
                    }
                }
                int n10 = n4 * i;
                for (int j = n; j < n4 - n; ++j) {
                    int n11;
                    int n12 = j + n10;
                    for (n11 = 0; n11 < n3; ++n11) {
                        nArray2[n11] = 0;
                    }
                    for (n11 = i - n; n11 <= i + n; ++n11) {
                        int n13 = n4 * n11;
                        for (int k = j - n; k <= j + n; ++k) {
                            for (int i2 = 0; i2 < n3; ++i2) {
                                int n14 = i2;
                                nArray2[n14] = nArray2[n14] + this.data[i2][k + n13];
                            }
                        }
                    }
                    for (n11 = 0; n11 < n3; ++n11) {
                        nArray[n11][n12] = n5 = nArray2[n11] / n8;
                        if (n5 < n6) {
                            n6 = n5;
                            continue;
                        }
                        if (n5 <= n9) continue;
                        n9 = n5;
                    }
                }
            }
            if (null != progressMonitor) {
                progressMonitor.close();
            }
            if (n6 == n9) {
                ++n9;
            }
            this.extremes = new RangeInt(n6, n9);
            this.data = nArray;
            timer.stop();
        }
    }

    @Override
    public void medianFilter(int n, ProgressMonitor progressMonitor) {
        int n2;
        int n3 = this.getNBands();
        int n4 = this.getWidth();
        int[][] nArray = this.createDataArray(n4, n2 = this.getHeight(), n3);
        if (null != nArray) {
            int n5;
            int n6;
            Timer timer = new Timer("Image32.medianFilter", this);
            int n7 = 2 * n + 1;
            int n8 = n7 * n7;
            int n9 = n8 / 2;
            int[][] nArray2 = new int[n3][n8];
            int n10 = n6 = (n5 = this.data[0][0]);
            if (null != progressMonitor) {
                progressMonitor.setMaximum(n2 - n);
            }
            for (int i = n; i < n2 - n; ++i) {
                if (null != progressMonitor) {
                    progressMonitor.setProgress(i);
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.close();
                        return;
                    }
                }
                int n11 = n4 * i;
                for (int j = n; j < n4 - n; ++j) {
                    int n12;
                    int n13 = j + n11;
                    int n14 = 0;
                    for (n12 = i - n; n12 <= i + n; ++n12) {
                        int n15 = n4 * n12;
                        int n16 = j - n;
                        while (n16 <= j + n) {
                            for (int k = 0; k < n3; ++k) {
                                nArray2[k][n14] = this.data[k][n16 + n15];
                            }
                            ++n16;
                            ++n14;
                        }
                    }
                    for (n12 = 0; n12 < n3; ++n12) {
                        Arrays.sort(nArray2[n12]);
                        nArray[n12][n13] = n5 = nArray2[n12][n9];
                        if (n5 < n6) {
                            n6 = n5;
                            continue;
                        }
                        if (n5 <= n10) continue;
                        n10 = n5;
                    }
                }
            }
            if (null != progressMonitor) {
                progressMonitor.close();
            }
            if (n6 == n10) {
                ++n10;
            }
            this.extremes = new RangeInt(n6, n10);
            this.data = nArray;
            timer.stop();
        }
    }

    @Override
    public void multiply(double d) {
        int n;
        Timer timer = new Timer("Image32.multiply ()", this);
        int n2 = (int)((double)this.extremes.high * d);
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        int n3 = 0;
        for (n = 0; n < this.height; ++n) {
            int n4 = 0;
            while (n4 < this.width) {
                for (int i = 0; i < this.getNBands(); ++i) {
                    this.data[i][n3] = (int)((double)this.data[i][n3] * d);
                    if (this.data[i][n3] >= 0) continue;
                    this.data[i][n3] = n2;
                }
                ++n4;
                ++n3;
            }
        }
        n = (int)((double)this.extremes.low * d);
        if (n < 0) {
            n = 0x7FFFFFFE;
        }
        if (n == n2) {
            ++n2;
        }
        this.extremes = new RangeInt(n, n2);
        timer.stop();
    }

    @Override
    public void multiply(Image image) {
        int n;
        int n2;
        Timer timer = new Timer("Image32.multiply", this);
        int n3 = this.getNBands();
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int n4 = image.getRange().high;
        double d = 1.0 / (double)n4;
        int n5 = n2 = (n = (int)((double)this.data[0][0] * image.getPixelDouble(0, 0)[0] * d));
        for (int i = 0; i < Math.min(this.getHeight(), image.getHeight()); ++i) {
            for (int j = 0; j < Math.min(this.getWidth(), image.getWidth()); ++j) {
                nArray = this.getPixel(j, i);
                nArray2 = image.getPixel(j, i);
                for (int k = 0; k < n3; ++k) {
                    nArray[k] = n = (int)((double)nArray[k] * (double)nArray2[k] * d);
                    if (n < n2) {
                        n2 = n;
                        continue;
                    }
                    if (n <= n5) continue;
                    n5 = n;
                }
                this.setPixel(j, i, nArray);
            }
        }
        if (n2 == n5) {
            ++n5;
        }
        this.extremes = new RangeInt(n2, n5);
        timer.stop();
    }

    @Override
    public void multiply(Image image, double d, double d2) {
        int n;
        int n2;
        Timer timer = new Timer("Image32.multiply", this);
        int n3 = this.getNBands();
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        double d3 = this.getRange().high;
        double d4 = image.getRange().high;
        double d5 = d3 / Math.sqrt(d3 + (d * d3 + d2 * d4));
        double d6 = this.data[0][0];
        double d7 = image.getPixelDouble(0, 0)[0];
        int n4 = n2 = (n = (int)(d5 * Math.sqrt(d6 * (d * d6 + d2 * d7))));
        for (int i = 0; i < Math.min(this.getHeight(), image.getHeight()); ++i) {
            for (int j = 0; j < Math.min(this.getWidth(), image.getWidth()); ++j) {
                nArray = this.getPixel(j, i);
                nArray2 = image.getPixel(j, i);
                for (int k = 0; k < n3; ++k) {
                    n = (int)(d5 * Math.sqrt((double)nArray[k] * (d * (double)nArray[k] + d2 * (double)nArray2[k])));
                    if (n < 0) {
                        n = Integer.MAX_VALUE;
                    }
                    nArray[k] = n;
                    if (n < n2) {
                        n2 = n;
                        continue;
                    }
                    if (n <= n4) continue;
                    n4 = n;
                }
                this.setPixel(j, i, nArray);
            }
        }
        if (n2 == Integer.MAX_VALUE) {
            --n2;
        } else if (n2 == n4) {
            ++n4;
        }
        this.extremes = new RangeInt(n2, n4);
        timer.stop();
    }

    @Override
    public void nearestExtremeFilter(int n, ProgressMonitor progressMonitor) {
        int n2;
        int n3;
        int n4 = this.getWidth();
        int[][] nArray = this.createDataArray(n4, n3 = this.getHeight(), n2 = this.getNBands());
        if (null != nArray) {
            int n5;
            int n6;
            Timer timer = new Timer("Image32.nearestExtremeFilter", this);
            int[] nArray2 = new int[n2];
            int[] nArray3 = new int[n2];
            int n7 = this.getRange().high;
            int n8 = n6 = (n5 = this.data[0][0]);
            if (null != progressMonitor) {
                progressMonitor.setMaximum(n3 - n);
            }
            for (int i = n; i < n3 - n; ++i) {
                if (null != progressMonitor) {
                    progressMonitor.setProgress(i);
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.close();
                        return;
                    }
                }
                int n9 = n4 * i;
                for (int j = n; j < n4 - n; ++j) {
                    int n10;
                    int n11;
                    int n12 = j + n9;
                    for (n11 = 0; n11 < n2; ++n11) {
                        nArray2[n11] = n7;
                        nArray3[n11] = 0;
                    }
                    for (n11 = i - n; n11 <= i + n; ++n11) {
                        int n13 = n4 * n11;
                        for (int k = j - n; k <= j + n; ++k) {
                            for (int i2 = 0; i2 < n2; ++i2) {
                                n10 = this.data[i2][k + n13];
                                if (n10 < nArray2[i2]) {
                                    nArray2[i2] = n10;
                                    continue;
                                }
                                if (n10 <= nArray3[i2]) continue;
                                nArray3[i2] = n10;
                            }
                        }
                    }
                    for (n11 = 0; n11 < n2; ++n11) {
                        n10 = this.data[n11][n12];
                        n5 = n10 - nArray2[n11] < nArray3[n11] - n10 ? nArray2[n11] : nArray3[n11];
                        nArray[n11][n12] = n5;
                        if (n5 < n6) {
                            n6 = n5;
                            continue;
                        }
                        if (n5 <= n8) continue;
                        n8 = n5;
                    }
                }
            }
            if (null != progressMonitor) {
                progressMonitor.close();
            }
            timer.stop();
            if (n6 == n8) {
                ++n8;
            }
            this.extremes = new RangeInt(n6, n8);
            this.data = nArray;
        }
    }

    @Override
    public void neutraliseBackground() {
        int n = this.getNBands();
        if (1 == n) {
            Util.message("Information", "Colour balancing is not relevant for monochrome (1-channel) images");
        } else {
            int n2;
            int n3;
            Timer timer = new Timer("Image32.neutraliseBackground", this);
            int n4 = this.getWidth();
            int n5 = this.getHeight();
            int n6 = this.extremes.high;
            Statistics[] statisticsArray = new HistogramAll(this).getStatistics(1, (int)((double)n6 * 0.8));
            int n7 = statisticsArray[0].mode;
            int n8 = 0;
            for (int i = 1; i < n; ++i) {
                if (statisticsArray[i].mode >= n7) continue;
                n7 = statisticsArray[i].mode;
                n8 = i;
            }
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = (float)(n6 - n7) / (float)(n6 - statisticsArray[i].mode);
            }
            int[][] nArray = new int[n][n6 + 1];
            for (n3 = 0; n3 <= n6; ++n3) {
                for (n2 = 0; n2 < n; ++n2) {
                    nArray[n2][n3] = Math.max(0, n6 - (int)((float)(n6 - n3) * fArray[n2]));
                }
            }
            n2 = 0;
            for (n3 = 0; n3 < n5; ++n3) {
                int n9 = 0;
                while (n9 < n4) {
                    for (int i = 0; i < n; ++i) {
                        if (i == n8) continue;
                        this.data[i][n2] = nArray[i][this.data[i][n2]];
                    }
                    ++n9;
                    ++n2;
                }
            }
            timer.stop();
        }
    }

    @Override
    public void rankFilter(int n, ProgressMonitor progressMonitor) {
        int n2;
        int n3;
        int n4 = this.getWidth();
        int[][] nArray = this.createDataArray(n4, n3 = this.getHeight(), n2 = this.getNBands());
        if (null != nArray) {
            int n5;
            int n6;
            Timer timer = new Timer("Image32.rankFilter", this);
            int[] nArray2 = new int[n2];
            int[] nArray3 = new int[n2];
            int[] nArray4 = new int[n2];
            int n7 = this.getRange().high;
            float f = 2 * n + 1;
            float f2 = (float)n7 / (f * f);
            int n8 = n6 = (n5 = this.data[0][0]);
            if (null != progressMonitor) {
                progressMonitor.setMaximum(n3 - n);
            }
            for (int i = n; i < n3 - n; ++i) {
                if (null != progressMonitor) {
                    progressMonitor.setProgress(i);
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.close();
                        return;
                    }
                }
                int n9 = n4 * i;
                for (int j = n; j < n4 - n; ++j) {
                    int n10;
                    int n11 = j + n9;
                    for (n10 = 0; n10 < n2; ++n10) {
                        nArray3[n10] = 0;
                        nArray4[n10] = 0;
                    }
                    nArray2 = this.getPixel(j, i);
                    for (n10 = i - n; n10 <= i + n; ++n10) {
                        int n12 = n4 * n10;
                        for (int k = j - n; k <= j + n; ++k) {
                            for (int i2 = 0; i2 < n2; ++i2) {
                                int n13 = this.data[i2][k + n12];
                                if (n13 < nArray2[i2]) {
                                    int n14 = i2;
                                    nArray3[n14] = nArray3[n14] + 1;
                                    continue;
                                }
                                if (n13 != nArray2[i2]) continue;
                                int n15 = i2;
                                nArray4[n15] = nArray4[n15] + 1;
                            }
                        }
                    }
                    for (n10 = 0; n10 < n2; ++n10) {
                        nArray[n10][n11] = n5 = (int)(f2 * (float)(nArray3[n10] + nArray4[n10] / 2));
                        if (n5 < n6) {
                            n6 = n5;
                            continue;
                        }
                        if (n5 <= n8) continue;
                        n8 = n5;
                    }
                }
            }
            if (null != progressMonitor) {
                progressMonitor.close();
            }
            if (n6 == n8) {
                ++n8;
            }
            this.extremes = new RangeInt(n6, n8);
            this.data = nArray;
            timer.stop();
        }
    }

    @Override
    public void reapplyColour(Image image, Image image2) {
        int n = image.getWidth();
        int n2 = image.getHeight();
        int n3 = image2.getNBands();
        int n4 = image2.getRange().high;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n5 = image.getPixel(j, i)[0];
                int[] nArray = image2.getPixel(j, i);
                for (int k = 0; k < n3; ++k) {
                    nArray[k] = (int)Math.round((double)n5 * (double)nArray[k] / (double)n4);
                }
                this.setPixel(j, i, nArray);
            }
        }
        this.setRange(this.getRangeByRescanning());
    }

    @Override
    public void rotate(double d) {
        double d2 = d * Math.PI / 180.0;
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = n / 2;
        int n4 = n2 / 2;
        int n5 = (int)Math.floor(Math.abs((double)n * d4) + Math.abs((double)n2 * d3));
        int n6 = (int)Math.floor(Math.abs((double)n * d3) + Math.abs((double)n2 * d4));
        int n7 = this.getNBands();
        int[][] nArray = this.createDataArray(n5, n6, n7);
        this.widthTimesHeight = n * n2;
        this.width = n;
        this.height = n2;
        if (null != nArray) {
            int n8;
            Timer timer = new Timer("Image32.rotate", this);
            int[] nArray2 = new int[n7];
            int n9 = n8 = this.data[0][0];
            int n10 = 0;
            int n11 = 0;
            int n12 = -n6 / 2;
            while (n10 < n6) {
                int n13 = 0;
                int n14 = -n5 / 2;
                while (n13 < n5) {
                    double d5 = (double)n14 * d4 - (double)n12 * d3;
                    double d6 = (double)n14 * d3 + (double)n12 * d4;
                    nArray2 = this.getPixelInterpolated(d5 + (double)n3, d6 + (double)n4);
                    for (int i = 0; i < n7; ++i) {
                        nArray[i][n11] = nArray2[i];
                        if (nArray2[i] < n8) {
                            n8 = nArray2[i];
                            continue;
                        }
                        if (nArray2[i] <= n9) continue;
                        n9 = nArray2[i];
                    }
                    ++n13;
                    ++n14;
                    ++n11;
                }
                ++n10;
                ++n12;
            }
            if (n8 == n9) {
                ++n9;
            }
            this.extremes = new RangeInt(n8, n9);
            this.data = nArray;
            this.widthTimesHeight = n5 * n6;
            this.width = n5;
            this.height = n6;
            timer.stop();
        }
    }

    @Override
    public void save(String string) {
        this.save(string, this.getRangeByRescanning());
    }

    @Override
    public void save(String string, RangeInt rangeInt) {
        String string2 = string.toLowerCase();
        if (string2.endsWith(".fits")) {
            this.saveAsFITS(string);
        } else if (string2.endsWith(".tif")) {
            try {
                this.saveAsTIFF(string);
            }
            catch (IncompatibleImageException incompatibleImageException) {
                Util.warning("Error", incompatibleImageException.getMessage());
            }
        } else {
            Util.warning("Image not saved", "Path " + string + "\ndoes not end in \".fits\" or \".accum\"");
        }
    }

    @Override
    public void save(String string, RangeDouble rangeDouble) {
        RangeInt rangeInt = new RangeInt((int)rangeDouble.low, (int)rangeDouble.high);
        this.save(string, rangeInt);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveAsFITS(String string) {
        Timer timer = new Timer("Image32.saveAsFITS", this);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getNBands();
        try {
            void var9_17;
            int n4;
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(FITS.padTo(80, "SIMPLE  =                    T / GRIP (www.grelf.net)"));
            stringBuffer.append(FITS.padTo(80, "BITPIX  =                   32"));
            stringBuffer.append(FITS.padTo(80, "BZERO   =                  0.0"));
            stringBuffer.append(FITS.padTo(80, "BSCALE  =                  1.0"));
            stringBuffer.append(FITS.padTo(80, "NAXIS   =                    3"));
            stringBuffer.append(FITS.padTo(80, "NAXIS1  = " + FITS.rJustified20(n)));
            stringBuffer.append(FITS.padTo(80, "NAXIS2  = " + FITS.rJustified20(n2)));
            stringBuffer.append(FITS.padTo(80, "NAXIS3  = " + FITS.rJustified20(n3)));
            stringBuffer.append(FITS.padTo(80, "DATE    = " + Util.format_yyyyMMddTHHmmss(new Date())));
            if (null != this.metadata) {
                String string2;
                if (null != this.metadata.getMap()) {
                    for (String object : this.metadata.getMap().keySet()) {
                        string2 = Metadata.FITS_KEYWORDS.get(object);
                        String string3 = this.metadata.getMap().get(object);
                        if (null == string2 || null == string3 || -1 != stringBuffer.indexOf(string2)) continue;
                        stringBuffer.append(FITS.padTo(80, string2 + "= " + string3));
                    }
                }
                if (null != this.metadata.getList()) {
                    for (FITS_KeywordRecord i : this.metadata.getList()) {
                        string2 = i.getKeyword();
                        if (-1 != stringBuffer.indexOf(string2)) continue;
                        stringBuffer.append(i.getRecord());
                    }
                }
            }
            stringBuffer.append(FITS.padTo(80, "END"));
            stringBuffer = FITS.padTo((1 + stringBuffer.length() / 2880) * 2880, stringBuffer);
            dataOutputStream.writeBytes(stringBuffer.toString());
            for (n4 = 0; n4 < n3; ++n4) {
                int n5 = 0;
                for (int i = 0; i < n2; ++i) {
                    int n6 = 0;
                    while (n6 < n) {
                        dataOutputStream.writeInt(this.data[n4][n5]);
                        ++n6;
                        ++n5;
                    }
                }
            }
            n4 = (int)(4L * (long)n3 * (long)n * (long)n2 % 2880L);
            boolean bl = false;
            while (var9_17 < 2880 - n4) {
                dataOutputStream.writeByte(32);
                ++var9_17;
            }
            dataOutputStream.close();
            this.setFilePath(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Util.warning("Error", fileNotFoundException);
        }
        catch (IOException iOException) {
            Util.warning("Error", iOException);
        }
        timer.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAsTIFF(String string) throws IncompatibleImageException {
        int n = this.getNBands();
        if (1 != n && 3 != n) {
            throw new IncompatibleImageException("saveAsTIFF cannot handle " + n + " bands");
        }
        Timer timer = new Timer("Image32.saveAsTIFF", this);
        byte[] byArray = null;
        if (3 == n) {
            byArray = ICC_Profile.getInstance(1004).getData();
        } else if (1 == n) {
            byArray = ICC_Profile.getInstance(1003).getData();
        }
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = n3 * 8;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<?xpacket begin=\"\" id=\"W5M0MpCehiHzreSzNTczkc9d\"?>\n");
            stringBuffer.append("<x:xmpmeta xmlns:x=\"adobe:ns:meta/\" x:xmptk=\"Adobe XMP Core 4.2.2-c063 53.352624, 2008/07/30-18:12:18        \">\n");
            stringBuffer.append("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n");
            stringBuffer.append("<rdf:Description rdf:about=\"\" xmlns:photoshop=\"http://ns.adobe.com/photoshop/1.0/\">\n");
            stringBuffer.append("<photoshop:ColorMode>");
            if (1 == n) {
                stringBuffer.append("1");
            } else {
                stringBuffer.append("3");
            }
            stringBuffer.append("</photoshop:ColorMode>\n");
            stringBuffer.append("<photoshop:ICCProfile>");
            if (1 == n) {
                stringBuffer.append("Linear Grayscale Profile");
            } else {
                stringBuffer.append("sRGB IEC61966-2.1 (Linear RGB Profile)");
            }
            stringBuffer.append("</photoshop:ICCProfile>\n");
            stringBuffer.append("</rdf:Description>\n");
            stringBuffer.append("</rdf:RDF>\n");
            stringBuffer.append("</x:xmpmeta>\n");
            stringBuffer.append("<?xpacket end=\"r\"?>\n");
            String string2 = stringBuffer.toString();
            byte[] byArray2 = string2.getBytes("UTF-8");
            byte[] byArray3 = "GRIP (www.grelf.net) \u0000".getBytes("UTF-8");
            byte[] byArray4 = (new JulianDate().toImageTimestampFormat() + '\u0000').getBytes("UTF-8");
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            dataOutputStream.writeShort(19789);
            dataOutputStream.writeShort(42);
            dataOutputStream.writeInt(8);
            dataOutputStream.writeShort(16);
            this.writeTiffValues(dataOutputStream, 254, (short)3, 1, 0);
            this.writeTiffValues(dataOutputStream, 256, (short)3, 1, n2);
            this.writeTiffValues(dataOutputStream, 257, (short)3, 1, n3);
            if (n == 1) {
                this.writeTiffValues(dataOutputStream, 258, (short)3, 1, 32);
            } else {
                this.writeTiffOffset(dataOutputStream, 258, (short)3, n, 206);
            }
            this.writeTiffValues(dataOutputStream, 259, (short)3, 1, 1);
            if (1 == n) {
                this.writeTiffValues(dataOutputStream, 262, (short)3, 1, 1);
            } else {
                this.writeTiffValues(dataOutputStream, 262, (short)3, 1, 2);
            }
            this.writeTiffValues(dataOutputStream, 273, (short)4, n3, 226);
            this.writeTiffValues(dataOutputStream, 277, (short)3, 1, n);
            this.writeTiffValues(dataOutputStream, 278, (short)3, 1, 1);
            this.writeTiffValues(dataOutputStream, 279, (short)4, n3, 226 + 4 * n3);
            this.writeTiffOffset(dataOutputStream, 282, (short)5, 1, 212);
            this.writeTiffOffset(dataOutputStream, 283, (short)5, 1, 212);
            this.writeTiffValues(dataOutputStream, 296, (short)3, 1, 2);
            this.writeTiffOffset(dataOutputStream, 305, (short)2, byArray3.length, 226 + n4 + 42 + byArray.length + 18 + byArray2.length);
            this.writeTiffOffset(dataOutputStream, 306, (short)2, byArray4.length, 226 + n4 + 42 + byArray.length + 18 + byArray2.length + byArray3.length);
            if (1 == n) {
                this.writeTiffValues(dataOutputStream, 339, (short)3, 1, 3);
            } else {
                this.writeTiffOffset(dataOutputStream, 339, (short)3, n, 220);
            }
            dataOutputStream.writeInt(226 + n4);
            dataOutputStream.writeShort(32);
            dataOutputStream.writeShort(32);
            dataOutputStream.writeShort(32);
            dataOutputStream.writeInt(300);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeShort(3);
            dataOutputStream.writeShort(3);
            dataOutputStream.writeShort(3);
            int n5 = n2 * n * 4;
            int n6 = 0;
            int n7 = 226 + n4 + 42 + byArray.length + 18 + byArray2.length + byArray3.length + byArray4.length;
            while (n6 < n3) {
                dataOutputStream.writeInt(n7);
                ++n6;
                n7 += n5;
            }
            for (n6 = 0; n6 < n3; ++n6) {
                dataOutputStream.writeInt(n5);
            }
            dataOutputStream.writeShort(3);
            this.writeTiffOffset(dataOutputStream, 700, (short)7, byArray2.length, 226 + n4 + 42 + byArray.length + 18);
            this.writeTiffOffset(dataOutputStream, 34665, (short)4, 1, 226 + n4 + 42 + byArray.length);
            this.writeTiffOffset(dataOutputStream, 34675, (short)7, byArray.length, 226 + n4 + 42);
            dataOutputStream.writeInt(0);
            dataOutputStream.write(byArray);
            dataOutputStream.writeShort(1);
            this.writeTiffValues(dataOutputStream, 40961, (short)3, 1, 65535);
            dataOutputStream.writeInt(0);
            dataOutputStream.write(byArray2);
            dataOutputStream.write(byArray3);
            dataOutputStream.write(byArray4);
            double d = 1.0 / this.getRangeDouble().high;
            for (int i = 0; i < this.widthTimesHeight; ++i) {
                for (int j = 0; j < n; ++j) {
                    dataOutputStream.writeFloat((float)((double)this.data[j][i] * d));
                }
            }
            dataOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Util.warning("Error", "Could not create file\n" + string);
        }
        catch (IOException iOException) {
            Util.warning("Error", "Input/output exception in file\n" + string);
        }
        finally {
            timer.stop();
        }
    }

    private void writeTiffValues(DataOutputStream dataOutputStream, int n, short s, int n2, int ... nArray) throws IOException {
        dataOutputStream.writeShort(n);
        dataOutputStream.writeShort(s);
        dataOutputStream.writeInt(n2);
        switch (s) {
            case 3: {
                dataOutputStream.writeShort(nArray[0]);
                if (2 == n2) {
                    dataOutputStream.writeShort(nArray[1]);
                    break;
                }
                dataOutputStream.writeShort(0);
                break;
            }
            case 4: {
                dataOutputStream.writeInt(nArray[0]);
            }
        }
    }

    private void writeTiffOffset(DataOutputStream dataOutputStream, int n, short s, int n2, int n3) throws IOException {
        dataOutputStream.writeShort(n);
        dataOutputStream.writeShort(s);
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeInt(n3);
    }

    private String readString(DataInputStream dataInputStream) throws EOFException, IOException {
        int n = dataInputStream.readShort();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(dataInputStream.readChar());
        }
        return stringBuilder.toString();
    }

    private int readValue(DataInputStream dataInputStream, String string) throws EOFException, IOException, NumberFormatException {
        String string2 = this.readString(dataInputStream);
        int n = string2.indexOf(string);
        if (0 == n) {
            return Integer.parseInt(string2.substring(string.length()));
        }
        throw new NumberFormatException("Invalid header value: " + string2);
    }

    private void writeString(DataOutputStream dataOutputStream, String string) throws IOException {
        int n = string.length();
        dataOutputStream.writeShort((short)n);
        for (int i = 0; i < n; ++i) {
            dataOutputStream.writeChar(string.charAt(i));
        }
    }

    @Override
    public void scale(double d, boolean bl) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = (int)Math.floor((double)n * d);
        int n4 = (int)Math.floor((double)n2 * d);
        int n5 = this.getNBands();
        int[][] nArray = this.createDataArray(n3, n4, n5);
        this.widthTimesHeight = n * n2;
        this.width = n;
        this.height = n2;
        if (null != nArray) {
            Timer timer = new Timer("Image32.scale", this);
            int n6 = n / 2;
            int n7 = n2 / 2;
            int[] nArray2 = new int[n5];
            double d2 = 1.0 / d;
            if (bl) {
                int n8 = 0;
                int n9 = -n4 / 2;
                int n10 = 0;
                while (n8 < n4) {
                    int n11 = 0;
                    int n12 = -n3 / 2;
                    while (n11 < n3) {
                        double d3 = (double)n12 * d2;
                        double d4 = (double)n9 * d2;
                        nArray2 = this.getPixelInterpolated(d3 + (double)n6, d4 + (double)n7);
                        for (int i = 0; i < n5; ++i) {
                            nArray[i][n10] = nArray2[i];
                        }
                        ++n11;
                        ++n12;
                        ++n10;
                    }
                    ++n8;
                    ++n9;
                }
            } else {
                int n13 = 0;
                int n14 = -n4 / 2;
                int n15 = 0;
                while (n13 < n4) {
                    int n16 = 0;
                    int n17 = -n3 / 2;
                    while (n16 < n3) {
                        double d5 = (double)n17 * d2;
                        double d6 = (double)n14 * d2;
                        int n18 = (int)(d5 + (double)n6) + n3 * (int)(d6 + (double)n7);
                        for (int i = 0; i < n5; ++i) {
                            nArray[i][n15] = this.data[i][n18];
                        }
                        ++n16;
                        ++n17;
                        ++n15;
                    }
                    ++n13;
                    ++n14;
                }
            }
            this.data = nArray;
            this.widthTimesHeight = n3 * n4;
            this.width = n3;
            this.height = n4;
            timer.stop();
        }
    }

    @Override
    public BufferedImage scaleDownForDisplay(int n) {
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = this.getNBands();
        double d = this.getRangeDouble().high;
        int n5 = n2 / n;
        int n6 = n3 / n;
        BufferedImage bufferedImage = Image32.getGraphicsConfiguration().createCompatibleImage(n5, n6);
        int n7 = Image8or16Base.getNBands(bufferedImage);
        double d2 = Image8or16Base.getMaxLevel(bufferedImage);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int[] nArray = new int[n7];
        for (int i = 0; i < n7; ++i) {
            nArray[i] = 0;
        }
        double d3 = d2 / d;
        if (1 == n4) {
            int n8 = 0;
            for (int i = 0; i < n6; ++i) {
                int n9 = 0;
                int n10 = n8 * this.width;
                while (n9 < n5) {
                    int n11 = (int)((double)this.data[0][n10] * d3);
                    for (int j = 0; j < n7; ++j) {
                        nArray[j] = n11;
                    }
                    writableRaster.setPixel(n9, i, nArray);
                    ++n9;
                    n10 += n;
                }
                n8 += n;
            }
        } else {
            int n12 = Math.min(n4, n7);
            int n13 = 0;
            for (int i = 0; i < n6; ++i) {
                int n14 = 0;
                int n15 = n13 * this.width;
                while (n14 < n5) {
                    for (int j = 0; j < n12; ++j) {
                        nArray[j] = (int)((double)this.data[j][n15] * d3);
                    }
                    writableRaster.setPixel(n14, i, nArray);
                    ++n14;
                    n15 += n;
                }
                n13 += n;
            }
        }
        return bufferedImage;
    }

    @Override
    public final void set(BufferedImage bufferedImage) throws IncompatibleImageException {
        int n;
        int n2;
        this.checkCompatibility("set", bufferedImage);
        Timer timer = new Timer("Image32.set ()", this);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n3 = this.getNBands();
        int[] nArray = new int[n3];
        int n4 = StrictMath.min(this.width, bufferedImage.getWidth());
        int n5 = StrictMath.min(this.height, bufferedImage.getHeight());
        writableRaster.getPixel(0, 0, nArray);
        int n6 = n2 = (n = nArray[0]);
        int n7 = 0;
        for (int i = 0; i < n5; ++i) {
            int n8 = 0;
            while (n8 < n4) {
                writableRaster.getPixel(n8, i, nArray);
                for (int j = 0; j < n3; ++j) {
                    this.data[j][n7] = n = nArray[j];
                    if (n < n2) {
                        n2 = n;
                        continue;
                    }
                    if (n <= n6) continue;
                    n6 = n;
                }
                ++n8;
                ++n7;
            }
        }
        if (n2 == n6) {
            ++n6;
        }
        this.extremes = new RangeInt(n2, n6);
        timer.stop();
    }

    @Override
    public void setPixel(int n, int n2, int[] nArray) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            int n3 = n + this.width * n2;
            for (int i = 0; i < this.getNBands(); ++i) {
                this.data[i][n3] = nArray[i];
            }
        }
    }

    @Override
    public void setPixel(int n, int n2, int n3, int n4) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            int n5 = n + this.width * n2;
            this.data[n3][n5] = n4;
        }
    }

    @Override
    public void setPixelDouble(int n, int n2, double[] dArray) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            int n3 = n + this.width * n2;
            for (int i = 0; i < this.getNBands(); ++i) {
                this.data[i][n3] = (int)dArray[i];
            }
        }
    }

    @Override
    public void setPixelDouble(int n, int n2, int n3, double d) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            int n4 = n + this.width * n2;
            this.data[n3][n4] = (int)d;
        }
    }

    @Override
    public void showInfo() {
        this.showInfo(this);
    }

    @Override
    public Image[] splitChannels() {
        Timer timer = new Timer("Image32.splitChannels", this);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getNBands();
        Image[] imageArray = new Image32[n3];
        for (int i = 0; i < n3; ++i) {
            imageArray[i] = new Image32(n, n2, 1);
            imageArray[i].extremes = new RangeInt(this.getRange().low, this.getRange().high);
        }
        int[] nArray = new int[n3];
        int[] nArray2 = new int[1];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray = this.getPixel(j, i);
                for (int k = 0; k < n3; ++k) {
                    nArray2[0] = nArray[k];
                    ((Image32)imageArray[k]).setPixel(j, i, nArray2);
                }
            }
        }
        timer.stop();
        return imageArray;
    }

    @Override
    public Image[] splitIntensity() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getNBands();
        int n4 = this.getBitsPerChannel();
        int n5 = this.getRange().high;
        Image image = ImageBase.createImage(n, n2, 1, n4);
        if (null == image) {
            Util.warning("Error", "Unable to create intensity image");
            return null;
        }
        Image image2 = ImageBase.createImage(n, n2, n3, n4);
        if (null == image2) {
            Util.warning("Error", "Unable to create colour image");
            return null;
        }
        Timer timer = new Timer("Image.splitIntensity", this);
        int n6 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n7;
                int[] nArray = this.getPixel(j, i);
                int n8 = 0;
                for (n7 = 0; n7 < n3; ++n7) {
                    n8 += nArray[n7];
                }
                image.setPixel(j, i, 0, n8);
                if (n8 > n6) {
                    n6 = n8;
                }
                for (n7 = 0; n7 < n3; ++n7) {
                    nArray[n7] = (int)Math.round((double)n5 * (double)nArray[n7] / (double)n8);
                }
                image2.setPixel(j, i, nArray);
            }
        }
        image.getRangeByRescanningDouble();
        image2.getRangeByRescanningDouble();
        Image[] imageArray = new Image32[]{image, image2};
        timer.stop();
        return imageArray;
    }

    @Override
    public void subtract(Image image) throws IncompatibleImageException {
        int n;
        int n2;
        if (!ImageBase.sameBitsAndBands(this, image)) {
            throw new IncompatibleImageException("Incompatible images for subtraction");
        }
        Timer timer = new Timer("Image32.subtract ()", this);
        int n3 = Math.min(this.getWidth(), image.getWidth());
        int n4 = Math.min(this.getHeight(), image.getHeight());
        int n5 = this.getNBands();
        int[] nArray = new int[n5];
        int n6 = this.extremes.low - image.getRange().high;
        int n7 = n2 = (n = this.data[0][0] - image.getPixel(0, 0)[0] - n6);
        int n8 = 0;
        for (int i = 0; i < n4; ++i) {
            int n9 = 0;
            while (n9 < n3) {
                nArray = image.getPixel(n9, i);
                for (int j = 0; j < n5; ++j) {
                    this.data[j][n8] = n = this.data[j][n8] - nArray[j] - n6;
                    if (n < n2) {
                        n2 = n;
                        continue;
                    }
                    if (n <= n7) continue;
                    n7 = n;
                }
                ++n9;
                ++n8;
            }
        }
        if (n2 == n7) {
            ++n7;
        }
        this.extremes = new RangeInt(n2, n7 * 2);
        timer.stop();
    }

    @Override
    public void subtractToZero(Image image) throws IncompatibleImageException {
        int n;
        int n2;
        if (!ImageBase.sameBitsAndBands(this, image)) {
            throw new IncompatibleImageException("Incompatible images for subtraction");
        }
        Timer timer = new Timer("Image32.subtract ()", this);
        int n3 = Math.min(this.getWidth(), image.getWidth());
        int n4 = Math.min(this.getHeight(), image.getHeight());
        int n5 = this.getNBands();
        int[] nArray = new int[n5];
        int n6 = n2 = (n = this.data[0][0] - image.getPixel(0, 0)[0]);
        int n7 = 0;
        for (int i = 0; i < n4; ++i) {
            int n8 = 0;
            while (n8 < n3) {
                nArray = image.getPixel(n8, i);
                for (int j = 0; j < n5; ++j) {
                    n = this.data[j][n7] - nArray[j];
                    if (n < 0) {
                        n = 0;
                    }
                    this.data[j][n7] = n;
                    if (n < n2) {
                        n2 = n;
                        continue;
                    }
                    if (n <= n6) continue;
                    n6 = n;
                }
                ++n8;
                ++n7;
            }
        }
        if (n2 == n6) {
            ++n6;
        }
        this.extremes = new RangeInt(n2, n6);
        timer.stop();
    }

    @Override
    public ByteMask threshold(Threshold threshold) {
        Timer timer = new Timer("Image32.threshold", this);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getNBands();
        int[] nArray = new int[n3];
        byte[][] byArray = new byte[n][n2];
        if (threshold.anding) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    nArray = this.getPixel(j, i);
                    int n4 = 3;
                    for (int k = 0; k < n3; ++k) {
                        if (nArray[k] >= threshold.th[k].low && nArray[k] <= threshold.th[k].high) continue;
                        n4 = 0;
                        break;
                    }
                    byArray[j][i] = n4;
                }
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    nArray = this.getPixel(j, i);
                    int n5 = 0;
                    for (int k = 0; k < n3; ++k) {
                        if (nArray[k] < threshold.th[k].low || nArray[k] > threshold.th[k].high) continue;
                        n5 = 3;
                        break;
                    }
                    byArray[j][i] = n5;
                }
            }
        }
        timer.stop();
        return new ByteMask(byArray);
    }

    @Override
    public String toString() {
        if (null == this.data) {
            return "Image32 is null";
        }
        return "Image32 " + this.getWidth() + " x " + this.getHeight() + " pixels x " + this.getNBands() + " channels";
    }

    @Override
    public String toFoldedString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getFilePath());
        stringBuffer.append(string);
        if (this.isRaw()) {
            stringBuffer.append("RAW");
            stringBuffer.append(string);
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        stringBuffer.append("Size: ");
        stringBuffer.append(n);
        stringBuffer.append(" x ");
        stringBuffer.append(n2);
        stringBuffer.append(" pixels");
        stringBuffer.append(string);
        stringBuffer.append("Channels: ");
        stringBuffer.append(this.getNBands());
        stringBuffer.append(string);
        stringBuffer.append("Bits per channel: ");
        stringBuffer.append(this.getBitsPerChannel());
        stringBuffer.append(" [levels ");
        stringBuffer.append(this.getRange().low);
        stringBuffer.append("..");
        stringBuffer.append(this.getRange().high);
        stringBuffer.append("]");
        stringBuffer.append(string);
        stringBuffer.append("Calibration: ");
        stringBuffer.append(this.getCalibration().getValue());
        stringBuffer.append(string);
        Metadata metadata = this.getMetadata();
        if (null != metadata) {
            stringBuffer.append(metadata.toFoldedString(string));
        }
        return stringBuffer.toString();
    }

    @Override
    public void translate(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = this.getWidth();
        int n7 = n6;
        int[][] nArray = this.createDataArray(n7, n5 = (n4 = this.getHeight()), n3 = this.getNBands());
        if (null != nArray) {
            Timer timer = new Timer("Image32.translate", this);
            int n8 = 0;
            int n9 = n2;
            int n10 = 0;
            while (n8 < n4) {
                if (n9 >= 0 && n9 < n4) {
                    int n11 = n9 * n7;
                    int n12 = 0;
                    int n13 = n;
                    int n14 = n11 + n;
                    while (n12 < n6) {
                        if (n13 >= 0 && n13 < n6) {
                            for (int i = 0; i < n3; ++i) {
                                nArray[i][n14] = this.data[i][n10];
                            }
                        }
                        ++n12;
                        ++n13;
                        ++n10;
                        ++n14;
                    }
                }
                ++n8;
                ++n9;
            }
            this.data = nArray;
            timer.stop();
        }
    }

    @Override
    public void translate(double d, double d2) {
        int n;
        int n2;
        int n3;
        int n4 = this.getWidth();
        int n5 = n4;
        int[][] nArray = this.createDataArray(n5, n3 = (n2 = this.getHeight()), n = this.getNBands());
        if (null != nArray) {
            Timer timer = new Timer("Image32.translate", this);
            int[] nArray2 = new int[n];
            int n6 = 0;
            for (int i = 0; i < n3; ++i) {
                double d3 = (double)i - d2;
                int n7 = 0;
                while (n7 < n5) {
                    double d4 = (double)n7 - d;
                    nArray2 = this.getPixelInterpolated(d4, d3);
                    for (int j = 0; j < n; ++j) {
                        nArray[j][n6] = nArray2[j];
                    }
                    ++n7;
                    ++n6;
                }
            }
            this.data = nArray;
            timer.stop();
        }
    }

    @Override
    public void varianceFilter(int n, ProgressMonitor progressMonitor) {
        int n2;
        int n3;
        int n4 = this.getWidth();
        int[][] nArray = this.createDataArray(n4, n3 = this.getHeight(), n2 = this.getNBands());
        if (null != nArray) {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            Timer timer = new Timer("Image32.varianceFilter", this);
            long[] lArray = new long[n2];
            long[] lArray2 = new long[n2];
            int n11 = 2 * n + 1;
            int n12 = n11 * n11;
            double d = 1.0 / (double)n12;
            double d2 = 0.0;
            if (null != progressMonitor) {
                progressMonitor.setMaximum(n3 - n);
            }
            for (n10 = n; n10 < n3 - n; ++n10) {
                if (null != progressMonitor) {
                    progressMonitor.setProgress(n10);
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.close();
                        return;
                    }
                }
                n9 = n4 * n10;
                for (int i = n; i < n4 - n; ++i) {
                    int n13;
                    n8 = i + n9;
                    for (n13 = 0; n13 < n2; ++n13) {
                        lArray[n13] = 0L;
                        lArray2[n13] = 0L;
                    }
                    for (n13 = n10 - n; n13 <= n10 + n; ++n13) {
                        n7 = n4 * n13;
                        for (int j = i - n; j <= i + n; ++j) {
                            n6 = 0;
                            while (n6 < n2) {
                                long l = this.data[n6][j + n7];
                                int n14 = n6;
                                lArray[n14] = lArray[n14] + l;
                                int n15 = n6++;
                                lArray2[n15] = lArray2[n15] + l * l;
                            }
                        }
                    }
                    for (n13 = 0; n13 < n2; ++n13) {
                        double d3 = d * (double)lArray2[n13];
                        double d4 = d * (double)lArray[n13];
                        double d5 = d3 - d4 * d4;
                        if (!(d5 > d2)) continue;
                        d2 = d5;
                    }
                }
            }
            n10 = 1000000;
            double d6 = (double)n10 / d2;
            int n16 = n6 = (n5 = (int)(d6 * d2));
            for (int i = n; i < n3 - n; ++i) {
                if (null != progressMonitor) {
                    progressMonitor.setProgress(i);
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.close();
                        return;
                    }
                }
                n9 = n4 * i;
                for (int j = n; j < n4 - n; ++j) {
                    int n17;
                    n8 = j + n9;
                    for (n17 = 0; n17 < n2; ++n17) {
                        lArray[n17] = 0L;
                        lArray2[n17] = 0L;
                    }
                    for (n17 = i - n; n17 <= i + n; ++n17) {
                        n7 = n4 * n17;
                        for (int k = j - n; k <= j + n; ++k) {
                            int n18 = 0;
                            while (n18 < n2) {
                                long l = this.data[n18][k + n7];
                                int n19 = n18;
                                lArray[n19] = lArray[n19] + l;
                                int n20 = n18++;
                                lArray2[n20] = lArray2[n20] + l * l;
                            }
                        }
                    }
                    for (n17 = 0; n17 < n2; ++n17) {
                        double d7 = d * (double)lArray2[n17];
                        double d8 = d * (double)lArray[n17];
                        double d9 = d7 - d8 * d8;
                        n5 = (int)(d6 * d9);
                        if (n5 >= n10) {
                            n5 = n10;
                        } else if (d9 < 0.0) {
                            n5 = 0;
                        }
                        nArray[n17][n8] = n5;
                        if (n5 < n6) {
                            n6 = n5;
                            continue;
                        }
                        if (n5 <= n16) continue;
                        n16 = n5;
                    }
                }
            }
            if (null != progressMonitor) {
                progressMonitor.close();
            }
            if (n6 == n16) {
                ++n16;
            }
            this.extremes = new RangeInt(n6, n16);
            this.data = nArray;
            timer.stop();
        }
    }
}

