/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.image;

import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.IIOImage;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import net.grelf.Util;
import net.grelf.astro.JulianDate;
import net.grelf.image.FITS_KeywordRecord;

public class Metadata {
    public static final String IMAGE_KIND_KEYWORD = "ImageKind";
    public static final String NIMAGES_KEYWORD = "NImages";
    public static final String METHOD_KEYWORD = "StackingMethod";
    public static final String FIRST_KEYWORD = "DateTimeFirst";
    public static final String LAST_KEYWORD = "DateTimeLast";
    public static final String EXPOSURE_KEYWORD = "Exposure";
    public static final String APERTURE_KEYWORD = "Aperture";
    public static final String FOCAL_LENGTH_KEYWORD = "FocalLength";
    public static final String ISO_KEYWORD = "ISO";
    public static final String CAMERA_KEYWORD = "CAMERA";
    public static final String OBSERVER_KEYWORD = "OBSERVER";
    public static final String COPYRIGHT_KEYWORD = "COPYRIGHT";
    public static final String GRIP_COMBINED_IMAGE_ID = "GRIP combined image";
    public static final Map<String, String> FITS_KEYWORDS = new HashMap<String, String>();
    private Map<String, String> map;
    private List<FITS_KeywordRecord> list;

    public Map<String, String> getMap() {
        return this.map;
    }

    public List<FITS_KeywordRecord> getList() {
        return this.list;
    }

    public Metadata(Map<String, String> map) {
        this.map = map;
    }

    public Metadata(List<FITS_KeywordRecord> list) {
        this();
        this.list = list;
    }

    public Metadata() {
        this.map = new HashMap<String, String>();
    }

    public Metadata(String string) {
        this();
        String[] stringArray = string.split(";");
        if (stringArray.length > 0 && stringArray[0].equals("ImageKind=GRIP combined image")) {
            for (String string2 : stringArray) {
                String[] stringArray2 = string2.split("=");
                if (stringArray2.length != 2) {
                    Util.logWarning("Invalid part in ImageKind metadata: {0}", string2);
                    continue;
                }
                this.map.put(stringArray2[0], stringArray2[1]);
            }
        }
    }

    public void convertImageKindString() {
        String string = this.map.get(IMAGE_KIND_KEYWORD);
        if (null != string) {
            this.map.remove(IMAGE_KIND_KEYWORD);
            String[] stringArray = string.split(";");
            if (0 < stringArray.length) {
                this.map.put(IMAGE_KIND_KEYWORD, GRIP_COMBINED_IMAGE_ID);
                for (int i = 1; i < stringArray.length; ++i) {
                    String[] stringArray2 = stringArray[i].split("=");
                    if (2 != stringArray2.length) continue;
                    String string2 = FITS_KEYWORDS.get(stringArray2[0]);
                    this.map.put(string2, stringArray2[1]);
                }
            }
        }
    }

    public void addValue(String string, String string2) {
        this.map.put(string, string2);
    }

    public boolean contains(String string) {
        if (null != this.list) {
            for (FITS_KeywordRecord fITS_KeywordRecord : this.list) {
                if (!fITS_KeywordRecord.getKeyword().equals(string)) continue;
                return true;
            }
        }
        return null != this.map.get(string);
    }

    public void clear() {
        this.map.clear();
        if (null != this.list) {
            this.list.clear();
        }
    }

    public String getValue(String string) {
        if (null != this.map) {
            return this.map.get(string);
        }
        return null;
    }

    public String getValue(String ... stringArray) {
        for (String string : stringArray) {
            String string2 = this.getValue(string);
            if (null == string2) continue;
            return string2;
        }
        if (null != this.list) {
            for (String string : stringArray) {
                for (FITS_KeywordRecord fITS_KeywordRecord : this.list) {
                    if (!fITS_KeywordRecord.getKeyword().equals(string)) continue;
                    return fITS_KeywordRecord.getValue();
                }
            }
        }
        return "";
    }

    public float getAperture() {
        if (this.map.containsKey("FNumber")) {
            return Util.rationalFloat(this.map.get("FNumber"));
        }
        String string = this.getValue("APERTURE");
        if (null == string || 0 == string.length()) {
            return 0.0f;
        }
        return Float.parseFloat(string);
    }

    public String getCamera() {
        return this.getValue("Camera", "CAMERA  ", "Model", "Make", CAMERA_KEYWORD);
    }

    public String getCopyright() {
        return this.getValue("Copyright", "COPYRIGH");
    }

    public float getExposure() {
        if (this.map.containsKey("ExposureTime")) {
            return Util.rationalFloat(this.map.get("ExposureTime"));
        }
        String string = this.getValue("EXPOSURE");
        if (null == string || 0 == string.length()) {
            return 0.0f;
        }
        return Float.parseFloat(string);
    }

    public int getFocalLength() {
        if (this.map.containsKey(FOCAL_LENGTH_KEYWORD)) {
            return Math.round(Util.rationalFloat(this.map.get(FOCAL_LENGTH_KEYWORD)));
        }
        String string = this.getValue("F_LENGTH");
        if (null == string || 0 == string.length()) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public void setFocalLength(int n) {
        this.map.put(FOCAL_LENGTH_KEYWORD, "" + n);
        this.map.put("F_LENGTH", "" + n);
    }

    public int getISO() {
        if (this.map.containsKey("ISOSpeedRatings")) {
            return Math.round(Util.rationalFloat(this.map.get("ISOSpeedRatings")));
        }
        String string = this.getValue("ISO_SENS");
        if (null == string || 0 == string.length()) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public String getPhotographer() {
        return this.getValue("Artist", "ARTIST  ", OBSERVER_KEYWORD, "ARTIST", "Photographer");
    }

    public String getDateTime() {
        String string = this.getValue("DateTimeOriginal");
        if (null != string) {
            return string;
        }
        return this.getValue("OBSBEGIN");
    }

    public long getTimeInMillis() {
        String string = this.getDateTime();
        if (null != string && string.length() > 0) {
            try {
                GregorianCalendar gregorianCalendar = new GregorianCalendar(Integer.parseInt(string.substring(0, 4)), Integer.parseInt(string.substring(5, 7)) - 1, Integer.parseInt(string.substring(8, 10)), Integer.parseInt(string.substring(11, 13)), Integer.parseInt(string.substring(14, 16)), Integer.parseInt(string.substring(17, 19)));
                return gregorianCalendar.getTimeInMillis();
            }
            catch (NumberFormatException numberFormatException) {
                Util.logWarning("Invalid DateTimeOriginal value in image metadata");
                return 0L;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Util.logWarning("Wrong length DateTimeOriginal value in image metadata");
                return 0L;
            }
        }
        Util.logWarning("DateTimeOriginal not found in image metadata");
        return 0L;
    }

    public IIOMetadataNode buildTree() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("javax_imageio_1.0");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Document");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("Text");
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        String string = "GRIP from www.grelf.net";
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("TextEntry");
        iIOMetadataNode4.setAttribute("keyword", "Software");
        iIOMetadataNode4.setAttribute("value", string);
        iIOMetadataNode3.appendChild(iIOMetadataNode4);
        StringBuffer stringBuffer = new StringBuffer();
        Set<String> set = this.map.keySet();
        for (String string2 : set) {
            if (string2.equals(LAST_KEYWORD)) {
                String string3 = this.map.get(string2);
                IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("ImageCreationTime");
                iIOMetadataNode5.setAttribute("year", string3.substring(0, 4));
                iIOMetadataNode5.setAttribute("month", string3.substring(5, 7));
                iIOMetadataNode5.setAttribute("day", string3.substring(8, 10));
                iIOMetadataNode5.setAttribute("hour", string3.substring(11, 13));
                iIOMetadataNode5.setAttribute("minute", string3.substring(14, 16));
                iIOMetadataNode5.setAttribute("second", string3.substring(17));
                iIOMetadataNode2.appendChild(iIOMetadataNode5);
            }
            stringBuffer.append(string2);
            stringBuffer.append("=");
            stringBuffer.append(this.map.get(string2));
            stringBuffer.append(";");
        }
        IIOMetadataNode iIOMetadataNode6 = new IIOMetadataNode("TextEntry");
        iIOMetadataNode6.setAttribute("keyword", "ImageDescription");
        iIOMetadataNode6.setAttribute("value", stringBuffer.toString());
        iIOMetadataNode3.appendChild(iIOMetadataNode6);
        return iIOMetadataNode;
    }

    public StringBuffer formatForDisplay() {
        StringBuffer stringBuffer = new StringBuffer();
        Set<String> set = this.map.keySet();
        for (String string : set) {
            String string2;
            stringBuffer.append(this.rephrase(string));
            stringBuffer.append(": ");
            String string3 = this.map.get(string);
            stringBuffer.append(string3);
            if ((string.equals(FIRST_KEYWORD) || string.equals(LAST_KEYWORD)) && null != (string2 = JulianDate.createJulianDate(string3).toString())) {
                stringBuffer.append(" (JD ");
                stringBuffer.append(string2);
                stringBuffer.append(")");
            }
            stringBuffer.append("<br>");
        }
        return stringBuffer;
    }

    public void mergeIntoIIOI(IIOImage iIOImage) {
        if (null != iIOImage) {
            try {
                IIOMetadata iIOMetadata = iIOImage.getMetadata();
                if (null == iIOMetadata) {
                    Util.logWarning("No metadata found for adding into");
                } else {
                    String[] stringArray;
                    if (!iIOMetadata.isStandardMetadataFormatSupported()) {
                        Util.logWarning("metadata.isStandardMetadataFormatSupported () = false");
                    }
                    if (iIOMetadata.isReadOnly()) {
                        Util.logWarning("metadata.isReadOnly () = true");
                    }
                    for (String string : stringArray = iIOMetadata.getMetadataFormatNames()) {
                        if (!string.equals("javax_imageio_1.0")) continue;
                        IIOMetadataNode iIOMetadataNode = this.buildTree();
                        iIOMetadata.mergeTree(string, iIOMetadataNode);
                    }
                }
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                Util.logWarning("IIOInvalidTreeException in Im.addMetadata()");
            }
        }
    }

    public void remove(String string) {
        if (null != this.list) {
            for (FITS_KeywordRecord fITS_KeywordRecord : this.list) {
                if (!fITS_KeywordRecord.getKeyword().equals(string)) continue;
                this.list.remove(fITS_KeywordRecord);
                return;
            }
        }
        this.map.remove(string);
    }

    public void removeTiffFields() {
        this.map.remove("StripByteCounts");
        this.map.remove("StripOffsets");
        this.map.remove("RowsPerStrip");
        this.map.remove("XResolution");
        this.map.remove("YResolution");
        this.map.remove("Compression");
        this.map.remove("SampleFormat");
        this.map.remove("BitsPerSample");
        this.map.remove("SamplesPerPixel");
        this.map.remove("ResolutionUnit");
        this.map.remove("PhotometricInterpretation");
    }

    private String rephrase(String string) {
        if (string.equals(APERTURE_KEYWORD)) {
            return APERTURE_KEYWORD;
        }
        if (string.equals(EXPOSURE_KEYWORD)) {
            return EXPOSURE_KEYWORD;
        }
        if (string.equals(FIRST_KEYWORD)) {
            return "First image taken";
        }
        if (string.equals(FOCAL_LENGTH_KEYWORD)) {
            return "Focal length";
        }
        if (string.equals(IMAGE_KIND_KEYWORD)) {
            return "Image kind";
        }
        if (string.equals(ISO_KEYWORD)) {
            return ISO_KEYWORD;
        }
        if (string.equals(LAST_KEYWORD)) {
            return "Last image taken";
        }
        if (string.equals(NIMAGES_KEYWORD)) {
            return "Number of images";
        }
        return string;
    }

    public void replaceValue(String string, String string2) {
        if (null != this.list) {
            for (FITS_KeywordRecord fITS_KeywordRecord : this.list) {
                if (!fITS_KeywordRecord.getKeyword().equals(string)) continue;
                fITS_KeywordRecord.setValue(string2);
                return;
            }
        }
        this.map.remove(string);
        this.addValue(string, string2);
    }

    public String toFoldedString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != this.map) {
            Object object;
            if (this.map.containsKey("Artist")) {
                stringBuffer.append("Photographer: ");
                stringBuffer.append(this.map.get("Artist"));
                stringBuffer.append(string);
            }
            if (this.map.containsKey("Make")) {
                stringBuffer.append("Camera maker: ");
                stringBuffer.append(this.map.get("Make"));
                stringBuffer.append(string);
            }
            if (this.map.containsKey("Model")) {
                stringBuffer.append("Camera: ");
                stringBuffer.append(this.map.get("Model"));
                stringBuffer.append(string);
            }
            if (this.map.containsKey("ExposureTime")) {
                stringBuffer.append("Exposure: ");
                stringBuffer.append(Util.rational(this.map.get("ExposureTime")));
                stringBuffer.append(" s");
                stringBuffer.append(string);
            }
            if (this.map.containsKey("FNumber")) {
                stringBuffer.append("Aperture: f/");
                stringBuffer.append(Util.rational(this.map.get("FNumber")));
                stringBuffer.append(string);
            }
            if (this.map.containsKey("ISOSpeedRatings")) {
                stringBuffer.append("ISO speed: ");
                stringBuffer.append(this.map.get("ISOSpeedRatings"));
                stringBuffer.append(string);
            }
            if (this.map.containsKey(FOCAL_LENGTH_KEYWORD)) {
                stringBuffer.append("Focal length: ");
                stringBuffer.append(Util.rational(this.map.get(FOCAL_LENGTH_KEYWORD)));
                stringBuffer.append(" mm");
                stringBuffer.append(string);
            }
            if (this.map.containsKey("DateTimeOriginal")) {
                object = this.map.get("DateTimeOriginal");
                stringBuffer.append("Originally taken: ");
                stringBuffer.append((String)object);
                String object2 = JulianDate.createJulianDate((String)object).toString();
                if (null != object2 && 0 < object2.length()) {
                    stringBuffer.append("(JD ");
                    stringBuffer.append(object2);
                    stringBuffer.append(")");
                }
                stringBuffer.append(string);
            }
            if (this.map.containsKey("Software")) {
                stringBuffer.append("\nCreated by: ");
                stringBuffer.append(this.map.get("Software"));
                stringBuffer.append(string);
            }
            if (this.map.containsKey(IMAGE_KIND_KEYWORD)) {
                object = this.map.get(IMAGE_KIND_KEYWORD);
                if (((String)object).contains("GRIP")) {
                    stringBuffer.append(new Metadata((String)object).formatForDisplay());
                } else {
                    stringBuffer.append((String)object);
                }
                stringBuffer.append(string);
            }
            if (this.map.containsKey("DateTime")) {
                stringBuffer.append("Last saved: ");
                stringBuffer.append(this.map.get("DateTime"));
                stringBuffer.append(string);
            }
        }
        if (null != this.getList()) {
            for (FITS_KeywordRecord fITS_KeywordRecord : this.getList()) {
                stringBuffer.append(fITS_KeywordRecord.getRecord());
                stringBuffer.append(string);
            }
        }
        if (null != this.getMap()) {
            for (String string2 : this.getMap().keySet()) {
                stringBuffer.append(string2);
                stringBuffer.append(" = ");
                stringBuffer.append(this.getMap().get(string2));
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    static {
        FITS_KEYWORDS.put(IMAGE_KIND_KEYWORD, "GR_IMAGE");
        FITS_KEYWORDS.put(NIMAGES_KEYWORD, "GR_NIMGS");
        FITS_KEYWORDS.put(METHOD_KEYWORD, "GR_METHD");
        FITS_KEYWORDS.put(FIRST_KEYWORD, "OBSBEGIN");
        FITS_KEYWORDS.put(LAST_KEYWORD, "OBSEND  ");
        FITS_KEYWORDS.put(EXPOSURE_KEYWORD, "EXPOSURE");
        FITS_KEYWORDS.put(APERTURE_KEYWORD, "APERTURE");
        FITS_KEYWORDS.put(FOCAL_LENGTH_KEYWORD, "F_LENGTH");
        FITS_KEYWORDS.put(ISO_KEYWORD, "ISO_SENS");
        FITS_KEYWORDS.put(CAMERA_KEYWORD, "CAMERA  ");
        FITS_KEYWORDS.put(OBSERVER_KEYWORD, OBSERVER_KEYWORD);
        FITS_KEYWORDS.put(COPYRIGHT_KEYWORD, "COPYRIGH");
    }
}

