/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.tiff;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.Directory;
import it.tidalwave.imageio.raw.TagRegistry;
import it.tidalwave.imageio.tiff.TIFFTag;
import it.tidalwave.imageio.util.Logger;
import java.io.IOException;
import javax.annotation.Nonnull;

public class IFDSupport
extends Directory {
    private static final String CLASS = IFDSupport.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final long serialVersionUID = -8252917582886315978L;
    public static final int CONSECUTIVE_INVALID_TAG_THRESHOLD = 5;

    public IFDSupport() {
    }

    protected IFDSupport(@Nonnull TagRegistry tagRegistry) {
        super(tagRegistry);
    }

    public long load(@Nonnull RAWImageInputStream iis, long offset) throws IOException {
        int entryCount;
        logger.finer(">>>> Reading IFD at offset: %d + %d", offset, iis.getBaseOffset());
        try {
            iis.seek(offset);
            this.start = iis.getStreamPosition() + iis.getBaseOffset();
            entryCount = iis.readShort();
        }
        catch (Exception e) {
            logger.warning("Ignoring invalid ifdOffset: %d", offset);
            return 0L;
        }
        logger.finest(">>>> entryCount: %d", entryCount);
        int consecutiveInvalidTagCount = 0;
        boolean giveUp = false;
        for (int i = 0; i < entryCount && !giveUp; ++i) {
            int ifdTag = iis.readUnsignedShort();
            TIFFTag tag = new TIFFTag(this.tagRegistry, ifdTag);
            tag.read(iis);
            this.addTag(tag);
            if (tag.isValid()) {
                consecutiveInvalidTagCount = 0;
                continue;
            }
            if (++consecutiveInvalidTagCount < 5) continue;
            logger.warning("Too many consecutive invalid tags (%d), giving up", 5);
            giveUp = true;
            this.removeAllTags();
        }
        offset = giveUp ? 0L : iis.readUnsignedInt();
        this.end = iis.getStreamPosition() + iis.getBaseOffset() - 1L;
        logger.finest(">>>> next ifdOffset: %d", offset);
        logger.finest(">>>> loaded: %s", this);
        return offset;
    }
}

