/*
 * Decompiled with CFR 0.152.
 */
package net.dieslunae.jgraphite.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.dieslunae.jgraphite.ctrl.JGraphiteController;
import net.dieslunae.jgraphite.gui.AboutDlg;
import net.dieslunae.jgraphite.gui.Histogram;
import net.dieslunae.jgraphite.gui.ToneCurveChangeListener;
import net.dieslunae.jgraphite.model.ToneCurve;
import net.dieslunae.jgraphite.util.ImageFilter;
import net.dieslunae.jgraphite.util.Settings;

public class MainView
extends JFrame
implements ToneCurveChangeListener,
ActionListener,
ChangeListener,
MouseListener,
DropTargetListener {
    private static final long serialVersionUID = 8695054924691691520L;
    JCheckBox processCheckBox = null;
    JSlider vignettingSlider = null;
    JLabel thumbnail = null;
    ImageIcon thumbIcon = null;
    JSlider brightnessSlider = null;
    JCheckBox autoBrightnessCheckBox = null;
    Histogram histogram = null;
    JComboBox toneCurveCombo;
    JComboBox grayscaleTypeCombo;
    JButton saveCurveButton = null;
    JMenuBar menuBar = null;
    JMenu fileMenu = null;
    JMenuItem menuOpenImage = null;
    JMenuItem menuSaveImage = null;
    JMenuItem menuPreview = null;
    JMenuItem menuAbout = null;
    JMenuItem menuExit = null;
    JRadioButtonMenuItem menuJpgQualityLow = null;
    JRadioButtonMenuItem menuJpgQualityAverage = null;
    JRadioButtonMenuItem menuJpgQualityFine = null;
    DropTarget dropTarget = null;
    private JGraphiteController controller;

    public MainView(JGraphiteController ctrl) {
        this.controller = ctrl;
    }

    public void init() {
        this.upadeteWindowTitle(null);
        this.setDefaultCloseOperation(3);
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
        this.initSaveCurveButton();
        this.initMenus();
        this.initProcessCheckBox();
        this.initVignettingSlider();
        this.initThumbnail();
        this.initBrightnessSlider();
        this.initAutoBrightnessCheckBox();
        this.initToneCurveCombo();
        this.initHistogram();
        this.initGrayscaleTypeCombo();
        this.setJMenuBar(this.menuBar);
        Container p = this.getContentPane();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(10, 0, 0, 0);
        c.anchor = 18;
        p.add((Component)this.processCheckBox, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 18;
        c.insets = new Insets(25, 0, 0, 0);
        p.add((Component)new JLabel(Settings.TXT_GRAYSCALE_CONVERSION_TYPE), c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 18;
        p.add((Component)this.grayscaleTypeCombo, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.anchor = 18;
        c.insets = new Insets(25, 0, 0, 0);
        p.add((Component)new JLabel(Settings.TXT_VIGNETTING), c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        c.anchor = 18;
        p.add((Component)this.vignettingSlider, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 5;
        c.anchor = 18;
        c.insets = new Insets(25, 0, 0, 0);
        p.add((Component)new JLabel(Settings.TXT_GAMMA), c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 2;
        c.anchor = 18;
        p.add((Component)this.brightnessSlider, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 7;
        c.gridwidth = 2;
        c.anchor = 18;
        p.add((Component)this.autoBrightnessCheckBox, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 8;
        c.anchor = 18;
        c.insets = new Insets(25, 0, 0, 0);
        p.add((Component)new JLabel(Settings.TXT_TONE_CURVE), c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 9;
        c.gridwidth = 2;
        c.anchor = 18;
        c.fill = 1;
        p.add((Component)this.toneCurveCombo, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 10;
        c.gridwidth = 2;
        c.anchor = 18;
        c.insets = new Insets(20, 0, 0, 0);
        c.fill = 1;
        JLabel mouseInfo = new JLabel(Settings.TXT_MOUSE_USAGE);
        p.add((Component)mouseInfo, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 11;
        c.gridwidth = 2;
        c.anchor = 18;
        c.fill = 1;
        p.add((Component)this.histogram, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 12;
        c.gridwidth = 1;
        c.anchor = 18;
        c.insets = new Insets(10, 0, 10, 30);
        c.fill = 1;
        p.add((Component)this.saveCurveButton, c);
        c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 2;
        c.gridy = 0;
        c.gridheight = 13;
        c.anchor = 10;
        c.insets = new Insets(20, 20, 20, 20);
        p.add((Component)this.thumbnail, c);
        this.dropTarget = new DropTarget(this, this);
    }

    public void upadeteWindowTitle(String imageFileName) {
        String title = "JGraphite 0.5.8 (c)2010-2012 Ireneusz Kulaga";
        if (imageFileName == null) {
            this.setTitle(title);
        } else {
            this.setTitle(String.valueOf(title) + " - " + imageFileName);
        }
    }

    private void initMenus() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu(Settings.TXT_MENU_FILE);
        this.fileMenu.setMnemonic(70);
        this.menuBar.add(this.fileMenu);
        this.menuOpenImage = new JMenuItem(Settings.TXT_MENU_OPEN_IMAGE);
        this.menuOpenImage.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.menuOpenImage.addActionListener(this);
        this.fileMenu.add(this.menuOpenImage);
        this.menuSaveImage = new JMenuItem(Settings.TXT_MENU_SAVE_IMAGE);
        this.menuSaveImage.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.menuSaveImage.addActionListener(this);
        this.fileMenu.add(this.menuSaveImage);
        this.fileMenu.addSeparator();
        this.menuPreview = new JMenuItem(Settings.TXT_MENU_PREVIEW);
        this.menuPreview.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.menuPreview.addActionListener(this);
        this.fileMenu.add(this.menuPreview);
        this.fileMenu.addSeparator();
        this.menuAbout = new JMenuItem(Settings.TXT_MENU_ABOUT);
        this.menuAbout.addActionListener(this);
        this.fileMenu.add(this.menuAbout);
        this.fileMenu.addSeparator();
        this.menuExit = new JMenuItem(Settings.TXT_MENU_EXIT);
        this.menuExit.addActionListener(this);
        this.fileMenu.add(this.menuExit);
        JMenu settingsMenu = new JMenu(Settings.TXT_MENU_SETTINGS);
        settingsMenu.setMnemonic(83);
        JMenu menuJpgQuality = new JMenu(Settings.TXT_MENU_JPG_QUALITY);
        settingsMenu.add(menuJpgQuality);
        ButtonGroup menuJpgQualityGroup = new ButtonGroup();
        this.menuJpgQualityLow = new JRadioButtonMenuItem(Settings.TXT_MENU_QUALITY_LOW);
        this.menuJpgQualityLow.addActionListener(this);
        this.menuJpgQualityAverage = new JRadioButtonMenuItem(Settings.TXT_MENU_QUALITY_AVERAGE);
        this.menuJpgQualityAverage.addActionListener(this);
        this.menuJpgQualityFine = new JRadioButtonMenuItem(Settings.TXT_MENU_QUALITY_FINE);
        this.menuJpgQualityFine.setSelected(true);
        this.menuJpgQualityFine.addActionListener(this);
        menuJpgQualityGroup.add(this.menuJpgQualityLow);
        menuJpgQualityGroup.add(this.menuJpgQualityAverage);
        menuJpgQualityGroup.add(this.menuJpgQualityFine);
        menuJpgQuality.add(this.menuJpgQualityLow);
        menuJpgQuality.add(this.menuJpgQualityAverage);
        menuJpgQuality.add(this.menuJpgQualityFine);
        this.menuBar.add(settingsMenu);
    }

    private void initProcessCheckBox() {
        this.processCheckBox = new JCheckBox(Settings.TXT_PROCESS, Settings.PROCESS_IMAGE);
        this.processCheckBox.addActionListener(this);
    }

    private void initVignettingSlider() {
        this.vignettingSlider = new JSlider(0, 100, Settings.VIGNETTE_STRENGTH_IN_PERCENT);
        this.vignettingSlider.setMajorTickSpacing(25);
        this.vignettingSlider.setPaintLabels(true);
        this.vignettingSlider.addChangeListener(this);
        this.vignettingSlider.addMouseListener(this);
    }

    private void initBrightnessSlider() {
        this.brightnessSlider = new JSlider(-50, 50, Settings.BRIGHTNESS);
        this.brightnessSlider.setMajorTickSpacing(this.brightnessSlider.getMaximum());
        this.brightnessSlider.setPaintLabels(true);
        this.brightnessSlider.addChangeListener(this);
        this.brightnessSlider.addMouseListener(this);
        this.updateBrightnessSlider();
    }

    public void updateBrightnessSlider() {
        if (Settings.AUTO_BRIGHTNESS) {
            this.brightnessSlider.setValue(this.controller.getAutoBrightnessLevel());
        } else {
            this.brightnessSlider.setValue(Settings.BRIGHTNESS);
        }
        this.brightnessSlider.setEnabled(!Settings.AUTO_BRIGHTNESS);
    }

    private void initAutoBrightnessCheckBox() {
        this.autoBrightnessCheckBox = new JCheckBox(Settings.TXT_AUTO_BRIGHTNESS, Settings.AUTO_BRIGHTNESS);
        this.autoBrightnessCheckBox.addActionListener(this);
    }

    private void initToneCurveCombo() {
        this.toneCurveCombo = new JComboBox();
        this.toneCurveCombo.addActionListener(this);
        this.updateToneCurveCombo();
    }

    private void updateToneCurveCombo() {
        List<ToneCurve> curves = Settings.getToneCurves();
        String[] names = new String[curves.size()];
        int i = 0;
        while (i < curves.size()) {
            names[i] = curves.get(i).getName();
            ++i;
        }
        this.toneCurveCombo.setModel(new DefaultComboBoxModel<String>(names));
        this.toneCurveCombo.setSelectedIndex(Settings.TONE_CURVE);
    }

    private void initGrayscaleTypeCombo() {
        Settings.ConversionType[] types = Settings.ConversionType.values();
        this.grayscaleTypeCombo = new JComboBox<Settings.ConversionType>(types);
        this.grayscaleTypeCombo.setSelectedIndex(Settings.CONVERTSION_TYPE.ordinal());
        this.grayscaleTypeCombo.addActionListener(this);
    }

    private void initHistogram() {
        this.histogram = new Histogram();
        this.histogram.setMinimumSize(new Dimension(100, 110));
        this.histogram.setPreferredSize(new Dimension(100, 110));
        this.histogram.addToneCurveChangeListener(this);
    }

    private void initThumbnail() {
        this.thumbnail = new JLabel();
        this.thumbIcon = new ImageIcon();
        this.thumbnail.setIcon(this.thumbIcon);
        this.thumbnail.setPreferredSize(new Dimension(480, 480));
    }

    private void initSaveCurveButton() {
        this.saveCurveButton = new JButton(Settings.TXT_SAVE_CURVE);
        this.saveCurveButton.addActionListener(this);
        this.saveCurveButton.setEnabled(false);
    }

    public void setThumbnail(Image img) {
        this.thumbIcon.setImage(img);
        this.thumbnail.repaint();
    }

    public void upadateHistogram(BufferedImage img) {
        this.histogram.setImage(img);
        this.histogram.repaint();
    }

    public void updateToneCurve(ToneCurve tc) {
        this.histogram.setToneCurve(tc);
    }

    public void setToneCurveSelection(int i) {
        this.toneCurveCombo.setSelectedIndex(i);
    }

    @Override
    public void toneCurveChanged(ToneCurve newCurve) {
        this.controller.setCustomCurve(newCurve);
        this.saveCurveButton.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String name;
        Object source = e.getSource();
        if (source == this.menuOpenImage) {
            this.controller.loadImage();
        } else if (source == this.menuSaveImage) {
            this.controller.saveImage();
        } else if (source == this.menuAbout) {
            AboutDlg.show();
        } else if (source == this.processCheckBox) {
            Settings.PROCESS_IMAGE = !Settings.PROCESS_IMAGE;
            this.controller.processImage();
        } else if (source == this.autoBrightnessCheckBox) {
            this.controller.autoBrightnessChanged();
        } else if (source == this.toneCurveCombo) {
            this.controller.changeToneCurve(this.toneCurveCombo.getSelectedIndex());
            if (this.toneCurveCombo.getSelectedIndex() == Settings.TONE_CURVE_INDEX_OF_CUSTOM && Settings.getToneCurves().get(Settings.TONE_CURVE).getPointsCount() > 2) {
                this.saveCurveButton.setEnabled(true);
            } else {
                this.saveCurveButton.setEnabled(false);
            }
        } else if (source == this.grayscaleTypeCombo) {
            this.controller.changeGrayscaleConversionType((Settings.ConversionType)((Object)this.grayscaleTypeCombo.getSelectedItem()));
        } else if (source == this.menuExit) {
            System.exit(0);
        } else if (source == this.menuJpgQualityLow) {
            Settings.OUTPUT_JPG_QUALITY = 0.85f;
        } else if (source == this.menuJpgQualityAverage) {
            Settings.OUTPUT_JPG_QUALITY = 0.9f;
        } else if (source == this.menuJpgQualityFine) {
            Settings.OUTPUT_JPG_QUALITY = 0.97f;
        } else if (source == this.menuPreview) {
            this.controller.displayPreview();
        } else if (source == this.saveCurveButton && (name = JOptionPane.showInputDialog(this, (Object)Settings.TXT_NAME)) != null && name.length() > 0) {
            Settings.TONE_CURVE = Settings.addToneCurve(new ToneCurve("_" + name, this.histogram.getPoints()));
            this.updateToneCurveCombo();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == this.vignettingSlider) {
            Settings.VIGNETTE_STRENGTH_IN_PERCENT = this.vignettingSlider.getValue();
            this.controller.processImage();
        } else if (source == this.brightnessSlider) {
            Settings.BRIGHTNESS = this.brightnessSlider.getValue();
            this.controller.processImage();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        boolean doubleClick;
        Object source = e.getSource();
        boolean bl = doubleClick = e.getClickCount() == 2;
        if (source == this.vignettingSlider && doubleClick) {
            Settings.VIGNETTE_STRENGTH_IN_PERCENT = 50;
            this.vignettingSlider.setValue(Settings.VIGNETTE_STRENGTH_IN_PERCENT);
        } else if (source == this.brightnessSlider && doubleClick) {
            Settings.BRIGHTNESS = 0;
            this.brightnessSlider.setValue(Settings.BRIGHTNESS);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Transferable tr = dtde.getTransferable();
        DataFlavor[] flavors = tr.getTransferDataFlavors();
        int i = 0;
        while (i < flavors.length) {
            if (flavors[i].isFlavorJavaFileListType()) {
                dtde.acceptDrop(3);
                try {
                    List list = (List)tr.getTransferData(flavors[i]);
                    if (list.size() > 0) {
                        this.controller.loadImage(list.get(0).toString());
                    }
                    dtde.dropComplete(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public String getLoadImagePath(String defaultPath) {
        JFileChooser fChooser = new JFileChooser(defaultPath);
        fChooser.setFileFilter(new ImageFilter());
        int retCode = fChooser.showOpenDialog(null);
        if (retCode != 0) {
            return null;
        }
        return fChooser.getSelectedFile().getPath();
    }

    public String getSaveImagePath(String defaultPath) {
        JFileChooser fChooser = new JFileChooser(Settings.getLastImagePath());
        fChooser.setFileFilter(new ImageFilter());
        fChooser.setSelectedFile(new File(defaultPath));
        int retCode = fChooser.showSaveDialog(null);
        if (retCode != 0) {
            return null;
        }
        return fChooser.getSelectedFile().getPath();
    }

    public void displayBusyCursor() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void displayNormalCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }
}

