/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifDirectory;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.iptc.IptcReader;
import com.drew.metadata.jpeg.JpegCommentReader;
import com.drew.metadata.jpeg.JpegReader;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class JpegMetadataReader {
    static /* synthetic */ Class class$0;

    public static Metadata readMetadata(InputStream inputStream) throws JpegProcessingException {
        JpegSegmentReader jpegSegmentReader = new JpegSegmentReader(inputStream);
        return JpegMetadataReader.U_extractJpegSegmentReaderMetadata(jpegSegmentReader);
    }

    public static Metadata readMetadata(File file) throws JpegProcessingException {
        JpegSegmentReader jpegSegmentReader = new JpegSegmentReader(file);
        return JpegMetadataReader.U_extractJpegSegmentReaderMetadata(jpegSegmentReader);
    }

    private static Metadata U_extractJpegSegmentReaderMetadata(JpegSegmentReader jpegSegmentReader) {
        byte[] byArray;
        Metadata metadata = new Metadata();
        try {
            byArray = jpegSegmentReader.readSegment((byte)-31);
            new ExifReader(byArray).extract(metadata);
        }
        catch (JpegProcessingException jpegProcessingException) {
            // empty catch block
        }
        try {
            byArray = jpegSegmentReader.readSegment((byte)-19);
            new IptcReader(byArray).extract(metadata);
        }
        catch (JpegProcessingException jpegProcessingException) {
            // empty catch block
        }
        try {
            byArray = jpegSegmentReader.readSegment((byte)-64);
            new JpegReader(byArray).extract(metadata);
        }
        catch (JpegProcessingException jpegProcessingException) {
            // empty catch block
        }
        try {
            byArray = jpegSegmentReader.readSegment((byte)-2);
            new JpegCommentReader(byArray).extract(metadata);
        }
        catch (JpegProcessingException jpegProcessingException) {
            // empty catch block
        }
        return metadata;
    }

    public static Metadata readMetadata(JPEGDecodeParam jPEGDecodeParam) {
        byte[][] byArray;
        byte[][] byArray2;
        Metadata metadata = new Metadata();
        byte[][] byArray3 = jPEGDecodeParam.getMarkerData(225);
        if (byArray3 != null && byArray3[0].length > 0) {
            new ExifReader(byArray3[0]).extract(metadata);
        }
        if ((byArray2 = jPEGDecodeParam.getMarkerData(237)) != null && byArray2[0].length > 0) {
            new IptcReader(byArray2[0]).extract(metadata);
        }
        if ((byArray = jPEGDecodeParam.getMarkerData(254)) != null && byArray[0].length > 0) {
            new JpegCommentReader(byArray[0]).extract(metadata);
        }
        return metadata;
    }

    private JpegMetadataReader() {
    }

    public static void main(String[] stringArray) throws MetadataException, IOException {
        Directory directory;
        JpegMetadataReader jpegMetadataReader = new JpegMetadataReader();
        Metadata metadata = null;
        try {
            metadata = JpegMetadataReader.readMetadata(new File(stringArray[0]));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(1);
        }
        Iterator iterator2 = metadata.getDirectoryIterator();
        while (iterator2.hasNext()) {
            Object object;
            directory = (Directory)iterator2.next();
            Iterator iterator3 = directory.getTagIterator();
            while (iterator3.hasNext()) {
                object = (Tag)iterator3.next();
                try {
                    System.out.println("[" + directory.getName() + "] " + ((Tag)object).getTagName() + " = " + ((Tag)object).getDescription());
                }
                catch (MetadataException metadataException) {
                    System.err.println(metadataException.getMessage());
                    System.err.println(String.valueOf(((Tag)object).getDirectoryName()) + " " + ((Tag)object).getTagName() + " (error)");
                }
            }
            if (!directory.hasErrors()) continue;
            object = directory.getErrors();
            while (object.hasNext()) {
                System.out.println("ERROR: " + object.next());
            }
        }
        if (stringArray.length > 1 && stringArray[1].trim().equals("/thumb")) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.drew.metadata.exif.ExifDirectory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (((ExifDirectory)(directory = (ExifDirectory)metadata.getDirectory(clazz))).containsThumbnail()) {
                System.out.println("Writing thumbnail...");
                ((ExifDirectory)directory).writeThumbnail(String.valueOf(stringArray[0].trim()) + ".thumb.jpg");
            } else {
                System.out.println("No thumbnail data exists in this image");
            }
        }
    }
}

