/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.TagDescriptor;

public class FujifilmMakernoteDescriptor
extends TagDescriptor {
    public FujifilmMakernoteDescriptor(Directory directory) {
        super(directory);
    }

    public String getDescription(int n) throws MetadataException {
        switch (n) {
            case 4097: {
                return this.UU_getSharpnessDescription();
            }
            case 4098: {
                return this.uV_getWhiteBalanceDescription();
            }
            case 4099: {
                return this.VU_getColorDescription();
            }
            case 4100: {
                return this.vV_getToneDescription();
            }
            case 4112: {
                return this.uU_getFlashModeDescription();
            }
            case 4113: {
                return this.Uv_getFlashStrengthDescription();
            }
            case 4128: {
                return this.vU_getMacroDescription();
            }
            case 4129: {
                return this.Vv_getFocusModeDescription();
            }
            case 4144: {
                return this.Uu_getSlowSyncDescription();
            }
            case 4145: {
                return this.uv_getPictureModeDescription();
            }
            case 4352: {
                return this.Vu_getContinuousTakingOrAutoBrackettingDescription();
            }
            case 4864: {
                return this.UV_getBlurWarningDescription();
            }
            case 4865: {
                return this.uu_getFocusWarningDescription();
            }
            case 4866: {
                return this.VV_getAutoExposureWarningDescription();
            }
        }
        return this._directory.getString(n);
    }

    private String VV_getAutoExposureWarningDescription() throws MetadataException {
        if (!this._directory.containsTag(4866)) {
            return null;
        }
        int n = this._directory.getInt(4866);
        switch (n) {
            case 0: {
                return "AE good";
            }
            case 1: {
                return "Over exposed (>1/1000s @ F11)";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String uu_getFocusWarningDescription() throws MetadataException {
        if (!this._directory.containsTag(4865)) {
            return null;
        }
        int n = this._directory.getInt(4865);
        switch (n) {
            case 0: {
                return "Auto focus good";
            }
            case 1: {
                return "Out of focus";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String UV_getBlurWarningDescription() throws MetadataException {
        if (!this._directory.containsTag(4864)) {
            return null;
        }
        int n = this._directory.getInt(4864);
        switch (n) {
            case 0: {
                return "No blur warning";
            }
            case 1: {
                return "Blur warning";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String Vu_getContinuousTakingOrAutoBrackettingDescription() throws MetadataException {
        if (!this._directory.containsTag(4352)) {
            return null;
        }
        int n = this._directory.getInt(4352);
        switch (n) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "On";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String uv_getPictureModeDescription() throws MetadataException {
        if (!this._directory.containsTag(4145)) {
            return null;
        }
        int n = this._directory.getInt(4145);
        switch (n) {
            case 0: {
                return "Auto";
            }
            case 1: {
                return "Portrait scene";
            }
            case 2: {
                return "Landscape scene";
            }
            case 4: {
                return "Sports scene";
            }
            case 5: {
                return "Night scene";
            }
            case 6: {
                return "Program AE";
            }
            case 256: {
                return "Aperture priority AE";
            }
            case 512: {
                return "Shutter priority AE";
            }
            case 768: {
                return "Manual exposure";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String Uu_getSlowSyncDescription() throws MetadataException {
        if (!this._directory.containsTag(4144)) {
            return null;
        }
        int n = this._directory.getInt(4144);
        switch (n) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "On";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String Vv_getFocusModeDescription() throws MetadataException {
        if (!this._directory.containsTag(4129)) {
            return null;
        }
        int n = this._directory.getInt(4129);
        switch (n) {
            case 0: {
                return "Auto focus";
            }
            case 1: {
                return "Manual focus";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String vU_getMacroDescription() throws MetadataException {
        if (!this._directory.containsTag(4128)) {
            return null;
        }
        int n = this._directory.getInt(4128);
        switch (n) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "On";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String Uv_getFlashStrengthDescription() throws MetadataException {
        if (!this._directory.containsTag(4113)) {
            return null;
        }
        Rational rational = this._directory.getRational(4113);
        return String.valueOf(rational.toSimpleString(false)) + " eV (Apex)";
    }

    private String uU_getFlashModeDescription() throws MetadataException {
        if (!this._directory.containsTag(4112)) {
            return null;
        }
        int n = this._directory.getInt(4112);
        switch (n) {
            case 0: {
                return "Auto";
            }
            case 1: {
                return "On";
            }
            case 2: {
                return "Off";
            }
            case 3: {
                return "Red-eye reduction";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String vV_getToneDescription() throws MetadataException {
        if (!this._directory.containsTag(4100)) {
            return null;
        }
        int n = this._directory.getInt(4100);
        switch (n) {
            case 0: {
                return "Normal (STD)";
            }
            case 256: {
                return "High (HARD)";
            }
            case 512: {
                return "Low (ORG)";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String VU_getColorDescription() throws MetadataException {
        if (!this._directory.containsTag(4099)) {
            return null;
        }
        int n = this._directory.getInt(4099);
        switch (n) {
            case 0: {
                return "Normal (STD)";
            }
            case 256: {
                return "High";
            }
            case 512: {
                return "Low (ORG)";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String uV_getWhiteBalanceDescription() throws MetadataException {
        if (!this._directory.containsTag(4098)) {
            return null;
        }
        int n = this._directory.getInt(4098);
        switch (n) {
            case 0: {
                return "Auto";
            }
            case 256: {
                return "Daylight";
            }
            case 512: {
                return "Cloudy";
            }
            case 768: {
                return "DaylightColor-fluorescence";
            }
            case 769: {
                return "DaywhiteColor-fluorescence";
            }
            case 770: {
                return "White-fluorescence";
            }
            case 1024: {
                return "Incandenscense";
            }
            case 3840: {
                return "Custom white balance";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String UU_getSharpnessDescription() throws MetadataException {
        if (!this._directory.containsTag(4097)) {
            return null;
        }
        int n = this._directory.getInt(4097);
        switch (n) {
            case 1: 
            case 2: {
                return "Soft";
            }
            case 3: {
                return "Normal";
            }
            case 4: 
            case 5: {
                return "Hard";
            }
        }
        return "Unknown (" + n + ")";
    }
}

