/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.TagDescriptor;

public class NikonType2MakernoteDescriptor
extends TagDescriptor {
    public NikonType2MakernoteDescriptor(Directory directory) {
        super(directory);
    }

    public String getDescription(int n) throws MetadataException {
        switch (n) {
            case 2: {
                return this.U_getIsoSettingDescription();
            }
            case 134: {
                return this.u_getDigitalZoomDescription();
            }
            case 136: {
                return this.V_getAutoFocusPositionDescription();
            }
        }
        return this._directory.getString(n);
    }

    private String V_getAutoFocusPositionDescription() throws MetadataException {
        if (!this._directory.containsTag(136)) {
            return null;
        }
        int[] nArray = this._directory.getIntArray(136);
        if (nArray.length != 4 || nArray[0] != 0 || nArray[2] != 0 || nArray[3] != 0) {
            return "Unknown (" + this._directory.getString(136) + ")";
        }
        switch (nArray[1]) {
            case 0: {
                return "Centre";
            }
            case 1: {
                return "Top";
            }
            case 2: {
                return "Bottom";
            }
            case 3: {
                return "Left";
            }
            case 4: {
                return "Right";
            }
        }
        return "Unknown (" + nArray[1] + ")";
    }

    private String u_getDigitalZoomDescription() throws MetadataException {
        if (!this._directory.containsTag(134)) {
            return null;
        }
        Rational rational = this._directory.getRational(134);
        if (rational.intValue() == 1) {
            return "No digital zoom";
        }
        return String.valueOf(rational.toSimpleString(true)) + "x digital zoom";
    }

    private String U_getIsoSettingDescription() throws MetadataException {
        if (!this._directory.containsTag(2)) {
            return null;
        }
        int[] nArray = this._directory.getIntArray(2);
        if (nArray[0] != 0 || nArray[1] == 0) {
            return "Unknown (" + this._directory.getString(2) + ")";
        }
        return "ISO " + nArray[1];
    }
}

