/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.DefaultImageFilter;
import imager.ImageFilterProcessor;

public class ArithmeticFilter
extends ImageFilterProcessor {
    public static final int ADD = 0;
    public static final int SUBTRACT = 1;
    public static final int DIFFERENCE = 2;
    public static final int MULTIPLY = 3;
    public static final int DARKEST = 4;
    public static final int LIGHTEST = 5;
    public static final int AVERAGE = 6;
    public static final int AND = 7;
    public static final int OR = 8;
    public static final int WEIGTAGE = 9;
    int m_Operation;
    float m_Weightage = 0.0f;

    public ArithmeticFilter(int n, float f) {
        this.m_Operation = n;
        this.m_Weightage = f;
    }

    public void setWeightage(float f) {
        this.m_Weightage = f;
    }

    public ArithmeticFilter(int n) {
        this.m_Operation = n;
    }

    public int[] processPixels(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[n * n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                int n5 = DefaultImageFilter.getRed(nArray[n3 * n + n4]);
                int n6 = DefaultImageFilter.getGreen(nArray[n3 * n + n4]);
                int n7 = DefaultImageFilter.getBlue(nArray[n3 * n + n4]);
                int n8 = DefaultImageFilter.getRed(nArray[n3 * n + n4 + n * n2]);
                int n9 = DefaultImageFilter.getGreen(nArray[n3 * n + n4 + n * n2]);
                int n10 = DefaultImageFilter.getBlue(nArray[n3 * n + n4 + n * n2]);
                switch (this.m_Operation) {
                    case 0: {
                        n5 += n8;
                        n6 += n9;
                        n7 += n10;
                        break;
                    }
                    case 1: {
                        n5 -= n8;
                        n6 -= n9;
                        n7 -= n10;
                        break;
                    }
                    case 2: {
                        n5 = Math.abs(n5 - n8);
                        n6 = Math.abs(n6 - n9);
                        n7 = Math.abs(n7 - n10);
                        break;
                    }
                    case 3: {
                        n5 *= n8;
                        n6 *= n9;
                        n7 *= n10;
                        break;
                    }
                    case 4: {
                        n5 = n5 < n8 ? n5 : n8;
                        n6 = n6 < n9 ? n6 : n9;
                        n7 = n7 < n10 ? n7 : n10;
                        break;
                    }
                    case 5: {
                        n5 = n5 > n8 ? n5 : n8;
                        n6 = n6 > n9 ? n6 : n9;
                        n7 = n7 > n10 ? n7 : n10;
                        break;
                    }
                    case 6: {
                        n5 = (n5 + n8) / 2;
                        n6 = (n6 + n9) / 2;
                        n7 = (n7 + n10) / 2;
                        break;
                    }
                    case 7: {
                        n5 &= n8;
                        n6 &= n9;
                        n7 &= n10;
                        break;
                    }
                    case 8: {
                        n5 |= n8;
                        n6 |= n9;
                        n7 |= n10;
                        break;
                    }
                    case 9: {
                        n5 = (int)((float)n5 * this.m_Weightage + (float)n8 * (1.0f - this.m_Weightage));
                        n6 = (int)((float)n6 * this.m_Weightage + (float)n9 * (1.0f - this.m_Weightage));
                        n7 = (int)((float)n7 * this.m_Weightage + (float)n10 * (1.0f - this.m_Weightage));
                    }
                }
                nArray2[n3 * n + n4] = DefaultImageFilter.getPixel(n5, n6, n7);
                ++n4;
            }
            this.m_PercentProgress = n3 * 100 / n2;
            ++n3;
        }
        return nArray2;
    }
}

