/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.FolderChooser;
import imager.FormatPanel;
import imager.HelpBrowser;
import imager.ImageLoadingThread;
import imager.ImageSavingThread;
import imager.ImageWrapper;
import imager.ImagerGlobal;
import imager.RegistrationValidator;
import imager.RenamePanel;
import imager.ResizePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class BatchOpPanel
extends JPanel
implements PropertyChangeListener,
ImageWrapper,
Runnable {
    BorderLayout borderLayout1 = new BorderLayout();
    private JSplitPane UUU_jSplitPane1 = new JSplitPane();
    private JPanel VvU_jPanel1 = new JPanel();
    DefaultListModel lm = new DefaultListModel();
    private BorderLayout vuU_borderLayout2 = new BorderLayout();
    private ImageFilenameFilter VuV_fileFilter = new ImageFilenameFilter();
    File currentFolder;
    private JPanel vVV_jPanel2 = new JPanel();
    private JList VVu_jList1 = new JList(this.lm);
    private JScrollPane vUu_jScrollPane1 = new JScrollPane();
    private JPanel VUv_jPanel4 = new JPanel();
    private BorderLayout uvv_borderLayout4 = new BorderLayout();
    private JButton VUU_jButton1 = new JButton();
    private JLabel uvU_jLabel1 = new JLabel();
    private FlowLayout UvV_flowLayout1 = new FlowLayout();
    private JPanel uuV_jPanel3 = new JPanel();
    private ResizePanel Uuu_m_ResizePanel = new ResizePanel();
    private JTabbedPane uVu_jTabbedPane1 = new JTabbedPane();
    private BorderLayout UVv_borderLayout3 = new BorderLayout();
    private JPanel uUv_jPanel5 = new JPanel();
    private JButton UVU_m_ProcessButton = new JButton();
    private JButton uUU_m_AbortButton = new JButton();
    private JButton UUV_m_HelpButton = new JButton();
    private HelpBrowser VvV_m_Help;
    private JProgressBar vuV_jProgressBar1 = new JProgressBar();
    Component m_Owner;
    private static int Vuu_m_nAppType = ImagerGlobal.getAppType();
    ImageLoadingThread imageLoadingThread = new ImageLoadingThread(this);
    ImageSavingThread imageSavingThread = new ImageSavingThread(this, BatchOpPanel.getAppType());
    private boolean vVu_process = true;
    private int VVv_currentImageCount = 0;
    private String vUv_targetDirectoryName = "";
    ThreadGroup loadingThreadGroup = new ThreadGroup("Image Loading threads");
    ThreadGroup savingThreadGroup = new ThreadGroup("Image Saving threads");
    private JPanel VVU_jPanel6 = new JPanel();
    private JCheckBox vUU_m_RenameCheckBox = new JCheckBox();
    private JCheckBox VUV_m_ResizeCheckBox = new JCheckBox();
    private JCheckBox uvV_m_FormatChangeCheckBox = new JCheckBox();
    private RenamePanel Uvu_m_RenamePanel = new RenamePanel();
    private JComboBox uuu_jComboBox1 = new JComboBox();
    private JPanel Uuv_jPanel7 = new JPanel();
    private JFileChooser uVv_jFileChooser1 = new FolderChooser();
    private JPanel UuU_jPanel8 = new JPanel();
    private JRadioButton uVU_m_ChooseFolderRadioButton = new JRadioButton();
    private JRadioButton UVV_m_SameFolderRadioButton = new JRadioButton();
    private JTextField uUV_m_TargetFolderTextField = new JTextField();
    private JButton UUu_m_TargetBrowseButton = new JButton();
    private ButtonGroup Vvu_buttonGroup1 = new ButtonGroup();
    private ButtonGroup vuu_buttonGroup2 = new ButtonGroup();
    private int Vuv_completedCount = 0;
    private int vVv_loadingFailedCount = 0;
    private int VuU_savingFailedCount = 0;
    private int vVU_operationFailedCount = 0;
    private JPanel VVV_jPanel9 = new JPanel();
    private JRadioButton vUV_m_DoNotSaveRadioButton = new JRadioButton();
    private JRadioButton VUu_m_PromptRadioButton = new JRadioButton();
    private JRadioButton uvu_m_OverwriteRadioButton = new JRadioButton();
    private Border Uvv_border1;
    private TitledBorder uuv_titledBorder1;
    boolean abortHandled = false;
    private FormatPanel UvU_m_FormatPanel = new FormatPanel();
    static /* synthetic */ Class class$0;

    public static int getAppType() {
        return Vuu_m_nAppType;
    }

    public BatchOpPanel(Component component, JFrame jFrame) {
        try {
            RegistrationValidator registrationValidator;
            if (!(Vuu_m_nAppType != 101 && Vuu_m_nAppType != 201 || (registrationValidator = new RegistrationValidator(jFrame)).validate())) {
                System.out.println("JPhotoBatch is not registered..Quitting");
                System.out.println("Please register JPhotoBatch athttp://www.jphotobrushpro.com");
                System.exit(0);
            }
            this.jbInit();
            this.m_Owner = component;
            this.currentFolder = this.uVv_jFileChooser1.getSelectedFile();
            this.uVv_jFileChooser1.addPropertyChangeListener(this);
            this.uVv_jFileChooser1.setDialogTitle("Browse Directories");
            this.uVv_jFileChooser1.setFileSelectionMode(1);
            this.uVv_jFileChooser1.setPreferredSize(new Dimension(300, 400));
            this.uVv_jFileChooser1.setMinimumSize(this.uVv_jFileChooser1.getPreferredSize());
            this.UUU_jSplitPane1.setDividerLocation(320);
            this.enableEvents(64L);
            this.VVu_jList1.getInputMap().put(KeyStroke.getKeyStroke(127, 0, false), "Delete");
            this.VVu_jList1.getActionMap().put("Delete", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BatchOpPanel.this.uuU_deleteFiles();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void uuU_deleteFiles() {
        Object[] objectArray = this.VVu_jList1.getSelectedValues();
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to delete the selected files?", "JPhotoBatch Query", 0) != 0) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            File file = new File(this.currentFolder + File.separator + (String)objectArray[n]);
            file.delete();
            ++n;
        }
        this.UuV_refreshFileList();
    }

    void jbInit() throws Exception {
        this.Uvv_border1 = BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 156));
        this.uuv_titledBorder1 = new TitledBorder(this.Uvv_border1, "If destination file exist ?");
        this.setLayout(this.borderLayout1);
        this.VvU_jPanel1.setLayout(this.vuU_borderLayout2);
        this.VVu_jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                BatchOpPanel.this.jList1_valueChanged(listSelectionEvent);
            }
        });
        this.vUu_jScrollPane1.setMinimumSize(new Dimension(22, 300));
        this.vUu_jScrollPane1.setPreferredSize(new Dimension(274, 200));
        this.VUv_jPanel4.setLayout(this.UvV_flowLayout1);
        this.VUU_jButton1.setText("Select All");
        this.VUU_jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BatchOpPanel.this.jButton1_actionPerformed(actionEvent);
            }
        });
        this.uvU_jLabel1.setText("no files selected        ");
        this.UvV_flowLayout1.setAlignment(0);
        this.uVu_jTabbedPane1.setPreferredSize(new Dimension(5, 250));
        this.uuV_jPanel3.setLayout(this.UVv_borderLayout3);
        this.UVU_m_ProcessButton.setEnabled(false);
        this.UVU_m_ProcessButton.setText("Process");
        this.UVU_m_ProcessButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BatchOpPanel.this.m_ProcessButton_actionPerformed(actionEvent);
            }
        });
        this.uUU_m_AbortButton.setEnabled(false);
        this.uUU_m_AbortButton.setText("Abort");
        this.uUU_m_AbortButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BatchOpPanel.this.m_AbortButton_actionPerformed(actionEvent);
            }
        });
        this.UUV_m_HelpButton.setEnabled(true);
        this.UUV_m_HelpButton.setText("Help");
        this.UUV_m_HelpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BatchOpPanel.this.Vvv_displayHelpBrowser();
            }
        });
        this.vuV_jProgressBar1.setStringPainted(true);
        this.VVU_jPanel6.setPreferredSize(new Dimension(10, 30));
        this.vUU_m_RenameCheckBox.setSelected(true);
        this.vUU_m_RenameCheckBox.setText("Rename");
        this.VUV_m_ResizeCheckBox.setText("Resize");
        this.uvV_m_FormatChangeCheckBox.setText("Format Change");
        this.uVU_m_ChooseFolderRadioButton.setText("Choose destination directory:");
        this.uVU_m_ChooseFolderRadioButton.setBounds(new Rectangle(13, 73, 191, 25));
        this.uVU_m_ChooseFolderRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BatchOpPanel.this.m_ChooseFolderRadioButton_itemStateChanged(itemEvent);
            }
        });
        this.UVV_m_SameFolderRadioButton.setToolTipText("");
        this.UVV_m_SameFolderRadioButton.setSelected(true);
        this.UVV_m_SameFolderRadioButton.setText("Destination directory is same as source directory");
        this.UVV_m_SameFolderRadioButton.setBounds(new Rectangle(13, 50, 305, 25));
        this.UuU_jPanel8.setLayout(null);
        this.UuU_jPanel8.setPreferredSize(new Dimension(100, 140));
        this.uUV_m_TargetFolderTextField.setEnabled(false);
        this.uUV_m_TargetFolderTextField.setBounds(new Rectangle(13, 103, 208, 24));
        this.UUu_m_TargetBrowseButton.setBounds(new Rectangle(230, 102, 85, 26));
        this.UUu_m_TargetBrowseButton.setEnabled(false);
        this.UUu_m_TargetBrowseButton.setFont(new Font("Dialog", 0, 12));
        this.UUu_m_TargetBrowseButton.setText("Browse");
        this.UUu_m_TargetBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BatchOpPanel.this.m_TargetBrowseButton_actionPerformed(actionEvent);
            }
        });
        this.VVV_jPanel9.setBorder(this.uuv_titledBorder1);
        this.VVV_jPanel9.setBounds(new Rectangle(4, 3, 305, 49));
        this.VVV_jPanel9.setLayout(null);
        this.vUV_m_DoNotSaveRadioButton.setText("Don't save");
        this.vUV_m_DoNotSaveRadioButton.setBounds(new Rectangle(200, 17, 96, 25));
        this.VUu_m_PromptRadioButton.setText("Prompt");
        this.VUu_m_PromptRadioButton.setBounds(new Rectangle(107, 17, 76, 25));
        this.uvu_m_OverwriteRadioButton.setSelected(true);
        this.uvu_m_OverwriteRadioButton.setText("Overwrite");
        this.uvu_m_OverwriteRadioButton.setBounds(new Rectangle(11, 17, 81, 25));
        this.add((Component)this.UUU_jSplitPane1, "Center");
        this.UUU_jSplitPane1.add((Component)this.VvU_jPanel1, "right");
        this.VvU_jPanel1.add((Component)this.vVV_jPanel2, "Center");
        this.vUu_jScrollPane1.setViewportView(this.VVu_jList1);
        this.vVV_jPanel2.setLayout(this.uvv_borderLayout4);
        this.vVV_jPanel2.add((Component)this.vUu_jScrollPane1, "Center");
        this.vVV_jPanel2.add((Component)this.VUv_jPanel4, "North");
        this.vVV_jPanel2.add((Component)this.VVU_jPanel6, "South");
        this.VVU_jPanel6.add((Component)this.vUU_m_RenameCheckBox, null);
        this.VVU_jPanel6.add((Component)this.VUV_m_ResizeCheckBox, null);
        this.VVU_jPanel6.add((Component)this.uvV_m_FormatChangeCheckBox, null);
        this.VUv_jPanel4.add((Component)this.VUU_jButton1, null);
        this.VUv_jPanel4.add((Component)this.uvU_jLabel1, null);
        FileFilter[] fileFilterArray = ImagerGlobal.SaveImageFileChooser.getChoosableFileFilters();
        this.uuu_jComboBox1.addItem("All Images");
        int n = 0;
        while (n < fileFilterArray.length) {
            this.uuu_jComboBox1.addItem(fileFilterArray[n].getDescription());
            ++n;
        }
        this.VUv_jPanel4.add((Component)this.uuu_jComboBox1, null);
        this.uuu_jComboBox1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BatchOpPanel.this.UuV_refreshFileList();
            }
        });
        this.VvU_jPanel1.add((Component)this.uuV_jPanel3, "South");
        this.uuV_jPanel3.add((Component)this.uVu_jTabbedPane1, "Center");
        this.uuV_jPanel3.add((Component)this.uUv_jPanel5, "South");
        this.uUv_jPanel5.add((Component)this.UVU_m_ProcessButton, null);
        this.uUv_jPanel5.add((Component)this.uUU_m_AbortButton, null);
        this.uUv_jPanel5.add((Component)this.UUV_m_HelpButton, null);
        this.uUv_jPanel5.add((Component)this.vuV_jProgressBar1, null);
        this.UUU_jSplitPane1.add((Component)this.Uuv_jPanel7, "left");
        this.Uuv_jPanel7.setLayout(new BorderLayout());
        this.Uuv_jPanel7.add((Component)this.uVv_jFileChooser1, "Center");
        this.Uuv_jPanel7.add((Component)this.UuU_jPanel8, "South");
        this.UuU_jPanel8.add((Component)this.VVV_jPanel9, null);
        this.VVV_jPanel9.add((Component)this.uvu_m_OverwriteRadioButton, null);
        this.VVV_jPanel9.add((Component)this.vUV_m_DoNotSaveRadioButton, null);
        this.VVV_jPanel9.add((Component)this.VUu_m_PromptRadioButton, null);
        this.UuU_jPanel8.add((Component)this.UVV_m_SameFolderRadioButton, null);
        this.UuU_jPanel8.add((Component)this.uVU_m_ChooseFolderRadioButton, null);
        this.UuU_jPanel8.add((Component)this.uUV_m_TargetFolderTextField, null);
        this.UuU_jPanel8.add((Component)this.UUu_m_TargetBrowseButton, null);
        this.uVu_jTabbedPane1.add((Component)this.Uvu_m_RenamePanel, "Rename");
        this.uVu_jTabbedPane1.add((Component)this.Uuu_m_ResizePanel, "Resize");
        this.uVu_jTabbedPane1.add((Component)this.UvU_m_FormatPanel, "Format Change");
        this.Vvu_buttonGroup1.add(this.UVV_m_SameFolderRadioButton);
        this.Vvu_buttonGroup1.add(this.uVU_m_ChooseFolderRadioButton);
        this.vuu_buttonGroup2.add(this.vUV_m_DoNotSaveRadioButton);
        this.vuu_buttonGroup2.add(this.VUu_m_PromptRadioButton);
        this.vuu_buttonGroup2.add(this.uvu_m_OverwriteRadioButton);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("SelectedFileChangedProperty")) {
            this.currentFolder = (File)propertyChangeEvent.getNewValue();
            this.UuV_refreshFileList();
        }
    }

    private void UuV_refreshFileList() {
        if (this.currentFolder == null) {
            return;
        }
        String[] stringArray = this.currentFolder.list(this.VuV_fileFilter);
        this.lm.clear();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            this.lm.addElement(stringArray[n]);
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println("JPhotoBatch by Tanveer Rameez");
            System.out.println("Java version:" + System.getProperty("java.version"));
            JFrame jFrame = new JFrame("JPhotoBatch");
            jFrame.getContentPane().setLayout(new BorderLayout());
            ImagerGlobal.initializeImageIO();
            jFrame.getContentPane().add(new BatchOpPanel(jFrame, jFrame));
            jFrame.setSize(750, 550);
            jFrame.setIconImage(ImagerGlobal.loadImage("resources/batch.gif", jFrame));
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            jFrame.setLocation((int)(dimension.getWidth() - (double)jFrame.getWidth()) / 2, (int)(dimension.getHeight() - (double)jFrame.getHeight()) / 2);
            jFrame.setVisible(true);
            jFrame.setDefaultCloseOperation(3);
        }
        catch (Exception exception) {
            System.out.println("Exception occured while initializing JPhotoBatch. Quitting.");
        }
    }

    public static JFrame getBatchOpFrame(Component component, JFrame jFrame) throws Exception {
        JFrame jFrame2 = new JFrame("JPhotoBatch");
        MetalLookAndFeel.setCurrentTheme(ImagerGlobal.METAL_THEME);
        ImagerGlobal.setLookAndFeel((Component)jFrame2, "javax.swing.plaf.metal.MetalLookAndFeel");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("imager.BatchOpPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        URL uRL = clazz.getResource("resources/batch.gif");
        Image image = null;
        image = uRL.getProtocol() == "jar" ? ImagerGlobal.getImage(Toolkit.getDefaultToolkit().getImage(uRL), component) : ImagerGlobal.loadImage("resources/batch.gif", component);
        jFrame2.setIconImage(image);
        jFrame2.getContentPane().setLayout(new BorderLayout());
        jFrame2.getContentPane().add(new BatchOpPanel(component, jFrame));
        jFrame2.setSize(750, 550);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        jFrame2.setLocation((int)(dimension.getWidth() - (double)jFrame2.getWidth()) / 2, (int)(dimension.getHeight() - (double)jFrame2.getHeight()) / 2);
        return jFrame2;
    }

    void jButton1_actionPerformed(ActionEvent actionEvent) {
        this.VVu_jList1.setSelectionInterval(0, this.lm.getSize() - 1);
        this.VVu_jList1.requestFocus();
    }

    void jList1_valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.uvU_jLabel1.setText(String.valueOf(this.VVu_jList1.getSelectedIndices().length) + " files selected     ");
        if (this.VVu_jList1.getSelectedIndices().length == 0) {
            this.UVU_m_ProcessButton.setEnabled(false);
        } else {
            this.UVU_m_ProcessButton.setEnabled(true);
        }
    }

    void m_ProcessButton_actionPerformed(ActionEvent actionEvent) {
        this.vVv_loadingFailedCount = 0;
        this.VuU_savingFailedCount = 0;
        this.vVU_operationFailedCount = 0;
        this.abortHandled = false;
        if (!(this.vUU_m_RenameCheckBox.isSelected() || this.VUV_m_ResizeCheckBox.isSelected() || this.uvV_m_FormatChangeCheckBox.isSelected())) {
            this.uVV_showErrorMessage("Please select atleast on operation- rename, resize or format change");
            return;
        }
        File file = null;
        if (!this.UVV_m_SameFolderRadioButton.isSelected()) {
            this.vUv_targetDirectoryName = this.uUV_m_TargetFolderTextField.getText().trim();
            file = new File(this.vUv_targetDirectoryName);
            if (this.uUV_m_TargetFolderTextField.getText().trim().length() == 0 || !file.exists()) {
                this.uVV_showErrorMessage("Please enter a valid target directory");
                this.uUV_m_TargetFolderTextField.requestFocus();
                return;
            }
        } else {
            this.vUv_targetDirectoryName = this.uVv_jFileChooser1.getSelectedFile().getAbsolutePath();
        }
        this.vVu_process = false;
        this.VVv_currentImageCount = 0;
        this.Vuv_completedCount = 0;
        if (this.VUV_m_ResizeCheckBox.isSelected()) {
            this.vVu_process = this.Uuu_m_ResizePanel.prepareForResizing();
            if (!this.vVu_process) {
                return;
            }
        }
        if (this.uvV_m_FormatChangeCheckBox.isSelected()) {
            this.vVu_process = true;
            if (!this.vVu_process) {
                return;
            }
        }
        if (this.vUU_m_RenameCheckBox.isSelected()) {
            this.vVu_process = this.Uvu_m_RenamePanel.prepareforRenaming();
            if (!this.vVu_process) {
                return;
            }
        }
        this.uUU_m_AbortButton.setEnabled(true);
        this.UVU_m_ProcessButton.setEnabled(false);
        Object[] objectArray = this.VVu_jList1.getSelectedValues();
        this.vuV_jProgressBar1.setMaximum(objectArray.length);
        if (this.VUV_m_ResizeCheckBox.isSelected() || this.uvV_m_FormatChangeCheckBox.isSelected()) {
            new Thread(this).start();
        } else if (this.vUU_m_RenameCheckBox.isSelected()) {
            int n = 0;
            while (n < objectArray.length) {
                if (!this.vVu_process) {
                    if (!this.abortHandled) {
                        this.UVu_operationStatus(false, true);
                    }
                    return;
                }
                if (this.Uvu_m_RenamePanel.deleteOriginalFile()) {
                    SwingUtilities.invokeLater(new FileCopyThread(this, String.valueOf(this.uVv_jFileChooser1.getSelectedFile().getAbsolutePath()) + File.separator + (String)objectArray[n], String.valueOf(this.vUv_targetDirectoryName) + File.separator + this.Uvu_m_RenamePanel.rename((String)objectArray[n]), true));
                } else {
                    SwingUtilities.invokeLater(new FileCopyThread(this, String.valueOf(this.uVv_jFileChooser1.getSelectedFile().getAbsolutePath()) + File.separator + (String)objectArray[n], String.valueOf(this.vUv_targetDirectoryName) + File.separator + this.Uvu_m_RenamePanel.rename((String)objectArray[n]), false));
                }
                ++n;
            }
        } else {
            this.uVV_showErrorMessage("Please select atleast one operation- rename, resize or format change");
        }
    }

    public void run() {
        Object[] objectArray = this.VVu_jList1.getSelectedValues();
        File file = null;
        int n = 0;
        while (n < objectArray.length) {
            try {
                if (!this.vVu_process) {
                    if (!this.abortHandled) {
                        this.UVu_operationStatus(false, true);
                    }
                    return;
                }
                file = new File(String.valueOf(this.uVv_jFileChooser1.getSelectedFile().getAbsolutePath()) + File.separator + (String)objectArray[n]);
                if (file.exists()) {
                    this.imageLoadingThread.setImageFile(file);
                    this.imageLoadingThread.run();
                } else {
                    ++this.vVv_loadingFailedCount;
                    this.UVu_operationStatus(false);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void uUu_copyFile(String var1_1, String var2_2) throws FileNotFoundException, IOException {
        var3_3 = new FileInputStream(var1_1);
        var4_4 = new FileOutputStream(var2_2);
        var5_5 = 1024;
        var6_6 = new byte[var5_5];
        var7_7 = 0;
        if (this.vVu_process) ** GOTO lbl11
        var3_3.close();
        var4_4.close();
        throw new IOException("");
lbl-1000:
        // 1 sources

        {
            var4_4.write(var6_6, 0, var7_7);
lbl11:
            // 2 sources

            ** while (var5_5 != 0 && (var7_7 = var3_3.read((byte[])var6_6)) > 0)
        }
lbl12:
        // 1 sources

        var3_3.close();
        var4_4.close();
    }

    private void uVV_showErrorMessage(String string) {
        JOptionPane.showMessageDialog(this, string, "Batch Operation Error!", 0);
    }

    void m_AbortButton_actionPerformed(ActionEvent actionEvent) {
        this.vVu_process = false;
        this.uUU_m_AbortButton.setEnabled(false);
    }

    public void imageLoaded(File file, Image image) {
        try {
            if (!this.vVu_process) {
                if (!this.abortHandled) {
                    this.UVu_operationStatus(false, true);
                }
                return;
            }
            String string = file.getName();
            File file2 = file;
            if (this.uvV_m_FormatChangeCheckBox.isSelected()) {
                string = this.UvU_m_FormatPanel.convert(file);
            }
            if (this.vUU_m_RenameCheckBox.isSelected()) {
                string = this.Uvu_m_RenamePanel.rename(string);
            }
            if (this.uvV_m_FormatChangeCheckBox.isSelected() || this.vUU_m_RenameCheckBox.isSelected() || !this.UVV_m_SameFolderRadioButton.isSelected()) {
                file = new File(String.valueOf(this.vUv_targetDirectoryName) + File.separator + string);
            }
            if (file.exists()) {
                if (this.vUV_m_DoNotSaveRadioButton.isSelected()) {
                    this.UVu_operationStatus(false);
                    return;
                }
                if (this.VUu_m_PromptRadioButton.isSelected()) {
                    int n = JOptionPane.showConfirmDialog(this, "File " + file.getName() + " already exist. Overwite?", "Batch Operation Question", 1, 3);
                    if (n == 1) {
                        this.UVu_operationStatus(false);
                        return;
                    }
                    if (n == 2) {
                        this.vVu_process = false;
                        this.UVu_operationStatus(false);
                        return;
                    }
                }
            }
            if (this.VUV_m_ResizeCheckBox.isSelected()) {
                image = this.Uuu_m_ResizePanel.resizeImage(image);
            }
            if (this.vVu_process) {
                this.imageSavingThread.setImage(image, file, true);
                if (this.Uvu_m_RenamePanel.deleteOriginalFile()) {
                    file2.delete();
                }
                this.imageSavingThread.run();
            } else {
                this.UVu_operationStatus(false, true);
            }
            System.runFinalization();
        }
        catch (Exception exception) {
            ++this.vVU_operationFailedCount;
            exception.printStackTrace();
        }
    }

    private synchronized void UUv_update(boolean bl) {
        if (bl) {
            ++this.Vuv_completedCount;
        }
        ++this.VVv_currentImageCount;
    }

    private void UVu_operationStatus(boolean bl) {
        this.UVu_operationStatus(bl, false);
    }

    private void UVu_operationStatus(boolean bl, boolean bl2) {
        this.UUv_update(bl);
        this.vuV_jProgressBar1.setValue(this.VVv_currentImageCount);
        this.vuV_jProgressBar1.setString(String.valueOf(this.VVv_currentImageCount) + " of " + this.vuV_jProgressBar1.getMaximum());
        if (this.VVv_currentImageCount == this.vuV_jProgressBar1.getMaximum() || bl2) {
            if (bl2) {
                this.abortHandled = true;
            }
            this.VVv_currentImageCount = 0;
            String string = "Operation " + (!this.vVu_process ? "Aborted." : "Completed.") + "\n" + this.Vuv_completedCount + " files processed succesfully" + (!this.vVu_process ? " before Aborting." : ".");
            string = String.valueOf(string) + (this.vVv_loadingFailedCount > 0 ? "\nError in loading " + this.vVv_loadingFailedCount + " files" : "");
            string = String.valueOf(string) + (this.vVU_operationFailedCount > 0 ? "\nError in processing " + this.vVU_operationFailedCount + " files" : "");
            string = String.valueOf(string) + (this.VuU_savingFailedCount > 0 ? "\nError in saving " + this.VuU_savingFailedCount + " files" : "");
            JOptionPane.showMessageDialog(this, string);
            this.uUU_m_AbortButton.setEnabled(false);
            if (this.VVu_jList1.getSelectedIndices().length > 0) {
                this.UVU_m_ProcessButton.setEnabled(true);
            }
            this.vuV_jProgressBar1.setValue(0);
            this.vuV_jProgressBar1.setString("");
            this.UuV_refreshFileList();
            if (this.VVu_jList1.getSelectedIndices().length == 0) {
                this.UVU_m_ProcessButton.setEnabled(false);
            }
        }
        System.gc();
    }

    public void imageSaved(File file) {
        this.UVu_operationStatus(true);
    }

    public void imageNotSaved(Exception exception, File file) {
        this.UVu_operationStatus(false);
        ++this.VuU_savingFailedCount;
    }

    public void imageNotLoaded(Exception exception) {
        this.UVu_operationStatus(false);
        ++this.vVv_loadingFailedCount;
    }

    public void setImageLoadingStatus(float f) {
    }

    void m_ChooseFolderRadioButton_itemStateChanged(ItemEvent itemEvent) {
        this.uUV_m_TargetFolderTextField.setEnabled(this.uVU_m_ChooseFolderRadioButton.isSelected());
        this.UUu_m_TargetBrowseButton.setEnabled(this.uVU_m_ChooseFolderRadioButton.isSelected());
    }

    void m_TargetBrowseButton_actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Select Destination Directory");
        jFileChooser.setFileSelectionMode(1);
        if (jFileChooser.showOpenDialog(this) == 0) {
            this.uUV_m_TargetFolderTextField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void Vvv_displayHelpBrowser() {
        if (this.VvV_m_Help == null) {
            try {
                if (this.VvV_m_Help == null) {
                    this.VvV_m_Help = new HelpBrowser((Frame)((JFrame)this.m_Owner), "JPhotoBatch", null, "JPhotoBatch.htm");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.VvV_m_Help.setVisible(true);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        System.gc();
    }

    class ImageFilenameFilter
    implements FilenameFilter {
        ImageFilenameFilter() {
        }

        public boolean accept(File file, String string) {
            if (BatchOpPanel.this.uuu_jComboBox1.getSelectedIndex() > 0) {
                FileFilter fileFilter = ImagerGlobal.SaveImageFileChooser.getChoosableFileFilters()[BatchOpPanel.this.uuu_jComboBox1.getSelectedIndex() - 1];
                File file2 = new File(file, string);
                if (file2.isDirectory()) {
                    return false;
                }
                return fileFilter.accept(file2);
            }
            int n = 0;
            while (n < ImagerGlobal.FILE_EXTS.length) {
                if (string.toUpperCase().endsWith("." + ImagerGlobal.FILE_EXTS[n].toUpperCase()) && new File(file, string).isFile()) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    }

    class FileCopyThread
    extends Thread {
        String src;
        String dest;
        boolean removeOriginal = false;
        File imageFile;
        Component m_Comp;

        FileCopyThread(Component component, String string, String string2, boolean bl) {
            this.m_Comp = component;
            this.src = string;
            this.dest = string2;
            this.removeOriginal = bl;
        }

        public void run() {
            try {
                if (!BatchOpPanel.this.vVu_process) {
                    if (!BatchOpPanel.this.abortHandled) {
                        BatchOpPanel.this.UVu_operationStatus(false, true);
                    }
                    return;
                }
                this.imageFile = new File(this.dest);
                if (this.imageFile.exists()) {
                    if (BatchOpPanel.this.vUV_m_DoNotSaveRadioButton.isSelected()) {
                        BatchOpPanel.this.UVu_operationStatus(false);
                        return;
                    }
                    if (BatchOpPanel.this.VUu_m_PromptRadioButton.isSelected()) {
                        int n = JOptionPane.showConfirmDialog(this.m_Comp, "File " + this.imageFile.getName() + " already exist. Overwite?", "Batch Operation Question", 1, 3);
                        if (n == 1) {
                            BatchOpPanel.this.UVu_operationStatus(false);
                            return;
                        }
                        if (n == 2) {
                            BatchOpPanel.this.vVu_process = false;
                            BatchOpPanel.this.UVu_operationStatus(false);
                            return;
                        }
                    }
                }
                if (this.removeOriginal) {
                    new File(this.src).renameTo(this.imageFile);
                } else {
                    BatchOpPanel.this.uUu_copyFile(this.src, this.dest);
                }
                BatchOpPanel.this.UVu_operationStatus(true);
            }
            catch (Exception exception) {
                if (!BatchOpPanel.this.abortHandled) {
                    BatchOpPanel.this.UVu_operationStatus(false, !BatchOpPanel.this.vVu_process);
                }
                BatchOpPanel batchOpPanel = BatchOpPanel.this;
                batchOpPanel.vVU_operationFailedCount = batchOpPanel.vVU_operationFailedCount + 1;
            }
        }
    }
}

