/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.BrowserFrame;
import imager.DropEnabledPanel;
import imager.IconLoader;
import imager.Imager;
import imager.ImagerGlobal;
import imager.ThumbnailPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

public final class BrowserPanel
extends JPanel {
    public static String ROOT = "@root@";
    private ImageIcon UUU_DIRECTORY_ICON = ImagerGlobal.loadIcon("resources/directory.gif", this);
    private ImageIcon UVV_DRIVE_ICON = ImagerGlobal.loadIcon("resources/drive.gif", this);
    private Component Uuu_m_Parent;
    private JFrame Uvv_m_Frame;
    private JScrollPane UUu_jScrollPane1 = new JScrollPane();
    private int UVv_totalFileCount;
    private MainPanel UvU_m_MainPanel = new MainPanel();
    private int VUV_tw = 100;
    private int UVU_th = 100;
    private int UuV_gap = 5;
    private Vector Uvu_m_Thumbnails = new Vector();
    private boolean UUV_showDirectory = true;
    private JLabel UVu_jLabel1 = new JLabel("Double click on the thumbnail to open it.   Right click for menu");
    private Border Uuv_border1;
    private String VUU_foldername;
    private int UUv_imageCounter;
    private int UuU_imageCount;
    BrowserPanelPopupMenu popUpMenu = new BrowserPanelPopupMenu();

    public BrowserPanel(Component component, JFrame jFrame) {
        try {
            this.jbInit();
            this.Uuu_m_Parent = component;
            this.Uvv_m_Frame = jFrame;
            this.UUV_showDirectory = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setThumbnailSize(int n) {
        this.VUV_tw = this.UVU_th = n;
    }

    void jbInit() throws Exception {
        this.Uuv_border1 = new EtchedBorder(0, Color.white, new Color(156, 156, 156));
        this.setLayout(new BorderLayout());
        this.UUu_jScrollPane1.setBorder(null);
        this.UVu_jLabel1.setBorder(this.Uuv_border1);
        this.add((Component)this.UUu_jScrollPane1, "Center");
        this.add((Component)this.UVu_jLabel1, "South");
        this.UUu_jScrollPane1.getViewport().add((Component)this.UvU_m_MainPanel, null);
    }

    public void setFolder(String string) {
        if (string == null) {
            this.flush();
            return;
        }
        this.firePropertyChange(BrowserFrame.DIRECTORY_CHANGED, this.VUU_foldername, string.equals(ROOT) ? "Roots" : string);
        this.UVu_jLabel1.setText("Reading directory contents ...");
        this.UVv_totalFileCount = 0;
        this.UUv_imageCounter = 0;
        this.UuU_imageCount = 0;
        this.VUU_foldername = string;
        File file = new File(this.VUU_foldername);
        File[] fileArray = null;
        if (this.VUU_foldername.equals(ROOT)) {
            fileArray = File.listRoots();
        } else {
            if (!(file.isDirectory() || this.VUU_foldername.endsWith(".jar") || this.VUU_foldername.endsWith(".zip"))) {
                return;
            }
            if (this.VUU_foldername.endsWith(".jar") || this.VUU_foldername.endsWith(".zip")) {
                Hashtable hashtable = ImagerGlobal.readImagesFromJarIntoHashtable(this.VUU_foldername, this.VUV_tw, this.UVU_th);
                if (hashtable == null || hashtable.size() == 0) {
                    JOptionPane.showMessageDialog(this.Uuu_m_Parent, "No supported image in this Zip/Jar file", "Browser message", 0);
                    return;
                }
                this.flush();
                this.Uuu_m_Parent.setVisible(true);
                this.setVisible(true);
                new LayoutThumbnailsThread(this, this.VUU_foldername, hashtable).start();
            } else {
                fileArray = file.listFiles(new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        if (BrowserPanel.this.UUV_showDirectory && new File(String.valueOf(file.getAbsolutePath()) + File.separator + string).isDirectory()) {
                            return true;
                        }
                        int n = 0;
                        while (n < ImagerGlobal.FILE_EXTS.length) {
                            if (string.toLowerCase().endsWith("." + ImagerGlobal.FILE_EXTS[n].toLowerCase())) {
                                BrowserPanel browserPanel = BrowserPanel.this;
                                browserPanel.UuU_imageCount = browserPanel.UuU_imageCount + 1;
                                return true;
                            }
                            ++n;
                        }
                        return false;
                    }
                });
            }
            if (fileArray.length == 0) {
                JOptionPane.showMessageDialog(this.Uuu_m_Parent, "No supported image in this directory", "Browser message", 0);
                return;
            }
        }
        this.flush();
        this.Uuu_m_Parent.setVisible(true);
        this.setVisible(true);
        this.repaint();
        new LayoutThumbnailsThread(this, this.VUU_foldername, fileArray).run();
    }

    public void thumbnailClicked(String string, String string2) {
        if (string.startsWith(ROOT)) {
            this.setFolder(ROOT);
        } else if ((string2 == null || string2.length() == 0) && string.length() == 3) {
            File file = new File(string);
            if (file.isDirectory()) {
                this.setFolder(string);
            } else {
                JOptionPane.showMessageDialog(this, "Drive " + string + " not ready!!!", "Browsing Error", 0);
            }
        } else if (string.endsWith(".zip") || string.endsWith(".jar")) {
            ((Imager)this.Uvv_m_Frame).setImage(string, string2);
        } else {
            try {
                if (this.Uvv_m_Frame instanceof Imager) {
                    File file = new File(String.valueOf(string) + File.separator + string2);
                    if (file.isDirectory()) {
                        this.setFolder(file.getAbsolutePath());
                    } else {
                        ((Imager)this.Uvv_m_Frame).setImage(new File(String.valueOf(string) + File.separator + string2));
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void UvV_showPopupMenu(Component component, int n, int n2) {
        this.popUpMenu.show(component, n, n2);
    }

    public void refreshFolder() {
        this.setFolder(this.VUU_foldername);
    }

    public void flush() {
        this.UvU_m_MainPanel.removeAll();
        this.Uvu_m_Thumbnails.removeAllElements();
        Runtime.getRuntime().gc();
    }

    void removeThumbnail(ThumbnailPanel thumbnailPanel) {
        this.Uvu_m_Thumbnails.removeElement(thumbnailPanel);
        this.UvU_m_MainPanel.removeAll();
        this.repaint();
        new LayoutThumbnailsThread(this).start();
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, this.VUV_tw * 5 + this.UUu_jScrollPane1.getVerticalScrollBar().getWidth());
    }

    public void setDropTarget() {
        this.UvU_m_MainPanel.setDropTarget();
    }

    public boolean isShowDirectory() {
        return this.UUV_showDirectory;
    }

    public void setShowDirectory(boolean bl) {
        this.UUV_showDirectory = bl;
    }

    static /* synthetic */ void access$16(BrowserPanel browserPanel, boolean bl) {
        browserPanel.UUV_showDirectory = bl;
    }

    class LayoutThumbnailsThread
    extends Thread {
        BrowserPanel m_Owner;
        String foldername;
        File[] files;
        Hashtable imagetable;

        LayoutThumbnailsThread(BrowserPanel browserPanel2) {
            this.m_Owner = browserPanel2;
        }

        LayoutThumbnailsThread(BrowserPanel browserPanel2, String string) {
            this.m_Owner = browserPanel2;
            this.foldername = string;
        }

        LayoutThumbnailsThread(BrowserPanel browserPanel2, String string, File[] fileArray) {
            this.m_Owner = browserPanel2;
            this.files = fileArray;
            this.foldername = string;
        }

        LayoutThumbnailsThread(BrowserPanel browserPanel2, String string, Hashtable hashtable) {
            this.m_Owner = browserPanel2;
            this.imagetable = hashtable;
            this.foldername = string;
        }

        public void run() {
            BrowserPanel.this.UvU_m_MainPanel.invalidate();
            if (this.imagetable == null) {
                if (this.files != null) {
                    LayoutThumbnailsThread layoutThumbnailsThread;
                    Serializable serializable;
                    String string = new File(this.foldername).getParent();
                    int n = 0;
                    if (string != null) {
                        serializable = new ThumbnailPanel(this.m_Owner, null, string, "", "...", "Up one level", true, true);
                        ((JComponent)serializable).setFont(new Font(((Component)serializable).getFont().getName(), 1, 20));
                        ((JComponent)serializable).setPreferredSize(new Dimension(BrowserPanel.this.VUV_tw, BrowserPanel.this.UVU_th));
                        layoutThumbnailsThread = this;
                        synchronized (layoutThumbnailsThread) {
                            BrowserPanel.this.UvU_m_MainPanel.add((Component)serializable);
                            BrowserPanel.this.Uvu_m_Thumbnails.addElement(serializable);
                            n = 1;
                        }
                    }
                    serializable = new ThumbnailPanel(this.m_Owner, null, ROOT, "", "...", "Up one level", true, true);
                    ((JComponent)serializable).setFont(new Font(((Component)serializable).getFont().getName(), 1, 20));
                    ((JComponent)serializable).setPreferredSize(new Dimension(BrowserPanel.this.VUV_tw, BrowserPanel.this.UVU_th));
                    layoutThumbnailsThread = this;
                    synchronized (layoutThumbnailsThread) {
                        BrowserPanel.this.UvU_m_MainPanel.add((Component)serializable);
                        BrowserPanel.this.Uvu_m_Thumbnails.addElement(serializable);
                        n = 1;
                    }
                    BrowserPanel.this.UVv_totalFileCount = this.files.length + n;
                    serializable = new FlowLayout(0);
                    int n2 = BrowserPanel.this.UVv_totalFileCount / ((BrowserPanel.this.Uuu_m_Parent.getWidth() - 25) / (BrowserPanel.this.VUV_tw + ((FlowLayout)serializable).getHgap()));
                    if (BrowserPanel.this.UVv_totalFileCount % ((BrowserPanel.this.Uuu_m_Parent.getWidth() - 25) / BrowserPanel.this.VUV_tw) != 0) {
                        ++n2;
                    }
                    BrowserPanel.this.UvU_m_MainPanel.setMinimumSize(new Dimension(BrowserPanel.this.Uuu_m_Parent.getWidth() - 25, n2 * (BrowserPanel.this.UVU_th + ((FlowLayout)serializable).getHgap())));
                    BrowserPanel.this.UvU_m_MainPanel.setPreferredSize(new Dimension(BrowserPanel.this.Uuu_m_Parent.getWidth() - 25, n2 * (BrowserPanel.this.UVU_th + ((FlowLayout)serializable).getHgap())));
                    BrowserPanel.this.UvU_m_MainPanel.setLayout((LayoutManager)((Object)serializable));
                    int n3 = 0;
                    while (n3 < BrowserPanel.this.UVv_totalFileCount - 1) {
                        if (this.foldername != null && this.files != null) {
                            new ThumbnailLoader(this.m_Owner, this.foldername, this.files[n3]).start();
                        }
                        ++n3;
                    }
                    BrowserPanel.this.UvU_m_MainPanel.revalidate();
                } else {
                    BrowserPanel.this.UVv_totalFileCount = BrowserPanel.this.Uvu_m_Thumbnails.size();
                    int n = 0;
                    while (n < BrowserPanel.this.UVv_totalFileCount) {
                        ThumbnailPanel thumbnailPanel = (ThumbnailPanel)BrowserPanel.this.Uvu_m_Thumbnails.elementAt(n);
                        File file = new File(thumbnailPanel.getFilePath());
                        if (!file.exists()) {
                            BrowserPanel.this.Uvu_m_Thumbnails.removeElementAt(n);
                            BrowserPanel browserPanel = BrowserPanel.this;
                            browserPanel.UVv_totalFileCount = browserPanel.UVv_totalFileCount - 1;
                        } else {
                            if (!file.isDirectory() && file.lastModified() != thumbnailPanel.getLastModifiedTime()) {
                                try {
                                    ImageIcon imageIcon = IconLoader.loadIcon(file.getAbsolutePath(), BrowserPanel.this.VUV_tw, BrowserPanel.this.UVU_th, this.m_Owner);
                                    thumbnailPanel.setIcon(imageIcon);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            BrowserPanel.this.UvU_m_MainPanel.add(thumbnailPanel);
                        }
                        ++n;
                    }
                    BrowserPanel.this.UvU_m_MainPanel.revalidate();
                    BrowserPanel.this.repaint();
                }
            } else {
                ThumbnailPanel thumbnailPanel;
                BrowserPanel.this.UVv_totalFileCount = this.imagetable.size();
                FlowLayout flowLayout = new FlowLayout(0);
                int n = BrowserPanel.this.UVv_totalFileCount / ((BrowserPanel.this.Uuu_m_Parent.getWidth() - 25) / (BrowserPanel.this.VUV_tw + flowLayout.getHgap()));
                if (BrowserPanel.this.UVv_totalFileCount % ((BrowserPanel.this.Uuu_m_Parent.getWidth() - 25) / BrowserPanel.this.VUV_tw) != 0) {
                    ++n;
                }
                BrowserPanel.this.UvU_m_MainPanel.setMinimumSize(new Dimension(BrowserPanel.this.Uuu_m_Parent.getWidth() - 25, n * (BrowserPanel.this.UVU_th + flowLayout.getHgap())));
                BrowserPanel.this.UvU_m_MainPanel.setPreferredSize(new Dimension(BrowserPanel.this.Uuu_m_Parent.getWidth() - 25, n * (BrowserPanel.this.UVU_th + flowLayout.getHgap())));
                BrowserPanel.this.UvU_m_MainPanel.setLayout(flowLayout);
                Enumeration enumeration = this.imagetable.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    thumbnailPanel = new ThumbnailPanel(this.m_Owner, (ImageIcon)this.imagetable.get(string), this.foldername, string);
                    thumbnailPanel.setPreferredSize(new Dimension(BrowserPanel.this.VUV_tw, BrowserPanel.this.UVU_th));
                    thumbnailPanel.setToolTipText(string);
                    LayoutThumbnailsThread layoutThumbnailsThread = this;
                    synchronized (layoutThumbnailsThread) {
                        BrowserPanel.this.UvU_m_MainPanel.add(thumbnailPanel);
                        BrowserPanel.this.Uvu_m_Thumbnails.addElement(thumbnailPanel);
                    }
                }
                thumbnailPanel = null;
            }
            this.m_Owner = null;
            this.files = null;
            this.foldername = null;
        }
    }

    class ThumbnailLoader
    extends Thread {
        String m_foldername;
        File m_file;
        BrowserPanel m_Owner;

        ThumbnailLoader(BrowserPanel browserPanel2, String string, File file) {
            this.m_file = file;
            this.m_foldername = string;
            this.m_Owner = browserPanel2;
        }

        public void run() {
            try {
                JComponent jComponent = null;
                if (this.m_foldername.equals(ROOT)) {
                    jComponent = new ThumbnailPanel(this.m_Owner, BrowserPanel.this.UVV_DRIVE_ICON, "" + this.m_file, "", "" + this.m_file, "" + this.m_file, true, true);
                    jComponent.setPreferredSize(new Dimension(BrowserPanel.this.VUV_tw, BrowserPanel.this.UVU_th));
                    BrowserPanel.this.UvU_m_MainPanel.add(jComponent);
                    BrowserPanel.this.Uvu_m_Thumbnails.addElement(jComponent);
                } else {
                    Object object;
                    if (!this.m_file.isDirectory()) {
                        try {
                            object = IconLoader.loadIcon(this.m_file.getAbsolutePath(), BrowserPanel.this.VUV_tw, BrowserPanel.this.UVU_th, this.m_Owner);
                            if (object == null || ((ImageIcon)object).getIconHeight() == -1 || ((ImageIcon)object).getIconHeight() == 0) {
                                throw new Exception();
                            }
                            jComponent = new ThumbnailPanel(this.m_Owner, (ImageIcon)object, this.m_foldername, this.m_file.getName());
                            ((ThumbnailPanel)jComponent).setLastModifiedTime(this.m_file.lastModified());
                        }
                        catch (Exception exception) {
                            jComponent = new ThumbnailPanel(this.m_Owner, null, this.m_foldername, this.m_file.getName(), "Bad Image", this.m_file.getName(), false, true);
                            ((ThumbnailPanel)jComponent).setLastModifiedTime(this.m_file.lastModified());
                        }
                        object = null;
                    } else if (BrowserPanel.this.UUV_showDirectory) {
                        jComponent = new ThumbnailPanel(this.m_Owner, BrowserPanel.this.UUU_DIRECTORY_ICON, this.m_foldername, this.m_file.getName(), this.m_file.getName(), this.m_file.getName(), true, true);
                    }
                    if (jComponent == null) {
                        return;
                    }
                    jComponent.setPreferredSize(new Dimension(BrowserPanel.this.VUV_tw, BrowserPanel.this.UVU_th));
                    object = this;
                    synchronized (object) {
                        if (this.m_foldername != BrowserPanel.this.VUU_foldername) {
                            return;
                        }
                        if (!this.m_file.isDirectory()) {
                            BrowserPanel.this.UVu_jLabel1.setText("loading image " + (BrowserPanel.this.UUv_imageCounter + 1) + " of " + BrowserPanel.this.UuU_imageCount);
                            BrowserPanel browserPanel = BrowserPanel.this;
                            browserPanel.UUv_imageCounter = browserPanel.UUv_imageCounter + 1;
                        }
                        BrowserPanel.this.UvU_m_MainPanel.add(jComponent);
                        BrowserPanel.this.Uvu_m_Thumbnails.addElement(jComponent);
                    }
                }
                jComponent = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.m_Owner = null;
            this.m_foldername = null;
            this.m_file = null;
            BrowserPanel.this.UvU_m_MainPanel.revalidate();
            if (BrowserPanel.this.UUv_imageCounter == BrowserPanel.this.UuU_imageCount) {
                BrowserPanel.this.UVu_jLabel1.setText("Double click on the thumbnail to open image. Right click for menu");
                System.gc();
            }
        }
    }

    class MainPanel
    extends DropEnabledPanel {
        MainPanel() {
            this.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ MainPanel this$1;
                {
                    this.this$1 = mainPanel;
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        this.this$1.showPopupMenuInBrowser(mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
        }

        void showPopupMenuInBrowser(int n, int n2) {
            BrowserPanel.this.UvV_showPopupMenu(this, n, n2);
        }

        public void setDropTarget() {
            this.dropTarget = new DropTarget(this, this);
        }

        public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dropTargetDropEvent.acceptDrop(3);
                    Object object = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    String string = "" + object;
                    string = string.substring(1, string.lastIndexOf("]"));
                    File file = new File(string);
                    if (file.isDirectory()) {
                        if (BrowserPanel.this.Uuu_m_Parent instanceof BrowserFrame) {
                            ((BrowserFrame)BrowserPanel.this.Uuu_m_Parent).setFolder(string);
                        }
                        dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                    } else if (string.endsWith(".jar") || string.endsWith(".zip")) {
                        if (BrowserPanel.this.Uuu_m_Parent instanceof BrowserFrame) {
                            ((BrowserFrame)BrowserPanel.this.Uuu_m_Parent).setFolder(string);
                        }
                        dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                    }
                } else {
                    dropTargetDropEvent.rejectDrop();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                dropTargetDropEvent.rejectDrop();
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
                dropTargetDropEvent.rejectDrop();
            }
        }
    }

    class BrowserPanelPopupMenu
    extends JPopupMenu {
        JMenuItem refreshMenuItem = new JMenuItem("Refresh List");

        BrowserPanelPopupMenu() {
            this.refreshMenuItem.setMnemonic('F');
            this.refreshMenuItem.addActionListener(new ActionListener(this){
                final /* synthetic */ BrowserPanelPopupMenu this$1;
                {
                    this.this$1 = browserPanelPopupMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    BrowserPanelPopupMenu.access$0(this.this$1).setFolder(BrowserPanel.access$10(BrowserPanelPopupMenu.access$0(this.this$1)));
                }
            });
            this.add(this.refreshMenuItem);
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Show Directory", BrowserPanel.this.UUV_showDirectory);
            this.add(jCheckBoxMenuItem);
            jCheckBoxMenuItem.addActionListener(new ActionListener(this){
                final /* synthetic */ BrowserPanelPopupMenu this$1;
                {
                    this.this$1 = browserPanelPopupMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    BrowserPanel.access$16(BrowserPanelPopupMenu.access$0(this.this$1), ((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
                    BrowserPanelPopupMenu.access$0(this.this$1).setFolder(BrowserPanel.access$10(BrowserPanelPopupMenu.access$0(this.this$1)));
                }
            });
        }

        static /* synthetic */ BrowserPanel access$0(BrowserPanelPopupMenu browserPanelPopupMenu) {
            return browserPanelPopupMenu.BrowserPanel.this;
        }
    }
}

