/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.Brush;
import imager.BrushBasicPanel;
import imager.CapJoinPanel;
import imager.ImagerGlobal;
import imager.PaletteFrame;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Rectangle;

public class BrushPalette
extends PaletteFrame {
    CapJoinPanel m_CapJoinPanel;
    BrushBasicPanel m_BrushPanel;
    Brush m_Brush;

    public BrushPalette() {
        super("Brush Options");
        try {
            this.m_Brush = new Brush();
            this.m_CapJoinPanel = new CapJoinPanel();
            this.m_BrushPanel = new BrushBasicPanel();
            this.U_jbInit();
            this.setFrameIcon(ImagerGlobal.loadIcon("resources/brush.gif", this));
            this.m_CapJoinPanel.m_OpacitySlider.setValue(50);
            this.setSize(300, 220);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void U_jbInit() throws Exception {
        this.getContentPane().setLayout(null);
        this.m_CapJoinPanel.setBounds(new Rectangle(1, 100, 284, 94));
        this.m_BrushPanel.setBounds(new Rectangle(0, 0, 282, 98));
        this.setTitle("Brush Options");
        this.getContentPane().add(this.m_BrushPanel);
        this.getContentPane().add(this.m_CapJoinPanel);
    }

    public Brush getBrush() {
        this.m_Brush.setTexture(this.m_BrushPanel.getBrushTexture());
        float f = (float)((double)this.m_CapJoinPanel.getOpacity() / 100.0);
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f);
        this.m_Brush.setComposite(alphaComposite);
        this.m_Brush.setStroke(new BasicStroke(this.m_BrushPanel.getBrushWidth(), this.m_CapJoinPanel.getStrokeStyle(), 0));
        return this.m_Brush;
    }

    public boolean isAlignModeOnce() {
        return this.m_BrushPanel.isAlignModeOnce();
    }

    public void setCloningPanel(boolean bl) {
        this.m_BrushPanel.setCloningPanel(bl);
    }

    public BasicStroke getStroke() {
        BasicStroke basicStroke = new BasicStroke(this.m_BrushPanel.jSlider1.getValue(), this.m_CapJoinPanel.m_cmbCapStyle.getSelectedIndex(), 2);
        return basicStroke;
    }

    public int getOpacity() {
        return this.m_CapJoinPanel.getOpacity();
    }
}

