/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.AbstractText;
import imager.FormattedTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CircularText
extends AbstractText {
    private int U_m_nRadius = 0;
    Color m_ShadowColor = new Color(200, 200, 200);
    int numShadows = 4;
    boolean showShadow = true;

    public CircularText() {
    }

    public CircularText(String string, int n, int n2, Font font, Color color, TexturePaint texturePaint) {
        super(string, n, n2, font, color, texturePaint);
        this.setUIPanel(new CircularTextUIPanel());
    }

    public void draw(Graphics2D graphics2D, Rectangle rectangle, boolean bl) {
        if (bl && this.showShadow) {
            this.render(graphics2D, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        }
        graphics2D.setFont(this.m_Font);
        int n = graphics2D.getFontMetrics().stringWidth(this.m_Text);
        this.U_m_nRadius = (int)((double)n / (Math.PI * 2));
        if (this.m_Tp == null || !bl) {
            graphics2D.setColor(this.m_Color);
        } else {
            graphics2D.setPaint(this.m_Tp);
        }
        double d = 0.0;
        int n2 = 0;
        while (n2 < this.m_Text.length()) {
            graphics2D.rotate(d, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            graphics2D.drawString("" + this.m_Text.charAt(n2), rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2 - this.U_m_nRadius);
            graphics2D.rotate(-d, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            d += Math.PI * 2 * (double)graphics2D.getFontMetrics().charWidth(this.m_Text.charAt(n2)) / (double)n;
            ++n2;
        }
        n2 = rectangle.x + rectangle.width / 2;
        int n3 = rectangle.y + rectangle.height / 2;
        this.m_X = n2;
        this.m_Y = n3;
    }

    void render(Graphics2D graphics2D, int n, int n2) {
        if (!System.getProperty("java.version").startsWith("1.3.0")) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        double d = 0.0;
        int n3 = 0;
        while (n3 < this.numShadows) {
            if (this.m_Font.getSize() - 2 * (4 - n3) <= 0) break;
            graphics2D.setFont(new Font(this.m_Font.getName(), this.m_Font.getStyle(), this.m_Font.getSize() - 2 * (4 - n3)));
            int n4 = graphics2D.getFontMetrics().stringWidth(this.m_Text);
            this.U_m_nRadius = (int)((double)n4 / (Math.PI * 2));
            try {
                graphics2D.setColor(new Color(this.m_ShadowColor.getRed() - n3 * 30, this.m_ShadowColor.getGreen() - n3 * 30, this.m_ShadowColor.getBlue() - 30 * n3));
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n5 = 0;
            while (n5 < this.m_Text.length()) {
                graphics2D.rotate(d, n, n2);
                graphics2D.drawString("" + this.m_Text.charAt(n5), n, n2 - this.U_m_nRadius);
                graphics2D.rotate(-d, n, n2);
                d += Math.PI * 2 * (double)graphics2D.getFontMetrics().charWidth(this.m_Text.charAt(n5)) / (double)n4;
                ++n5;
            }
            ++n3;
        }
    }

    public Rectangle getBounds(Graphics graphics) {
        int n = graphics.getFontMetrics(this.m_Font).stringWidth(this.m_Text);
        this.U_m_nRadius = (int)((double)n / (Math.PI * 2));
        int n2 = this.m_X - this.U_m_nRadius - graphics.getFontMetrics(this.m_Font).getAscent();
        n2 = n2 < 0 ? 0 : n2;
        int n3 = this.m_Y - this.U_m_nRadius - graphics.getFontMetrics(this.m_Font).getAscent();
        n3 = n3 < 0 ? 0 : n3;
        return new Rectangle(n2, n3, this.U_m_nRadius * 2 + 2 * graphics.getFontMetrics(this.m_Font).getAscent(), this.U_m_nRadius * 2 + 2 * graphics.getFontMetrics(this.m_Font).getAscent());
    }

    public String getName() {
        return "Circular Text";
    }

    class CircularTextUIPanel
    extends JPanel {
        JLabel jLabel1 = new JLabel();
        JButton jButton1 = new JButton();
        JLabel jLabel2 = new JLabel();
        JTextField jTextField1 = new FormattedTextField(2);
        JCheckBox jCheckBox1 = new JCheckBox();

        public CircularTextUIPanel() {
            try {
                this.jbInit();
                this.jTextField1.setText("" + CircularText.this.numShadows);
                this.jLabel2.setOpaque(true);
                this.jLabel2.setBackground(CircularText.this.m_ShadowColor);
                this.jCheckBox1.setSelected(CircularText.this.showShadow);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        void jbInit() throws Exception {
            this.jLabel1.setFont(new Font("Dialog", 0, 11));
            this.jLabel1.setText("Number of shadows:");
            this.jLabel1.setBounds(new Rectangle(9, 26, 106, 26));
            this.setLayout(null);
            this.jButton1.setBounds(new Rectangle(8, 54, 92, 24));
            this.jButton1.setFont(new Font("Dialog", 0, 11));
            this.jButton1.setMargin(new Insets(2, 2, 2, 2));
            this.jButton1.setText("Shadow Color");
            this.jLabel2.setBounds(new Rectangle(111, 54, 38, 26));
            this.jTextField1.setBounds(new Rectangle(122, 25, 28, 26));
            this.jCheckBox1.setText("Shadows");
            this.jCheckBox1.setBounds(new Rectangle(7, 6, 79, 22));
            this.jTextField1.addFocusListener(new FocusAdapter(this){
                final /* synthetic */ CircularTextUIPanel this$1;
                {
                    this.this$1 = circularTextUIPanel;
                }

                public void focusLost(FocusEvent focusEvent) {
                    int n = CircularTextUIPanel.access$1((CircularTextUIPanel)this.this$1).numShadows;
                    CircularTextUIPanel.access$1((CircularTextUIPanel)this.this$1).numShadows = Integer.parseInt(this.this$1.jTextField1.getText());
                    this.this$1.firePropertyChange(AbstractText.TEXT_PROPERTIES_CHANGED, n, CircularTextUIPanel.access$1((CircularTextUIPanel)this.this$1).numShadows);
                }
            });
            this.jButton1.addActionListener(new ActionListener(this){
                final /* synthetic */ CircularTextUIPanel this$1;
                {
                    this.this$1 = circularTextUIPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    CircularTextUIPanel.access$0(this.this$1);
                }
            });
            this.add((Component)this.jLabel2, null);
            this.add((Component)this.jButton1, null);
            this.add((Component)this.jLabel1, null);
            this.add((Component)this.jTextField1, null);
            this.add((Component)this.jCheckBox1, null);
            this.jCheckBox1.addChangeListener(new ChangeListener(this){
                final /* synthetic */ CircularTextUIPanel this$1;
                {
                    this.this$1 = circularTextUIPanel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    boolean bl;
                    CircularTextUIPanel.access$1((CircularTextUIPanel)this.this$1).showShadow = bl = this.this$1.jCheckBox1.isSelected();
                    this.this$1.firePropertyChange(AbstractText.TEXT_PROPERTIES_CHANGED, this.this$1.jButton1.isEnabled(), bl);
                    this.this$1.jButton1.setEnabled(bl);
                    this.this$1.jTextField1.setEnabled(bl);
                }
            });
        }

        private void U_setShadowColor() {
            Color color = JColorChooser.showDialog(this, "Shadow Color", this.jLabel2.getBackground());
            if (color != null) {
                CircularText.this.m_ShadowColor = color;
                this.firePropertyChange(AbstractText.TEXT_PROPERTIES_CHANGED, this.jLabel2.getBackground(), color);
                this.jLabel2.setBackground(color);
            }
        }

        static /* synthetic */ void access$0(CircularTextUIPanel circularTextUIPanel) {
            circularTextUIPanel.U_setShadowColor();
        }

        static /* synthetic */ CircularText access$1(CircularTextUIPanel circularTextUIPanel) {
            return circularTextUIPanel.CircularText.this;
        }
    }
}

