/*
 * Decompiled with CFR 0.152.
 */
package imager;

import java.awt.GridLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class FormattedTextField
extends JTextField
implements KeyListener,
FocusListener {
    public static final int NONE = 0;
    public static final int INTEGER = 1;
    public static final int POSITIVE_INTEGER = 2;
    public static final int DOUBLE = 3;
    public static final int POSITIVE_DOUBLE = 4;
    public static final int ALPHA_NUMERIC = 5;
    int m_nPrecision = 4;
    int m_nFormat = 0;

    public FormattedTextField() {
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public FormattedTextField(String string) {
        super(string);
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public FormattedTextField(int n) {
        this.m_nFormat = n;
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public FormattedTextField(String string, int n) {
        super(string, n);
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public boolean isNumeric(char c) {
        return c >= '0' && c <= '9';
    }

    public boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\b') {
            return;
        }
        char c = keyEvent.getKeyChar();
        try {
            switch (this.m_nFormat) {
                default: {
                    return;
                }
                case 2: {
                    if (this.isNumeric(c)) {
                        return;
                    }
                    break;
                }
                case 1: {
                    if (this.isNumeric(c) || c == '-') {
                        return;
                    }
                    break;
                }
                case 3: {
                    if (this.isNumeric(c) || c == '-' || c == 'E' || c == 'e' || c == '.') {
                        return;
                    }
                    break;
                }
                case 4: {
                    if (this.isNumeric(c) || c == 'E' || c == 'e' || c == '.') {
                        return;
                    }
                    break;
                }
                case 5: {
                    if (this.isNumeric(c) || c == '-' || c == 'E' || c == 'e' || c == '.' || this.isAlpha(c)) {
                        return;
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Invalid format: Please enter " + (this.m_nFormat == 1 ? "an integer." : (this.m_nFormat == 3 ? " a numerical." : "proper format")));
            this.select(0, this.getText().length());
            this.requestFocus();
        }
        keyEvent.consume();
    }

    public void setText(String string) {
        super.setText(string);
    }

    public int getPrecision() {
        return this.m_nPrecision;
    }

    public void setPrecision(int n) {
        this.m_nPrecision = n;
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!(this.isVisible() && this.isDisplayable() && this.isShowing() && this.isEnabled())) {
            return;
        }
        try {
            switch (this.m_nFormat) {
                case 1: 
                case 2: {
                    Integer.parseInt(this.getText());
                    break;
                }
                case 3: 
                case 4: {
                    Double.parseDouble(this.getText());
                    break;
                }
                case 5: {
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Improper format.", "Format Error", 0);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.setSelectionStart(0);
        this.setSelectionEnd(this.getText().length());
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().setLayout(new GridLayout(1, 2));
        jFrame.getContentPane().add(new FormattedTextField(4));
        jFrame.getContentPane().add(new JTextField("HH"));
        jFrame.setSize(100, 100);
        jFrame.setVisible(true);
    }
}

