/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.ImageFilterProcessor;

public final class GammaFilter
extends ImageFilterProcessor {
    private double UU_rValue;
    private double VV_gValue;
    private double UV_bValue;
    private int[] Vu_rTable;
    private int[] Uu_gTable;
    private int[] Vv_bTable;
    private boolean Uv_initialized = false;

    public GammaFilter(double d) {
        this(d, d, d);
    }

    public GammaFilter(double d, double d2, double d3) {
        this.UU_rValue = d;
        this.VV_gValue = d2;
        this.UV_bValue = d3;
    }

    public int[] processPixels(int[] nArray, int n, int n2) {
        this.uU_initialize();
        int[] nArray2 = new int[nArray.length];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                int n5 = nArray[n3 * n + n4];
                int n6 = n5 >> 24 & 0xFF;
                int n7 = n5 >> 16 & 0xFF;
                int n8 = n5 >> 8 & 0xFF;
                int n9 = n5 & 0xFF;
                n7 = this.Vu_rTable[n7];
                n8 = this.Uu_gTable[n8];
                n9 = this.Vv_bTable[n9];
                nArray2[n3 * n + n4] = n6 << 24 | n7 << 16 | n8 << 8 | n9;
                ++n4;
            }
            this.m_PercentProgress = n3 * 100 / n2;
            ++n3;
        }
        return nArray2;
    }

    private void uU_initialize() {
        if (this.Uv_initialized) {
            return;
        }
        this.Uv_initialized = true;
        this.Vu_rTable = this.VU_buildTable(this.UU_rValue);
        this.Uu_gTable = this.VV_gValue == this.UU_rValue ? this.Vu_rTable : this.VU_buildTable(this.VV_gValue);
        this.Vv_bTable = this.UV_bValue == this.UU_rValue ? this.Vu_rTable : (this.UV_bValue == this.VV_gValue ? this.Uu_gTable : this.VU_buildTable(this.UV_bValue));
    }

    private int[] VU_buildTable(double d) {
        int[] nArray = new int[256];
        double d2 = 1.0 / d;
        int n = 0;
        while (n < 256) {
            int n2 = (int)(255.0 * Math.pow((double)n / 255.0, d2) + 0.5);
            if (n2 > 255) {
                n2 = 255;
            }
            nArray[n] = n2;
            ++n;
        }
        return nArray;
    }
}

