/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.Consumer;
import imager.ImageIOUtils;
import imager.ImageWrapper;
import imager.ImagerException;
import imager.ImagerGlobal;
import imager.imagefileio.BMP.BMP;
import imager.imagefileio.PICT.PICTReader;
import imager.imagefileio.PSD.PSDReader;
import imager.imagefileio.TGA.TGAinput;
import imager.imagefileio.TIFF.enhanced.tiff.Tiff;
import imager.imagefileio.XPM.Xpm;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JOptionPane;

public final class ImageLoadingThread
extends Thread {
    File imageFile;
    ImageWrapper m_Owner;
    ImageProducer input;
    ImageConsumer output = new Consumer();
    Image image;

    public ImageLoadingThread(ThreadGroup threadGroup, File file, ImageWrapper imageWrapper) {
        super(threadGroup, "Image Loading thread");
        this.imageFile = file;
        this.m_Owner = imageWrapper;
    }

    public ImageLoadingThread(ImageWrapper imageWrapper) {
        this.m_Owner = imageWrapper;
    }

    public ImageLoadingThread(File file, ImageWrapper imageWrapper) {
        this.imageFile = file;
        this.m_Owner = imageWrapper;
    }

    public void setImageFile(File file) {
        this.imageFile = file;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Component component = (Component)((Object)this.m_Owner);
        try {
            try {
                if (!ImagerGlobal.JavaVersion.startsWith("1.3")) {
                    try {
                        this.image = ImageIOUtils.loadUsingImageIO(this.imageFile, this.m_Owner);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.m_Owner.imageNotLoaded(fileNotFoundException);
                        Object var3_8 = null;
                        if (this.image != null) {
                            this.image.flush();
                            this.image = null;
                        }
                        this.imageFile = null;
                        return;
                    }
                    catch (Exception exception) {
                    }
                    catch (Error error) {
                        error.printStackTrace();
                    }
                }
                if (this.image == null) {
                    Object object;
                    if (this.imageFile.getName().toLowerCase().endsWith(".bmp")) {
                        object = new BMP(this.imageFile);
                        this.image = ((BMP)object).getImage();
                        this.image = ImagerGlobal.getImage(this.image, component);
                    } else if (this.imageFile.getName().toLowerCase().endsWith(".tif")) {
                        object = new Tiff();
                        ((Tiff)object).readInputStream(new FileInputStream(this.imageFile));
                        this.image = ((Tiff)object).getImage(0);
                        if (this.image == null) {
                            throw new ImagerException("Probably the TIF image is in compressed format. \nIf not, probably the image is invalid.");
                        }
                    } else if (this.imageFile.getName().toLowerCase().endsWith(".tga")) {
                        this.input = new TGAinput(new FileInputStream(this.imageFile));
                        this.input.addConsumer(this.output);
                        this.image = Toolkit.getDefaultToolkit().createImage(this.input);
                        this.image = ImagerGlobal.getImage(this.image, component);
                        if (this.image == null) {
                            throw new ImagerException("Probably the TGA image is in compressed format. \nIf not, probably the image is invalid.");
                        }
                    } else if (this.imageFile.getName().toLowerCase().endsWith(".psd")) {
                        object = new PSDReader();
                        ((PSDReader)object).read(this.imageFile.getAbsolutePath());
                        this.image = ((PSDReader)object).getImage();
                        if (this.image == null) {
                            throw new ImagerException("Probably the PSD image is in compressed format. \nIf not, probably the image is invalid.");
                        }
                    } else if (this.imageFile.getName().toLowerCase().endsWith(".xpm")) {
                        this.image = Xpm.getXPM(this.imageFile.getAbsolutePath());
                    } else if (this.imageFile.getName().toLowerCase().endsWith(".pct") || this.imageFile.getName().toLowerCase().endsWith(".pict")) {
                        object = new PICTReader();
                        ((PICTReader)object).setImageFile(this.imageFile.getAbsolutePath());
                        this.image = ((PICTReader)object).getImage();
                    } else {
                        this.image = Toolkit.getDefaultToolkit().getImage(this.imageFile.getAbsolutePath());
                    }
                }
                if (this.image == null) {
                    throw new IOException("Error loading image");
                }
                this.image = ImagerGlobal.getBufferedImage(this.image, component);
                this.input = null;
                if (this.image != null) {
                    this.m_Owner.imageLoaded(this.imageFile, this.image);
                }
            }
            catch (Exception exception) {
                this.input = null;
                exception.printStackTrace();
                this.m_Owner.imageNotLoaded(exception);
            }
            catch (Error error) {
                JOptionPane.showMessageDialog((Component)((Object)this.m_Owner), "The program is out of memory.\nPlease close any large images, histogram window or any the image browser if you are not using them.\nThe program will attempt to  reclaim memory.", "Memory Error!!!", 64);
                System.gc();
            }
        }
        catch (Throwable throwable) {
            Object var3_9 = null;
            if (this.image != null) {
                this.image.flush();
                this.image = null;
            }
            this.imageFile = null;
            throw throwable;
        }
        {
            Object var3_10 = null;
            if (this.image != null) {
                this.image.flush();
                this.image = null;
            }
            this.imageFile = null;
            return;
        }
    }
}

