/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.FormattedTextField;
import imager.ImageWrapper;
import imager.Imager;
import imager.ImagerGlobal;
import imager.TextureListPanel;
import imager.TexturePanel;
import imager.components.dialogs.JPhotoDialog;
import imager.utils.CommonComponentHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NewImageDialog
extends JPhotoDialog
implements ImageWrapper {
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JTextField m_WidthTextField = new FormattedTextField(2);
    JTextField m_HeightTextField = new FormattedTextField(2);
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JPanel jPanel2 = new JPanel();
    Border border1;
    TitledBorder titledBorder1;
    JRadioButton m_ColorRadioButton = new JRadioButton();
    JRadioButton m_TextureRadioButton = new JRadioButton();
    JPanel m_ColorPanel = new JPanel();
    JButton m_OkButton = new JButton();
    JButton m_CancelButton = new JButton();
    Imager m_Imager;
    TexturePanel m_TexturePanel = new TexturePanel();
    ButtonGroup buttonGroup1 = new ButtonGroup();
    JButton m_TextureButton = new JButton();
    JButton m_ColorButton = new JButton();
    TitledBorder titledBorder2;

    public NewImageDialog(Imager imager) {
        super(imager, "New Image", true);
        this.m_Imager = imager;
        try {
            this.jbInit();
            this.m_ColorPanel.setBackground(this.m_Imager.m_SelectedBackgroundColor);
            this.setSize(350, 300);
            this.setLocationRelativeTo(this.m_Imager);
            this.m_WidthTextField.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    NewImageDialog.this.m_WidthTextField.selectAll();
                }
            });
            this.m_HeightTextField.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    NewImageDialog.this.m_HeightTextField.selectAll();
                }
            });
            this.getRootPane().setDefaultButton(this.m_OkButton);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void showDialog() {
        this.getRootPane().setDefaultButton(this.m_OkButton);
        this.show();
    }

    void jbInit() throws Exception {
        this.border1 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93));
        this.titledBorder1 = new TitledBorder(this.border1, "Background");
        this.titledBorder2 = new TitledBorder("");
        this.panel1.setLayout(null);
        this.getContentPane().setLayout(this.borderLayout2);
        this.panel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setPreferredSize(new Dimension(10, 50));
        this.m_WidthTextField.setText("500");
        this.m_WidthTextField.setBounds(new Rectangle(64, 25, 71, 21));
        this.m_HeightTextField.setText("500");
        this.m_HeightTextField.setBounds(new Rectangle(229, 23, 69, 22));
        this.jLabel1.setText("Width");
        this.jLabel1.setBounds(new Rectangle(20, 24, 41, 23));
        this.jLabel2.setText("Height");
        this.jLabel2.setBounds(new Rectangle(185, 23, 47, 26));
        this.jPanel2.setBorder(this.titledBorder1);
        this.jPanel2.setBounds(new Rectangle(15, 73, 314, 142));
        this.jPanel2.setLayout(null);
        this.m_ColorRadioButton.setSelected(true);
        this.m_ColorRadioButton.setText("Color");
        this.m_ColorRadioButton.setBounds(new Rectangle(12, 25, 77, 25));
        this.m_ColorRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                NewImageDialog.this.m_ColorRadioButton_stateChanged(changeEvent);
            }
        });
        this.m_TextureRadioButton.setText("Texture");
        this.m_TextureRadioButton.setBounds(new Rectangle(13, 67, 79, 37));
        this.m_TextureRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                NewImageDialog.this.m_TextureRadioButton_stateChanged(changeEvent);
            }
        });
        this.m_ColorPanel.setBounds(new Rectangle(118, 27, 116, 25));
        this.m_OkButton.setSelected(true);
        this.m_OkButton.setText("   Ok   ");
        this.m_OkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewImageDialog.this.m_OkButton_actionPerformed(actionEvent);
            }
        });
        this.m_CancelButton.setText("Cancel");
        this.m_CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewImageDialog.this.m_CancelButton_actionPerformed(actionEvent);
            }
        });
        this.m_TexturePanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.m_TexturePanel.setBounds(new Rectangle(117, 68, 116, 29));
        this.setResizable(false);
        this.m_TextureButton.setBounds(new Rectangle(252, 64, 37, 30));
        this.m_TextureButton.setText("...");
        this.m_TextureButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewImageDialog.this.getTexturePanel().show();
            }
        });
        this.m_TextureButton.setEnabled(false);
        this.m_ColorButton.setText("...");
        this.m_ColorButton.setBounds(new Rectangle(252, 27, 37, 30));
        this.m_ColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewImageDialog.this.m_ColorButton_actionPerformed(actionEvent);
            }
        });
        this.getContentPane().add((Component)this.panel1, "Center");
        this.panel1.add((Component)this.jLabel1, null);
        this.panel1.add((Component)this.m_WidthTextField, null);
        this.panel1.add((Component)this.jLabel2, null);
        this.panel1.add((Component)this.m_HeightTextField, null);
        this.panel1.add((Component)this.jPanel2, null);
        this.jPanel2.add((Component)this.m_ColorRadioButton, null);
        this.jPanel2.add((Component)this.m_TextureRadioButton, null);
        this.jPanel2.add((Component)this.m_ColorPanel, null);
        this.jPanel2.add((Component)this.m_TexturePanel, null);
        this.jPanel2.add((Component)this.m_TextureButton, null);
        this.jPanel2.add((Component)this.m_ColorButton, null);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.m_OkButton, null);
        this.jPanel1.add((Component)this.m_CancelButton, null);
        this.buttonGroup1.add(this.m_ColorRadioButton);
        this.buttonGroup1.add(this.m_TextureRadioButton);
    }

    private TextureListPanel getTexturePanel() {
        return CommonComponentHandler.getTexturePanel(this, this.m_TexturePanel);
    }

    void m_OkButton_actionPerformed(ActionEvent actionEvent) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImagerGlobal.getBufferedImage(Integer.parseInt(this.m_WidthTextField.getText()), Integer.parseInt(this.m_HeightTextField.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Please put valid integer values in width and height", "New Image Error", 0);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(this, "Please put valid integer values in width and height", "New Image Error", 0);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        if (this.m_TextureRadioButton.isSelected()) {
            if (this.m_TexturePanel.getTexture() == null) {
                JOptionPane.showMessageDialog(this, "You must select a texture file or enable text color!", "New Image Error", 0);
                return;
            }
            graphics2D.setPaint(this.m_TexturePanel.getTexture());
        } else {
            graphics2D.setColor(this.m_ColorPanel.getBackground());
        }
        graphics2D.fill(new Rectangle(0, 0, bufferedImage.getWidth(null), bufferedImage.getHeight(null)));
        this.dispose();
        this.m_Imager.setSelectedBackgroundColor(this.m_ColorPanel.getBackground());
        this.m_Imager.createInternalImageFrame(null, bufferedImage, false);
    }

    void m_CancelButton_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    void m_ColorButton_actionPerformed(ActionEvent actionEvent) {
        Color color = JColorChooser.showDialog(this, "Background Color", this.m_ColorPanel.getBackground());
        if (color != null) {
            this.m_ColorPanel.setBackground(color);
        }
    }

    void m_TextureRadioButton_stateChanged(ChangeEvent changeEvent) {
        if (this.m_TextureRadioButton.isSelected()) {
            this.m_TextureButton.setEnabled(true);
        } else {
            this.m_TextureButton.setEnabled(false);
        }
    }

    void m_ColorRadioButton_stateChanged(ChangeEvent changeEvent) {
        if (this.m_ColorRadioButton.isSelected()) {
            this.m_ColorButton.setEnabled(true);
        } else {
            this.m_ColorButton.setEnabled(false);
        }
    }

    public void imageLoaded(File file, Image image) {
        this.m_TexturePanel.setTexture(image);
    }

    public void imageSaved(File file) {
    }

    public void imageNotSaved(Exception exception, File file) {
    }

    public void imageNotLoaded(Exception exception) {
        JOptionPane.showMessageDialog(this, "Error loading the texture", "Texture error", 0);
    }

    public void setImageLoadingStatus(float f) {
    }
}

