/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.AbstractText;
import imager.FormattedTextField;
import imager.Text;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Text3D
extends Text {
    private int U_blockWidth = 5;
    Color m_BlockColor = Color.black;
    boolean isTop = true;
    boolean isLeft = true;

    public Text3D() {
    }

    public Text3D(String string, int n, int n2, Font font, Color color, TexturePaint texturePaint) {
        super(string, n, n2, font, color, texturePaint);
        this.setUIPanel(new text3DPanel());
    }

    public void draw(Graphics2D graphics2D, Rectangle rectangle, boolean bl) {
        graphics2D.setFont(this.m_Font);
        if (bl) {
            this.render(graphics2D, rectangle.x, rectangle.y + rectangle.height - graphics2D.getFontMetrics().getDescent());
        } else {
            graphics2D.drawString(this.m_Text, rectangle.x, rectangle.y + rectangle.height - graphics2D.getFontMetrics().getDescent());
        }
    }

    public void render(Graphics2D graphics2D, int n, int n2) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance((this.isLeft ? -1 : 1) * this.U_blockWidth, (this.isTop ? -1 : 1) * this.U_blockWidth);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = this.m_Font;
        Shape shape = font.createGlyphVector(fontRenderContext, this.m_Text).getOutline();
        PathIterator pathIterator = shape.getPathIterator(null);
        float[] fArray = new float[6];
        float[] fArray2 = new float[6];
        GeneralPath generalPath = new GeneralPath(1);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        while (!pathIterator.isDone()) {
            int n3 = pathIterator.currentSegment(fArray);
            switch (n3) {
                case 0: {
                    affineTransform.transform(fArray, 0, fArray2, 0, 1);
                    f = fArray[0];
                    f2 = fArray[1];
                    f3 = fArray2[0];
                    f4 = fArray2[1];
                    f5 = f;
                    f6 = f2;
                    f7 = f3;
                    f8 = f4;
                    break;
                }
                case 1: {
                    affineTransform.transform(fArray, 0, fArray2, 0, 1);
                    if (Line2D.relativeCCW(f, f2, f3, f4, fArray[0], fArray[1]) < 0) {
                        generalPath.moveTo(f, f2);
                        generalPath.lineTo(fArray[0], fArray[1]);
                        generalPath.lineTo(fArray2[0], fArray2[1]);
                        generalPath.lineTo(f3, f4);
                        generalPath.lineTo(f, f2);
                    } else {
                        generalPath.moveTo(f, f2);
                        generalPath.lineTo(f3, f4);
                        generalPath.lineTo(fArray2[0], fArray2[1]);
                        generalPath.lineTo(fArray[0], fArray[1]);
                        generalPath.lineTo(f, f2);
                    }
                    f = fArray[0];
                    f2 = fArray[1];
                    f3 = fArray2[0];
                    f4 = fArray2[1];
                    break;
                }
                case 2: {
                    affineTransform.transform(fArray, 0, fArray2, 0, 2);
                    if (Line2D.relativeCCW(f, f2, f3, f4, fArray[2], fArray[3]) < 0) {
                        generalPath.moveTo(f, f2);
                        generalPath.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                        generalPath.lineTo(fArray2[2], fArray2[3]);
                        generalPath.quadTo(fArray2[0], fArray2[1], f3, f4);
                        generalPath.lineTo(f, f2);
                    } else {
                        generalPath.moveTo(f, f2);
                        generalPath.lineTo(f3, f4);
                        generalPath.quadTo(fArray2[0], fArray2[1], fArray2[2], fArray2[3]);
                        generalPath.lineTo(fArray[2], fArray[3]);
                        generalPath.quadTo(fArray[0], fArray[1], f, f2);
                    }
                    f = fArray[2];
                    f2 = fArray[3];
                    f3 = fArray2[2];
                    f4 = fArray2[3];
                    break;
                }
                case 3: {
                    affineTransform.transform(fArray, 0, fArray2, 0, 3);
                    if (Line2D.relativeCCW(f, f2, f3, f4, fArray[4], fArray[5]) < 0) {
                        generalPath.moveTo(f, f2);
                        generalPath.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                        generalPath.lineTo(fArray2[4], fArray2[5]);
                        generalPath.curveTo(fArray2[2], fArray2[3], fArray2[0], fArray2[1], f3, f4);
                        generalPath.lineTo(f, f2);
                    } else {
                        generalPath.moveTo(f, f2);
                        generalPath.lineTo(f3, f4);
                        generalPath.curveTo(fArray2[0], fArray2[1], fArray2[2], fArray2[3], fArray2[4], fArray2[5]);
                        generalPath.lineTo(fArray[4], fArray[5]);
                        generalPath.curveTo(fArray[2], fArray[3], fArray[0], fArray[1], f, f2);
                    }
                    f = fArray[4];
                    f2 = fArray[5];
                    f3 = fArray2[4];
                    f4 = fArray2[5];
                    break;
                }
                case 4: {
                    if (Line2D.relativeCCW(f, f2, f3, f4, f5, f6) < 0) {
                        generalPath.moveTo(f, f2);
                        generalPath.lineTo(f5, f6);
                        generalPath.lineTo(f7, f8);
                        generalPath.lineTo(f3, f4);
                        generalPath.lineTo(f, f2);
                    } else {
                        generalPath.moveTo(f, f2);
                        generalPath.lineTo(f3, f4);
                        generalPath.lineTo(f7, f8);
                        generalPath.lineTo(f5, f6);
                        generalPath.lineTo(f, f2);
                    }
                    f = f5;
                    f2 = f6;
                    f3 = f7;
                    f4 = f8;
                }
            }
            pathIterator.next();
        }
        GeneralPath generalPath2 = generalPath;
        graphics2D.translate(n, n2);
        graphics2D.setColor(this.m_BlockColor);
        graphics2D.fill(generalPath2);
        if (this.m_Tp == null) {
            graphics2D.setColor(this.m_Color);
        } else {
            graphics2D.setPaint(this.m_Tp);
        }
        graphics2D.fill(shape);
        graphics2D.translate(-n, -n2);
    }

    public String getName() {
        return "3D Text";
    }

    class text3DPanel
    extends JPanel {
        JButton jButton1 = new JButton();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JTextField jTextField1 = new FormattedTextField(2);
        JRadioButton jRadioButton1 = new JRadioButton();
        JRadioButton jRadioButton2 = new JRadioButton();
        JRadioButton jRadioButton3 = new JRadioButton();
        JRadioButton jRadioButton4 = new JRadioButton();
        ButtonGroup buttonGroup1 = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();

        public text3DPanel() {
            try {
                this.jbInit();
                this.jTextField1.setText("" + Text3D.this.U_blockWidth);
                this.jLabel1.setBackground(Text3D.this.m_BlockColor);
                if (Text3D.this.isLeft) {
                    this.jRadioButton1.setSelected(true);
                } else {
                    this.jRadioButton2.setSelected(true);
                }
                if (Text3D.this.isTop) {
                    this.jRadioButton3.setSelected(true);
                } else {
                    this.jRadioButton4.setSelected(true);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        void jbInit() throws Exception {
            this.jButton1.setBounds(new Rectangle(90, 53, 81, 25));
            this.jButton1.setFont(new Font("Dialog", 0, 12));
            this.jButton1.setMargin(new Insets(2, 2, 2, 2));
            this.jButton1.setText("Block Color");
            this.jButton1.addActionListener(new ActionListener(this){
                final /* synthetic */ text3DPanel this$1;
                {
                    this.this$1 = text3DPanel2;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.jButton1_actionPerformed(actionEvent);
                }
            });
            this.setLayout(null);
            this.jLabel1.setOpaque(true);
            this.jLabel1.setBounds(new Rectangle(102, 83, 26, 23));
            this.jLabel2.setFont(new Font("Dialog", 0, 12));
            this.jLabel2.setText("Block width");
            this.jLabel2.setBounds(new Rectangle(4, 53, 72, 25));
            this.jTextField1.setBounds(new Rectangle(17, 79, 30, 25));
            this.jTextField1.addFocusListener(new FocusAdapter(this){
                final /* synthetic */ text3DPanel this$1;
                {
                    this.this$1 = text3DPanel2;
                }

                public void focusLost(FocusEvent focusEvent) {
                    this.this$1.jTextField1_focusLost(focusEvent);
                }
            });
            this.jRadioButton1.setFont(new Font("Dialog", 0, 12));
            this.jRadioButton1.setText("Left");
            this.jRadioButton1.setBounds(new Rectangle(5, 25, 49, 26));
            this.jRadioButton1.addChangeListener(new ChangeListener(this){
                final /* synthetic */ text3DPanel this$1;
                {
                    this.this$1 = text3DPanel2;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    this.this$1.jRadioButton1_stateChanged(changeEvent);
                }
            });
            this.jRadioButton2.setFont(new Font("Dialog", 0, 12));
            this.jRadioButton2.setText("Right");
            this.jRadioButton2.setBounds(new Rectangle(77, 25, 55, 26));
            this.jRadioButton2.addChangeListener(new ChangeListener(this){
                final /* synthetic */ text3DPanel this$1;
                {
                    this.this$1 = text3DPanel2;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    this.this$1.jRadioButton2_stateChanged(changeEvent);
                }
            });
            this.jRadioButton3.setFont(new Font("Dialog", 0, 12));
            this.jRadioButton3.setText("Top");
            this.jRadioButton3.setBounds(new Rectangle(5, 0, 69, 24));
            this.jRadioButton3.addChangeListener(new ChangeListener(this){
                final /* synthetic */ text3DPanel this$1;
                {
                    this.this$1 = text3DPanel2;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    this.this$1.jRadioButton3_stateChanged(changeEvent);
                }
            });
            this.jRadioButton4.setFont(new Font("Dialog", 0, 12));
            this.jRadioButton4.setText("Bottom");
            this.jRadioButton4.setBounds(new Rectangle(78, 0, 67, 26));
            this.jRadioButton4.addChangeListener(new ChangeListener(this){
                final /* synthetic */ text3DPanel this$1;
                {
                    this.this$1 = text3DPanel2;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    this.this$1.jRadioButton4_stateChanged(changeEvent);
                }
            });
            this.add((Component)this.jButton1, null);
            this.add((Component)this.jLabel1, null);
            this.add((Component)this.jRadioButton3, null);
            this.add((Component)this.jRadioButton4, null);
            this.add((Component)this.jRadioButton2, null);
            this.add((Component)this.jRadioButton1, null);
            this.add((Component)this.jLabel2, null);
            this.add((Component)this.jTextField1, null);
            this.buttonGroup1.add(this.jRadioButton3);
            this.buttonGroup1.add(this.jRadioButton4);
            this.buttonGroup2.add(this.jRadioButton1);
            this.buttonGroup2.add(this.jRadioButton2);
        }

        void jButton1_actionPerformed(ActionEvent actionEvent) {
            Color color = JColorChooser.showDialog(this, "Shadow Color", this.jLabel1.getBackground());
            if (color != null) {
                Text3D.this.m_BlockColor = color;
                this.firePropertyChange(AbstractText.TEXT_PROPERTIES_CHANGED, this.jLabel1.getBackground(), color);
                this.jLabel1.setBackground(color);
            }
        }

        void jTextField1_focusLost(FocusEvent focusEvent) {
            int n = Text3D.this.U_blockWidth;
            Text3D.this.U_blockWidth = Integer.parseInt(this.jTextField1.getText());
            this.firePropertyChange(AbstractText.TEXT_PROPERTIES_CHANGED, n, Text3D.this.U_blockWidth);
        }

        void jRadioButton3_stateChanged(ChangeEvent changeEvent) {
            if (this.jRadioButton3.isSelected()) {
                Text3D.this.isTop = true;
                this.firePropertyChange(AbstractText.TEXT_PROPERTIES_CHANGED, false, true);
            }
        }

        void jRadioButton4_stateChanged(ChangeEvent changeEvent) {
            if (this.jRadioButton4.isSelected()) {
                Text3D.this.isTop = false;
                this.firePropertyChange(AbstractText.TEXT_PROPERTIES_CHANGED, false, true);
            }
        }

        void jRadioButton1_stateChanged(ChangeEvent changeEvent) {
            if (this.jRadioButton1.isSelected()) {
                Text3D.this.isLeft = true;
                this.firePropertyChange(AbstractText.TEXT_PROPERTIES_CHANGED, false, true);
            }
        }

        void jRadioButton2_stateChanged(ChangeEvent changeEvent) {
            if (this.jRadioButton2.isSelected()) {
                Text3D.this.isLeft = false;
                this.firePropertyChange(AbstractText.TEXT_PROPERTIES_CHANGED, false, true);
            }
        }
    }
}

