/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.Drawable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

class ThumbNail
extends JLabel
implements MouseListener {
    Drawable drawable;
    boolean selected = false;
    Rectangle m_Rectangle;
    Color color = new Color(200, 200, 200);
    static BasicStroke boldStroke = new BasicStroke(5.0f);
    boolean bDrawOutline = false;

    ThumbNail(Drawable drawable) {
        this.drawable = drawable;
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.addMouseListener(this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.selected = true;
        this.firePropertyChange("thumbnail selected", null, this);
        this.repaint();
    }

    public void drawOutline(boolean bl) {
        this.bDrawOutline = bl;
    }

    public void setFillColor(Color color) {
        this.color = color;
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
    }

    public void paint(Graphics graphics) {
        Object object;
        if (this.bDrawOutline) {
            graphics.setColor(this.color);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            this.paintBorder(graphics);
        }
        if (this.m_Rectangle == null && (object = this.drawable.getBounds(graphics)) != null) {
            this.m_Rectangle = new Rectangle((this.getWidth() - ((Rectangle)object).width) / 2, (this.getHeight() - ((Rectangle)object).height) / 2, ((Rectangle)object).width, ((Rectangle)object).height);
        }
        object = (Graphics2D)graphics;
        if (this.m_Rectangle != null) {
            this.drawable.draw((Graphics2D)object, this.m_Rectangle, true);
        }
        if (this.selected) {
            ((Graphics)object).setColor(Color.red);
            ((Graphics2D)object).setStroke(boldStroke);
            ((Graphics)object).drawRect((int)boldStroke.getLineWidth() / 2, (int)boldStroke.getLineWidth() / 2, this.getWidth() - (int)boldStroke.getLineWidth(), this.getHeight() - (int)boldStroke.getLineWidth());
        } else if (this.bDrawOutline) {
            graphics.setColor(Color.black);
            graphics.drawRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        }
    }
}

