/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.ImageWarper;
import imager.Imager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;

final class Warp {
    int[] m_oldPixels;
    int[] m_newPixels;
    Point fromPoint;
    Point toPoint;
    int kVOffset = 0;
    int kHOffset = 0;
    int mHeight;
    int mWidth;
    Imager m_Imager;

    public Warp(Imager imager) {
        this.m_Imager = imager;
    }

    public void DoneWithWarping() {
        MemoryImageSource memoryImageSource = new MemoryImageSource(this.mWidth, this.mHeight, this.m_newPixels, 0, this.mWidth);
        this.m_Imager.setSelectedImagePortion(Toolkit.getDefaultToolkit().createImage(memoryImageSource));
    }

    Point ClipToImage(Point point, int n, int n2) {
        int n3 = n - point.x;
        int n4 = n2 - point.y;
        if (n3 == 0) {
            if (n2 < this.kVOffset) {
                n2 = this.kVOffset;
            }
            if (n2 >= this.kVOffset + this.mHeight) {
                n2 = this.kVOffset + this.mHeight - 1;
            }
        } else if (n4 == 0) {
            if (n < this.kHOffset) {
                n = this.kHOffset;
            }
            if (n >= this.kHOffset + this.mWidth) {
                n = this.kHOffset + this.mWidth - 1;
            }
        } else {
            double d = (double)n4 / (double)n3;
            if (n < this.kHOffset) {
                n = this.kHOffset;
                n2 = point.y + (int)(d * (double)(n - point.x));
            }
            if (n >= this.kHOffset + this.mWidth) {
                n = this.kHOffset + this.mWidth - 1;
                n2 = point.y + (int)(d * (double)(n - point.x));
            }
            if (n2 < this.kVOffset) {
                n2 = this.kVOffset;
                n = point.x + (int)((double)(n2 - point.y) / d);
            }
            if (n2 >= this.kVOffset + this.mHeight) {
                n2 = this.kVOffset + this.mHeight - 1;
                n = point.x + (int)((double)(n2 - point.y) / d);
            }
        }
        return new Point(n, n2);
    }

    boolean PointInImage(int n, int n2) {
        return n >= this.kHOffset && n < this.kHOffset + this.mWidth && n2 >= this.kVOffset && n2 < this.kVOffset + this.mHeight;
    }

    public void mousePressed(int n, int n2) {
        this.m_oldPixels = this.m_Imager.m_ImageHandler.getPixels();
        this.mWidth = this.m_Imager.getImage().getWidth(null);
        this.mHeight = this.m_Imager.getImage().getHeight(null);
        if (!this.PointInImage(n, n2)) {
            return;
        }
        this.fromPoint = new Point(n, n2);
    }

    public void mouseReleased(int n, int n2) {
        Point point = this.ClipToImage(this.fromPoint, n, n2);
        this.m_newPixels = new int[this.mWidth * this.mHeight];
        ImageWarper imageWarper = new ImageWarper(this, this.m_oldPixels, this.m_newPixels, this.mWidth, this.mHeight, point, this.fromPoint);
        imageWarper.start();
        this.toPoint = point;
        this.toPoint = null;
        this.fromPoint = null;
    }

    public void mouseDragged(int n, int n2) {
        if (this.fromPoint == null) {
            return;
        }
        if (this.toPoint == null || !this.toPoint.equals(this.fromPoint)) {
            this.toPoint = this.ClipToImage(this.fromPoint, n, n2);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }
}

