/*
 * Decompiled with CFR 0.152.
 */
package imager.components.dialogs;

import imager.AbstractText;
import imager.AlphaFilter;
import imager.FormattedTextField;
import imager.HelpBrowser;
import imager.HorizScrollingTextAnimation;
import imager.ImagerGlobal;
import imager.TextDialog;
import imager.components.dialogs.AnimationPreviewPanel;
import imager.components.dialogs.GIFAnimatorFrame;
import imager.imagefileio.GIF.GIFFrame;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class BannerDialog
extends TextDialog {
    AnimationPreviewPanel animPanel;
    HorizScrollingTextAnimation animation;
    private JTextField U_widthTF;
    private JTextField u_heightTF;
    private static int V_counter = 0;
    GIFAnimatorFrame gifFrameDialog;
    JTextField textfield;

    public BannerDialog(GIFAnimatorFrame gIFAnimatorFrame, Vector vector, Font font, Color color) {
        super((Frame)gIFAnimatorFrame, vector, font, color);
        this.gifFrameDialog = gIFAnimatorFrame;
        this.setTitle("Horizontal Scrolling Text Banner Options");
        this.fontPanel1.setBounds(5, 5, 280, 170);
        this.animPanel = new AnimationPreviewPanel();
        this.animation = new HorizScrollingTextAnimation();
        AbstractText abstractText = (AbstractText)ImagerGlobal.getClone(this.tsp.getSelectedText());
        abstractText.setText("Scrolling Banner");
        this.animation.setText(abstractText);
        this.animation.setScrollValue(20);
        this.animation.setDelay(500);
        this.animation.setTransparent(false);
        this.animPanel.setAnimation(this.animation);
        this.jScrollPane1.remove(this.jTextArea1);
        this.jScrollPane1.setViewportView(this.animPanel);
        this.animation.setUIPanelBounds(10, 180, 250, 100);
        this.panel1.add(this.animation.getUIPanel());
        this.U_widthTF = new FormattedTextField(2);
        this.u_heightTF = new FormattedTextField(2);
        JLabel jLabel = new JLabel("Banner  Width:");
        jLabel.setBounds(10, 290, 80, 25);
        jLabel.setFont(new Font("Dialog", 0, 12));
        this.panel1.add(jLabel);
        this.panel1.add(this.U_widthTF);
        this.U_widthTF.setBounds(95, 290, 40, 25);
        jLabel = new JLabel("height:");
        jLabel.setBounds(155, 290, 45, 25);
        jLabel.setFont(new Font("Dialog", 0, 12));
        jLabel.setOpaque(true);
        this.panel1.add(jLabel);
        this.panel1.add(this.u_heightTF);
        this.u_heightTF.setBounds(200, 290, 40, 25);
        this.U_widthTF.setText("" + this.animPanel.getBannerSize().width);
        this.u_heightTF.setText("" + this.animPanel.getBannerSize().height);
        this.u_heightTF.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (BannerDialog.this.u_heightTF.getText().trim().length() > 0) {
                    BannerDialog.this.animPanel.setBannerHeight(Integer.parseInt(BannerDialog.this.u_heightTF.getText().trim()));
                }
            }
        });
        this.U_widthTF.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (BannerDialog.this.U_widthTF.getText().trim().length() > 0) {
                    BannerDialog.this.animPanel.setBannerWidth(Integer.parseInt(BannerDialog.this.U_widthTF.getText().trim()));
                }
            }
        });
        JLabel jLabel2 = new JLabel("Text:");
        jLabel2.setBounds(10, 320, 30, 30);
        this.panel1.add(jLabel2);
        this.textfield = new JTextField("Scrolling Banner");
        this.textfield.setBounds(40, 320, 255, 30);
        this.textfield.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (BannerDialog.this.textfield.getText().trim().length() > 0) {
                    ((AbstractText)BannerDialog.this.animation.getText()).setText(BannerDialog.this.textfield.getText().trim());
                }
            }
        });
        this.panel1.add(this.textfield);
        this.setVisible(true);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if (propertyChangeEvent.getPropertyName().equals("Selected Text Changed") || propertyChangeEvent.getPropertyName().equals(AbstractText.TEXT_PROPERTIES_CHANGED)) {
            AbstractText abstractText = (AbstractText)ImagerGlobal.getClone((AbstractText)propertyChangeEvent.getNewValue());
            abstractText.setColor(this.m_ColorPanel.getBackground());
            abstractText.setTexture(this.jRadioButton1.isSelected() ? null : this.m_TexturePanel.getTexture());
            abstractText.setFont(this.fontPanel1.getSelectedFont());
            if (this.textfield.getText().trim().length() > 0) {
                abstractText.setText(this.textfield.getText());
            }
            this.animation.setText(abstractText);
        } else if (propertyChangeEvent.getPropertyName().equals("Texture Changed") || propertyChangeEvent.getPropertyName().equals("texture changed")) {
            ((AbstractText)this.animation.getText()).setTexture((TexturePaint)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("Font Changed")) {
            if (propertyChangeEvent.getNewValue() != null) {
                ((AbstractText)this.animation.getText()).setFont((Font)propertyChangeEvent.getNewValue());
            }
        } else if (propertyChangeEvent.getPropertyName().equals("Text Color Changed")) {
            ((AbstractText)this.animation.getText()).setColor((Color)propertyChangeEvent.getNewValue());
            ((AbstractText)this.animation.getText()).setTexture(null);
        }
    }

    protected void m_OkButton_actionPerformed(ActionEvent actionEvent) {
        int n;
        if (this.jRadioButton2.isSelected() && this.m_TexturePanel.getTexture() == null) {
            JOptionPane.showConfirmDialog(this, "You must select a texture file or enable text color!", "Text Option Error", -1, 0);
            return;
        }
        int n2 = this.animation.getNumFrames(this.animPanel.getBannerSize());
        if (n2 > 15 && (n = JOptionPane.showConfirmDialog(this, "The number of frames to be generated is " + n2 + "\n which is a high number. The resulting animated GIF " + "\nbanner may be of a large size and the generation will " + "\ntake some time. If you want to reduce the number of frames, " + "\n increase the scroll value or decrease the banner width." + "\n Do you want to continue the operation? press 'Yes' if you do want to." + "\n Or if you want to modify the configurations press 'No'. ", "Frame Generation Warning", 0)) != 0) {
            return;
        }
        this.animPanel.stopAnimate();
        BufferedImage bufferedImage = null;
        GIFFrame[] gIFFrameArray = new GIFFrame[n2];
        this.animation.reset();
        int n3 = 0;
        while (n3 < n2) {
            bufferedImage = ImagerGlobal.getBufferedImage(this.animPanel.getBannerSize().width, this.animPanel.getBannerSize().height);
            Graphics graphics = bufferedImage.getGraphics();
            gIFFrameArray[n3] = new GIFFrame();
            gIFFrameArray[n3].setDelay(this.animation.getDelay());
            if (this.animation.isTransparent()) {
                gIFFrameArray[n3].setTransparentColor(AlphaFilter.TRANSPARENTCOLOR);
                graphics.setColor(AlphaFilter.TRANSPARENTCOLOR);
                graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            }
            this.animation.animate(graphics, new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight()));
            gIFFrameArray[n3].setImage(bufferedImage);
            gIFFrameArray[n3].setFrameName("Scrolling Text " + V_counter);
            ++V_counter;
            ++n3;
        }
        this.gifFrameDialog.setGIFFrames(gIFFrameArray);
        this.setVisible(false);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.animPanel.startAnimation();
        } else {
            this.animPanel.stopAnimate();
        }
        super.setVisible(bl);
    }

    protected void helpButton_actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.m_Help == null) {
                this.m_Help = new HelpBrowser((Dialog)this, "Banner Wizard Dialog", null, "BannerWizard.htm");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_Help.setVisible(true);
    }
}

