/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.GIF;

import imager.DemoStamper;
import imager.ImageWrapper;
import imager.ImagerGlobal;
import imager.imagefileio.GIF.AnimatedGifDecoder;
import imager.imagefileio.GIF.AnimatedGifEncoder;
import imager.imagefileio.GIF.GIFFrame;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class AnimatedGifProcessor {
    public static void createAnimatedGif(String string, int n, int n2, int n3, int n4, Object[] objectArray, ImageWrapper imageWrapper, Component component) {
        try {
            AnimatedGifEncoder animatedGifEncoder = new AnimatedGifEncoder();
            animatedGifEncoder.start(string);
            animatedGifEncoder.setQuality(n);
            animatedGifEncoder.setRepeat(n2);
            if (n3 > 0 && n4 > 0) {
                animatedGifEncoder.setSize(n3, n4);
            }
            BufferedImage bufferedImage = null;
            int n5 = 0;
            while (n5 < objectArray.length) {
                GIFFrame gIFFrame = (GIFFrame)objectArray[n5];
                animatedGifEncoder.setDelay(gIFFrame.getDelay());
                bufferedImage = gIFFrame.isResizeImage() ? (gIFFrame.getImage().getWidth() == n3 && gIFFrame.getImage().getHeight() == n4 ? gIFFrame.getImage() : ImagerGlobal.getBufferedImage(gIFFrame.getImage().getScaledInstance(n3, n4, 16), component)) : gIFFrame.getImage();
                if (gIFFrame.getTransparentColor() != null) {
                    animatedGifEncoder.setTransparent(gIFFrame.getTransparentColor());
                }
                if (ImagerGlobal.getAppType() == 0) {
                    DemoStamper.stamp(bufferedImage, "Saved in Demo Version");
                }
                animatedGifEncoder.addFrame(bufferedImage);
                imageWrapper.setImageLoadingStatus((n5 + 1) * 100 / objectArray.length);
                ++n5;
            }
            animatedGifEncoder.finish();
            imageWrapper.imageSaved(new File(string));
        }
        catch (Exception exception) {
            imageWrapper.imageNotSaved(exception, new File(string));
        }
    }

    public static void extractAnimatedGifFrames(ImageWrapper imageWrapper, File file) {
        try {
            AnimatedGifDecoder animatedGifDecoder = new AnimatedGifDecoder();
            animatedGifDecoder.read(new FileInputStream(file));
            int n = animatedGifDecoder.getFrameCount();
            if (n == 0) {
                throw new IOException("Error Loading Image");
            }
            int n2 = 0;
            while (n2 < n) {
                imageWrapper.imageLoaded(new File(String.valueOf(file.getName()) + "_" + n2), animatedGifDecoder.getFrame(n2));
                ++n2;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            imageWrapper.imageNotLoaded(fileNotFoundException);
        }
        catch (IOException iOException) {
            imageWrapper.imageNotLoaded(iOException);
        }
    }
}

