/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.ICO;

import imager.imagefileio.ICO.ICOBitmap;
import imager.imagefileio.ICO.ICOBitmapMask;
import imager.imagefileio.ICO.ICOEntry;
import imager.imagefileio.ICO.general.FileDecoder;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.IOException;

public abstract class ICOBitmapIndexed
extends ICOBitmap {
    protected int[] fBits;
    private Color[] U_fColorPalette;

    public ICOBitmapIndexed(ICOEntry iCOEntry) {
        super(iCOEntry);
        this.fBits = new int[this.fWidth * this.fHeight];
    }

    public void read(FileDecoder fileDecoder) throws IOException {
        this.read(fileDecoder, false);
    }

    public void read(FileDecoder fileDecoder, boolean bl) throws IOException {
        if (!bl) {
            this.U_fColorPalette = new Color[this.fEntry.getColorCount()];
            int n = 0;
            while (n < this.fEntry.getColorCount()) {
                this.setColor(n, this.u_readColor(fileDecoder));
                ++n;
            }
        }
        this.readIndexed(fileDecoder);
        if (!bl) {
            ICOBitmapMask iCOBitmapMask = new ICOBitmapMask(this.fEntry);
            iCOBitmapMask.read(fileDecoder);
            this.fEntry.setMask(iCOBitmapMask);
        }
    }

    protected abstract void readIndexed(FileDecoder var1) throws IOException;

    private Color u_readColor(FileDecoder fileDecoder) throws IOException {
        int n = fileDecoder.readUInt1();
        int n2 = fileDecoder.readUInt1();
        int n3 = fileDecoder.readUInt1();
        fileDecoder.readUInt1();
        return new Color(n3, n2, n);
    }

    protected int adjustToPadding(int n) {
        if ((n & 3) != 0) {
            n = (n & 0xFFFFFFFC) + 4;
        }
        return n;
    }

    public BufferedImage createImageIndexed() {
        IndexColorModel indexColorModel = this.V_createColorModel();
        BufferedImage bufferedImage = new BufferedImage(this.fWidth, this.fHeight, 13, indexColorModel);
        bufferedImage.getRaster().setSamples(0, 0, this.fWidth, this.fHeight, 0, this.fBits);
        return bufferedImage;
    }

    private IndexColorModel V_createColorModel() {
        int n = this.fEntry.getColorCount();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            Color color = this.getColor(n2);
            byArray[n2] = (byte)color.getRed();
            byArray2[n2] = (byte)color.getGreen();
            byArray3[n2] = (byte)color.getBlue();
            byArray4[n2] = -1;
            ++n2;
        }
        IndexColorModel indexColorModel = new IndexColorModel(8, n, byArray, byArray2, byArray3, byArray4);
        return indexColorModel;
    }

    public BufferedImage createImageRGB() {
        BufferedImage bufferedImage = new BufferedImage(this.fWidth, this.fHeight, 2);
        int n = 0;
        while (n < this.fHeight) {
            int n2 = 0;
            while (n2 < this.fWidth) {
                int n3 = this.getColor(n2, n).getRGB();
                n3 = this.fEntry.getMask().getPaletteIndex(n2, n) == 0 ? (n3 |= 0xFF000000) : (n3 &= 0xFFFFFF);
                bufferedImage.setRGB(n2, n, n3);
                ++n2;
            }
            ++n;
        }
        return bufferedImage;
    }

    public Color getColor(int n, int n2) {
        return this.getColor(this.getPaletteIndex(n, n2));
    }

    public int getPaletteIndex(int n, int n2) {
        return this.fBits[n2 * this.fWidth + n];
    }

    public Color getColor(int n) {
        return this.U_fColorPalette[n];
    }

    public void setColor(int n, Color color) {
        this.U_fColorPalette[n] = color;
    }
}

