/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.ICO;

import imager.imagefileio.ICO.ICOEntry;
import imager.imagefileio.ICO.ICOFile;
import imager.imagefileio.ICO.ICOImageReaderSpi;
import imager.imagefileio.ICO.ICOMetaData;
import imager.imagefileio.ICO.general.FileDecoderImageInputStream;
import java.awt.Container;
import java.awt.color.ColorSpace;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;

public class ICOReader
extends ImageReader {
    ICOFile _icoFile;
    ImageInputStream _stream;

    public ICOReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    public int getHeight(int n) throws IOException {
        return this.U_getICOEntry(n).getHeight();
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        return new ICOMetaData(this.U_getICOEntry(n));
    }

    public Iterator getImageTypes(int n) throws IOException {
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
        int n2 = 0;
        while (n2 < this.getNumImages(false)) {
            ICOEntry iCOEntry = this.U_getICOEntry(n2);
            ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createInterleaved(ColorSpace.getInstance(1000), new int[1], 0, false, false);
            arrayList.add(imageTypeSpecifier);
            ++n2;
        }
        return arrayList.iterator();
    }

    public int getNumImages(boolean bl) throws IOException {
        return this.v_getICOFile().getImageCount();
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    public int getWidth(int n) throws IOException {
        return this.U_getICOEntry(n).getWidth();
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        return this.U_getICOEntry(n).getBitmap().createImageRGB();
    }

    public void setInput(Object object, boolean bl, boolean bl2) {
        this._stream = (ImageInputStream)object;
    }

    private ICOFile v_getICOFile() {
        if (this._icoFile == null) {
            try {
                this._icoFile = new ICOFile(new FileDecoderImageInputStream(this._stream));
            }
            catch (IOException iOException) {
                System.err.println("Can't create ICOFile: " + iOException.getMessage());
            }
        }
        return this._icoFile;
    }

    private ICOEntry U_getICOEntry(int n) {
        return (ICOEntry)this.v_getICOFile().getEntries().get(n);
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.err.println("Please specify the icon file name");
            System.exit(1);
        }
        IIORegistry.getDefaultInstance().registerServiceProvider(new ICOImageReaderSpi());
        ICOReader.listServiceProviders();
        String string = stringArray[0];
        File file = new File(string);
        if (!file.isFile()) {
            System.err.println(String.valueOf(string) + " not found, or is no file");
            System.exit(1);
        }
        String string2 = file.getName();
        JFrame jFrame = ICOReader.u_createWindow(string2);
        ImageReader imageReader = ImageIO.getImageReadersByFormatName("ico").next();
        if (imageReader == null) {
            System.err.println("No reader for format 'ico' found");
            System.exit(1);
        }
        imageReader.setInput(ImageIO.createImageInputStream(file));
        int n = imageReader.getNumImages(true);
        int n2 = 0;
        while (n2 < n) {
            ICOReader.V_addImage(jFrame.getContentPane(), imageReader, n2);
            ++n2;
        }
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private static JFrame u_createWindow(String string) {
        JFrame jFrame = new JFrame(string);
        jFrame.setDefaultCloseOperation(2);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        BoxLayout boxLayout = new BoxLayout(jFrame.getContentPane(), 1);
        jFrame.getContentPane().setLayout(boxLayout);
        return jFrame;
    }

    private static void V_addImage(Container container, ImageReader imageReader, int n) throws IOException {
        JButton jButton = new JButton();
        jButton.setIcon(new ImageIcon(imageReader.read(n)));
        jButton.setText(imageReader.getWidth(n) + "x" + imageReader.getHeight(n));
        container.add(jButton);
    }

    public static void listServiceProviders() {
        System.out.println("Registered image formats and their providers");
        String[] stringArray = ImageIO.getReaderFormatNames();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            Iterator<ImageReader> iterator2 = ImageIO.getImageReadersBySuffix(string);
            while (iterator2.hasNext()) {
                ImageReader imageReader = iterator2.next();
                ImageReaderSpi imageReaderSpi = imageReader.getOriginatingProvider();
                System.out.println(" o " + string + " (" + imageReaderSpi.getDescription(Locale.getDefault()) + ") by " + imageReaderSpi.getVendorName());
            }
            ++n;
        }
    }
}

