/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.TIFF.enhanced.tiff;

import imager.imagefileio.TIFF.enhanced.MemoryFileInputFilter;
import imager.imagefileio.TIFF.enhanced.MotorolaIntelInputFilter;
import imager.imagefileio.TIFF.enhanced.tag.CompressionType;
import imager.imagefileio.TIFF.enhanced.tiff.DataType;
import imager.imagefileio.TIFF.enhanced.tiff.Tag;
import java.io.IOException;

class IFDEntry {
    public static final int SIZE = 12;
    public Tag tag;
    public DataType type;
    public long count;
    public long value;
    public byte[] dataArray;

    public IFDEntry() {
        this.init();
    }

    public IFDEntry(int n, int n2, long l, long l2) {
        this.tag = new Tag(n);
        this.type = new DataType(n2);
        this.count = l;
        this.value = l2;
        this.dataArray = null;
    }

    void init() {
        this.tag = new Tag();
        this.type = new DataType();
        this.count = 0L;
        this.value = 0L;
        this.dataArray = null;
    }

    public boolean isOffset() {
        return this.sizeOfData() > 4;
    }

    public int sizeOfData() {
        return (int)this.count * this.type.size();
    }

    void setOffset(long l) {
        this.value = l;
    }

    public void writeEntry(MotorolaIntelInputFilter motorolaIntelInputFilter) throws IOException {
        this.tag.write(motorolaIntelInputFilter);
        this.type.write(motorolaIntelInputFilter);
        motorolaIntelInputFilter.writeInt((int)this.count);
        motorolaIntelInputFilter.writeInt((int)this.value);
    }

    public void writeData(MotorolaIntelInputFilter motorolaIntelInputFilter) throws IOException {
        motorolaIntelInputFilter.seek(this.value);
        if (this.type.isRational()) {
            byte[] byArray = new byte[this.dataArray.length];
            byArray[0] = this.dataArray[3];
            byArray[1] = this.dataArray[2];
            byArray[2] = this.dataArray[1];
            byArray[3] = this.dataArray[0];
            byArray[4] = this.dataArray[7];
            byArray[5] = this.dataArray[6];
            byArray[6] = this.dataArray[5];
            byArray[7] = this.dataArray[4];
            motorolaIntelInputFilter.write(byArray);
        } else {
            motorolaIntelInputFilter.writeProperly(this.dataArray, this.type.size(), this.sizeOfData());
        }
    }

    public void read(MemoryFileInputFilter memoryFileInputFilter) {
        this.read(memoryFileInputFilter, 0L);
    }

    public void read(MemoryFileInputFilter memoryFileInputFilter, long l) {
        this.tag.read(memoryFileInputFilter);
        this.type.read(memoryFileInputFilter);
        this.count = memoryFileInputFilter.readInt();
        this.value = memoryFileInputFilter.readInt();
        if (this.isOffset()) {
            int n = this.sizeOfData();
            long l2 = memoryFileInputFilter.getFilePointer();
            this.dataArray = new byte[n];
            memoryFileInputFilter.seek(this.value + l);
            if (this.type.isAscii()) {
                memoryFileInputFilter.readFully(this.dataArray);
            } else if (this.type.isRational()) {
                DataType dataType = new DataType(4);
                byte[] byArray = new byte[4];
                if (memoryFileInputFilter.isIntel()) {
                    memoryFileInputFilter.readProperly(this.dataArray, dataType.size(), 4);
                    memoryFileInputFilter.readProperly(byArray, dataType.size(), 4);
                    System.arraycopy(byArray, 0, this.dataArray, 4, 4);
                } else {
                    memoryFileInputFilter.readFully(this.dataArray);
                }
            } else {
                memoryFileInputFilter.readProperly(this.dataArray, this.type.size(), n);
            }
            memoryFileInputFilter.seek(l2);
        }
        if (this.type.isShort() && !memoryFileInputFilter.isIntel()) {
            this.value = (int)(this.value >> 16 & 0xFFFFL);
        }
    }

    public String toString() {
        String string = "Tag: " + this.tag.toString() + ", Type: " + this.type.toString() + ", Count: " + this.count;
        if (this.tag.equals(259)) {
            string = String.valueOf(string) + ", " + CompressionType.toString((int)this.value);
        } else if (this.isOffset()) {
            int n = Math.min(this.dataArray.length, 256);
            string = String.valueOf(string) + ", Offset: 0x" + Long.toHexString(this.value) + ", " + this.sizeOfData() + "bytes";
            if (this.type.isAscii()) {
                String string2 = new String(this.dataArray, 0, 0, this.dataArray.length);
                string = String.valueOf(string) + "\n\t\t" + string2 + "\n";
            } else if (this.type.isRational()) {
                int n2 = ((this.dataArray[0] & 0xFF) << 24) + ((this.dataArray[1] & 0xFF) << 16) + ((this.dataArray[2] & 0xFF) << 8) + (this.dataArray[3] & 0xFF);
                int n3 = ((this.dataArray[4] & 0xFF) << 24) + ((this.dataArray[5] & 0xFF) << 16) + ((this.dataArray[6] & 0xFF) << 8) + (this.dataArray[7] & 0xFF);
                string = String.valueOf(string) + "\n\t\t" + n2 + "/" + n3 + "\n";
            } else if (this.tag.equals(320)) {
                int n4 = this.dataArray.length / 3;
                int n5 = 0;
                while (n5 < this.dataArray.length) {
                    if (n5 % n4 == 0) {
                        string = String.valueOf(string) + "\n\n\t\t";
                    }
                    if (n5 % 16 == 0) {
                        string = String.valueOf(string) + "\n\t\t";
                    }
                    string = n5 % 2 == 0 ? String.valueOf(string) + "|" : String.valueOf(string) + " ";
                    int n6 = this.dataArray[n5] & 0xFF;
                    string = String.valueOf(string) + (n6 == 0 ? "00" : Integer.toHexString(n6));
                    ++n5;
                }
                string = String.valueOf(string) + "\n";
            } else if (this.type.equals(3)) {
                int n7 = 0;
                while (n7 < this.dataArray.length) {
                    string = n7 % 16 == 0 ? String.valueOf(string) + "\n\t\t" : String.valueOf(string) + ", ";
                    int n8 = ((this.dataArray[n7] & 0xFF) << 8) + (this.dataArray[n7 + 1] & 0xFF);
                    string = String.valueOf(string) + n8;
                    n7 += 2;
                }
                string = String.valueOf(string) + "\n";
            } else if (this.type.equals(4)) {
                int n9 = 0;
                while (n9 < n) {
                    int n10 = ((this.dataArray[n9] & 0xFF) << 24) + ((this.dataArray[n9 + 1] & 0xFF) << 16) + ((this.dataArray[n9 + 2] & 0xFF) << 8) + (this.dataArray[n9 + 3] & 0xFF);
                    string = n9 % 16 == 0 ? String.valueOf(string) + "\n\t\t" : String.valueOf(string) + ", ";
                    string = String.valueOf(string) + n10;
                    n9 += 4;
                }
                string = String.valueOf(string) + "\n";
            }
        } else {
            string = String.valueOf(string) + ", Value: " + this.value;
        }
        return string;
    }
}

