/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.TIFF.enhanced.tiff;

import imager.imagefileio.TIFF.enhanced.Converter;
import imager.imagefileio.TIFF.enhanced.tiff.T4Code;

class T4Node {
    public static final int NOMASK = 65535;
    int mask = 65535;
    T4Node zero = null;
    T4Node one = null;
    T4Code code = null;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Converter.intToBinaryString(this.mask, 16);
        int n = this.mask != 65535 ? string.indexOf("1") : this.code.bitLength;
        stringBuffer.append("\n");
        while (n > 0) {
            stringBuffer.append(" ");
            --n;
        }
        stringBuffer.append("{");
        stringBuffer.append(string);
        stringBuffer.append(",");
        stringBuffer.append(this.zero);
        stringBuffer.append(",");
        stringBuffer.append(this.one);
        stringBuffer.append(",");
        stringBuffer.append(this.code);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void Add(int n, T4Code t4Code) {
        if (n == t4Code.bitLength) {
            this.code = t4Code;
        } else {
            int n2;
            ++n;
            if (this.mask == 65535) {
                this.mask = 1 << 16 - n;
            }
            if (((n2 = t4Code.codeWord << 16 - t4Code.bitLength) & this.mask) == 0) {
                if (this.zero == null) {
                    this.zero = new T4Node();
                }
                this.zero.Add(n, t4Code);
            } else {
                if (this.one == null) {
                    this.one = new T4Node();
                }
                this.one.Add(n, t4Code);
            }
        }
    }

    public void ReversedAdd(int n, T4Code t4Code) {
        if (n == t4Code.bitLength) {
            this.code = t4Code;
        } else {
            if (this.mask == 65535) {
                this.mask = 1 << n;
            }
            ++n;
            int n2 = t4Code.codeWord;
            if ((n2 & this.mask) == 0) {
                if (this.zero == null) {
                    this.zero = new T4Node();
                }
                this.zero.ReversedAdd(n, t4Code);
            } else {
                if (this.one == null) {
                    this.one = new T4Node();
                }
                this.one.ReversedAdd(n, t4Code);
            }
        }
    }

    public T4Node Find(int n) {
        if (this.code != null) {
            return this;
        }
        if (this.mask != 65535) {
            if ((this.mask & n) == 0) {
                return this.zero != null ? this.zero.Find(n) : null;
            }
            return this.one != null ? this.one.Find(n) : null;
        }
        return null;
    }
}

