/*
 * Decompiled with CFR 0.152.
 */
package imager.plugins;

import imager.plugins.Colormap;
import imager.plugins.Function2D;
import imager.plugins.Gradient;
import imager.plugins.ImageMath;
import imager.plugins.MutatableFilter;
import imager.plugins.Noise;
import imager.plugins.PixelUtils;
import imager.plugins.WholeImageFilter;
import java.awt.image.ImageFilter;
import java.io.Serializable;
import java.util.Random;

public class CellularFilter
extends WholeImageFilter
implements Function2D,
MutatableFilter,
Cloneable,
Serializable {
    protected float scale = 32.0f;
    protected float stretch = 1.0f;
    protected float angle = 0.0f;
    public float amount = 1.0f;
    public float turbulence = 1.0f;
    public float gain = 0.5f;
    public float bias = 0.5f;
    public float distancePower = 2.0f;
    public boolean useColor = false;
    protected Colormap colormap = new Gradient();
    protected float[] coefficients = new float[]{1.0f, 0.0f, 0.0f, 0.0f};
    protected float angleCoefficient;
    protected Random random = new Random();
    protected float m00 = 1.0f;
    protected float m01 = 0.0f;
    protected float m10 = 0.0f;
    protected float m11 = 1.0f;
    protected Point[] results = new Point[3];
    protected float randomness = 0.0f;
    protected int gridType = 2;
    private float UU_min;
    private float UV_max;
    private static byte[] Uu_probabilities;
    private float Uv_gradientCoefficient;
    public static final int RANDOM = 0;
    public static final int SQUARE = 1;
    public static final int HEXAGONAL = 2;
    public static final int OCTAGONAL = 3;
    public static final int TRIANGULAR = 4;

    public CellularFilter() {
        int n = 0;
        while (n < this.results.length) {
            this.results[n] = new Point();
            ++n;
        }
        if (Uu_probabilities == null) {
            Uu_probabilities = new byte[8192];
            float f = 1.0f;
            float f2 = 0.0f;
            float f3 = 2.5f;
            int n2 = 0;
            while (n2 < 10) {
                if (n2 > 1) {
                    f *= (float)n2;
                }
                float f4 = (float)Math.pow(f3, n2) * (float)Math.exp(-f3) / f;
                int n3 = (int)(f2 * 8192.0f);
                int n4 = (int)((f2 += f4) * 8192.0f);
                int n5 = n3;
                while (n5 < n4) {
                    CellularFilter.Uu_probabilities[n5] = (byte)n2;
                    ++n5;
                }
                ++n2;
            }
        }
    }

    public void setScale(float f) {
        this.scale = f;
    }

    public float getScale() {
        return this.scale;
    }

    public void setStretch(float f) {
        this.stretch = f;
    }

    public float getStretch() {
        return this.stretch;
    }

    public void setAngle(float f) {
        this.angle = f;
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        this.m00 = f2;
        this.m01 = f3;
        this.m10 = -f3;
        this.m11 = f2;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setCoefficient(int n, float f) {
        this.coefficients[n] = f;
    }

    public float getCoefficient(int n) {
        return this.coefficients[n];
    }

    public void setAngleCoefficient(float f) {
        this.angleCoefficient = f;
    }

    public float getAngleCoefficient() {
        return this.angleCoefficient;
    }

    public void setGradientCoefficient(float f) {
        this.Uv_gradientCoefficient = f;
    }

    public float getGradientCoefficient() {
        return this.Uv_gradientCoefficient;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public void setRandomness(float f) {
        this.randomness = f;
    }

    public float getRandomness() {
        return this.randomness;
    }

    public void setGridType(int n) {
        this.gridType = n;
    }

    public int getGridType() {
        return this.gridType;
    }

    public void setDistancePower(float f) {
        this.distancePower = f;
    }

    public float getDistancePower() {
        return this.distancePower;
    }

    public void setTurbulence(float f) {
        this.turbulence = f;
    }

    public float getTurbulence() {
        return this.turbulence;
    }

    public void setAmount(float f) {
        this.amount = f;
    }

    public float getAmount() {
        return this.amount;
    }

    private float VU_checkCube(float f, float f2, int n, int n2, Point[] pointArray) {
        int n3;
        this.random.setSeed(571 * n + 23 * n2);
        switch (this.gridType) {
            default: {
                n3 = Uu_probabilities[this.random.nextInt() & 0x1FFF];
                break;
            }
            case 1: {
                n3 = 1;
                break;
            }
            case 2: {
                n3 = 1;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
            case 4: {
                n3 = 2;
            }
        }
        int n4 = 0;
        while (n4 < n3) {
            Point point;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 1.0f;
            switch (this.gridType) {
                case 0: {
                    f3 = this.random.nextFloat();
                    f4 = this.random.nextFloat();
                    break;
                }
                case 1: {
                    f4 = 0.5f;
                    f3 = 0.5f;
                    if (this.randomness == 0.0f) break;
                    f3 = (float)((double)f3 + (double)this.randomness * ((double)this.random.nextFloat() - 0.5));
                    f4 = (float)((double)f4 + (double)this.randomness * ((double)this.random.nextFloat() - 0.5));
                    break;
                }
                case 2: {
                    if ((n & 1) == 0) {
                        f3 = 0.75f;
                        f4 = 0.0f;
                    } else {
                        f3 = 0.75f;
                        f4 = 0.5f;
                    }
                    if (this.randomness == 0.0f) break;
                    f3 += this.randomness * Noise.noise2(271.0f * ((float)n + f3), 271.0f * ((float)n2 + f4));
                    f4 += this.randomness * Noise.noise2(271.0f * ((float)n + f3) + 89.0f, 271.0f * ((float)n2 + f4) + 137.0f);
                    break;
                }
                case 3: {
                    switch (n4) {
                        case 0: {
                            f3 = 0.207f;
                            f4 = 0.207f;
                            break;
                        }
                        case 1: {
                            f3 = 0.707f;
                            f4 = 0.707f;
                            f5 = 1.6f;
                        }
                    }
                    if (this.randomness == 0.0f) break;
                    f3 += this.randomness * Noise.noise2(271.0f * ((float)n + f3), 271.0f * ((float)n2 + f4));
                    f4 += this.randomness * Noise.noise2(271.0f * ((float)n + f3) + 89.0f, 271.0f * ((float)n2 + f4) + 137.0f);
                    break;
                }
                case 4: {
                    if ((n2 & 1) == 0) {
                        if (n4 == 0) {
                            f3 = 0.25f;
                            f4 = 0.35f;
                        } else {
                            f3 = 0.75f;
                            f4 = 0.65f;
                        }
                    } else if (n4 == 0) {
                        f3 = 0.75f;
                        f4 = 0.35f;
                    } else {
                        f3 = 0.25f;
                        f4 = 0.65f;
                    }
                    if (this.randomness == 0.0f) break;
                    f3 += this.randomness * Noise.noise2(271.0f * ((float)n + f3), 271.0f * ((float)n2 + f4));
                    f4 += this.randomness * Noise.noise2(271.0f * ((float)n + f3) + 89.0f, 271.0f * ((float)n2 + f4) + 137.0f);
                }
            }
            float f6 = Math.abs(f - f3);
            float f7 = Math.abs(f2 - f4);
            float f8 = this.distancePower == 1.0f ? f6 + f7 : (this.distancePower == 2.0f ? (float)Math.sqrt(f6 * f6 + f7 * f7) : (float)Math.pow((float)Math.pow(f6 *= f5, this.distancePower) + (float)Math.pow(f7 *= f5, this.distancePower), 1.0f / this.distancePower));
            if (f8 < pointArray[0].distance) {
                point = pointArray[2];
                pointArray[2] = pointArray[1];
                pointArray[1] = pointArray[0];
                pointArray[0] = point;
                point.distance = f8;
                point.dx = f6;
                point.dy = f7;
                point.x = (float)n + f3;
                point.y = (float)n2 + f4;
            } else if (f8 < pointArray[1].distance) {
                point = pointArray[2];
                pointArray[2] = pointArray[1];
                pointArray[1] = point;
                point.distance = f8;
                point.dx = f6;
                point.dy = f7;
                point.x = (float)n + f3;
                point.y = (float)n2 + f4;
            } else if (f8 < pointArray[2].distance) {
                point = pointArray[2];
                point.distance = f8;
                point.dx = f6;
                point.dy = f7;
                point.x = (float)n + f3;
                point.y = (float)n2 + f4;
            }
            ++n4;
        }
        return pointArray[2].distance;
    }

    public float evaluate(float f, float f2) {
        int n = 0;
        while (n < this.results.length) {
            this.results[n].distance = Float.POSITIVE_INFINITY;
            ++n;
        }
        n = (int)f;
        float f3 = f - (float)n;
        int n2 = (int)f2;
        float f4 = f2 - (float)n2;
        float f5 = this.VU_checkCube(f3, f4, n, n2, this.results);
        if (f5 > f4) {
            f5 = this.VU_checkCube(f3, f4 + 1.0f, n, n2 - 1, this.results);
        }
        if (f5 > 1.0f - f4) {
            f5 = this.VU_checkCube(f3, f4 - 1.0f, n, n2 + 1, this.results);
        }
        if (f5 > f3) {
            this.VU_checkCube(f3 + 1.0f, f4, n - 1, n2, this.results);
            if (f5 > f4) {
                f5 = this.VU_checkCube(f3 + 1.0f, f4 + 1.0f, n - 1, n2 - 1, this.results);
            }
            if (f5 > 1.0f - f4) {
                f5 = this.VU_checkCube(f3 + 1.0f, f4 - 1.0f, n - 1, n2 + 1, this.results);
            }
        }
        if (f5 > 1.0f - f3) {
            f5 = this.VU_checkCube(f3 - 1.0f, f4, n + 1, n2, this.results);
            if (f5 > f4) {
                f5 = this.VU_checkCube(f3 - 1.0f, f4 + 1.0f, n + 1, n2 - 1, this.results);
            }
            if (f5 > 1.0f - f4) {
                f5 = this.VU_checkCube(f3 - 1.0f, f4 - 1.0f, n + 1, n2 + 1, this.results);
            }
        }
        float f6 = 0.0f;
        int n3 = 0;
        while (n3 < 3) {
            f6 += this.coefficients[n3] * this.results[n3].distance;
            ++n3;
        }
        if (this.angleCoefficient != 0.0f) {
            float f7 = (float)Math.atan2(f2 - this.results[0].y, f - this.results[0].x);
            if (f7 < 0.0f) {
                f7 += (float)Math.PI * 2;
            }
            f6 += this.angleCoefficient * (f7 /= (float)Math.PI * 4);
        }
        if (this.Uv_gradientCoefficient != 0.0f) {
            float f8 = 1.0f / (this.results[0].dy + this.results[0].dx);
            f6 += this.Uv_gradientCoefficient * f8;
        }
        return f6;
    }

    public float turbulence2(float f, float f2, float f3) {
        float f4 = 0.0f;
        float f5 = 1.0f;
        while (f5 <= f3) {
            f4 += this.evaluate(f5 * f, f5 * f2) / f5;
            f5 *= 2.0f;
        }
        return f4;
    }

    public int getPixel(int n, int n2, int[] nArray, int n3, int n4) {
        try {
            float f = this.m00 * (float)n + this.m01 * (float)n2;
            float f2 = this.m10 * (float)n + this.m11 * (float)n2;
            f /= this.scale;
            f2 /= this.scale * this.stretch;
            float f3 = this.turbulence == 1.0f ? this.evaluate(f, f2) : this.turbulence2(f += 1000.0f, f2 += 1000.0f, this.turbulence);
            f3 *= 2.0f;
            f3 *= this.amount;
            int n5 = -16777216;
            if (this.colormap != null) {
                int n6 = this.colormap.getColor(f3);
                if (this.useColor) {
                    int n7 = ImageMath.clamp((int)((this.results[0].x - 1000.0f) * this.scale), 0, n3 - 1);
                    int n8 = ImageMath.clamp((int)((this.results[0].y - 1000.0f) * this.scale), 0, n4 - 1);
                    n6 = nArray[n8 * n3 + n7];
                    f3 = (this.results[1].distance - this.results[0].distance) / (this.results[1].distance + this.results[0].distance);
                    f3 = ImageMath.smoothStep(this.coefficients[1], this.coefficients[0], f3);
                    n6 = ImageMath.mixColors(f3, -16777216, n6);
                }
                return n6;
            }
            int n9 = PixelUtils.clamp((int)(f3 * 255.0f));
            int n10 = n9 << 16;
            int n11 = n9 << 8;
            int n12 = n9;
            return n5 | n10 | n11 | n12;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public void imageComplete(int n) {
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        int n2 = this.originalSpace.width;
        int n3 = this.originalSpace.height;
        int n4 = 0;
        int[] nArray = new int[n2 * n3];
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < n2) {
                nArray[n4++] = this.getPixel(n6, n5, this.inPixels, n2, n3);
                ++n6;
            }
            ++n5;
        }
        this.consumer.setPixels(0, 0, n2, n3, this.defaultRGBModel, nArray, 0, n2);
        this.consumer.imageComplete(n);
        this.inPixels = null;
    }

    public void mutate(int n, ImageFilter imageFilter, boolean bl, boolean bl2) {
        CellularFilter cellularFilter = (CellularFilter)imageFilter;
        this.random.setSeed((int)System.currentTimeMillis());
        if (bl || n == 0) {
            cellularFilter.setGridType(this.getGridType());
            cellularFilter.setRandomness(this.getRandomness());
            cellularFilter.setScale(this.getScale());
            cellularFilter.setAngle(this.getAngle());
            cellularFilter.setStretch(this.getStretch());
            cellularFilter.setAmount(this.getAmount());
            cellularFilter.setTurbulence(this.getTurbulence());
            cellularFilter.setColormap(this.getColormap());
            cellularFilter.setDistancePower(this.getDistancePower());
            cellularFilter.setAngleCoefficient(this.getAngleCoefficient());
            int n2 = 0;
            while (n2 < 4) {
                cellularFilter.setCoefficient(n2, this.getCoefficient(n2));
                ++n2;
            }
        } else {
            cellularFilter.scale = this.mutate(this.scale, 0.9f, 5.0f, 3.0f, 64.0f);
            cellularFilter.setAngle(this.mutate(this.angle, 0.6f, 1.5707964f));
            cellularFilter.stretch = this.mutate(this.stretch, 0.6f, 3.0f, 1.0f, 10.0f);
            cellularFilter.amount = this.mutate(n, 0.6f, 0.2f, 0.0f, 1.0f);
            cellularFilter.turbulence = this.mutate(this.turbulence, 0.7f, 0.5f, 1.0f, 8.0f);
            cellularFilter.distancePower = this.mutate(this.distancePower, 0.5f, 0.5f, 1.0f, 3.0f);
            cellularFilter.randomness = this.mutate(this.randomness, 0.9f, 0.2f, 0.0f, 1.0f);
            int n3 = 0;
            while (n3 < this.coefficients.length) {
                cellularFilter.coefficients[n3] = this.mutate(this.coefficients[n3], 0.7f, 0.2f, -1.0f, 1.0f);
                ++n3;
            }
            if ((double)this.random.nextFloat() >= 0.5) {
                cellularFilter.gridType = this.random.nextInt() % 5;
            }
            cellularFilter.angleCoefficient = this.random.nextFloat() >= 0.5f ? 0.0f : this.mutate(this.angleCoefficient, 0.5f, 0.5f, -1.0f, 1.0f);
        }
        if (bl2 || n == 0) {
            cellularFilter.setColormap(this.getColormap());
        } else {
            cellularFilter.setColormap(Gradient.randomGradient());
        }
    }

    private float mutate(float f, float f2, float f3, float f4, float f5) {
        if (this.random.nextFloat() <= f2) {
            return f;
        }
        return ImageMath.clamp(f + f3 * (float)this.random.nextGaussian(), f4, f5);
    }

    private float mutate(float f, float f2, float f3) {
        if (this.random.nextFloat() <= f2) {
            return f;
        }
        return f + f3 * (float)this.random.nextGaussian();
    }

    public Object clone() {
        CellularFilter cellularFilter = (CellularFilter)super.clone();
        cellularFilter.coefficients = (float[])this.coefficients.clone();
        return cellularFilter;
    }

    public String toString() {
        return "Texture/Cellular...";
    }

    public class Point {
        public int index;
        public float x;
        public float y;
        public float dx;
        public float dy;
        public float cubeX;
        public float cubeY;
        public float distance;
    }
}

