/*
 * Decompiled with CFR 0.152.
 */
package imager.plugins;

import imager.plugins.Kernel;
import imager.plugins.PixelUtils;
import imager.plugins.WholeImageFilter;

public class ConvolveFilter
extends WholeImageFilter {
    static final long serialVersionUID = 2239251672685254626L;
    protected Kernel kernel = null;
    public boolean alpha = true;

    public ConvolveFilter() {
        this(new float[9]);
    }

    public ConvolveFilter(float[] fArray) {
        this(new Kernel(3, 3, fArray));
    }

    public ConvolveFilter(int n, int n2, float[] fArray) {
        this(new Kernel(n, n2, fArray));
    }

    public ConvolveFilter(Kernel kernel) {
        this.kernel = kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void imageComplete(int n) {
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        int n2 = this.originalSpace.width;
        int n3 = this.originalSpace.height;
        int[] nArray = new int[n2 * n3];
        ConvolveFilter.convolve(this.kernel, this.inPixels, nArray, n2, n3, this.alpha);
        this.consumer.setPixels(0, 0, n2, n3, this.defaultRGBModel, nArray, 0, n2);
        this.consumer.imageComplete(n);
        this.inPixels = null;
    }

    public static void convolve(Kernel kernel, int[] nArray, int[] nArray2, int n, int n2) {
        ConvolveFilter.convolve(kernel, nArray, nArray2, n, n2, true);
    }

    public static void convolve(Kernel kernel, int[] nArray, int[] nArray2, int n, int n2, boolean bl) {
        int n3 = 0;
        float[] fArray = kernel.matrix;
        int n4 = kernel.rows;
        int n5 = kernel.cols;
        int n6 = n4 / 2;
        int n7 = n5 / 2;
        int n8 = 0;
        while (n8 < n2) {
            int n9 = 0;
            while (n9 < n) {
                int n10;
                int n11;
                int n12;
                float f = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                int n13 = -n6;
                while (n13 <= n6) {
                    n12 = n8 + n13;
                    n11 = n12 >= 0 && n12 < n2 ? n12 * n : n8 * n;
                    n10 = n5 * (n13 + n6) + n7;
                    int n14 = -n7;
                    while (n14 <= n7) {
                        float f5 = fArray[n10 + n14];
                        if (f5 != 0.0f) {
                            int n15 = n9 + n14;
                            if (n15 < 0 || n15 >= n) {
                                n15 = n9;
                            }
                            int n16 = nArray[n11 + n15];
                            f4 += f5 * (float)(n16 >> 24 & 0xFF);
                            f += f5 * (float)(n16 >> 16 & 0xFF);
                            f2 += f5 * (float)(n16 >> 8 & 0xFF);
                            f3 += f5 * (float)(n16 & 0xFF);
                        }
                        ++n14;
                    }
                    ++n13;
                }
                n13 = bl ? PixelUtils.clamp((int)((double)f4 + 0.5)) : 255;
                n12 = PixelUtils.clamp((int)((double)f + 0.5));
                n11 = PixelUtils.clamp((int)((double)f2 + 0.5));
                n10 = PixelUtils.clamp((int)((double)f3 + 0.5));
                nArray2[n3++] = n13 << 24 | n12 << 16 | n11 << 8 | n10;
                ++n9;
            }
            ++n8;
        }
    }

    public String toString() {
        return "Blur/Convolve...";
    }
}

