/*
 * Decompiled with CFR 0.152.
 */
package imager.plugins;

import imager.plugins.HSBAdjustFilter;
import imager.plugins.PreviewFilterCustomizer;
import imager.plugins.SuperGridLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HSBAdjustFilterCustomizer
extends PreviewFilterCustomizer
implements ChangeListener {
    private JSlider U_hue;
    private JSlider v_saturation;
    private JSlider u_brightness;
    private HSBAdjustFilter V_filter;

    public HSBAdjustFilterCustomizer() {
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "South");
        SuperGridLayout superGridLayout = new SuperGridLayout(3, 2);
        jPanel.setLayout(superGridLayout);
        superGridLayout.setColWeight(1, 1);
        jPanel.add(new JLabel("Hue:", 4));
        this.U_hue = new JSlider(0, -180, 180, 0);
        jPanel.add(this.U_hue);
        this.U_hue.setPaintTicks(true);
        this.U_hue.setMajorTickSpacing(90);
        this.U_hue.setMinorTickSpacing(10);
        this.U_hue.setPaintLabels(true);
        jPanel.add(new JLabel("Saturation:", 4));
        this.v_saturation = new JSlider(0, -100, 100, 0);
        jPanel.add(this.v_saturation);
        this.v_saturation.setPaintTicks(true);
        this.v_saturation.setMajorTickSpacing(100);
        this.v_saturation.setMinorTickSpacing(5);
        this.v_saturation.setPaintLabels(true);
        jPanel.add(new JLabel("Brightness:", 4));
        this.u_brightness = new JSlider(0, -100, 100, 0);
        jPanel.add(this.u_brightness);
        this.u_brightness.setPaintTicks(true);
        this.u_brightness.setMajorTickSpacing(100);
        this.u_brightness.setMinorTickSpacing(5);
        this.u_brightness.setPaintLabels(true);
        this.U_hue.addChangeListener(this);
        this.v_saturation.addChangeListener(this);
        this.u_brightness.addChangeListener(this);
    }

    public void setObject(Object object) {
        super.setObject(object);
        this.V_filter = (HSBAdjustFilter)object;
        this.U_hue.setValue((int)((double)this.V_filter.hFactor * 180.0 / Math.PI));
        this.v_saturation.setValue((int)((double)this.V_filter.sFactor * 100.0));
        this.u_brightness.setValue((int)((double)this.V_filter.bFactor * 100.0));
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.V_filter != null) {
            Object object = changeEvent.getSource();
            if (object == this.U_hue) {
                this.V_filter.hFactor = (float)this.U_hue.getValue() / 180.0f;
            } else if (object == this.v_saturation) {
                this.V_filter.sFactor = (float)this.v_saturation.getValue() / 100.0f;
            } else if (object == this.u_brightness) {
                this.V_filter.bFactor = (float)this.u_brightness.getValue() / 100.0f;
            }
            this.preview();
        }
    }
}

