/*
 * Decompiled with CFR 0.152.
 */
package imager.plugins;

public class ImageMath {
    public static final float PI = (float)Math.PI;
    public static final float HALF_PI = 1.5707964f;
    public static final float QUARTER_PI = 0.7853982f;
    public static final float TWO_PI = (float)Math.PI * 2;
    private static final float UU_m00 = -0.5f;
    private static final float Vv_m01 = 1.5f;
    private static final float vu_m02 = -1.5f;
    private static final float VV_m03 = 0.5f;
    private static final float vU_m10 = 1.0f;
    private static final float Uv_m11 = -2.5f;
    private static final float uu_m12 = 2.0f;
    private static final float UV_m13 = -0.5f;
    private static final float uU_m20 = -0.5f;
    private static final float vv_m21 = 0.0f;
    private static final float Vu_m22 = 0.5f;
    private static final float vV_m23 = 0.0f;
    private static final float VU_m30 = 0.0f;
    private static final float uv_m31 = 1.0f;
    private static final float Uu_m32 = 0.0f;
    private static final float uV_m33 = 0.0f;

    public static float bias(float f, float f2) {
        return (float)Math.pow(f, Math.log(f2) / Math.log(0.5));
    }

    public static float gain(float f, float f2) {
        float f3 = (float)Math.log(1.0 - (double)f2) / (float)Math.log(0.5);
        if ((double)f < 0.001) {
            return 0.0f;
        }
        if ((double)f > 0.999) {
            return 1.0f;
        }
        if ((double)f < 0.5) {
            return (float)Math.pow(2.0f * f, f3) / 2.0f;
        }
        return 1.0f - (float)Math.pow(2.0 * (1.0 - (double)f), f3) / 2.0f;
    }

    public static float step(float f, float f2) {
        return f2 < f ? 0.0f : 1.0f;
    }

    public static float pulse(float f, float f2, float f3) {
        return f3 < f || f3 >= f2 ? 0.0f : 1.0f;
    }

    public static float smoothPulse(float f, float f2, float f3, float f4, float f5) {
        if (f5 < f || f5 >= f4) {
            return 0.0f;
        }
        if (f5 >= f2) {
            if (f5 < f3) {
                return 1.0f;
            }
            f5 = (f5 - f3) / (f4 - f3);
            return 1.0f - f5 * f5 * (3.0f - 2.0f * f5);
        }
        f5 = (f5 - f) / (f2 - f);
        return f5 * f5 * (3.0f - 2.0f * f5);
    }

    public static float smoothStep(float f, float f2, float f3) {
        if (f3 < f) {
            return 0.0f;
        }
        if (f3 >= f2) {
            return 1.0f;
        }
        f3 = (f3 - f) / (f2 - f);
        return f3 * f3 * (3.0f - 2.0f * f3);
    }

    public static float circleUp(float f) {
        f = 1.0f - f;
        return (float)Math.sqrt(1.0f - f * f);
    }

    public static float circleDown(float f) {
        return 1.0f - (float)Math.sqrt(1.0f - f * f);
    }

    public static float clamp(float f, float f2, float f3) {
        return f < f2 ? f2 : (f > f3 ? f3 : f);
    }

    public static int clamp(int n, int n2, int n3) {
        return n < n2 ? n2 : (n > n3 ? n3 : n);
    }

    public static float mod(float f, float f2) {
        int n;
        if ((f -= (float)(n = (int)(f / f2)) * f2) < 0.0f) {
            return f + f2;
        }
        return f;
    }

    public static int mod(int n, int n2) {
        int n3;
        if ((n -= (n3 = n / n2) * n2) < 0) {
            return n + n2;
        }
        return n;
    }

    public static float triangle(float f) {
        float f2 = ImageMath.mod(f, 1.0f);
        return 2.0f * ((double)f2 < 0.5 ? f2 : 1.0f - f2);
    }

    public static float lerp(float f, float f2, float f3) {
        return f2 + f * (f3 - f2);
    }

    public static int lerp(float f, int n, int n2) {
        return (int)((float)n + f * (float)(n2 - n));
    }

    public static int mixColors(float f, int n, int n2) {
        int n3 = n >> 24 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 8 & 0xFF;
        int n6 = n & 0xFF;
        int n7 = n2 >> 24 & 0xFF;
        int n8 = n2 >> 16 & 0xFF;
        int n9 = n2 >> 8 & 0xFF;
        int n10 = n2 & 0xFF;
        n3 = ImageMath.lerp(f, n3, n7);
        n4 = ImageMath.lerp(f, n4, n8);
        n5 = ImageMath.lerp(f, n5, n9);
        n6 = ImageMath.lerp(f, n6, n10);
        return n3 << 24 | n4 << 16 | n5 << 8 | n6;
    }

    public static int bilinearInterpolate(float f, float f2, int[] nArray) {
        int n = nArray[0] >> 24 & 0xFF;
        int n2 = nArray[0] >> 16 & 0xFF;
        int n3 = nArray[0] >> 8 & 0xFF;
        int n4 = nArray[0] & 0xFF;
        int n5 = nArray[1] >> 24 & 0xFF;
        int n6 = nArray[1] >> 16 & 0xFF;
        int n7 = nArray[1] >> 8 & 0xFF;
        int n8 = nArray[1] & 0xFF;
        int n9 = nArray[2] >> 24 & 0xFF;
        int n10 = nArray[2] >> 16 & 0xFF;
        int n11 = nArray[2] >> 8 & 0xFF;
        int n12 = nArray[2] & 0xFF;
        int n13 = nArray[3] >> 24 & 0xFF;
        int n14 = nArray[3] >> 16 & 0xFF;
        int n15 = nArray[3] >> 8 & 0xFF;
        int n16 = nArray[3] & 0xFF;
        float f3 = 1.0f - f;
        float f4 = 1.0f - f2;
        float f5 = f3 * (float)n + f * (float)n5;
        float f6 = f3 * (float)n9 + f * (float)n13;
        int n17 = (int)(f4 * f5 + f2 * f6);
        f5 = f3 * (float)n2 + f * (float)n6;
        f6 = f3 * (float)n10 + f * (float)n14;
        int n18 = (int)(f4 * f5 + f2 * f6);
        f5 = f3 * (float)n3 + f * (float)n7;
        f6 = f3 * (float)n11 + f * (float)n15;
        int n19 = (int)(f4 * f5 + f2 * f6);
        f5 = f3 * (float)n4 + f * (float)n8;
        f6 = f3 * (float)n12 + f * (float)n16;
        int n20 = (int)(f4 * f5 + f2 * f6);
        return n17 << 24 | n18 << 16 | n19 << 8 | n20;
    }

    public static int brightnessNTSC(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        return (int)((float)n2 * 0.299f + (float)n3 * 0.587f + (float)n4 * 0.114f);
    }

    public static float spline(float f, int n, float[] fArray) {
        int n2 = n - 3;
        if (n2 < 1) {
            throw new IllegalArgumentException("Too few knots in spline");
        }
        int n3 = (int)(f = ImageMath.clamp(f, 0.0f, 1.0f) * (float)n2);
        if (n3 > n - 4) {
            n3 = n - 4;
        }
        f -= (float)n3;
        float f2 = fArray[n3];
        float f3 = fArray[n3 + 1];
        float f4 = fArray[n3 + 2];
        float f5 = fArray[n3 + 3];
        float f6 = -0.5f * f2 + 1.5f * f3 + -1.5f * f4 + 0.5f * f5;
        float f7 = 1.0f * f2 + -2.5f * f3 + 2.0f * f4 + -0.5f * f5;
        float f8 = -0.5f * f2 + 0.0f * f3 + 0.5f * f4 + 0.0f * f5;
        float f9 = 0.0f * f2 + 1.0f * f3 + 0.0f * f4 + 0.0f * f5;
        return ((f6 * f + f7) * f + f8) * f + f9;
    }

    public static float spline(float f, int n, int[] nArray, int[] nArray2) {
        int n2 = n - 3;
        if (n2 < 1) {
            throw new IllegalArgumentException("Too few knots in spline");
        }
        int n3 = 0;
        while (n3 < n2) {
            if ((float)nArray[n3 + 1] > f) break;
            ++n3;
        }
        if (n3 > n - 3) {
            n3 = n - 3;
        }
        float f2 = (f - (float)nArray[n3]) / (float)(nArray[n3 + 1] - nArray[n3]);
        if (--n3 < 0) {
            n3 = 0;
            f2 = 0.0f;
        }
        float f3 = nArray2[n3];
        float f4 = nArray2[n3 + 1];
        float f5 = nArray2[n3 + 2];
        float f6 = nArray2[n3 + 3];
        float f7 = -0.5f * f3 + 1.5f * f4 + -1.5f * f5 + 0.5f * f6;
        float f8 = 1.0f * f3 + -2.5f * f4 + 2.0f * f5 + -0.5f * f6;
        float f9 = -0.5f * f3 + 0.0f * f4 + 0.5f * f5 + 0.0f * f6;
        float f10 = 0.0f * f3 + 1.0f * f4 + 0.0f * f5 + 0.0f * f6;
        return ((f7 * f2 + f8) * f2 + f9) * f2 + f10;
    }

    public static int colorSpline(float f, int n, int[] nArray) {
        int n2 = n - 3;
        if (n2 < 1) {
            throw new IllegalArgumentException("Too few knots in spline");
        }
        int n3 = (int)(f = ImageMath.clamp(f, 0.0f, 1.0f) * (float)n2);
        if (n3 > n - 4) {
            n3 = n - 4;
        }
        f -= (float)n3;
        int n4 = 0;
        int n5 = 0;
        while (n5 < 4) {
            int n6 = n5 * 8;
            float f2 = nArray[n3] >> n6 & 0xFF;
            float f3 = nArray[n3 + 1] >> n6 & 0xFF;
            float f4 = nArray[n3 + 2] >> n6 & 0xFF;
            float f5 = nArray[n3 + 3] >> n6 & 0xFF;
            float f6 = -0.5f * f2 + 1.5f * f3 + -1.5f * f4 + 0.5f * f5;
            float f7 = 1.0f * f2 + -2.5f * f3 + 2.0f * f4 + -0.5f * f5;
            float f8 = -0.5f * f2 + 0.0f * f3 + 0.5f * f4 + 0.0f * f5;
            float f9 = 0.0f * f2 + 1.0f * f3 + 0.0f * f4 + 0.0f * f5;
            int n7 = (int)(((f6 * f + f7) * f + f8) * f + f9);
            if (n7 < 0) {
                n7 = 0;
            } else if (n7 > 255) {
                n7 = 255;
            }
            n4 |= n7 << n6;
            ++n5;
        }
        return n4;
    }

    public static int colorSpline(int n, int n2, int[] nArray, int[] nArray2) {
        int n3 = n2 - 3;
        if (n3 < 1) {
            throw new IllegalArgumentException("Too few knots in spline");
        }
        int n4 = 0;
        while (n4 < n3) {
            if (nArray[n4 + 1] > n) break;
            ++n4;
        }
        if (n4 > n2 - 3) {
            n4 = n2 - 3;
        }
        float f = (float)(n - nArray[n4]) / (float)(nArray[n4 + 1] - nArray[n4]);
        if (--n4 < 0) {
            n4 = 0;
            f = 0.0f;
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < 4) {
            int n7 = n6 * 8;
            float f2 = nArray2[n4] >> n7 & 0xFF;
            float f3 = nArray2[n4 + 1] >> n7 & 0xFF;
            float f4 = nArray2[n4 + 2] >> n7 & 0xFF;
            float f5 = nArray2[n4 + 3] >> n7 & 0xFF;
            float f6 = -0.5f * f2 + 1.5f * f3 + -1.5f * f4 + 0.5f * f5;
            float f7 = 1.0f * f2 + -2.5f * f3 + 2.0f * f4 + -0.5f * f5;
            float f8 = -0.5f * f2 + 0.0f * f3 + 0.5f * f4 + 0.0f * f5;
            float f9 = 0.0f * f2 + 1.0f * f3 + 0.0f * f4 + 0.0f * f5;
            int n8 = (int)(((f6 * f + f7) * f + f8) * f + f9);
            if (n8 < 0) {
                n8 = 0;
            } else if (n8 > 255) {
                n8 = 255;
            }
            n5 |= n8 << n7;
            ++n6;
        }
        return n5;
    }

    /*
     * Unable to fully structure code
     */
    public static void resample(int[] var0, int[] var1_1, int var2_2, int var3_3, int var4_4, float[] var5_5) {
        var25_6 = var3_3;
        var26_7 = var3_3;
        var27_8 = var0.length;
        var24_9 = new float[var2_2 + 1];
        var6_10 = 0;
        var7_11 = 0;
        ** GOTO lbl13
        {
            ++var6_10;
            do {
                if (var5_5[var6_10 + 1] < (float)var7_11) continue block0;
                var24_9[var7_11] = (float)var6_10 + ((float)var7_11 - var5_5[var6_10]) / (var5_5[var6_10 + 1] - var5_5[var6_10]);
                ++var7_11;
lbl13:
                // 2 sources

            } while (var7_11 < var2_2);
        }
        var24_9[var2_2] = var2_2;
        var10_12 = 1.0f;
        var9_14 = var11_13 = var24_9[1];
        var23_15 = 0.0f;
        var22_16 = 0.0f;
        var21_17 = 0.0f;
        var20_18 = 0.0f;
        var28_19 = var0[var25_6];
        var12_20 = var28_19 >> 24 & 255;
        var13_21 = var28_19 >> 16 & 255;
        var14_22 = var28_19 >> 8 & 255;
        var15_23 = var28_19 & 255;
        var28_19 = var0[var25_6 += var4_4];
        var16_24 = var28_19 >> 24 & 255;
        var17_25 = var28_19 >> 16 & 255;
        var18_26 = var28_19 >> 8 & 255;
        var19_27 = var28_19 & 255;
        var25_6 += var4_4;
        var6_10 = 1;
        while (var6_10 < var2_2) {
            var29_28 = var10_12 * (float)var12_20 + (1.0f - var10_12) * (float)var16_24;
            var30_29 = var10_12 * (float)var13_21 + (1.0f - var10_12) * (float)var17_25;
            var31_30 = var10_12 * (float)var14_22 + (1.0f - var10_12) * (float)var18_26;
            var32_31 = var10_12 * (float)var15_23 + (1.0f - var10_12) * (float)var19_27;
            if (var10_12 < var11_13) {
                var20_18 += var29_28 * var10_12;
                var21_17 += var30_29 * var10_12;
                var22_16 += var31_30 * var10_12;
                var23_15 += var32_31 * var10_12;
                var11_13 -= var10_12;
                var10_12 = 1.0f;
                var12_20 = var16_24;
                var13_21 = var17_25;
                var14_22 = var18_26;
                var15_23 = var19_27;
                if (var25_6 < var27_8) {
                    var28_19 = var0[var25_6];
                }
                var16_24 = var28_19 >> 24 & 255;
                var17_25 = var28_19 >> 16 & 255;
                var18_26 = var28_19 >> 8 & 255;
                var19_27 = var28_19 & 255;
                var25_6 += var4_4;
                continue;
            }
            var1_1[var26_7] = (int)Math.min((var20_18 += var29_28 * var11_13) / var9_14, 255.0f) << 24 | (int)Math.min((var21_17 += var30_29 * var11_13) / var9_14, 255.0f) << 16 | (int)Math.min((var22_16 += var31_30 * var11_13) / var9_14, 255.0f) << 8 | (int)Math.min((var23_15 += var32_31 * var11_13) / var9_14, 255.0f);
            var26_7 += var4_4;
            var23_15 = 0.0f;
            var22_16 = 0.0f;
            var21_17 = 0.0f;
            var10_12 -= var11_13;
            var9_14 = var11_13 = var24_9[var6_10 + 1] - var24_9[var6_10];
            ++var6_10;
        }
    }
}

