/*
 * Decompiled with CFR 0.152.
 */
package imager.plugins;

import imager.plugins.PixelUtils;
import imager.plugins.WholeImageFilter;

public class MotionBlurFilter
extends WholeImageFilter {
    public static final int LINEAR = 0;
    public static final int RADIAL = 1;
    public static final int ZOOM = 2;
    private float UU_angle = 0.0f;
    private float UV_falloff = 1.0f;
    private float Uu_distance = 1.0f;
    private int Uv_repetitions = 4;
    private int VU_type = 0;

    public void setType(int n) {
        this.VU_type = n;
    }

    public int getType() {
        return this.VU_type;
    }

    public void setAngle(float f) {
        this.UU_angle = f;
    }

    public float getAngle() {
        return this.UU_angle;
    }

    public void setDistance(float f) {
        this.Uu_distance = f;
    }

    public float getDistance() {
        return this.Uu_distance;
    }

    public void setRepetitions(int n) {
        this.Uv_repetitions = n;
    }

    public int getRepetitions() {
        return this.Uv_repetitions;
    }

    public void imageComplete(int n) {
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        int n2 = this.originalSpace.width;
        int n3 = this.originalSpace.height;
        int n4 = 0;
        int[] nArray = new int[n2 * n3];
        float f = (float)Math.sin(this.UU_angle);
        float f2 = (float)Math.cos(this.UU_angle);
        int n5 = n2 / 2;
        int n6 = n3 / 2;
        int n7 = 0;
        while (n7 < n3) {
            int n8 = 0;
            while (n8 < n2) {
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                int n14 = 0;
                while (n14 < this.Uv_repetitions) {
                    int n15 = n8;
                    int n16 = n7;
                    if (n14 != 0) {
                        switch (this.VU_type) {
                            default: {
                                n15 = (int)((float)n8 + (float)n14 * this.Uu_distance * f);
                                n16 = (int)((float)n7 + (float)n14 * this.Uu_distance * f2);
                                break;
                            }
                            case 1: {
                                float f3 = n8 - n5;
                                float f4 = n7 - n6;
                                float f5 = (float)Math.sqrt(f3 * f3 + f4 * f4);
                                float f6 = (float)Math.atan2(f4, f3);
                                f6 = (float)((double)f6 + (double)(this.Uu_distance * (float)(n14 - this.Uv_repetitions / 2) / (float)Math.PI) / 10.0);
                                n15 = (int)((double)n5 + (double)f5 * Math.cos(f6));
                                n16 = (int)((double)n6 + (double)f5 * Math.sin(f6));
                                break;
                            }
                            case 2: {
                                float f7 = n8 - n5;
                                float f4 = n7 - n6;
                                n15 = (int)((double)n5 + (1.0 - (double)((float)n14 * this.Uu_distance) / 100.0) * (double)f7);
                                n16 = (int)((double)n6 + (1.0 - (double)((float)n14 * this.Uu_distance) / 100.0) * (double)f4);
                            }
                        }
                        if (n15 < 0 || n15 >= n2 || n16 < 0 || n16 >= n3) break;
                    }
                    ++n13;
                    int n17 = this.inPixels[n16 * n2 + n15];
                    n9 += n17 >> 24 & 0xFF;
                    n10 += n17 >> 16 & 0xFF;
                    n11 += n17 >> 8 & 0xFF;
                    n12 += n17 & 0xFF;
                    ++n14;
                }
                if (n13 == 0) {
                    nArray[n4] = this.inPixels[n4];
                } else {
                    n9 = PixelUtils.clamp(n9 / n13);
                    n10 = PixelUtils.clamp(n10 / n13);
                    n11 = PixelUtils.clamp(n11 / n13);
                    n12 = PixelUtils.clamp(n12 / n13);
                    nArray[n4] = n9 << 24 | n10 << 16 | n11 << 8 | n12;
                }
                ++n4;
                ++n8;
            }
            ++n7;
        }
        this.consumer.setPixels(0, 0, n2, n3, this.defaultRGBModel, nArray, 0, n2);
        this.consumer.imageComplete(n);
        this.inPixels = null;
    }

    public String toString() {
        return "Blur/Motion Blur...";
    }
}

