/*
 * Decompiled with CFR 0.152.
 */
package imager.plugins;

import imager.plugins.TransformFilter;

public class SphereFilter
extends TransformFilter {
    static final long serialVersionUID = -8148404526162968279L;
    private float UU_a = 0.0f;
    private float UV_b = 0.0f;
    private float Uu_a2 = 0.0f;
    private float Uv_b2 = 0.0f;
    private float VU_refractionIndex = 1.5f;

    public void setRefractionIndex(float f) {
        this.VU_refractionIndex = f;
    }

    public float getRefractionIndex() {
        return this.VU_refractionIndex;
    }

    public void setDimensions(int n, int n2) {
        super.setDimensions(n, n2);
        this.UU_a = n / 2;
        this.UV_b = n2 / 2;
        this.Uu_a2 = this.UU_a * this.UU_a;
        this.Uv_b2 = this.UV_b * this.UV_b;
    }

    protected void transformInverse(int n, int n2, float[] fArray) {
        float f = (float)n2 - this.UV_b;
        float f2 = f * f;
        float f3 = (float)n - this.UU_a;
        float f4 = f3 * f3;
        if (f2 >= this.Uv_b2 - this.Uv_b2 * f4 / this.Uu_a2) {
            fArray[0] = n;
            fArray[1] = n2;
        } else {
            float f5 = 1.0f / this.VU_refractionIndex;
            float f6 = (float)Math.sqrt((1.0f - f4 / this.Uu_a2 - f2 / this.Uv_b2) * (this.UU_a * this.UV_b));
            float f7 = f6 * f6;
            float f8 = (float)Math.acos((double)f3 / Math.sqrt(f4 + f7));
            float f9 = 1.5707964f - f8;
            float f10 = (float)Math.asin(Math.sin(f9) * (double)f5);
            f10 = 1.5707964f - f8 - f10;
            fArray[0] = (float)n - (float)Math.tan(f10) * f6;
            float f11 = (float)Math.acos((double)f / Math.sqrt(f2 + f7));
            f9 = 1.5707964f - f11;
            f10 = (float)Math.asin(Math.sin(f9) * (double)f5);
            f10 = 1.5707964f - f11 - f10;
            fArray[1] = (float)n2 - (float)Math.tan(f10) * f6;
        }
    }

    public String toString() {
        return "Distort/Sphere...";
    }
}

