/*
 * Decompiled with CFR 0.152.
 */
package imager.plugins;

import imager.plugins.PreviewFilterCustomizer;
import imager.plugins.SphereFilter;
import imager.plugins.SuperGridLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SphereFilterCustomizer
extends PreviewFilterCustomizer
implements ChangeListener {
    private JSlider U_refraction;
    private SphereFilter V_filter;

    public SphereFilterCustomizer() {
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "Center");
        SuperGridLayout superGridLayout = new SuperGridLayout(4, 2);
        jPanel.setLayout(superGridLayout);
        superGridLayout.setColWeight(1, 1);
        jPanel.add(new JLabel("Refraction:", 4));
        this.U_refraction = new JSlider(0, 100, 300, 100);
        jPanel.add(this.U_refraction);
        this.U_refraction.setPaintTicks(true);
        this.U_refraction.setMajorTickSpacing(50);
        this.U_refraction.setMinorTickSpacing(5);
        this.U_refraction.setPaintLabels(true);
        this.U_refraction.addChangeListener(this);
    }

    public void setObject(Object object) {
        super.setObject(object);
        this.V_filter = (SphereFilter)object;
        this.U_refraction.setValue((int)((double)this.V_filter.getRefractionIndex() * 100.0));
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.V_filter != null) {
            Object object = changeEvent.getSource();
            if (object instanceof JSlider && ((JSlider)object).getValueIsAdjusting()) {
                return;
            }
            if (object == this.U_refraction) {
                this.V_filter.setRefractionIndex((float)this.U_refraction.getValue() / 100.0f);
            }
            this.preview();
        }
    }
}

