/*
 * Decompiled with CFR 0.152.
 */
package imager.plugins;

import imager.plugins.ImageMath;
import imager.plugins.WholeImageFilter;

public class WaterFilter
extends WholeImageFilter {
    static final long serialVersionUID = 8789236343162990941L;
    private float UU_wavelength = 16.0f;
    private float UV_amplitude = 10.0f;
    private float Uu_phase = 0.0f;
    private boolean Uv_antialias = true;

    public void setWavelength(float f) {
        this.UU_wavelength = f;
    }

    public float getWavelength() {
        return this.UU_wavelength;
    }

    public void setAmplitude(float f) {
        this.UV_amplitude = f;
    }

    public float getAmplitude() {
        return this.UV_amplitude;
    }

    public void setPhase(float f) {
        this.Uu_phase = f;
    }

    public float getPhase() {
        return this.Uu_phase;
    }

    public void setAntialias(boolean bl) {
        this.Uv_antialias = bl;
    }

    public boolean getAntialias() {
        return this.Uv_antialias;
    }

    private boolean VU_inside(int n, int n2, int n3) {
        return n2 <= n && n <= n3;
    }

    public void imageComplete(int n) {
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        int n2 = this.originalSpace.width;
        int n3 = this.originalSpace.height;
        int n4 = 0;
        int n5 = n2 / 2;
        int n6 = n3 / 2;
        int[] nArray = new int[n2 * n3];
        int[] nArray2 = new int[4];
        int n7 = 0;
        while (n7 < n3) {
            int n8 = 0;
            while (n8 < n2) {
                int n9;
                int n10;
                int n11;
                float f = n8 - n5;
                float f2 = n7 - n6;
                float f3 = (float)Math.sqrt(f * f + f2 * f2);
                float f4 = this.UV_amplitude * (float)Math.sin(f3 / this.UU_wavelength * ((float)Math.PI * 2) + this.Uu_phase);
                float f5 = (float)n5 + f + f4;
                float f6 = (float)n6 + f2 + f4;
                f5 = ImageMath.clamp(f5, 0.0f, (float)(n2 - 1));
                f6 = ImageMath.clamp(f6, 0.0f, (float)(n3 - 1));
                if (this.Uv_antialias) {
                    n11 = (int)f5;
                    n10 = (int)f6;
                    boolean bl = this.VU_inside(n11, 0, n2 - 1);
                    boolean bl2 = this.VU_inside(n10, 0, n3 - 1);
                    boolean bl3 = this.VU_inside(n11, 0, n2 - 2);
                    boolean bl4 = this.VU_inside(n10, 0, n3 - 2);
                    int n12 = n10 * n2 + n11;
                    nArray2[0] = bl && bl2 ? this.inPixels[n12] : -16777216;
                    nArray2[1] = bl3 && bl2 ? this.inPixels[n12 + 1] : -16777216;
                    nArray2[2] = bl && bl4 ? this.inPixels[n12 + n2] : -16777216;
                    nArray2[3] = bl3 && bl4 ? this.inPixels[n12 + n2 + 1] : -16777216;
                    f5 = ImageMath.mod(f5, 1.0f);
                    f6 = ImageMath.mod(f6, 1.0f);
                    n9 = ImageMath.bilinearInterpolate(f5, f6, nArray2);
                } else {
                    n11 = ImageMath.clamp((int)(f5 + 0.5f), 0, n2 - 1);
                    n10 = ImageMath.clamp((int)(f6 + 0.5f), 0, n3 - 1);
                    n9 = this.inPixels[n10 * n2 + n11];
                }
                nArray[n4++] = n9;
                ++n8;
            }
            ++n7;
        }
        this.consumer.setPixels(0, 0, n2, n3, this.defaultRGBModel, nArray, 0, n2);
        this.consumer.imageComplete(n);
        this.inPixels = null;
    }

    public String toString() {
        return "Distort/Water Ripples...";
    }
}

