/*
 * Decompiled with CFR 0.152.
 */
package imager.plugins;

import imager.plugins.PreviewFilterCustomizer;
import imager.plugins.SuperGridLayout;
import imager.plugins.WaterFilter;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WaterFilterCustomizer
extends PreviewFilterCustomizer
implements ChangeListener {
    private JSlider UU_wavelength;
    private JSlider UV_amplitude;
    private JSlider Uu_phase;
    private JCheckBox Uv_antialias;
    private WaterFilter VU_filter;

    public WaterFilterCustomizer() {
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "South");
        SuperGridLayout superGridLayout = new SuperGridLayout(3, 2);
        jPanel.setLayout(superGridLayout);
        superGridLayout.setColWeight(1, 1);
        jPanel.add(new JLabel("Wavelength:", 4));
        this.UU_wavelength = new JSlider(0, 1, 100, 1);
        jPanel.add(this.UU_wavelength);
        this.UU_wavelength.setPaintTicks(true);
        this.UU_wavelength.setMajorTickSpacing(50);
        this.UU_wavelength.setMinorTickSpacing(25);
        this.UU_wavelength.setPaintLabels(true);
        this.UU_wavelength.addChangeListener(this);
        jPanel.add(new JLabel("Amplitude:", 4));
        this.UV_amplitude = new JSlider(0, 0, 100, 0);
        jPanel.add(this.UV_amplitude);
        this.UV_amplitude.setPaintTicks(true);
        this.UV_amplitude.setMajorTickSpacing(50);
        this.UV_amplitude.setMinorTickSpacing(25);
        this.UV_amplitude.setPaintLabels(true);
        this.UV_amplitude.addChangeListener(this);
        jPanel.add(new JLabel("Phase:", 4));
        this.Uu_phase = new JSlider(0, 0, 100, 0);
        jPanel.add(this.Uu_phase);
        this.Uu_phase.setPaintTicks(true);
        this.Uu_phase.setMajorTickSpacing(50);
        this.Uu_phase.setMinorTickSpacing(25);
        this.Uu_phase.setPaintLabels(true);
        this.Uu_phase.addChangeListener(this);
        this.Uv_antialias = new JCheckBox("Antialias");
        jPanel.add(this.Uv_antialias);
        this.Uv_antialias.addChangeListener(this);
    }

    public void setObject(Object object) {
        super.setObject(object);
        this.VU_filter = (WaterFilter)object;
        this.UU_wavelength.setValue((int)this.VU_filter.getWavelength());
        this.UV_amplitude.setValue((int)this.VU_filter.getAmplitude());
        this.Uu_phase.setValue((int)((double)this.VU_filter.getPhase() * 100.0 / (Math.PI * 2)));
        this.Uv_antialias.setSelected(this.VU_filter.getAntialias());
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.VU_filter != null) {
            Object object = changeEvent.getSource();
            if (object instanceof JSlider && ((JSlider)object).getValueIsAdjusting()) {
                return;
            }
            if (object == this.UU_wavelength) {
                this.VU_filter.setWavelength(this.UU_wavelength.getValue());
            } else if (object == this.UV_amplitude) {
                this.VU_filter.setAmplitude(this.UV_amplitude.getValue());
            } else if (object == this.Uu_phase) {
                this.VU_filter.setPhase((float)this.Uu_phase.getValue() / 100.0f * 6.283185f);
            } else if (object == this.Uv_antialias) {
                this.VU_filter.setAntialias(this.Uv_antialias.isSelected());
            }
            this.preview();
        }
    }
}

