/*
 * Decompiled with CFR 0.152.
 */
import com.jhlabs.beans.PropertySheet;
import com.jhlabs.image.BlurTransition;
import com.jhlabs.image.FireFilter;
import com.jhlabs.image.GaussianFilter;
import com.jhlabs.image.ImageUtils;
import com.jhlabs.image.PreviewFilterCustomizer;
import com.jhlabs.math.ImageFunction2D;
import java.applet.Applet;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.InputStream;

class FilterAnimation
extends Applet
implements Runnable {
    private BufferedImage image;
    private BufferedImage sourceImage;
    private BufferedImage destImage;
    private BufferedImageOp filter;
    private Thread thread = null;

    public FilterAnimation(BufferedImageOp filter, BufferedImage image) {
        this.filter = filter;
        this.sourceImage = image;
        this.image = filter.filter(this.sourceImage, null);
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(256, 256);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        if (this.image != null) {
            BufferedImage bufferedImage = this.image;
            synchronized (bufferedImage) {
                if (this.image != null) {
                    Dimension size = this.getSize();
                    g.drawImage(this.image, 0, 0, this);
                }
            }
        }
    }

    public void init() {
    }

    public void start() {
        if (this.thread == null) {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.stop();
            this.thread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            float t = 0.0f;
            while (true) {
                t += 0.1f;
                if (this.sourceImage != null) {
                    BufferedImage bufferedImage = this.image;
                    synchronized (bufferedImage) {
                        ((BlurTransition)this.filter).setTransition(t);
                        this.image = this.filter.filter(this.sourceImage, this.image);
                        this.setImage(this.image);
                    }
                }
                Thread.sleep(20L);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public static void main(String[] args) {
        PreviewFilterCustomizer customizer = null;
        BufferedImageOp filter = null;
        String filterName = "com.jhlabs.image.FireFilter";
        try {
            InputStream is;
            filter = (BufferedImageOp)Class.forName(filterName).newInstance();
            String name = filterName;
            int index = name.lastIndexOf(46);
            if (index != -1) {
                name = name.substring(index + 1);
            }
            if ((is = filter.getClass().getResourceAsStream(name + ".xml")) != null) {
                PreviewFilterCustomizer pfc = new PreviewFilterCustomizer(new PropertySheet(), false);
                PropertySheet propertySheet = pfc.getPropertySheet();
                propertySheet.loadXML(is);
                PreviewFilterCustomizer.previewWholeImage = true;
                customizer = pfc;
            } else {
                customizer = (PreviewFilterCustomizer)Class.forName(filterName + "Customizer").newInstance();
            }
        }
        catch (Throwable e) {
            System.out.println("Error loading " + filterName + ":");
            e.printStackTrace();
        }
        Frame f = new Frame();
        System.out.println(FilterAnimation.class.getResource("/fire1.jpg"));
        ImageFunction2D imageF = new ImageFunction2D(f.getToolkit().getImage(FilterAnimation.class.getResource("/fire1.jpg")));
        BufferedImage maskImage = ImageUtils.createImage(f.getToolkit().getImage(FilterAnimation.class.getResource("/fire1.jpg")).getSource());
        BufferedImage image = ImageUtils.createImage(f.getToolkit().getImage(FilterAnimation.class.getResource("/background.jpg")).getSource());
        maskImage = new GaussianFilter(25.0f).filter(maskImage, null);
        maskImage = new BlurUpFilter().filter(maskImage, null);
        ImageFunction2D mask = new ImageFunction2D(maskImage);
        filter = new FireFilter(imageF, mask);
        f.add(customizer);
        customizer.setObject(filter);
        f.pack();
        f.setVisible(true);
        f = new Frame();
        FilterAnimation a = new FilterAnimation(filter, image);
        f.add(a);
        a.init();
        f.pack();
        f.setVisible(true);
        a.start();
    }
}

