/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaComboBoxCellRenderer;
import ch.randelshofer.quaqua.QuaquaComboBoxUI;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboPopup;

public class QuaquaComboPopup
extends BasicComboPopup {
    private QuaquaComboBoxUI qqui;
    static /* synthetic */ Class class$java$awt$GraphicsConfiguration;
    static /* synthetic */ Class class$java$awt$Toolkit;

    public QuaquaComboPopup(JComboBox cBox, QuaquaComboBoxUI qqui) {
        super(cBox);
        this.qqui = qqui;
        this.updateCellRenderer(qqui.isTableCellEditor());
    }

    public void show() {
        super.show();
        this.list.repaint();
    }

    private void updateCellRenderer(boolean isTableCellEditor) {
        this.list.setCellRenderer(new QuaquaComboBoxCellRenderer(this.comboBox.getRenderer(), isTableCellEditor, this.comboBox.isEditable()));
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new BasicComboPopup.PropertyChangeHandler(){

            public void propertyChange(PropertyChangeEvent e) {
                super.propertyChange(e);
                String propertyName = e.getPropertyName();
                JComboBox comboBox = (JComboBox)e.getSource();
                if (propertyName.equals("renderer") || propertyName.equals("JComboBox.isTableCellEditor")) {
                    QuaquaComboPopup.this.updateCellRenderer(e.getNewValue().equals(Boolean.TRUE));
                } else if (propertyName.equals("JComboBox.lightweightKeyboardNavigation")) {
                    QuaquaComboPopup.this.updateCellRenderer(e.getNewValue() != null && e.getNewValue().equals("Lightweight"));
                } else if (propertyName.equals("editable")) {
                    QuaquaComboPopup.this.updateCellRenderer(QuaquaComboPopup.this.isTableCellEditor());
                }
            }
        };
    }

    protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
        Rectangle screenBounds;
        boolean isSmall;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int listWidth = this.getList().getPreferredSize().width;
        Insets margin = this.qqui.getMargin();
        boolean isTableCellEditor = this.isTableCellEditor();
        boolean hasScrollBars = this.hasScrollBars();
        boolean isEditable = this.isEditable();
        boolean bl = isSmall = this.comboBox.getFont().getSize() <= 11;
        if (isTableCellEditor) {
            pw = hasScrollBars ? Math.max(pw, listWidth + 16) : Math.max(pw, listWidth);
        } else if (hasScrollBars) {
            px += margin.left;
            pw = Math.max(pw - margin.left - margin.right, listWidth + 16);
        } else if (isEditable) {
            px += margin.left;
            pw = Math.max(pw - this.qqui.getArrowWidth() - margin.left, listWidth);
        } else {
            px += margin.left;
            pw = Math.max(pw - this.qqui.getArrowWidth() - margin.left, listWidth);
        }
        GraphicsConfiguration gc = this.comboBox.getGraphicsConfiguration();
        Point p = new Point();
        SwingUtilities.convertPointFromScreen(p, this.comboBox);
        if (gc != null) {
            Insets screenInsets;
            try {
                screenInsets = (Insets)(class$java$awt$Toolkit == null ? (class$java$awt$Toolkit = QuaquaComboPopup.class$("java.awt.Toolkit")) : class$java$awt$Toolkit).getMethod("getScreenInsets", class$java$awt$GraphicsConfiguration == null ? (class$java$awt$GraphicsConfiguration = QuaquaComboPopup.class$("java.awt.GraphicsConfiguration")) : class$java$awt$GraphicsConfiguration).invoke((Object)toolkit, gc);
            }
            catch (Exception e) {
                screenInsets = new Insets(22, 0, 0, 0);
            }
            screenBounds = new Rectangle(gc.getBounds());
            screenBounds.width -= screenInsets.left + screenInsets.right;
            screenBounds.height -= screenInsets.top + screenInsets.bottom;
            screenBounds.x += p.x + screenInsets.left;
            screenBounds.y += p.y + screenInsets.top;
        } else {
            screenBounds = new Rectangle(p, toolkit.getScreenSize());
        }
        if (this.isDropDown()) {
            if (!isTableCellEditor) {
                py = isEditable ? (py -= margin.bottom + 2) : (py -= margin.bottom);
            }
        } else {
            int yOffset = isTableCellEditor ? 7 : 4 - margin.top;
            int selectedIndex = this.comboBox.getSelectedIndex();
            py = selectedIndex <= 0 ? -yOffset : Math.max(screenBounds.y, -yOffset - this.list.getCellBounds((int)0, (int)(selectedIndex - 1)).height);
        }
        Rectangle rect = new Rectangle(px, py, pw, ph);
        if (py + ph > screenBounds.y + screenBounds.height && ph < screenBounds.height) {
            rect.y = -rect.height;
        }
        return rect;
    }

    private boolean isDropDown() {
        return this.comboBox.isEditable() || this.hasScrollBars();
    }

    private boolean hasScrollBars() {
        return this.comboBox.getModel().getSize() > this.comboBox.getMaximumRowCount();
    }

    private boolean isEditable() {
        return this.comboBox.isEditable();
    }

    private boolean isTableCellEditor() {
        return this.qqui.isTableCellEditor();
    }

    protected void configurePopup() {
        super.configurePopup();
        this.setBorder(UIManager.getBorder("PopupMenu.border"));
    }

    protected void configureList() {
        super.configureList();
        this.list.setBackground(UIManager.getColor("PopupMenu.background"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

