/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.BackgroundBorder;
import ch.randelshofer.quaqua.Debug;
import ch.randelshofer.quaqua.QuaquaBorderFactory;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.VisualMargin;
import ch.randelshofer.quaqua.util.InsetsUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class QuaquaTextFieldBorder
extends VisualMargin
implements BackgroundBorder {
    private String imagesLocation;
    private Border[] borders;
    private Border textFieldBackground = new Border(){

        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 0, 0);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (c.isOpaque()) {
                g.setColor(UIManager.getColor("Panel.background"));
                g.fillRect(0, 0, width, height);
            }
            g.setColor(c.getBackground());
            Insets insets = QuaquaTextFieldBorder.this.getVisualMargin(c, new Insets(0, 0, 0, 0));
            g.fillRect(insets.left + 3, insets.bottom + 3, width - insets.left - insets.right - 6, height - insets.top - insets.bottom - 7);
        }
    };

    public QuaquaTextFieldBorder(String imagesLocation) {
        super(3, 3, 2, 3);
        this.imagesLocation = imagesLocation;
    }

    private static boolean isSmall(Component c) {
        return c.getFont().getSize() <= 11;
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets = this.getVisualMargin(c, insets);
        Insets inner = QuaquaTextFieldBorder.isSmall(c) ? new Insets(6, 7, 5, 7) : new Insets(6, 7, 6, 7);
        InsetsUtil.addTo(inner, insets);
        return insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Insets margin = this.getVisualMargin(c, new Insets(0, 0, 0, 0));
        Border border = this.getBorder(c);
        border.paintBorder(c, g, x + margin.left, y + margin.top, width - margin.left - margin.right, height - margin.top - margin.bottom);
        if (c instanceof JTextComponent) {
            Debug.paint(g, (JTextComponent)c, ((JTextComponent)c).getUI());
        }
    }

    public Border getBackgroundBorder() {
        return this.textFieldBackground;
    }

    private Border getBorder(Component c) {
        if (this.borders == null) {
            this.borders = (Border[])QuaquaBorderFactory.create(this.imagesLocation, new Insets(6, 6, 5, 6), 3, true);
        }
        boolean isEditable = c instanceof JTextComponent ? ((JTextComponent)c).isEditable() : true;
        if (QuaquaUtilities.isFocused(c)) {
            return this.borders[2];
        }
        if (c.isEnabled() && isEditable) {
            return this.borders[0];
        }
        return this.borders[1];
    }

    public static class UIResource
    extends QuaquaTextFieldBorder
    implements javax.swing.plaf.UIResource {
        public UIResource(String imagesLocation) {
            super(imagesLocation);
        }
    }
}

